% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/risk_based_functions.R
\name{sep.rb2.hypergeo}
\alias{sep.rb2.hypergeo}
\title{Hypergeometric risk-based population sensitivity for 2 risk factors}
\usage{
sep.rb2.hypergeo(pstar, rr1, rr2, N, n, se)
}
\arguments{
\item{pstar}{design prevalence (scalar)}

\item{rr1}{relative risks for first level risk factor (vector of values corresponding 
to the number of risk strata)}

\item{rr2}{relative risks for second level risk factor, 
matrix, rows = levels of rr1, cols = levels of rr2}

\item{N}{matrix of population size for each risk group 
(rows = levels of rr1, cols = levels of rr2)}

\item{n}{matrix of number tested (sample size) for each risk group 
(rows = levels of rr1, cols = levels of rr2)}

\item{se}{test unit sensitivity (scalar)}
}
\value{
list of 6 elements, a scalar of population-level sensitivity
  a matrix of EPI values, a vector of corresponding Adjusted risks for
  the first risk factor and a matrix of adjusted risks for the second risk factor,
  a vector of population proportions for the first risk factor 
  and a matrix of population proportions for the second risk factor
}
\description{
Calculates risk-based population sensitivity for 
  two risk factors, using hypergeometric approximation method 
  (assumes a known population size)
}
\examples{
# examples for sep.rb2.hypergeo
pstar<- 0.01
rr1<- c(3, 1)
rr2<- rbind(c(4,1), c(4,1))
N<- rbind(c(100, 500), c(300, 1000))
n<- rbind(c(50, 20), c(20, 10))
se<- 0.8
sep.rb2.hypergeo(pstar, rr1, rr2, N, n, se)
}
\keyword{methods}

