% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/genscape.R
\name{getGenscapeStorageOil}
\alias{getGenscapeStorageOil}
\title{Genscape API call for oil storage}
\usage{
getGenscapeStorageOil(
  feed = "owner-volumes",
  regions = "Canada",
  products = "Crude",
  revision = "revised",
  limit = 5000,
  offset = 0,
  startDate = "2011-01-01",
  endDate = as.character(Sys.Date()),
  apikey = "yourapikey"
)
}
\arguments{
\item{feed}{"owner-volumes" DEFAULT or "tank-volumes". \code{character}}

\item{regions}{See API webpage. Multiple values separated by commas e.g. "Canada, Cushing"). \code{character}}

\item{products}{See API webpage. Multiple values separated by commas e.g. "Crude, JetFuel"). \code{character}}

\item{revision}{See API webpage. \code{character}}

\item{limit}{See API webpage. Max 5000. \code{numeric}}

\item{offset}{See API webpage. \code{numeric}}

\item{startDate}{"yyyy-mm-dd". \code{character}}

\item{endDate}{"yyyy-mm-dd". \code{character}}

\item{apikey}{Your API key as a character string. \code{character}}
}
\value{
wide data frame \code{tibble}
}
\description{
Returns oil storage data from Genscape API.You need your own credentials.
Refer to API documentation for argument values.
https://developer.genscape.com/docs/services/oil-storage/operations/StorageVolumeByOwnerGet
}
\examples{
\dontrun{
# where yourapikey = "yourapikey".
getGenscapeStorageOil(
  feed = "owner-volumes", regions = "Canada", products = "Crude",
  revision = "revised", limit = 5000, offset = 0,
  startDate = "2011-01-01", endDate = "2020-11-01", apikey = yourapikey
)
}

}
\author{
Philippe Cote
}
