% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RTestCase.test-adapter.R
\name{generic}
\alias{generic}
\alias{generic,RTestCase-method}
\title{Generic test adapter Method}
\arguments{
\item{object}{(\code{object}) The \code{\link{RTestCase-class}} object}

\item{inputData}{(\code{list}) List of input values}

\item{execCache}{(\code{list}) list of already executed tests and their return values}

\item{xmlDef}{(\code{xmlNode}) xmlNode of the Test case}

\item{package}{(\code{character}) Name of the package to be tested}

\item{...}{additional values can be given from \code{execAdapter}}
}
\value{
(\code{list})
}
\description{
Generic test adapter Method
}
\examples{
options("RTest_verbose" = TRUE)

testCollection <- new("RTestCollection",
    project.name    = "RTest Vignette",
    project.details = "Example test exectuion",
    tester          = "Example tester",
    test.start      = format(Sys.time(), "\%Y-\%m-\%d \%H:\%M:\%S"))

TCDir <- paste0(find.package("RTest"),"/xml-templates")

testCollection <- RTest::importTCsFromDir(testCollection,
    xml.dPath = TCDir,f.pattern  = "RTest_TC-02.xml")


outf <- tempfile(fileext=".html")

funct_02 <<- function(data, mult) {   cbind(data, "sum" = apply(data, 1, sum)*mult) }
environment(funct_02) <- asNamespace('RTest')

testCollection <- RTest::exec(testCollection, out.fPath = outf, open=FALSE)

}
\seealso{
\code{\link{RTestCase-class}}
}
\author{
Sebastian Wolf \email{sebastian@mail-wolf.de}
}
