% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RTestCase.R
\docType{methods}
\name{execAdapter}
\alias{execAdapter}
\alias{execAdapter,RTestCase-method}
\title{Execute the Adapter Function of the Test Case}
\usage{
\S4method{execAdapter}{RTestCase}(object, tf.pkg, tf.pkg.i, tf.func,
  tf.func.i, out.fPathPre = NULL, ...)
}
\arguments{
\item{object}{(\code{object}) The \code{\link{RTestCase-class}} object}

\item{tf.pkg}{(\code{character}) The package name of the currently executed test
function.}

\item{tf.pkg.i}{(\code{integer}) The package iteration number of the currently executed
test function.}

\item{tf.func}{(\code{character}) The function name of the currently executed test
function.}

\item{tf.func.i}{(\code{character}) The function iteration number of the currently
executed test function.}

\item{out.fPathPre}{(\code{character}) Prefix incl. path to output files generated during
tests}

\item{...}{Additional arguments passed to the check function.}
}
\value{
(\code{ANY}) The cached result of the executed test function.
}
\description{
This is an abstract method definition and specifies the adapter function of the individual
test case adapter, which understand the test case and knows how to execute it. It has to be
implemented in the specialized test classes separetly for each test project.
}
\seealso{
\code{\link{RTestCase-class}}
}
\author{
Matthias Pfeifer \email{matthias.pfeifer@roche.com}
}
