% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RVCompare.R
\name{sampleFromDensity}
\alias{sampleFromDensity}
\title{Get sample given the density function}
\usage{
sampleFromDensity(density, nSamples, xlims, nIntervals = 1e+05)
}
\arguments{
\item{density}{the probability density function.}

\item{nSamples}{the number of samples to generate.}

\item{xlims}{the domain of definition of the random variable.}

\item{nIntervals}{(optional, default = 1e4) the number of intervals from which to draw samples. A higher value implies more accuracy but also more computation time.}
}
\value{
Returns an array of samples.
}
\description{
Returns an array with samples given the probability density function.
}
\examples{
normDens <- normalDensity(0,1)
samples <- sampleFromDensity(normDens, 1e4, c(-4,4))
hist(samples,  breaks=20)
}
