% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RVCompare.R
\name{mixtureDensity}
\alias{mixtureDensity}
\title{A mixture of two or more distributions}
\usage{
mixtureDensity(densities, weights = NULL)
}
\arguments{
\item{densities}{the probability density functions to be combined.}

\item{weights}{(optional) the weights of the distributions in the mixture. If it is not give, equal weights are assumed.}
}
\value{
Returns a callable function with a single parameter that returns the probability of the mixture distribution each point.
}
\description{
Returns the density function of the mixture distribution.
The returned function is a single parameter function that returns the probability of the mixture in that point.
}
\examples{
#If parameter weights not given, equal weights are assumed.
dist1 <- mixtureDensity(c(normalDensity(-2,1), normalDensity(2,1)))
plot(dist1, xlim = c(-5,5), xlab="x", ylab = "Probability density",
     main="Mixture of two Gaussians with equal weights", cex.main=0.85)

dist2 <- mixtureDensity(c(normalDensity(-2,1), normalDensity(2,1)), weights=c(0.8,0.2))
plot(dist2, xlim = c(-5,5), xlab="x", ylab = "Probability density",
     main="Mixture of two Gaussians with different weights", cex.main=0.85)
}
