% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Ave_func.R
\name{Ave_func}
\alias{Ave_func}
\title{Optimizing data from UK Biobank}
\usage{
Ave_func(resp.range, type = "all", data)
}
\arguments{
\item{resp.range}{a numeric vector specifying column range of regional neuroimaging traits.}

\item{type}{a character string specifying data types of regional neuroimaging traits(i.e. All traits(type='all'), White matter(type='WM'),Gray matter(type='GM') or Subcortical(type='Subcortical'))}

\item{data}{a data frame contains regional neuroimaging traits with field IDs from UKBB. Default(type='all')}
}
\value{
a dataframe of regional neuroimaging traits with abbreviated field names.
}
\description{
The Ave_func() can optimize data from UK Biobank(UKB). It will rename field IDs of regional neuroimaging traits to abbreviation names, and then average data of left and right
hemispheres of the same field.
}
\note{
The Ave_func() function is developed at the Maryland Psychiatric Research Center, Department of Psychiatry,
University of Maryland School of Medicine. This project is supported by NIH R01 EB015611 grant. Please cite our funding if
you use this software.
}
\references{
Kochunov P, Fan F, Ryan MC, et al. Translating ENIGMA schizophrenia findings using the regional vulnerability index: Association
with cognition, symptoms, and disease trajectory (2020). Hum Brain Mapp. 2020;10.1002/hbm.25045. \doi{10.1002/hbm.25045}

R Core Team (2020). R: A language and environment for statistical computing. R
Foundation for Statistical Computing, Vienna, Austria. URL
https://www.R-project.org/.
}
