/*
 * Decompiled with CFR 0.152.
 */
package weka.classifiers.meta;

import java.util.Enumeration;
import java.util.Random;
import java.util.Vector;
import weka.classifiers.Classifier;
import weka.classifiers.Evaluation;
import weka.classifiers.RandomizableIteratedSingleClassifierEnhancer;
import weka.classifiers.trees.J48;
import weka.core.Capabilities;
import weka.core.Instance;
import weka.core.Instances;
import weka.core.Option;
import weka.core.TechnicalInformation;
import weka.core.TechnicalInformationHandler;
import weka.core.UnsupportedClassTypeException;
import weka.core.Utils;

public class Decorate
extends RandomizableIteratedSingleClassifierEnhancer
implements TechnicalInformationHandler {
    static final long serialVersionUID = -6020193348750269931L;
    protected Vector m_Committee = null;
    protected int m_DesiredSize = 10;
    protected double m_ArtSize = 1.0;
    protected Random m_Random = new Random(0L);
    protected Vector m_AttributeStats = null;

    public Decorate() {
        this.m_Classifier = new J48();
    }

    protected String defaultClassifierString() {
        return "weka.classifiers.trees.J48";
    }

    public Enumeration listOptions() {
        Vector<Option> vector = new Vector<Option>(8);
        vector.addElement(new Option("\tDesired size of ensemble.\n\t(default 10)", "E", 1, "-E"));
        vector.addElement(new Option("\tFactor that determines number of artificial examples to generate.\n\tSpecified proportional to training set size.\n\t(default 1.0)", "R", 1, "-R"));
        Enumeration enumeration = super.listOptions();
        while (enumeration.hasMoreElements()) {
            vector.addElement((Option)enumeration.nextElement());
        }
        return vector.elements();
    }

    public void setOptions(String[] stringArray) throws Exception {
        String string = Utils.getOption('E', stringArray);
        if (string.length() != 0) {
            this.setDesiredSize(Integer.parseInt(string));
        } else {
            this.setDesiredSize(10);
        }
        String string2 = Utils.getOption('R', stringArray);
        if (string2.length() != 0) {
            this.setArtificialSize(Double.parseDouble(string2));
        } else {
            this.setArtificialSize(1.0);
        }
        super.setOptions(stringArray);
    }

    public String[] getOptions() {
        String[] stringArray = super.getOptions();
        String[] stringArray2 = new String[stringArray.length + 4];
        int n = 0;
        stringArray2[n++] = "-E";
        stringArray2[n++] = "" + this.getDesiredSize();
        stringArray2[n++] = "-R";
        stringArray2[n++] = "" + this.getArtificialSize();
        System.arraycopy(stringArray, 0, stringArray2, n, stringArray.length);
        n += stringArray.length;
        while (n < stringArray2.length) {
            stringArray2[n++] = "";
        }
        return stringArray2;
    }

    public String desiredSizeTipText() {
        return "the desired number of member classifiers in the Decorate ensemble. Decorate may terminate before this size is reached (depending on the value of numIterations). Larger ensemble sizes usually lead to more accurate models, but increases training time and model complexity.";
    }

    public String numIterationsTipText() {
        return "the maximum number of Decorate iterations to run. Each iteration generates a classifier, but does not necessarily add it to the ensemble. Decorate stops when the desired ensemble size is reached. This parameter should be greater than equal to the desiredSize. If the desiredSize is not being reached it may help to increase this value.";
    }

    public String artificialSizeTipText() {
        return "determines the number of artificial examples to use during training. Specified as a proportion of the training data. Higher values can increase ensemble diversity.";
    }

    public String globalInfo() {
        return "DECORATE is a meta-learner for building diverse ensembles of classifiers by using specially constructed artificial training examples. Comprehensive experiments have demonstrated that this technique is consistently more accurate than the base classifier, Bagging and Random Forests.Decorate also obtains higher accuracy than Boosting on small training sets, and achieves comparable performance on larger training sets. \n\nFor more details see: \n\n" + this.getTechnicalInformation().toString();
    }

    public TechnicalInformation getTechnicalInformation() {
        TechnicalInformation technicalInformation = new TechnicalInformation(TechnicalInformation.Type.INPROCEEDINGS);
        technicalInformation.setValue(TechnicalInformation.Field.AUTHOR, "P. Melville and R. J. Mooney");
        technicalInformation.setValue(TechnicalInformation.Field.TITLE, "Constructing Diverse Classifier Ensembles Using Artificial Training Examples");
        technicalInformation.setValue(TechnicalInformation.Field.BOOKTITLE, "Eighteenth International Joint Conference on Artificial Intelligence");
        technicalInformation.setValue(TechnicalInformation.Field.YEAR, "2003");
        technicalInformation.setValue(TechnicalInformation.Field.PAGES, "505-510");
        TechnicalInformation technicalInformation2 = technicalInformation.add(TechnicalInformation.Type.ARTICLE);
        technicalInformation2.setValue(TechnicalInformation.Field.AUTHOR, "P. Melville and R. J. Mooney");
        technicalInformation2.setValue(TechnicalInformation.Field.TITLE, "Creating Diversity in Ensembles Using Artificial Data");
        technicalInformation2.setValue(TechnicalInformation.Field.JOURNAL, "Information Fusion: Special Issue on Diversity in Multiclassifier Systems");
        technicalInformation2.setValue(TechnicalInformation.Field.YEAR, "2004");
        technicalInformation2.setValue(TechnicalInformation.Field.NOTE, "submitted");
        return technicalInformation;
    }

    public double getArtificialSize() {
        return this.m_ArtSize;
    }

    public void setArtificialSize(double d) {
        this.m_ArtSize = d;
    }

    public int getDesiredSize() {
        return this.m_DesiredSize;
    }

    public void setDesiredSize(int n) {
        this.m_DesiredSize = n;
    }

    public Capabilities getCapabilities() {
        Capabilities capabilities = super.getCapabilities();
        capabilities.disableAllClasses();
        capabilities.disableAllClassDependencies();
        capabilities.enable(Capabilities.Capability.NOMINAL_CLASS);
        capabilities.setMinimumNumberInstances(this.m_DesiredSize);
        return capabilities;
    }

    public void buildClassifier(Instances instances) throws Exception {
        if (this.m_Classifier == null) {
            throw new Exception("A base classifier has not been specified!");
        }
        this.getCapabilities().testWithFail(instances);
        instances = new Instances(instances);
        instances.deleteWithMissingClass();
        this.m_Random = this.m_Seed == -1 ? new Random() : new Random(this.m_Seed);
        int n = 1;
        int n2 = 1;
        Instances instances2 = new Instances(instances);
        Instances instances3 = null;
        int n3 = (int)(Math.abs(this.m_ArtSize) * (double)instances2.numInstances());
        if (n3 == 0) {
            n3 = 1;
        }
        this.computeStats(instances);
        this.m_Committee = new Vector();
        Classifier classifier = this.m_Classifier;
        classifier.buildClassifier(instances2);
        this.m_Committee.add(classifier);
        double d = this.computeError(instances2);
        if (this.m_Debug) {
            System.out.println("Initialize:\tClassifier " + n + " added to ensemble. Ensemble error = " + d);
        }
        while (n < this.m_DesiredSize && n2 < this.m_NumIterations) {
            instances3 = this.generateArtificialData(n3, instances);
            this.labelData(instances3);
            this.addInstances(instances2, instances3);
            Classifier[] classifierArray = Classifier.makeCopies(this.m_Classifier, 1);
            classifier = classifierArray[0];
            classifier.buildClassifier(instances2);
            this.removeInstances(instances2, n3);
            this.m_Committee.add(classifier);
            double d2 = this.computeError(instances2);
            if (d2 <= d) {
                ++n;
                d = d2;
                if (this.m_Debug) {
                    System.out.println("Iteration: " + (1 + n2) + "\tClassifier " + n + " added to ensemble. Ensemble error = " + d);
                }
            } else {
                this.m_Committee.removeElementAt(this.m_Committee.size() - 1);
            }
            ++n2;
        }
    }

    protected void computeStats(Instances instances) throws Exception {
        int n = instances.numAttributes();
        this.m_AttributeStats = new Vector(n);
        for (int i = 0; i < n; ++i) {
            Object[] objectArray;
            if (instances.attribute(i).isNominal()) {
                objectArray = instances.attributeStats((int)i).nominalCounts;
                double[] dArray = new double[objectArray.length];
                if (dArray.length < 2) {
                    throw new Exception("Nominal attribute has less than two distinct values!");
                }
                for (int j = 0; j < dArray.length; ++j) {
                    dArray[j] = objectArray[j] + 1;
                }
                Utils.normalize(dArray);
                double[] dArray2 = new double[dArray.length - 1];
                dArray2[0] = dArray[0];
                for (int j = 1; j < dArray2.length; ++j) {
                    dArray2[j] = dArray2[j - 1] + dArray[j];
                }
                this.m_AttributeStats.add(i, dArray2);
                continue;
            }
            if (instances.attribute(i).isNumeric()) {
                objectArray = new double[2];
                objectArray[0] = (int)instances.meanOrMode(i);
                objectArray[1] = (int)Math.sqrt(instances.variance(i));
                this.m_AttributeStats.add(i, objectArray);
                continue;
            }
            System.err.println("Decorate can only handle numeric and nominal values.");
        }
    }

    protected Instances generateArtificialData(int n, Instances instances) {
        int n2 = instances.numAttributes();
        Instances instances2 = new Instances(instances, n);
        for (int i = 0; i < n; ++i) {
            double[] dArray = new double[n2];
            for (int j = 0; j < n2; ++j) {
                double[] dArray2;
                if (instances.attribute(j).isNominal()) {
                    dArray2 = (double[])this.m_AttributeStats.get(j);
                    dArray[j] = this.selectIndexProbabilistically(dArray2);
                    continue;
                }
                if (instances.attribute(j).isNumeric()) {
                    dArray2 = (double[])this.m_AttributeStats.get(j);
                    dArray[j] = this.m_Random.nextGaussian() * dArray2[1] + dArray2[0];
                    continue;
                }
                System.err.println("Decorate can only handle numeric and nominal values.");
            }
            Instance instance = new Instance(1.0, dArray);
            instances2.add(instance);
        }
        return instances2;
    }

    protected void labelData(Instances instances) throws Exception {
        for (int i = 0; i < instances.numInstances(); ++i) {
            Instance instance = instances.instance(i);
            double[] dArray = this.distributionForInstance(instance);
            instance.setClassValue(this.inverseLabel(dArray));
        }
    }

    protected int inverseLabel(double[] dArray) throws Exception {
        double[] dArray2 = new double[dArray.length];
        for (int i = 0; i < dArray.length; ++i) {
            dArray2[i] = dArray[i] == 0.0 ? Double.MAX_VALUE / (double)dArray.length : 1.0 / dArray[i];
        }
        Utils.normalize(dArray2);
        double[] dArray3 = new double[dArray2.length];
        dArray3[0] = dArray2[0];
        for (int i = 1; i < dArray2.length; ++i) {
            dArray3[i] = dArray2[i] + dArray3[i - 1];
        }
        if (Double.isNaN(dArray3[dArray2.length - 1])) {
            System.err.println("Cumulative class membership probability is NaN!");
        }
        return this.selectIndexProbabilistically(dArray3);
    }

    protected int selectIndexProbabilistically(double[] dArray) {
        int n;
        double d = this.m_Random.nextDouble();
        for (n = 0; n < dArray.length && d > dArray[n]; ++n) {
        }
        return n;
    }

    protected void removeInstances(Instances instances, int n) {
        int n2 = instances.numInstances();
        for (int i = n2 - 1; i > n2 - 1 - n; --i) {
            instances.delete(i);
        }
    }

    protected void addInstances(Instances instances, Instances instances2) {
        for (int i = 0; i < instances2.numInstances(); ++i) {
            instances.add(instances2.instance(i));
        }
    }

    protected double computeError(Instances instances) throws Exception {
        double d = 0.0;
        int n = instances.numInstances();
        for (int i = 0; i < n; ++i) {
            Instance instance = instances.instance(i);
            if (instance.classValue() == (double)((int)this.classifyInstance(instance))) continue;
            d += 1.0;
        }
        return d / (double)n;
    }

    public double[] distributionForInstance(Instance instance) throws Exception {
        if (instance.classAttribute().isNumeric()) {
            throw new UnsupportedClassTypeException("Decorate can't handle a numeric class!");
        }
        double[] dArray = new double[instance.numClasses()];
        for (int i = 0; i < this.m_Committee.size(); ++i) {
            Classifier classifier = (Classifier)this.m_Committee.get(i);
            double[] dArray2 = classifier.distributionForInstance(instance);
            for (int j = 0; j < dArray2.length; ++j) {
                int n = j;
                dArray[n] = dArray[n] + dArray2[j];
            }
        }
        if (Utils.eq(Utils.sum(dArray), 0.0)) {
            return dArray;
        }
        Utils.normalize(dArray);
        return dArray;
    }

    public String toString() {
        if (this.m_Committee == null) {
            return "Decorate: No model built yet.";
        }
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("Decorate base classifiers: \n\n");
        for (int i = 0; i < this.m_Committee.size(); ++i) {
            stringBuffer.append(((Classifier)this.m_Committee.get(i)).toString() + "\n\n");
        }
        stringBuffer.append("Number of classifier in the ensemble: " + this.m_Committee.size() + "\n");
        return stringBuffer.toString();
    }

    public static void main(String[] stringArray) {
        try {
            System.out.println(Evaluation.evaluateModel(new Decorate(), stringArray));
        }
        catch (Exception exception) {
            System.err.println(exception.getMessage());
        }
    }
}

