/*
 * Decompiled with CFR 0.152.
 */
package weka.classifiers.functions;

import java.util.Enumeration;
import java.util.Vector;
import weka.classifiers.Classifier;
import weka.classifiers.Evaluation;
import weka.classifiers.functions.pace.ChisqMixture;
import weka.classifiers.functions.pace.MixtureDistribution;
import weka.classifiers.functions.pace.NormalMixture;
import weka.classifiers.functions.pace.PaceMatrix;
import weka.core.Instance;
import weka.core.Instances;
import weka.core.NoSupportForMissingValuesException;
import weka.core.Option;
import weka.core.OptionHandler;
import weka.core.SelectedTag;
import weka.core.Tag;
import weka.core.UnsupportedAttributeTypeException;
import weka.core.UnsupportedClassTypeException;
import weka.core.Utils;
import weka.core.WeightedInstancesHandler;
import weka.core.WekaException;
import weka.core.matrix.DoubleVector;
import weka.core.matrix.IntVector;

public class PaceRegression
extends Classifier
implements OptionHandler,
WeightedInstancesHandler {
    Instances m_Model = null;
    private double[] m_Coefficients;
    private int m_ClassIndex;
    private boolean m_Debug;
    private static final int olsEstimator = 0;
    private static final int ebEstimator = 1;
    private static final int nestedEstimator = 2;
    private static final int subsetEstimator = 3;
    private static final int pace2Estimator = 4;
    private static final int pace4Estimator = 5;
    private static final int pace6Estimator = 6;
    private static final int olscEstimator = 7;
    private static final int aicEstimator = 8;
    private static final int bicEstimator = 9;
    private static final int ricEstimator = 10;
    public static final Tag[] TAGS_ESTIMATOR = new Tag[]{new Tag(0, "Ordinary least squares"), new Tag(1, "Empirical Bayes"), new Tag(2, "Nested model selector"), new Tag(3, "Subset selector"), new Tag(4, "PACE2"), new Tag(5, "PACE4"), new Tag(6, "PACE6"), new Tag(7, "Ordinary least squares selection"), new Tag(8, "AIC"), new Tag(9, "BIC"), new Tag(10, "RIC")};
    private int paceEstimator = 1;
    private double olscThreshold = 2.0;

    public String globalInfo() {
        return "Class for building pace regression linear models and using them for prediction. \n\nUnder regularity conditions, pace regression is provably optimal when the number of coefficients tends to infinity. It consists of a group of estimators that are either overall optimal or optimal under certain conditions.\n\nThe current work of the pace regression theory, and therefore also this implementation, do not handle: \n\n- missing values \n- non-binary nominal attributes \n- the case that n - k is small where n is the number of instances and k is the number of coefficients (the threshold used in this implmentation is 20)\n\nFor more information see:\n\nWang, Y. (2000). A new approach to fitting linear models in high dimensional spaces. PhD Thesis. Department of Computer Science, University of Waikato, New Zealand. \n\nWang, Y. and Witten, I. H. (2002). Modeling for optimal probability prediction. Proceedings of ICML'2002. Sydney.";
    }

    public void buildClassifier(Instances instances) throws Exception {
        if (!instances.classAttribute().isNumeric()) {
            throw new UnsupportedClassTypeException("Class attribute has to be numeric for pace regression!");
        }
        if (instances.numInstances() == 0) {
            throw new Exception("No instances in training file!");
        }
        if (instances.checkForStringAttributes()) {
            throw new UnsupportedAttributeTypeException("Can't handle string attributes!");
        }
        if (this.checkForNonBinary(instances)) {
            throw new UnsupportedAttributeTypeException("Can only deal with numeric and binary attributes!");
        }
        if (this.checkForMissing(instances)) {
            throw new NoSupportForMissingValuesException("Can't handle missing values!");
        }
        if (instances.numInstances() - instances.numAttributes() < 20) {
            throw new IllegalArgumentException("Not enough instances. Ratio of number of instances (n) to number of attributes (k) is too small (n - k < 20).");
        }
        this.m_Model = new Instances(instances, 0);
        this.m_ClassIndex = instances.classIndex();
        double[][] dArray = this.getTransformedDataMatrix(instances, this.m_ClassIndex);
        double[] dArray2 = instances.attributeToDoubleArray(this.m_ClassIndex);
        this.m_Coefficients = null;
        this.m_Coefficients = this.pace(dArray, dArray2);
    }

    private double[] pace(double[][] dArray, double[] dArray2) {
        DoubleVector doubleVector;
        Object object;
        PaceMatrix paceMatrix = new PaceMatrix(dArray);
        PaceMatrix paceMatrix2 = new PaceMatrix(dArray2, dArray2.length);
        IntVector intVector = IntVector.seq(0, paceMatrix.getColumnDimension() - 1);
        int n = paceMatrix.getRowDimension();
        int n2 = paceMatrix.getColumnDimension();
        paceMatrix.lsqrSelection(paceMatrix2, intVector, 1);
        paceMatrix.positiveDiagonal(paceMatrix2, intVector);
        int n3 = intVector.size();
        PaceMatrix paceMatrix3 = (PaceMatrix)paceMatrix2.clone();
        paceMatrix.rsolve(paceMatrix3, intVector, intVector.size());
        DoubleVector doubleVector2 = paceMatrix3.getColumn(0).unpivoting(intVector, n2);
        DoubleVector doubleVector3 = paceMatrix2.getColumn(intVector.size(), n - 1, 0);
        double d = Math.sqrt(doubleVector3.sum2() / (double)doubleVector3.size());
        DoubleVector doubleVector4 = paceMatrix2.getColumn(0, intVector.size() - 1, 0).times(1.0 / d);
        DoubleVector doubleVector5 = null;
        switch (this.paceEstimator) {
            case 1: 
            case 2: 
            case 3: {
                object = new NormalMixture();
                ((MixtureDistribution)object).fit(doubleVector4, 1);
                if (this.paceEstimator == 1) {
                    doubleVector5 = ((NormalMixture)object).empiricalBayesEstimate(doubleVector4);
                    break;
                }
                if (this.paceEstimator == 1) {
                    doubleVector5 = ((NormalMixture)object).subsetEstimate(doubleVector4);
                    break;
                }
                doubleVector5 = ((NormalMixture)object).nestedEstimate(doubleVector4);
                break;
            }
            case 4: 
            case 5: 
            case 6: {
                doubleVector = doubleVector4.square();
                ChisqMixture chisqMixture = new ChisqMixture();
                chisqMixture.fit(doubleVector, 1);
                DoubleVector doubleVector6 = this.paceEstimator == 6 ? chisqMixture.pace6(doubleVector) : (this.paceEstimator == 4 ? chisqMixture.pace2(doubleVector) : chisqMixture.pace4(doubleVector));
                doubleVector5 = doubleVector6.sqrt().times(doubleVector4.sign());
                break;
            }
            case 0: {
                doubleVector5 = doubleVector4.copy();
                break;
            }
            case 7: 
            case 8: 
            case 9: 
            case 10: {
                if (this.paceEstimator == 8) {
                    this.olscThreshold = 2.0;
                } else if (this.paceEstimator == 9) {
                    this.olscThreshold = Math.log(n);
                } else if (this.paceEstimator == 10) {
                    this.olscThreshold = 2.0 * Math.log(n2);
                }
                doubleVector5 = doubleVector4.copy();
                for (int i = 0; i < doubleVector5.size(); ++i) {
                    if (!(Math.abs(doubleVector5.get(i)) < Math.sqrt(this.olscThreshold))) continue;
                    doubleVector5.set(i, 0.0);
                }
                break;
            }
        }
        object = new PaceMatrix(new PaceMatrix(doubleVector5).times(d));
        paceMatrix.rsolve((PaceMatrix)object, intVector, intVector.size());
        doubleVector = ((PaceMatrix)object).getColumn(0).unpivoting(intVector, n2);
        return doubleVector.getArrayCopy();
    }

    public boolean checkForMissing(Instances instances) {
        for (int i = 0; i < instances.numInstances(); ++i) {
            Instance instance = instances.instance(i);
            for (int j = 0; j < instances.numAttributes(); ++j) {
                if (!instance.isMissing(j)) continue;
                return true;
            }
        }
        return false;
    }

    public boolean checkForMissing(Instance instance, Instances instances) {
        for (int i = 0; i < instance.numAttributes(); ++i) {
            if (i == instances.classIndex() || !instance.isMissing(i)) continue;
            return true;
        }
        return false;
    }

    public boolean checkForNonBinary(Instances instances) {
        for (int i = 0; i < instances.numAttributes(); ++i) {
            if (!instances.attribute(i).isNominal() || instances.attribute(i).numValues() == 2) continue;
            return true;
        }
        return false;
    }

    private double[][] getTransformedDataMatrix(Instances instances, int n) {
        int n2 = instances.numInstances();
        int n3 = instances.numAttributes();
        int n4 = n;
        if (n4 < 0) {
            n4 = n3;
        }
        double[][] dArray = new double[n2][n3];
        for (int i = 0; i < n2; ++i) {
            int n5;
            Instance instance = instances.instance(i);
            dArray[i][0] = 1.0;
            for (n5 = 0; n5 < n4; ++n5) {
                dArray[i][n5 + 1] = instance.value(n5);
            }
            for (n5 = n4 + 1; n5 < n3; ++n5) {
                dArray[i][n5] = instance.value(n5);
            }
        }
        return dArray;
    }

    public double classifyInstance(Instance instance) throws Exception {
        if (this.m_Coefficients == null) {
            throw new Exception("Pace Regression: No model built yet.");
        }
        if (this.checkForMissing(instance, this.m_Model)) {
            throw new NoSupportForMissingValuesException("Can't handle missing values!");
        }
        return this.regressionPrediction(instance, this.m_Coefficients);
    }

    public String toString() {
        if (this.m_Coefficients == null) {
            return "Pace Regression: No model built yet.";
        }
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("\nPace Regression Model\n\n");
        stringBuffer.append(this.m_Model.classAttribute().name() + " =\n\n");
        int n = 0;
        stringBuffer.append(Utils.doubleToString(this.m_Coefficients[0], 12, 4));
        for (int i = 1; i < this.m_Coefficients.length; ++i) {
            if (n == this.m_ClassIndex) {
                ++n;
            }
            if (this.m_Coefficients[i] != 0.0) {
                stringBuffer.append(" +\n");
                stringBuffer.append(Utils.doubleToString(this.m_Coefficients[i], 12, 4) + " * ");
                stringBuffer.append(this.m_Model.attribute(n).name());
            }
            ++n;
        }
        return stringBuffer.toString();
    }

    public Enumeration listOptions() {
        Vector<Option> vector = new Vector<Option>(2);
        vector.addElement(new Option("\tProduce debugging output.\n\t(default no debugging output)", "D", 0, "-D"));
        vector.addElement(new Option("\tThe estimator can be one of the following:\n\t\teb\tEmpirical Bayes(default)\n\t\tnested\tOptimal nested model\n\t\tsubset\tOptimal subset\n\t\tpace2\tPACE2\n\t\tpace4\tPACE4\n\t\tpace6\tPACE6\n\n\t\tols\tOrdinary least squares\n\t\taic\tAIC\n\t\tbic\tBIC\n\t\tric\tRIC\n\t\tolsc\tOLSC", "E", 0, "-E <estimator>"));
        vector.addElement(new Option("\tThreshold value for the OLSC estimator", "S", 0, "-S <threshold value>"));
        return vector.elements();
    }

    public void setOptions(String[] stringArray) throws Exception {
        this.setDebug(Utils.getFlag('D', stringArray));
        String string = Utils.getOption('E', stringArray);
        if (string.equals("ols")) {
            this.paceEstimator = 0;
        } else if (string.equals("olsc")) {
            this.paceEstimator = 7;
        } else if (string.equals("eb") || string.equals("")) {
            this.paceEstimator = 1;
        } else if (string.equals("nested")) {
            this.paceEstimator = 2;
        } else if (string.equals("subset")) {
            this.paceEstimator = 3;
        } else if (string.equals("pace2")) {
            this.paceEstimator = 4;
        } else if (string.equals("pace4")) {
            this.paceEstimator = 5;
        } else if (string.equals("pace6")) {
            this.paceEstimator = 6;
        } else if (string.equals("aic")) {
            this.paceEstimator = 8;
        } else if (string.equals("bic")) {
            this.paceEstimator = 9;
        } else if (string.equals("ric")) {
            this.paceEstimator = 10;
        } else {
            throw new WekaException("unknown estimator " + string + " for -E option");
        }
        String string2 = Utils.getOption('S', stringArray);
        if (!string2.equals("")) {
            this.olscThreshold = Double.parseDouble(string2);
        }
    }

    public double[] coefficients() {
        double[] dArray = new double[this.m_Coefficients.length];
        for (int i = 0; i < dArray.length; ++i) {
            dArray[i] = this.m_Coefficients[i];
        }
        return dArray;
    }

    public String[] getOptions() {
        String[] stringArray = new String[6];
        int n = 0;
        if (this.getDebug()) {
            stringArray[n++] = "-D";
        }
        stringArray[n++] = "-E";
        switch (this.paceEstimator) {
            case 0: {
                stringArray[n++] = "ols";
                break;
            }
            case 7: {
                stringArray[n++] = "olsc";
                stringArray[n++] = "-S";
                stringArray[n++] = "" + this.olscThreshold;
                break;
            }
            case 1: {
                stringArray[n++] = "eb";
                break;
            }
            case 2: {
                stringArray[n++] = "nested";
                break;
            }
            case 3: {
                stringArray[n++] = "subset";
                break;
            }
            case 4: {
                stringArray[n++] = "pace2";
                break;
            }
            case 5: {
                stringArray[n++] = "pace4";
                break;
            }
            case 6: {
                stringArray[n++] = "pace6";
                break;
            }
            case 8: {
                stringArray[n++] = "aic";
                break;
            }
            case 9: {
                stringArray[n++] = "bic";
                break;
            }
            case 10: {
                stringArray[n++] = "ric";
            }
        }
        while (n < stringArray.length) {
            stringArray[n++] = "";
        }
        return stringArray;
    }

    public int numParameters() {
        return this.m_Coefficients.length - 1;
    }

    public String debugTipText() {
        return "Output debug information to the console.";
    }

    public void setDebug(boolean bl) {
        this.m_Debug = bl;
    }

    public boolean getDebug() {
        return this.m_Debug;
    }

    public String estimatorTipText() {
        return "The estimator to use.\n\neb -- Empirical Bayes estimator for noraml mixture (default)\nnested -- Optimal nested model selector for normal mixture\nsubset -- Optimal subset selector for normal mixture\npace2 -- PACE2 for Chi-square mixture\npace4 -- PACE4 for Chi-square mixture\npace6 -- PACE6 for Chi-square mixture\nols -- Ordinary least squares estimator\naic -- AIC estimator\nbic -- BIC estimator\nric -- RIC estimator\nolsc -- Ordinary least squares subset selector with a threshold";
    }

    public SelectedTag getEstimator() {
        return new SelectedTag(this.paceEstimator, TAGS_ESTIMATOR);
    }

    public void setEstimator(SelectedTag selectedTag) {
        if (selectedTag.getTags() == TAGS_ESTIMATOR) {
            this.paceEstimator = selectedTag.getSelectedTag().getID();
        }
    }

    public String thresholdTipText() {
        return "Threshold for the olsc estimator.";
    }

    public void setThreshold(double d) {
        this.olscThreshold = d;
    }

    public double getThreshold() {
        return this.olscThreshold;
    }

    private double regressionPrediction(Instance instance, double[] dArray) throws Exception {
        int n = 0;
        double d = dArray[n];
        for (int i = 0; i < instance.numAttributes(); ++i) {
            if (this.m_ClassIndex == i) continue;
            d += dArray[++n] * instance.value(i);
        }
        return d;
    }

    public static void main(String[] stringArray) {
        try {
            PaceRegression paceRegression = new PaceRegression();
            System.out.println(Evaluation.evaluateModel(paceRegression, stringArray));
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }
}

