/*
 * Decompiled with CFR 0.152.
 */
package weka.classifiers.meta;

import weka.classifiers.Classifier;
import weka.classifiers.Evaluation;
import weka.classifiers.SingleClassifierEnhancer;
import weka.classifiers.trees.M5P;
import weka.core.Instance;
import weka.core.Instances;
import weka.core.UnsupportedClassTypeException;
import weka.core.Utils;
import weka.filters.Filter;
import weka.filters.unsupervised.attribute.MakeIndicator;

public class ClassificationViaRegression
extends SingleClassifierEnhancer {
    private Classifier[] m_Classifiers;
    private MakeIndicator[] m_ClassFilters;

    public String globalInfo() {
        return "Class for doing classification using regression methods. Class is binarized and one regression model is built for each class value. For more information, see, for example\n\nE. Frank, Y. Wang, S. Inglis, G. Holmes, and I.H. Witten (1998) \"Using model trees for classification\", Machine Learning, Vol.32, No.1, pp. 63-76.";
    }

    protected String defaultClassifierString() {
        return "weka.classifiers.trees.M5P";
    }

    public ClassificationViaRegression() {
        this.m_Classifier = new M5P();
    }

    public void buildClassifier(Instances instances) throws Exception {
        if (instances.classAttribute().isNumeric()) {
            throw new UnsupportedClassTypeException("ClassificationViaRegression can't handle a numeric class!");
        }
        this.m_Classifiers = Classifier.makeCopies(this.m_Classifier, instances.numClasses());
        this.m_ClassFilters = new MakeIndicator[instances.numClasses()];
        for (int i = 0; i < instances.numClasses(); ++i) {
            this.m_ClassFilters[i] = new MakeIndicator();
            this.m_ClassFilters[i].setAttributeIndex("" + (instances.classIndex() + 1));
            this.m_ClassFilters[i].setValueIndex(i);
            this.m_ClassFilters[i].setNumeric(true);
            this.m_ClassFilters[i].setInputFormat(instances);
            Instances instances2 = Filter.useFilter(instances, this.m_ClassFilters[i]);
            this.m_Classifiers[i].buildClassifier(instances2);
        }
    }

    public double[] distributionForInstance(Instance instance) throws Exception {
        double[] dArray = new double[instance.numClasses()];
        double d = 0.0;
        double d2 = Double.MIN_VALUE;
        double d3 = Double.MAX_VALUE;
        for (int i = 0; i < instance.numClasses(); ++i) {
            this.m_ClassFilters[i].input(instance);
            this.m_ClassFilters[i].batchFinished();
            Instance instance2 = this.m_ClassFilters[i].output();
            dArray[i] = this.m_Classifiers[i].classifyInstance(instance2);
            if (dArray[i] > 1.0) {
                dArray[i] = 1.0;
            }
            if (dArray[i] < 0.0) {
                dArray[i] = 0.0;
            }
            d += dArray[i];
        }
        if (d != 0.0) {
            Utils.normalize(dArray, d);
        }
        return dArray;
    }

    public String toString() {
        if (this.m_Classifiers == null) {
            return "Classification via Regression: No model built yet.";
        }
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("Classification via Regression\n\n");
        for (int i = 0; i < this.m_Classifiers.length; ++i) {
            stringBuffer.append("Classifier for class with index " + i + ":\n\n");
            stringBuffer.append(this.m_Classifiers[i].toString() + "\n\n");
        }
        return stringBuffer.toString();
    }

    public static void main(String[] stringArray) {
        try {
            ClassificationViaRegression classificationViaRegression = new ClassificationViaRegression();
            System.out.println(Evaluation.evaluateModel(classificationViaRegression, stringArray));
        }
        catch (Exception exception) {
            System.out.println(exception.getMessage());
        }
    }
}

