/*
 * Decompiled with CFR 0.152.
 */
package weka.clusterers;

import java.io.BufferedReader;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.PrintWriter;
import java.io.Reader;
import java.io.Serializable;
import java.util.Enumeration;
import java.util.Random;
import java.util.Vector;
import weka.clusterers.ClusterEvaluation;
import weka.clusterers.Clusterer;
import weka.core.AlgVector;
import weka.core.EuclideanDistance;
import weka.core.Instance;
import weka.core.Instances;
import weka.core.KDTree;
import weka.core.Option;
import weka.core.OptionHandler;
import weka.core.Utils;
import weka.filters.Filter;
import weka.filters.unsupervised.attribute.ReplaceMissingValues;

public class XMeans
extends Clusterer
implements OptionHandler {
    private Instances m_Instances = null;
    private Instances m_Model = null;
    private ReplaceMissingValues m_ReplaceMissingFilter;
    private double m_BinValue = 1.0;
    double m_Bic = Double.MIN_VALUE;
    double[] m_Mle = null;
    private int m_MaxIterations = 1;
    private int m_MaxKMeans = 1000;
    private int m_MaxKMeansForChildren = 1000;
    private int m_NumClusters = 2;
    private int m_MinNumClusters = 2;
    private int m_MaxNumClusters = 4;
    private EuclideanDistance m_DistanceF = null;
    private Instances m_ClusterCenters;
    String m_InputCenterFile = null;
    Reader m_DebugVektorsInput = null;
    int m_DebugVektorsIndex = 0;
    Instances m_DebugVektors = null;
    String m_DebugVektorsFile = null;
    Reader m_CenterInput = null;
    String m_OutputCenterFile = null;
    PrintWriter m_CenterOutput = null;
    private int[] m_ClusterAssignments;
    double m_CutOffFactor = 0.5;
    private int m_Seed = 10;
    public static int R_LOW = 0;
    public static int R_HIGH = 1;
    public static int R_WIDTH = 2;
    private KDTree m_KDTree = null;
    private int m_IterationCount = 0;
    private int m_KMeansStopped = 0;
    private int m_NumSplits = 0;
    private int m_NumSplitsDone = 0;
    private int m_NumSplitsStillDone = 0;
    private int m_DebugLevel = 0;
    public static int D_PRINTCENTERS = 1;
    public static int D_FOLLOWSPLIT = 2;
    public static int D_CONVCHCLOSER = 3;
    public static int D_RANDOMVEKTOR = 4;
    public static int D_KDTREE = 5;
    public static int D_ITERCOUNT = 6;
    public static int D_METH_MISUSE = 80;
    public static int D_CURR = 88;
    public static int D_GENERAL = 99;
    public boolean m_CurrDebugFlag = true;
    static /* synthetic */ Class class$weka$core$KDTree;
    static /* synthetic */ Class class$weka$core$EuclideanDistance;

    public String globalInfo() {
        return "Cluster data using the X-means algorithm, as described in D. Pelleg and A. Moore's paper 'X-means: Extending K-means with Efficient Estimation of the Number of Clusters'.";
    }

    public void buildClusterer(Instances instances) throws Exception {
        int n;
        if (instances.checkForStringAttributes()) {
            throw new Exception("Can't handle string attributes!");
        }
        this.m_ReplaceMissingFilter = new ReplaceMissingValues();
        this.m_ReplaceMissingFilter.setInputFormat(instances);
        this.m_Instances = instances = Filter.useFilter(instances, this.m_ReplaceMissingFilter);
        Random random = new Random(this.m_Seed);
        this.m_NumClusters = this.m_MinNumClusters;
        if (this.m_DistanceF == null) {
            this.m_DistanceF = new EuclideanDistance(instances);
            this.checkInstances();
        } else if (this.m_DistanceF.getInstances() == null) {
            this.m_DistanceF.setInstances(instances);
        }
        if (this.m_DistanceF != null) {
            this.checkInstances();
        }
        if (this.m_DebugVektorsFile != null) {
            this.initDebugVektorsInput();
        }
        int[] nArray = new int[this.m_Instances.numInstances()];
        for (n = 0; n < this.m_Instances.numInstances(); ++n) {
            nArray[n] = n;
        }
        this.m_Model = new Instances(this.m_Instances, 0);
        if (this.m_CenterInput != null) {
            this.m_ClusterCenters = new Instances(this.m_CenterInput);
            this.m_NumClusters = this.m_ClusterCenters.numInstances();
        } else {
            this.m_ClusterCenters = this.makeCentersRandomly(random, this.m_Instances, this.m_NumClusters);
        }
        this.PFD(D_FOLLOWSPLIT, "\n*** Starting centers ");
        for (n = 0; n < this.m_ClusterCenters.numInstances(); ++n) {
            this.PFD(D_FOLLOWSPLIT, "Center " + n + ": " + this.m_ClusterCenters.instance(n));
        }
        this.PrCentersFD(D_PRINTCENTERS);
        n = 0;
        if (this.m_KDTree != null) {
            this.m_KDTree.setInstances(this.m_Instances);
        }
        this.m_IterationCount = 0;
        boolean bl = true;
        while (n == 0 && !this.stopIteration(this.m_IterationCount, this.m_MaxIterations)) {
            int[] nArray2;
            this.PFD(D_FOLLOWSPLIT, "\nBeginning of main loop - centers:");
            this.PrCentersFD(D_FOLLOWSPLIT);
            this.PFD(D_ITERCOUNT, "\n*** 1. Improve-Params " + this.m_IterationCount + ". time");
            ++this.m_IterationCount;
            boolean bl2 = false;
            this.m_ClusterAssignments = this.initAssignments(this.m_Instances.numInstances());
            int[][] nArrayArray = new int[this.m_ClusterCenters.numInstances()][];
            int n2 = 0;
            this.PFD(D_FOLLOWSPLIT, "\nConverge in K-Means:");
            while (!bl2 && !this.stopKMeansIteration(n2, this.m_MaxKMeans)) {
                bl2 = true;
                bl2 = this.assignToCenters(this.m_KDTree, this.m_ClusterCenters, nArrayArray, nArray, this.m_ClusterAssignments, ++n2);
                this.PFD(D_FOLLOWSPLIT, "\nMain loop - Assign - centers:");
                this.PrCentersFD(D_FOLLOWSPLIT);
                bl2 = this.recomputeCenters(this.m_ClusterCenters, nArrayArray, this.m_Model);
                this.PFD(D_FOLLOWSPLIT, "\nMain loop - Recompute - centers:");
                this.PrCentersFD(D_FOLLOWSPLIT);
            }
            this.PFD(D_FOLLOWSPLIT, "");
            this.PFD(D_FOLLOWSPLIT, "End of Part: 1. Improve-Params - conventional K-means");
            this.m_Mle = this.distortion(nArrayArray, this.m_ClusterCenters);
            this.m_Bic = this.calculateBIC(nArrayArray, this.m_ClusterCenters, this.m_Mle);
            this.PFD(D_FOLLOWSPLIT, "m_Bic " + this.m_Bic);
            int n3 = this.m_ClusterCenters.numInstances();
            Instances instances2 = new Instances(this.m_ClusterCenters, n3 * 2);
            double[] dArray = new double[n3];
            double[] dArray2 = new double[n3];
            for (int i = 0; i < n3; ++i) {
                this.PFD(D_FOLLOWSPLIT, "\nsplit center " + i + " " + this.m_ClusterCenters.instance(i));
                Instance instance = this.m_ClusterCenters.instance(i);
                nArray2 = nArrayArray[i];
                int n4 = nArrayArray[i].length;
                double d = this.m_Mle[i];
                if (n4 <= 2) {
                    dArray[i] = Double.MAX_VALUE;
                    dArray2[i] = 0.0;
                    instances2.add(instance);
                    instances2.add(instance);
                    continue;
                }
                double d2 = this.m_Mle[i] / (double)n4;
                Instances instances3 = this.splitCenter(random, instance, d2, this.m_Model);
                int[] nArray3 = this.initAssignments(n4);
                int[][] nArrayArray2 = new int[2][];
                bl2 = false;
                int n5 = 0;
                this.PFD(D_FOLLOWSPLIT, "\nConverge, K-Means for children: " + i);
                while (!bl2 && !this.stopKMeansIteration(n5, this.m_MaxKMeansForChildren)) {
                    ++n5;
                    bl2 = this.assignToCenters(instances3, nArrayArray2, nArray2, nArray3);
                    if (bl2) continue;
                    this.recomputeCentersFast(instances3, nArrayArray2, this.m_Model);
                }
                instances2.add(instances3.instance(0));
                instances2.add(instances3.instance(1));
                this.PFD(D_FOLLOWSPLIT, "\nconverged cildren ");
                this.PFD(D_FOLLOWSPLIT, " " + instances3.instance(0));
                this.PFD(D_FOLLOWSPLIT, " " + instances3.instance(1));
                dArray[i] = this.calculateBIC(nArray2, instance, this.m_Mle[i], this.m_Model);
                double[] dArray3 = this.distortion(nArrayArray2, instances3);
                dArray2[i] = this.calculateBIC(nArrayArray2, instances3, dArray3);
            }
            Instances instances4 = null;
            instances4 = this.newCentersAfterSplit(dArray, dArray2, this.m_CutOffFactor, instances2);
            int n6 = instances4.numInstances();
            if (n6 != this.m_NumClusters) {
                this.PFD(D_FOLLOWSPLIT, "Compare with non-split");
                nArray2 = this.initAssignments(this.m_Instances.numInstances());
                int[][] nArrayArray3 = new int[instances4.numInstances()][];
                bl2 = this.assignToCenters(this.m_KDTree, instances4, nArrayArray3, nArray, nArray2, this.m_IterationCount);
                double[] dArray4 = this.distortion(nArrayArray3, instances4);
                double d = this.calculateBIC(nArrayArray3, instances4, dArray4);
                this.PFD(D_FOLLOWSPLIT, "newBic " + d);
                if (d > this.m_Bic) {
                    this.PFD(D_FOLLOWSPLIT, "*** decide for new clusters");
                    this.m_Bic = d;
                    this.m_ClusterCenters = instances4;
                    this.m_ClusterAssignments = nArray2;
                } else {
                    this.PFD(D_FOLLOWSPLIT, "*** keep old clusters");
                }
            }
            if ((n6 = this.m_ClusterCenters.numInstances()) >= this.m_MaxNumClusters || n6 == this.m_NumClusters) {
                n = 1;
            }
            this.m_NumClusters = n6;
        }
    }

    public boolean checkForNominalAttributes(Instances instances) {
        int n = 0;
        while (n < instances.numAttributes()) {
            if (n == instances.classIndex() || !instances.attribute(n++).isNominal()) continue;
            return true;
        }
        return false;
    }

    private int[] initAssignments(int[] nArray) {
        for (int i = 0; i < nArray.length; ++i) {
            nArray[i] = -1;
        }
        return nArray;
    }

    private int[] initAssignments(int n) {
        int[] nArray = new int[n];
        for (int i = 0; i < n; ++i) {
            nArray[i] = -1;
        }
        return nArray;
    }

    boolean[] initBoolArray(int n) {
        boolean[] blArray = new boolean[n];
        for (int i = 0; i < n; ++i) {
            blArray[i] = false;
        }
        return blArray;
    }

    private Instances newCentersAfterSplit(double[] dArray, double[] dArray2, double d, Instances instances) {
        boolean bl = false;
        boolean bl2 = false;
        boolean[] blArray = this.initBoolArray(this.m_ClusterCenters.numInstances());
        int n = 0;
        Instances instances2 = null;
        for (int i = 0; i < dArray2.length; ++i) {
            if (dArray2[i] > dArray[i]) {
                blArray[i] = true;
                ++n;
                this.PFD(D_FOLLOWSPLIT, "Center " + i + " decide for children");
                continue;
            }
            this.PFD(D_FOLLOWSPLIT, "Center " + i + " decide for parent");
        }
        if (n == 0 && d > 0.0) {
            bl = true;
            n = (int)((double)this.m_ClusterCenters.numInstances() * this.m_CutOffFactor);
        }
        double[] dArray3 = new double[this.m_NumClusters];
        for (int i = 0; i < dArray3.length; ++i) {
            dArray3[i] = dArray[i] - dArray2[i];
        }
        int[] nArray = Utils.sort(dArray3);
        int n2 = this.m_MaxNumClusters - this.m_NumClusters;
        if (n2 > n) {
            n2 = n;
        } else {
            bl2 = true;
        }
        if (bl) {
            for (int i = 0; i < n2 && dArray2[nArray[i]] > 0.0; ++i) {
                blArray[nArray[i]] = true;
            }
            this.m_NumSplitsStillDone += n2;
        } else if (bl2) {
            int n3;
            int n4 = 0;
            for (n3 = 0; n3 < blArray.length && n4 < n2; ++n3) {
                if (!blArray[nArray[n3]]) continue;
                ++n4;
            }
            while (n3 < blArray.length) {
                blArray[nArray[n3]] = false;
                ++n3;
            }
        }
        instances2 = n2 > 0 ? this.newCentersAfterSplit(blArray, instances) : this.m_ClusterCenters;
        return instances2;
    }

    private Instances newCentersAfterSplit(boolean[] blArray, Instances instances) {
        Instances instances2 = new Instances(instances, 0);
        int n = 0;
        for (int i = 0; i < blArray.length; ++i) {
            if (blArray[i]) {
                ++this.m_NumSplitsDone;
                instances2.add(instances.instance(n++));
                instances2.add(instances.instance(n++));
                continue;
            }
            ++n;
            ++n;
            instances2.add(this.m_ClusterCenters.instance(i));
        }
        return instances2;
    }

    private boolean stopKMeansIteration(int n, int n2) {
        boolean bl = false;
        if (n2 >= 0) {
            boolean bl2 = bl = n >= n2;
        }
        if (bl) {
            ++this.m_KMeansStopped;
        }
        return bl;
    }

    private boolean stopIteration(int n, int n2) {
        boolean bl = false;
        if (n2 >= 0) {
            bl = n >= n2;
        }
        return bl;
    }

    private boolean recomputeCenters(Instances instances, int[][] nArray, Instances instances2) {
        boolean bl = true;
        for (int i = 0; i < instances.numInstances(); ++i) {
            for (int j = 0; j < instances2.numAttributes(); ++j) {
                double d = this.meanOrMode(this.m_Instances, nArray[i], j);
                for (int k = 0; k < nArray[i].length; ++k) {
                    if (!bl || this.m_ClusterCenters.instance(i).value(j) == d) continue;
                    bl = false;
                }
                if (bl) continue;
                this.m_ClusterCenters.instance(i).setValue(j, d);
            }
        }
        return bl;
    }

    private void recomputeCentersFast(Instances instances, int[][] nArray, Instances instances2) {
        for (int i = 0; i < instances.numInstances(); ++i) {
            for (int j = 0; j < instances2.numAttributes(); ++j) {
                double d = this.meanOrMode(this.m_Instances, nArray[i], j);
                instances.instance(i).setValue(j, d);
            }
        }
    }

    private double meanOrMode(Instances instances, int[] nArray, int n) {
        int n2 = nArray.length;
        if (instances.attribute(n).isNumeric()) {
            double d = 0.0;
            double d2 = 0.0;
            for (int i = 0; i < n2; ++i) {
                Instance instance = instances.instance(nArray[i]);
                if (instance.isMissing(n)) continue;
                d += instance.weight();
                d2 += instance.weight() * instance.value(n);
            }
            if (Utils.eq(d, 0.0)) {
                return 0.0;
            }
            return d2 / d;
        }
        if (instances.attribute(n).isNominal()) {
            int[] nArray2 = new int[instances.attribute(n).numValues()];
            for (int i = 0; i < n2; ++i) {
                Instance instance = instances.instance(nArray[i]);
                if (instance.isMissing(n)) continue;
                int n3 = (int)instance.value(n);
                nArray2[n3] = (int)((double)nArray2[n3] + instance.weight());
            }
            return Utils.maxIndex(nArray2);
        }
        return 0.0;
    }

    private boolean assignToCenters(KDTree kDTree, Instances instances, int[][] nArray, int[] nArray2, int[] nArray3, int n) throws Exception {
        boolean bl = true;
        bl = kDTree != null ? this.assignToCenters(kDTree, instances, nArray, nArray3, n) : this.assignToCenters(instances, nArray, nArray2, nArray3);
        return bl;
    }

    private boolean assignToCenters(KDTree kDTree, Instances instances, int[][] object, int[] nArray, int n) throws Exception {
        int n2;
        int n3 = instances.numInstances();
        int n4 = this.m_Instances.numInstances();
        int[] nArray2 = new int[n4];
        if (nArray == null) {
            this.OOPS(D_METH_MISUSE, "assignment was null");
            nArray = new int[n4];
            for (n2 = 0; n2 < n4; n2 += 1) {
                nArray[0] = -1;
            }
        }
        if (object == null) {
            this.OOPS(D_METH_MISUSE, "inst of cent was null");
            object = new int[n3][];
        }
        for (n2 = 0; n2 < nArray.length; n2 += 1) {
            nArray2[n2] = nArray[n2];
        }
        kDTree.centerInstances(instances, nArray, Math.pow(0.8, n));
        n2 = 1;
        for (int i = 0; n2 && i < nArray.length; ++i) {
            int n5 = n2 = nArray2[i] == nArray[i] ? 1 : 0;
            if (nArray[i] != -1) continue;
            throw new Exception("Instance " + i + " has not been assigned to cluster.");
        }
        if (!n2) {
            int n6;
            int[] nArray3 = new int[n3];
            for (n6 = 0; n6 < n3; ++n6) {
                nArray3[n6] = 0;
            }
            for (n6 = 0; n6 < n4; ++n6) {
                int n7 = nArray[n6];
                nArray3[n7] = nArray3[n7] + 1;
            }
            for (n6 = 0; n6 < n3; ++n6) {
                object[n6] = new int[nArray3[n6]];
            }
            for (n6 = 0; n6 < n3; ++n6) {
                int n8 = -1;
                for (int i = 0; i < nArray3[n6]; ++i) {
                    object[n6][i] = n8 = this.nextAssignedOne(n6, n8, nArray);
                }
            }
        }
        return n2 != 0;
    }

    private boolean assignToCenters(Instances instances, int[][] object, int[] nArray, int[] nArray2) throws Exception {
        int n;
        int n2;
        boolean bl = true;
        int n3 = nArray.length;
        int n4 = instances.numInstances();
        int[] nArray3 = new int[n4];
        for (n2 = 0; n2 < n4; ++n2) {
            nArray3[n2] = 0;
        }
        if (nArray2 == null) {
            this.OOPS(D_METH_MISUSE, "assignment was null");
            nArray2 = new int[n3];
            for (n2 = 0; n2 < n3; ++n2) {
                nArray2[n2] = -1;
            }
        }
        if (object == null) {
            this.OOPS(D_METH_MISUSE, "inst of cent was null");
            object = new int[n4][];
        }
        for (n2 = 0; n2 < n3; ++n2) {
            Instance instance = this.m_Instances.instance(nArray[n2]);
            n = this.clusterProcessedInstance(instance, instances);
            if (bl && n != nArray2[n2]) {
                bl = false;
            }
            int n5 = n;
            nArray3[n5] = nArray3[n5] + 1;
            if (bl) continue;
            nArray2[n2] = n;
        }
        if (!bl) {
            this.PFD(D_FOLLOWSPLIT, "assignToCenters -> it has NOT converged");
            for (n2 = 0; n2 < n4; ++n2) {
                object[n2] = new int[nArray3[n2]];
            }
            for (n2 = 0; n2 < n4; ++n2) {
                int n6 = -1;
                for (n = 0; n < nArray3[n2]; ++n) {
                    n6 = this.nextAssignedOne(n2, n6, nArray2);
                    object[n2][n] = nArray[n6];
                }
            }
        } else {
            this.PFD(D_FOLLOWSPLIT, "assignToCenters -> it has converged");
        }
        return bl;
    }

    private int nextAssignedOne(int n, int n2, int[] nArray) {
        int n3 = nArray.length;
        for (int i = n2 + 1; i < n3; ++i) {
            if (nArray[i] != n) continue;
            return i;
        }
        return -1;
    }

    private Instances splitCenter(Random random, Instance instance, double d, Instances instances) throws Exception {
        Serializable serializable;
        ++this.m_NumSplits;
        AlgVector algVector = null;
        Instances instances2 = new Instances(instances, 2);
        if (this.m_DebugVektorsFile != null) {
            serializable = this.getNextDebugVektorsInstance(instances);
            this.PFD(D_RANDOMVEKTOR, "Random Vector from File " + serializable);
            algVector = new AlgVector((Instance)serializable);
        } else {
            algVector = new AlgVector(instances, random);
        }
        algVector.changeLength(Math.pow(d, 0.5));
        this.PFD(D_RANDOMVEKTOR, "random vector *variance " + algVector);
        serializable = new AlgVector(instance);
        AlgVector algVector2 = (AlgVector)((AlgVector)serializable).clone();
        ((AlgVector)serializable).add(algVector);
        Instance instance2 = ((AlgVector)serializable).getAsInstance(instances, random);
        instances2.add(instance2);
        this.PFD(D_FOLLOWSPLIT, "first child " + instance2);
        algVector2.substract(algVector);
        instance2 = ((AlgVector)serializable).getAsInstance(instances, random);
        instances2.add(instance2);
        this.PFD(D_FOLLOWSPLIT, "second child " + instance2);
        return instances2;
    }

    private Instances splitCenters(Random random, Instances instances, Instances instances2) {
        Instances instances3 = new Instances(instances2, 2);
        int n = Math.abs(random.nextInt()) % instances.numInstances();
        instances3.add(instances.instance(n));
        int n2 = n;
        for (int i = 0; n2 == n && i < 10; ++i) {
            n2 = Math.abs(random.nextInt()) % instances.numInstances();
        }
        instances3.add(instances.instance(n2));
        return instances3;
    }

    private Instances makeCentersRandomly(Random random, Instances instances, int n) {
        Instances instances2 = new Instances(instances, n);
        this.m_NumClusters = n;
        for (int i = 0; i < n; ++i) {
            int n2 = Math.abs(random.nextInt()) % this.m_Instances.numInstances();
            instances2.add(this.m_Instances.instance(n2));
        }
        return instances2;
    }

    private double calculateBIC(int[] nArray, Instance instance, double d, Instances instances) {
        int[][] nArray2 = new int[1][nArray.length];
        for (int i = 0; i < nArray.length; ++i) {
            nArray2[0][i] = nArray[i];
        }
        double[] dArray = new double[]{d};
        Instances instances2 = new Instances(instances, 1);
        instances2.add(instance);
        return this.calculateBIC(nArray2, instances2, dArray);
    }

    private double calculateBIC(int[][] nArray, Instances instances, double[] dArray) {
        double d = 0.0;
        int n = 0;
        int n2 = instances.numInstances();
        int n3 = instances.numAttributes();
        int n4 = n2 - 1 + n2 * n3 + n2;
        for (int i = 0; i < instances.numInstances(); ++i) {
            d += this.logLikelihoodEstimate(nArray[i].length, instances.instance(i), dArray[i], instances.numInstances() * 2);
            n += nArray[i].length;
        }
        d -= (double)n * Math.log(n);
        return d -= (double)n4 / 2.0 * Math.log(n);
    }

    private double logLikelihoodEstimate(int n, Instance instance, double d, int n2) {
        double d2 = 0.0;
        if (n > 1) {
            double d3 = d / ((double)n - 1.0);
            double d4 = -((double)n / 2.0) * Math.log(Math.PI * 2);
            double d5 = (double)(-(n * instance.numAttributes()) / 2) * Math.log(d3);
            double d6 = -((double)n - 1.0) / 2.0;
            double d7 = (double)n * Math.log(n);
            d2 = d4 + d5 + d6 + d7;
        }
        return d2;
    }

    private double[] distortion(int[][] nArray, Instances instances) throws Exception {
        double[] dArray = new double[instances.numInstances()];
        for (int i = 0; i < instances.numInstances(); ++i) {
            dArray[i] = 0.0;
            for (int j = 0; j < nArray[i].length; ++j) {
                int n = i;
                dArray[n] = dArray[n] + this.m_DistanceF.distance(this.m_Instances.instance(nArray[i][j]), instances.instance(i));
            }
        }
        return dArray;
    }

    private int clusterProcessedInstance(Instance instance, Instances instances) throws Exception {
        double d = 2.147483647E9;
        int n = 0;
        for (int i = 0; i < instances.numInstances(); ++i) {
            double d2 = this.m_DistanceF.distance(instance, instances.instance(i));
            if (!(d2 < d)) continue;
            d = d2;
            n = i;
        }
        return n;
    }

    private int clusterProcessedInstance(Instance instance) throws Exception {
        double d = 2.147483647E9;
        int n = 0;
        for (int i = 0; i < this.m_NumClusters; ++i) {
            double d2 = this.m_DistanceF.distance(instance, this.m_ClusterCenters.instance(i));
            if (!(d2 < d)) continue;
            d = d2;
            n = i;
        }
        return n;
    }

    public int clusterInstance(Instance instance) throws Exception {
        this.m_ReplaceMissingFilter.input(instance);
        Instance instance2 = this.m_ReplaceMissingFilter.output();
        return this.clusterProcessedInstance(instance2);
    }

    public int numberOfClusters() {
        return this.m_NumClusters;
    }

    public Enumeration listOptions() {
        Vector<Option> vector = new Vector<Option>(4);
        vector.addElement(new Option("\tmaximum number of overall iterations (default = 1).", "I", 1, "-I <num>"));
        vector.addElement(new Option("\tmaximum number of iterations in the kMeans loop in the Improve-Parameter part  (default = 1000).", "M", 1, "-M <num>"));
        vector.addElement(new Option("\tmaximum number of iterations in the kMeans loop for the splitted centroids in the Improve-Structure part  (default = 1000).", "J", 1, "-J <num>"));
        vector.addElement(new Option("\tminimum number of clusters (default = 2).", "L", 1, "-L <num>"));
        vector.addElement(new Option("\tmaximum number of clusters (default = 4).", "H", 1, "-H <num>"));
        vector.addElement(new Option("\tdistance value for binary attributes (default = 1.0).", "V", 1, "-V <value>"));
        vector.addElement(new Option("\tFull class name of KDTree class to use, followed\n\tby scheme options.\n\teg: \"weka.core.KDTree -P\"\n(default = no KDTree class used).", "K", 1, "-K <KDTree class specification>"));
        vector.addElement(new Option("\tcutoff factor, takes the given percentage of the splitted \n\tcentroids if none of the children win\n\t(default = 0.0).", "C", 1, "-C <value>"));
        vector.addElement(new Option("\tFull class name of Distance function class to use, followed\n\tby scheme options.\n\teg: \"weka.core.MahalanobisDistance\"\n\t(default = weka.core.EuclideanDistance).", "K", 1, "-K <distance function class specification>"));
        vector.addElement(new Option("\tfile to read starting centers from (ARFF format).", "N", 1, "-N <file name>"));
        vector.addElement(new Option("\tfile to write centers to (ARFF format).", "O", 1, "-O <file name>"));
        vector.addElement(new Option("\trandom number seed (default 10).", "S", 1, "-S <num>"));
        return vector.elements();
    }

    public String minNumClustersTipText() {
        return "set minimum number of clusters";
    }

    public String maxNumClustersTipText() {
        return "set maximum number of clusters";
    }

    public void setMaxIterations(int n) throws Exception {
        if (n < 0) {
            throw new Exception("Only positive values for iteration number allowed (Option I).");
        }
        this.m_MaxIterations = n;
    }

    public int getMaxIterations() {
        return this.m_MaxIterations;
    }

    public void setMaxKMeans(int n) {
        this.m_MaxKMeans = n;
        this.m_MaxKMeansForChildren = n;
    }

    public int getMaxKMeans() {
        return this.m_MaxKMeans;
    }

    public void setMaxKMeansForChildren(int n) throws Exception {
        this.m_MaxKMeansForChildren = n;
    }

    public int getMaxKMeansForChildren() {
        return this.m_MaxKMeansForChildren;
    }

    public void setCutOffFactor(double d) throws Exception {
        this.m_CutOffFactor = d;
    }

    public double getCutOffFactor() {
        return this.m_CutOffFactor;
    }

    public void setMinNumClusters(int n) {
        if (n <= this.m_MaxNumClusters) {
            this.m_MinNumClusters = n;
        }
    }

    public void setMaxNumClusters(int n) {
        if (n >= this.m_MinNumClusters) {
            this.m_MaxNumClusters = n;
        }
    }

    public String binValueTipText() {
        return "Set the value that represents true in the new attributes.";
    }

    public double getBinValue() {
        return this.m_BinValue;
    }

    public void setBinValue(double d) {
        this.m_BinValue = d;
    }

    public void setDistanceF(EuclideanDistance euclideanDistance) {
        this.m_DistanceF = euclideanDistance;
    }

    public EuclideanDistance getDistanceF() {
        return this.m_DistanceF;
    }

    protected String getDistanceFSpec() {
        EuclideanDistance euclideanDistance = this.getDistanceF();
        if (euclideanDistance instanceof OptionHandler) {
            return euclideanDistance.getClass().getName() + " " + Utils.joinOptions(euclideanDistance.getOptions());
        }
        return euclideanDistance.getClass().getName();
    }

    public void setDebugVektorsFile(String string) {
        this.m_DebugVektorsFile = string;
    }

    public void initDebugVektorsInput() throws Exception {
        this.m_DebugVektorsInput = new BufferedReader(new FileReader(this.m_DebugVektorsFile));
        this.m_DebugVektors = new Instances(this.m_DebugVektorsInput);
        this.m_DebugVektorsIndex = 0;
    }

    public Instance getNextDebugVektorsInstance(Instances instances) throws Exception {
        if (this.m_DebugVektorsIndex >= this.m_DebugVektors.numInstances()) {
            throw new Exception("no more prefabricated Vektors");
        }
        Instance instance = this.m_DebugVektors.instance(this.m_DebugVektorsIndex);
        instance.setDataset(instances);
        ++this.m_DebugVektorsIndex;
        return instance;
    }

    public void setInputCenterFile(String string) {
        this.m_InputCenterFile = string;
    }

    public void setOutputCenterFile(String string) {
        this.m_OutputCenterFile = string;
    }

    public String getInputCenterFile() {
        return this.m_InputCenterFile;
    }

    public String getOutputCenterFile() {
        return this.m_OutputCenterFile;
    }

    public void setKDTree(KDTree kDTree) {
        this.m_KDTree = kDTree;
    }

    public KDTree getKDTree() {
        return this.m_KDTree;
    }

    protected String getKDTreeSpec() {
        KDTree kDTree = this.getKDTree();
        if (kDTree instanceof OptionHandler) {
            return kDTree.getClass().getName() + " " + Utils.joinOptions(kDTree.getOptions());
        }
        return kDTree.getClass().getName();
    }

    public void setDebugLevel(int n) {
        this.m_DebugLevel = n;
    }

    public int getDebugLevel() {
        return this.m_DebugLevel;
    }

    public int getMinNumClusters() {
        return this.m_MinNumClusters;
    }

    public int getMaxNumClusters() {
        return this.m_MaxNumClusters;
    }

    public String seedTipText() {
        return "random number seed";
    }

    public void setSeed(int n) {
        this.m_Seed = n;
    }

    public int getSeed() {
        return this.m_Seed;
    }

    private void checkInstances() throws Exception {
    }

    public void setOptions(String[] stringArray) throws Exception {
        String string;
        String[] stringArray2;
        String string2;
        String string3 = Utils.getOption('I', stringArray);
        if (string3.length() != 0) {
            this.setMaxIterations(Integer.parseInt(string3));
        }
        if ((string3 = Utils.getOption('M', stringArray)).length() != 0) {
            this.setMaxKMeans(Integer.parseInt(string3));
        }
        if ((string3 = Utils.getOption('J', stringArray)).length() != 0) {
            this.setMaxKMeansForChildren(Integer.parseInt(string3));
        }
        if ((string3 = Utils.getOption('L', stringArray)).length() != 0) {
            this.setMinNumClusters(Integer.parseInt(string3));
        }
        if ((string3 = Utils.getOption('H', stringArray)).length() != 0) {
            this.setMaxNumClusters(Integer.parseInt(string3));
        }
        if ((string3 = Utils.getOption('B', stringArray)).length() != 0) {
            this.setBinValue(Double.parseDouble(string3));
        }
        if ((string2 = Utils.getOption('K', stringArray)).length() != 0) {
            stringArray2 = Utils.splitOptions(string2);
            if (stringArray2.length == 0) {
                throw new Exception("Invalid function specification string");
            }
            string = stringArray2[0];
            stringArray2[0] = "";
            this.setKDTree((KDTree)Utils.forName(class$weka$core$KDTree == null ? (class$weka$core$KDTree = XMeans.class$("weka.core.KDTree")) : class$weka$core$KDTree, string, stringArray2));
        }
        if ((string3 = Utils.getOption('C', stringArray)).length() != 0) {
            this.setCutOffFactor(Double.parseDouble(string3));
        }
        if ((string2 = Utils.getOption('D', stringArray)).length() != 0) {
            stringArray2 = Utils.splitOptions(string2);
            if (stringArray2.length == 0) {
                throw new Exception("Invalid function specification string");
            }
            string = stringArray2[0];
            stringArray2[0] = "";
            this.setDistanceF((EuclideanDistance)Utils.forName(class$weka$core$EuclideanDistance == null ? (class$weka$core$EuclideanDistance = XMeans.class$("weka.core.EuclideanDistance")) : class$weka$core$EuclideanDistance, string, stringArray2));
        }
        if ((string3 = Utils.getOption('N', stringArray)).length() != 0) {
            this.setInputCenterFile(string3);
            this.m_CenterInput = new BufferedReader(new FileReader(string3));
        }
        if ((string3 = Utils.getOption('O', stringArray)).length() != 0) {
            this.setOutputCenterFile(string3);
            this.m_CenterOutput = new PrintWriter(new FileOutputStream(string3));
        }
        if ((string3 = Utils.getOption('S', stringArray)).length() != 0) {
            this.setSeed(Integer.parseInt(string3));
        }
        string3 = Utils.getOption('U', stringArray);
        int n = 0;
        if (string3.length() != 0) {
            try {
                n = Integer.parseInt(string3);
            }
            catch (NumberFormatException numberFormatException) {
                throw new Exception(string3 + "is an illegal value for option D");
            }
        }
        this.setDebugLevel(n);
        string3 = Utils.getOption('Y', stringArray);
        if (string3.length() != 0) {
            this.setDebugVektorsFile(string3);
        }
    }

    public String[] getOptions() {
        String[] stringArray = new String[27];
        int n = 0;
        stringArray[n++] = "-I";
        stringArray[n++] = "" + this.getMaxIterations();
        stringArray[n++] = "-M";
        stringArray[n++] = "" + this.getMaxKMeans();
        stringArray[n++] = "-J";
        stringArray[n++] = "" + this.getMaxKMeansForChildren();
        stringArray[n++] = "-L";
        stringArray[n++] = "" + this.getMinNumClusters();
        stringArray[n++] = "-H";
        stringArray[n++] = "" + this.getMaxNumClusters();
        stringArray[n++] = "-B";
        stringArray[n++] = "" + this.getBinValue();
        if (this.getKDTree() != null) {
            stringArray[n++] = "-K";
            stringArray[n++] = "" + this.getKDTreeSpec();
        }
        stringArray[n++] = "-C";
        stringArray[n++] = "" + this.getCutOffFactor();
        if (this.getDistanceF() != null) {
            stringArray[n++] = "-D";
            stringArray[n++] = "" + this.getDistanceFSpec();
        }
        if (this.getInputCenterFile() != null) {
            stringArray[n++] = "-N";
            stringArray[n++] = "" + this.getInputCenterFile();
        }
        if (this.getOutputCenterFile() != null) {
            stringArray[n++] = "-O";
            stringArray[n++] = "" + this.getOutputCenterFile();
        }
        stringArray[n++] = "-S";
        stringArray[n++] = "" + this.getSeed();
        int n2 = this.getDebugLevel();
        if (n2 > 0) {
            stringArray[n++] = "-U";
            stringArray[n++] = "" + this.getDebugLevel();
        }
        while (n < stringArray.length) {
            stringArray[n++] = "";
        }
        return stringArray;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("\nkMeans\n======\n");
        stringBuffer.append("Requested iterations            : " + this.m_MaxIterations + "\n");
        stringBuffer.append("Iterations performed            : " + this.m_IterationCount + "\n");
        stringBuffer.append("kMeans did not converge\n");
        stringBuffer.append("  but was stopped by max-loops " + this.m_KMeansStopped + " times (max kMeans-iter) = \n\n");
        stringBuffer.append("Splits prepared                 : " + this.m_NumSplits + "\n");
        stringBuffer.append("Splits performed                : " + this.m_NumSplitsDone + "\n");
        stringBuffer.append("Cutoff factor                   : " + this.m_CutOffFactor + "\n");
        double d = this.m_NumSplitsDone > 0 ? (double)this.m_NumSplitsStillDone / (double)this.m_NumSplitsDone * 100.0 : 0.0;
        stringBuffer.append("Percentage of splits accepted \nby cutoff factor                : " + Utils.doubleToString(d, 2) + " %\n");
        stringBuffer.append("------\n");
        stringBuffer.append("Cutoff factor                   : " + this.m_CutOffFactor + "\n");
        stringBuffer.append("------\n");
        stringBuffer.append("\nCluster centers                 : " + this.m_NumClusters + " centers\n");
        for (int i = 0; i < this.m_NumClusters; ++i) {
            stringBuffer.append("\nCluster " + i + "\n           ");
            for (int j = 0; j < this.m_ClusterCenters.numAttributes(); ++j) {
                if (this.m_ClusterCenters.attribute(j).isNominal()) {
                    stringBuffer.append(" " + this.m_ClusterCenters.attribute(j).value((int)this.m_ClusterCenters.instance(i).value(j)));
                    continue;
                }
                stringBuffer.append(" " + this.m_ClusterCenters.instance(i).value(j));
            }
        }
        if (this.m_Mle != null) {
            stringBuffer.append("\n\nDistortion: " + Utils.doubleToString(Utils.sum(this.m_Mle), 6) + "\n");
        }
        stringBuffer.append("BIC-Value : " + Utils.doubleToString(this.m_Bic, 6) + "\n");
        return stringBuffer.toString();
    }

    private void OOPS(int n, String string) {
        if (n == this.m_DebugLevel) {
            System.out.println(string);
        }
    }

    private void OOPS(String string) {
        System.out.println(string);
    }

    private void PrCentersFD(int n) {
        if (n == this.m_DebugLevel) {
            for (int i = 0; i < this.m_ClusterCenters.numInstances(); ++i) {
                System.out.println(this.m_ClusterCenters.instance(i));
            }
        }
    }

    private boolean TFD(int n) {
        return n == this.m_DebugLevel;
    }

    private void PFD(int n, String string) {
        if (n == this.m_DebugLevel) {
            System.out.println(string);
        }
    }

    private void PFD_CURR(String string) {
        if (this.m_CurrDebugFlag) {
            System.out.println(string);
        }
    }

    public static void main(String[] stringArray) {
        try {
            System.out.println(ClusterEvaluation.evaluateClusterer(new XMeans(), stringArray));
        }
        catch (Exception exception) {
            System.out.println(exception.getMessage());
            exception.printStackTrace();
        }
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

