/*
 * Decompiled with CFR 0.152.
 */
package weka.core;

import weka.core.EuclideanDistance;
import weka.core.Instance;
import weka.core.Instances;
import weka.core.NearestNeighbourSearch;

public class LinearNN
extends NearestNeighbourSearch {
    private int m_Debug = 0;
    private double[] m_Distances;

    public LinearNN() {
    }

    public LinearNN(Instances instances) {
        super(instances);
        this.m_DistanceFunction.setInstances(instances);
    }

    public Instance nearestNeighbour(Instance instance) throws Exception {
        return this.kNearestNeighbours(instance, 1).instance(0);
    }

    public Instances kNearestNeighbours(Instance instance, int n) throws Exception {
        MyHeapElement myHeapElement;
        Object object;
        boolean bl = false;
        MyHeap myHeap = new MyHeap(n);
        for (int i = 0; i < this.m_Instances.numInstances(); ++i) {
            double d;
            if (instance == this.m_Instances.instance(i)) continue;
            if (i < n) {
                if (bl) {
                    System.out.println("K: " + (myHeap.size() + myHeap.noOfKthNearest()));
                }
                d = ((EuclideanDistance)this.m_DistanceFunction).distance(instance, this.m_Instances.instance(i), Double.MAX_VALUE, bl);
                myHeap.put(i, d);
                continue;
            }
            object = myHeap.peek();
            if (bl) {
                System.out.println("K: " + (myHeap.size() + myHeap.noOfKthNearest()));
            }
            if ((d = ((EuclideanDistance)this.m_DistanceFunction).distance(instance, this.m_Instances.instance(i), ((MyHeapElement)object).distance, bl)) < ((MyHeapElement)object).distance) {
                myHeap.putBySubstitute(i, d);
                continue;
            }
            if (d != ((MyHeapElement)object).distance) continue;
            myHeap.putKthNearest(i, d);
        }
        Instances instances = new Instances(this.m_Instances, myHeap.size() + myHeap.noOfKthNearest());
        this.m_Distances = new double[myHeap.size() + myHeap.noOfKthNearest()];
        object = new int[myHeap.size() + myHeap.noOfKthNearest()];
        int n2 = 1;
        while (myHeap.noOfKthNearest() > 0) {
            myHeapElement = myHeap.getKthNearest();
            object[((Object)object).length - n2] = myHeapElement.index;
            this.m_Distances[((Object)object).length - n2] = myHeapElement.distance;
            ++n2;
        }
        while (myHeap.size() > 0) {
            myHeapElement = myHeap.get();
            object[((Object)object).length - n2] = myHeapElement.index;
            this.m_Distances[((Object)object).length - n2] = myHeapElement.distance;
            ++n2;
        }
        this.m_DistanceFunction.postProcessDistances(this.m_Distances);
        for (int i = 0; i < ((Object)object).length; ++i) {
            instances.add(this.m_Instances.instance((int)object[i]));
        }
        return instances;
    }

    public double[] getDistances() throws Exception {
        if (this.m_Distances == null) {
            throw new Exception("No distances available. Please call either kNearestNeighbours or nearestNeighbours first.");
        }
        return this.m_Distances;
    }

    public void setInstances(Instances instances) throws Exception {
        this.m_Instances = instances;
        this.m_DistanceFunction.setInstances(instances);
    }

    public void update(Instance instance) throws Exception {
        if (this.m_Instances == null) {
            throw new Exception("No instances supplied yet. Cannot update withoutsupplying a set of instances first.");
        }
        this.m_DistanceFunction.update(instance);
    }

    public void addInstanceInfo(Instance instance) {
        if (this.m_Instances != null) {
            try {
                this.update(instance);
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
    }

    public String globalInfo() {
        return "Class implementing the brute force search algorithm for nearest neighbour search.";
    }

    private void OOPS(String string) {
        System.out.println(string);
    }

    private class NeighborList {
        private NeighborNode m_First;
        private NeighborNode m_Last;
        private int m_Length = 1;

        public NeighborList(int n) {
            this.m_Length = n;
        }

        public boolean isEmpty() {
            return this.m_First == null;
        }

        public int currentLength() {
            int n = 0;
            NeighborNode neighborNode = this.m_First;
            while (neighborNode != null) {
                ++n;
                neighborNode = neighborNode.m_Next;
            }
            return n;
        }

        public void insertSorted(double d, Instance instance) {
            if (this.isEmpty()) {
                this.m_First = this.m_Last = new NeighborNode(d, instance);
            } else {
                NeighborNode neighborNode = this.m_First;
                if (d < this.m_First.m_Distance) {
                    this.m_First = new NeighborNode(d, instance, this.m_First);
                } else {
                    while (neighborNode.m_Next != null && neighborNode.m_Next.m_Distance < d) {
                        neighborNode = neighborNode.m_Next;
                    }
                    neighborNode.m_Next = new NeighborNode(d, instance, neighborNode.m_Next);
                    if (neighborNode.equals(this.m_Last)) {
                        this.m_Last = neighborNode.m_Next;
                    }
                }
                int n = 0;
                neighborNode = this.m_First;
                while (neighborNode.m_Next != null) {
                    if (++n >= this.m_Length && neighborNode.m_Distance != neighborNode.m_Next.m_Distance) {
                        this.m_Last = neighborNode;
                        neighborNode.m_Next = null;
                        break;
                    }
                    neighborNode = neighborNode.m_Next;
                }
            }
        }

        public void pruneToK(int n) {
            if (this.isEmpty()) {
                return;
            }
            if (n < 1) {
                n = 1;
            }
            int n2 = 0;
            double d = this.m_First.m_Distance;
            NeighborNode neighborNode = this.m_First;
            while (neighborNode.m_Next != null) {
                d = neighborNode.m_Distance;
                if (++n2 >= n && d != neighborNode.m_Next.m_Distance) {
                    this.m_Last = neighborNode;
                    neighborNode.m_Next = null;
                    break;
                }
                neighborNode = neighborNode.m_Next;
            }
        }

        public void printList() {
            if (this.isEmpty()) {
                System.out.println("Empty list");
            } else {
                NeighborNode neighborNode = this.m_First;
                while (neighborNode != null) {
                    System.out.println("Node: instance " + neighborNode.m_Instance + ", distance " + neighborNode.m_Distance);
                    neighborNode = neighborNode.m_Next;
                }
                System.out.println();
            }
        }
    }

    private class NeighborNode {
        private Instance m_Instance;
        private double m_Distance;
        private NeighborNode m_Next;

        public NeighborNode(double d, Instance instance, NeighborNode neighborNode) {
            this.m_Distance = d;
            this.m_Instance = instance;
            this.m_Next = neighborNode;
        }

        public NeighborNode(double d, Instance instance) {
            this(d, instance, null);
        }
    }

    private class MyHeapElement {
        int index;
        double distance;

        public MyHeapElement(int n, double d) {
            this.distance = d;
            this.index = n;
        }
    }

    private class MyHeap {
        MyHeapElement[] m_heap = null;
        MyHeapElement[] m_KthNearest = null;
        int m_KthNearestSize = 0;
        int initSize = 10;

        public MyHeap(int n) {
            if (n % 2 == 0) {
                ++n;
            }
            this.m_heap = new MyHeapElement[n + 1];
            this.m_heap[0] = new MyHeapElement(0, 0.0);
        }

        public int size() {
            return this.m_heap[0].index;
        }

        public MyHeapElement peek() {
            return this.m_heap[1];
        }

        public MyHeapElement get() throws Exception {
            if (this.m_heap[0].index == 0) {
                throw new Exception("No elements present in the heap");
            }
            MyHeapElement myHeapElement = this.m_heap[1];
            this.m_heap[1] = this.m_heap[this.m_heap[0].index];
            --this.m_heap[0].index;
            this.downheap();
            return myHeapElement;
        }

        public void put(int n, double d) throws Exception {
            if (this.m_heap[0].index + 1 > this.m_heap.length - 1) {
                throw new Exception("the number of elements cannot exceed the initially set maximum limit");
            }
            ++this.m_heap[0].index;
            this.m_heap[this.m_heap[0].index] = new MyHeapElement(n, d);
            this.upheap();
        }

        public void putBySubstitute(int n, double d) throws Exception {
            MyHeapElement myHeapElement = this.get();
            this.put(n, d);
            if (myHeapElement.distance == this.m_heap[1].distance) {
                this.putKthNearest(myHeapElement.index, myHeapElement.distance);
            } else if (myHeapElement.distance > this.m_heap[1].distance) {
                this.m_KthNearest = null;
                this.m_KthNearestSize = 0;
                this.initSize = 10;
            } else if (myHeapElement.distance < this.m_heap[1].distance) {
                throw new Exception("The substituted element is smaller than the head element. put() should have been called in place of putBySubstitute()");
            }
        }

        public int noOfKthNearest() {
            return this.m_KthNearestSize;
        }

        public void putKthNearest(int n, double d) {
            if (this.m_KthNearest == null) {
                this.m_KthNearest = new MyHeapElement[this.initSize];
            }
            if (this.m_KthNearestSize >= this.m_KthNearest.length) {
                this.initSize += this.initSize;
                MyHeapElement[] myHeapElementArray = new MyHeapElement[this.initSize];
                System.arraycopy(this.m_KthNearest, 0, myHeapElementArray, 0, this.m_KthNearest.length);
                this.m_KthNearest = myHeapElementArray;
            }
            this.m_KthNearest[this.m_KthNearestSize++] = new MyHeapElement(n, d);
        }

        public MyHeapElement getKthNearest() {
            if (this.m_KthNearestSize == 0) {
                return null;
            }
            --this.m_KthNearestSize;
            return this.m_KthNearest[this.m_KthNearestSize];
        }

        private void upheap() {
            int n = this.m_heap[0].index;
            while (n > 1 && this.m_heap[n].distance > this.m_heap[n / 2].distance) {
                MyHeapElement myHeapElement = this.m_heap[n];
                this.m_heap[n] = this.m_heap[n / 2];
                this.m_heap[n /= 2] = myHeapElement;
            }
        }

        private void downheap() {
            int n = 1;
            while (2 * n <= this.m_heap[0].index && this.m_heap[n].distance < this.m_heap[2 * n].distance || 2 * n + 1 <= this.m_heap[0].index && this.m_heap[n].distance < this.m_heap[2 * n + 1].distance) {
                MyHeapElement myHeapElement;
                if (2 * n + 1 <= this.m_heap[0].index) {
                    if (this.m_heap[2 * n].distance > this.m_heap[2 * n + 1].distance) {
                        myHeapElement = this.m_heap[n];
                        this.m_heap[n] = this.m_heap[2 * n];
                        n = 2 * n;
                        this.m_heap[n] = myHeapElement;
                        continue;
                    }
                    myHeapElement = this.m_heap[n];
                    this.m_heap[n] = this.m_heap[2 * n + 1];
                    n = 2 * n + 1;
                    this.m_heap[n] = myHeapElement;
                    continue;
                }
                myHeapElement = this.m_heap[n];
                this.m_heap[n] = this.m_heap[2 * n];
                n = 2 * n;
                this.m_heap[n] = myHeapElement;
            }
        }
    }
}

