/*
 * Decompiled with CFR 0.152.
 */
import weka.classifiers.Classifier;
import weka.clusterers.Clusterer;
import weka.core.Instance;
import weka.core.Instances;
import weka.core.stemmers.Stemmer;

public abstract class RWekaInterfaces {
    public static double[] classifyInstances(Classifier classifier, Instances instances) throws Exception {
        int n = instances.numInstances();
        double[] dArray = new double[n];
        int n2 = 0;
        for (int i = 0; i < n; ++i) {
            try {
                dArray[i] = classifier.classifyInstance(instances.instance(i));
                continue;
            }
            catch (Exception exception) {
                ++n2;
                dArray[i] = Double.NaN;
            }
        }
        if (n2 > 0) {
            System.out.println(n2 + " instances not classified");
        }
        return dArray;
    }

    public static double[] clusterInstances(Clusterer clusterer, Instances instances) throws Exception {
        int n = instances.numInstances();
        double[] dArray = new double[n];
        int n2 = 0;
        for (int i = 0; i < n; ++i) {
            try {
                dArray[i] = clusterer.clusterInstance(instances.instance(i));
                if (!(dArray[i] < 0.0)) continue;
                dArray[i] = Double.NaN;
                continue;
            }
            catch (Exception exception) {
                ++n2;
                dArray[i] = Double.NaN;
            }
        }
        if (n2 > 0) {
            System.out.println(n2 + " instances not classified");
        }
        return dArray;
    }

    public static double[] distributionForInstances(Classifier classifier, Instances instances) throws Exception {
        int n = instances.numInstances();
        int n2 = instances.numClasses();
        double[] dArray = new double[n * n2];
        double[] dArray2 = new double[n2];
        int n3 = 0;
        for (int i = 0; i < n; ++i) {
            dArray2 = classifier.distributionForInstance(instances.instance(i));
            int n4 = 0;
            while (n4 < n2) {
                dArray[n3] = dArray2[n4];
                ++n4;
                ++n3;
            }
        }
        return dArray;
    }

    public static double[] distributionForInstances(Clusterer clusterer, Instances instances) throws Exception {
        int n = instances.numInstances();
        int n2 = clusterer.numberOfClusters();
        double[] dArray = new double[n * n2];
        double[] dArray2 = new double[n2];
        int n3 = 0;
        for (int i = 0; i < n; ++i) {
            dArray2 = clusterer.distributionForInstance(instances.instance(i));
            int n4 = 0;
            while (n4 < n2) {
                dArray[n3] = dArray2[n4];
                ++n4;
                ++n3;
            }
        }
        return dArray;
    }

    public static void addInstances(Instances instances, double[] dArray, int n) throws Exception {
        int n2 = instances.numAttributes();
        for (int i = 0; i < n; ++i) {
            Instance instance = new Instance(n2);
            for (int j = 0; j < n2; ++j) {
                instance.setValue(j, dArray[i + j * n]);
            }
            instances.add(instance);
        }
    }

    public static double[] getAttributeWeights(Instances instances) throws Exception {
        int n = instances.numAttributes();
        double[] dArray = new double[n];
        for (int i = 0; i < n; ++i) {
            dArray[i] = instances.attribute(i).weight();
        }
        return dArray;
    }

    public static double[] getInstanceWeights(Instances instances) throws Exception {
        int n = instances.numInstances();
        double[] dArray = new double[n];
        for (int i = 0; i < n; ++i) {
            dArray[i] = instances.instance(i).weight();
        }
        return dArray;
    }

    public static String[] stem(Stemmer stemmer, String[] stringArray) throws Exception {
        int n = stringArray.length;
        String[] stringArray2 = new String[n];
        for (int i = 0; i < n; ++i) {
            stringArray2[i] = stemmer.stem(stringArray[i]);
        }
        return stringArray2;
    }
}

