/*
 * Decompiled with CFR 0.152.
 */
package weka.classifiers.bayes.net.search;

import java.io.Serializable;
import java.util.Enumeration;
import java.util.Vector;
import weka.classifiers.bayes.BayesNet;
import weka.classifiers.bayes.net.ParentSet;
import weka.core.Instances;
import weka.core.OptionHandler;

public class SearchAlgorithm
implements OptionHandler,
Serializable {
    static final long serialVersionUID = 6164792240778525312L;
    protected int m_nMaxNrOfParents = 1;
    protected boolean m_bInitAsNaiveBayes = true;
    protected boolean m_bMarkovBlanketClassifier = false;

    protected boolean addArcMakesSense(BayesNet bayesNet, Instances instances, int n, int n2) {
        int n3;
        if (n == n2) {
            return false;
        }
        if (this.isArc(bayesNet, n, n2)) {
            return false;
        }
        int n4 = instances.numAttributes();
        boolean[] blArray = new boolean[n4];
        for (n3 = 0; n3 < n4; ++n3) {
            blArray[n3] = false;
        }
        bayesNet.getParentSet(n).addParent(n2, instances);
        for (n3 = 0; n3 < n4; ++n3) {
            boolean bl = false;
            for (int i = 0; !bl && i < n4; ++i) {
                if (blArray[i]) continue;
                boolean bl2 = true;
                for (int j = 0; j < bayesNet.getParentSet(i).getNrOfParents(); ++j) {
                    if (blArray[bayesNet.getParentSet(i).getParent(j)]) continue;
                    bl2 = false;
                }
                if (!bl2) continue;
                blArray[i] = true;
                bl = true;
            }
            if (bl) continue;
            bayesNet.getParentSet(n).deleteLastParent(instances);
            return false;
        }
        bayesNet.getParentSet(n).deleteLastParent(instances);
        return true;
    }

    protected boolean reverseArcMakesSense(BayesNet bayesNet, Instances instances, int n, int n2) {
        int n3;
        if (n == n2) {
            return false;
        }
        if (!this.isArc(bayesNet, n, n2)) {
            return false;
        }
        int n4 = instances.numAttributes();
        boolean[] blArray = new boolean[n4];
        for (n3 = 0; n3 < n4; ++n3) {
            blArray[n3] = false;
        }
        bayesNet.getParentSet(n2).addParent(n, instances);
        for (n3 = 0; n3 < n4; ++n3) {
            boolean bl = false;
            for (int i = 0; !bl && i < n4; ++i) {
                if (blArray[i]) continue;
                ParentSet parentSet = bayesNet.getParentSet(i);
                boolean bl2 = true;
                for (int j = 0; j < parentSet.getNrOfParents(); ++j) {
                    if (blArray[parentSet.getParent(j)] || i == n && parentSet.getParent(j) == n2) continue;
                    bl2 = false;
                }
                if (!bl2) continue;
                blArray[i] = true;
                bl = true;
            }
            if (bl) continue;
            bayesNet.getParentSet(n2).deleteLastParent(instances);
            return false;
        }
        bayesNet.getParentSet(n2).deleteLastParent(instances);
        return true;
    }

    protected boolean isArc(BayesNet bayesNet, int n, int n2) {
        for (int i = 0; i < bayesNet.getParentSet(n).getNrOfParents(); ++i) {
            if (bayesNet.getParentSet(n).getParent(i) != n2) continue;
            return true;
        }
        return false;
    }

    public Enumeration listOptions() {
        return new Vector(0).elements();
    }

    public void setOptions(String[] stringArray) throws Exception {
    }

    public String[] getOptions() {
        return new String[0];
    }

    public String toString() {
        return "SearchAlgorithm\n";
    }

    public void buildStructure(BayesNet bayesNet, Instances instances) throws Exception {
        if (this.m_bInitAsNaiveBayes) {
            int n = instances.classIndex();
            for (int i = 0; i < instances.numAttributes(); ++i) {
                if (i == n) continue;
                bayesNet.getParentSet(i).addParent(n, instances);
            }
        }
        this.search(bayesNet, instances);
        if (this.m_bMarkovBlanketClassifier) {
            this.doMarkovBlanketCorrection(bayesNet, instances);
        }
    }

    protected void search(BayesNet bayesNet, Instances instances) throws Exception {
    }

    protected void doMarkovBlanketCorrection(BayesNet bayesNet, Instances instances) {
        int n;
        int n2;
        int n3 = instances.classIndex();
        ParentSet parentSet = new ParentSet();
        int n4 = 0;
        parentSet.addParent(n3, instances);
        while (n4 != parentSet.getNrOfParents()) {
            n4 = parentSet.getNrOfParents();
            for (n2 = 0; n2 < n4; ++n2) {
                n = parentSet.getParent(n2);
                ParentSet parentSet2 = bayesNet.getParentSet(n);
                for (int i = 0; i < parentSet2.getNrOfParents(); ++i) {
                    if (parentSet.contains(parentSet2.getParent(i))) continue;
                    parentSet.addParent(parentSet2.getParent(i), instances);
                }
            }
        }
        for (n2 = 0; n2 < instances.numAttributes(); ++n2) {
            n = n2 == n3 || bayesNet.getParentSet(n2).contains(n3) || bayesNet.getParentSet(n3).contains(n2) ? 1 : 0;
            for (int i = 0; n == 0 && i < instances.numAttributes(); ++i) {
                n = bayesNet.getParentSet(i).contains(n2) && bayesNet.getParentSet(i).contains(n3) ? 1 : 0;
            }
            if (n != 0) continue;
            if (parentSet.contains(n2)) {
                if (bayesNet.getParentSet(n3).getCardinalityOfParents() >= 1024) continue;
                bayesNet.getParentSet(n3).addParent(n2, instances);
                continue;
            }
            bayesNet.getParentSet(n2).addParent(n3, instances);
        }
    }

    protected void setMarkovBlanketClassifier(boolean bl) {
        this.m_bMarkovBlanketClassifier = bl;
    }

    protected boolean getMarkovBlanketClassifier() {
        return this.m_bMarkovBlanketClassifier;
    }

    public String maxNrOfParentsTipText() {
        return "Set the maximum number of parents a node in the Bayes net can have. When initialized as Naive Bayes, setting this parameter to 1 results in a Naive Bayes classifier. When set to 2, a Tree Augmented Bayes Network (TAN) is learned, and when set >2, a Bayes Net Augmented Bayes Network (BAN) is learned. By setting it to a value much larger than the number of nodes in the network (the default of 100000 pretty much guarantees this), no restriction on the number of parents is enforced";
    }

    public String initAsNaiveBayesTipText() {
        return "When set to true (default), the initial network used for structure learning is a Naive Bayes Network, that is, a network with an arrow from the classifier node to each other node. When set to false, an empty network is used as initial network structure";
    }

    protected String markovBlanketClassifierTipText() {
        return "When set to true (default is false), after a network structure is learned a Markov Blanket correction is applied to the network structure. This ensures that all nodes in the network are part of the Markov blanket of the classifier node.";
    }
}

