/*
 * Decompiled with CFR 0.152.
 */
package weka.core;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.util.Enumeration;
import java.util.StringTokenizer;
import java.util.Vector;
import weka.core.Option;
import weka.core.OptionHandler;
import weka.core.RevisionHandler;
import weka.core.Utils;

public abstract class Javadoc
implements OptionHandler,
RevisionHandler {
    protected String[] m_StartTag = null;
    protected String[] m_EndTag = null;
    protected String m_Classname = Javadoc.class.getName();
    protected boolean m_UseStars = true;
    protected String m_Dir = "";
    protected boolean m_Silent = false;

    public Enumeration listOptions() {
        Vector<Option> vector = new Vector<Option>();
        vector.addElement(new Option("\tThe class to load.", "W", 1, "-W <classname>"));
        vector.addElement(new Option("\tSuppresses the '*' in the Javadoc.", "nostars", 0, "-nostars"));
        vector.addElement(new Option("\tThe directory above the package hierarchy of the class.", "dir", 1, "-dir <dir>"));
        vector.addElement(new Option("\tSuppresses printing in the console.", "silent", 0, "-silent"));
        return vector.elements();
    }

    public void setOptions(String[] stringArray) throws Exception {
        String string = Utils.getOption('W', stringArray);
        if (string.length() > 0) {
            this.setClassname(string);
        } else {
            this.setClassname(this.getClass().getName());
        }
        this.setUseStars(!Utils.getFlag("nostars", stringArray));
        this.setDir(Utils.getOption("dir", stringArray));
        this.setSilent(Utils.getFlag("silent", stringArray));
    }

    public String[] getOptions() {
        Vector<String> vector = new Vector<String>();
        vector.add("-W");
        vector.add(this.getClassname());
        if (!this.getUseStars()) {
            vector.add("-nostars");
        }
        if (this.getDir().length() != 0) {
            vector.add("-dir");
            vector.add(this.getDir());
        }
        if (this.getSilent()) {
            vector.add("-silent");
        }
        return vector.toArray(new String[vector.size()]);
    }

    public void setClassname(String string) {
        this.m_Classname = string;
    }

    public String getClassname() {
        return this.m_Classname;
    }

    public void setUseStars(boolean bl) {
        this.m_UseStars = bl;
    }

    public boolean getUseStars() {
        return this.m_UseStars;
    }

    public void setDir(String string) {
        this.m_Dir = string;
    }

    public String getDir() {
        return this.m_Dir;
    }

    public void setSilent(boolean bl) {
        this.m_Silent = bl;
    }

    public boolean getSilent() {
        return this.m_Silent;
    }

    protected void println(Object object) {
        if (!this.getSilent()) {
            System.err.println(object.toString());
        }
    }

    protected boolean canInstantiateClass() {
        boolean bl = true;
        Class<?> clazz = null;
        try {
            clazz = Class.forName(this.getClassname());
        }
        catch (Exception exception) {
            bl = false;
            this.println("Cannot instantiate '" + this.getClassname() + "'! Class in CLASSPATH?");
        }
        if (bl) {
            try {
                clazz.newInstance();
            }
            catch (Exception exception) {
                bl = false;
                this.println("Cannot instantiate '" + this.getClassname() + "'! Missing default constructor?");
            }
        }
        return bl;
    }

    protected Object getInstance() {
        Object var1_1 = null;
        try {
            Class<?> clazz = Class.forName(this.getClassname());
            var1_1 = clazz.newInstance();
        }
        catch (Exception exception) {
            var1_1 = null;
        }
        return var1_1;
    }

    protected String toHTML(String string) {
        String string2 = string;
        string2 = string2.replaceAll("&", "&amp;");
        string2 = string2.replaceAll("<", "&lt;");
        string2 = string2.replaceAll(">", "&gt;");
        string2 = string2.replaceAll("@", "&#64;");
        string2 = string2.replaceAll("\n", "<br/>\n");
        return string2;
    }

    protected String indent(String string, int n, String string2) {
        StringTokenizer stringTokenizer = new StringTokenizer(string, "\n", true);
        String string3 = "";
        while (stringTokenizer.hasMoreTokens()) {
            if (string3.endsWith("\n") || string3.length() == 0) {
                for (int i = 0; i < n; ++i) {
                    string3 = string3 + string2;
                }
            }
            string3 = string3 + stringTokenizer.nextToken();
        }
        return string3;
    }

    protected abstract String generateJavadoc(int var1) throws Exception;

    protected String generateJavadoc() throws Exception {
        String string = "";
        for (int i = 0; i < this.m_StartTag.length; ++i) {
            if (i > 0) {
                string = string + "\n\n";
            }
            string = string + this.generateJavadoc(i).trim();
        }
        return string;
    }

    protected String getIndentionString(String string) {
        String string2 = string.replaceAll(" ", "").length() == 0 ? " " : (string.replaceAll("\t", "").length() == 0 ? "\t" : string);
        return string2;
    }

    protected int getIndentionLength(String string) {
        int n = string.replaceAll(" ", "").length() == 0 ? string.length() : (string.replaceAll("\t", "").length() == 0 ? string.length() : 1);
        return n;
    }

    protected String updateJavadoc(String string, int n) throws Exception {
        if (string.indexOf(this.m_StartTag[n]) == -1 || string.indexOf(this.m_EndTag[n]) == -1) {
            this.println("No start and/or end tags found: " + this.m_StartTag[n] + "/" + this.m_EndTag[n]);
            return string;
        }
        StringBuffer stringBuffer = new StringBuffer();
        while (string.length() > 0) {
            if (string.indexOf(this.m_StartTag[n]) > -1) {
                String string2 = string.substring(0, string.indexOf(this.m_StartTag[n]));
                if (string2.endsWith("\"")) {
                    stringBuffer.append(string2);
                    stringBuffer.append(this.m_StartTag[n]);
                    string = string.substring(string2.length() + this.m_StartTag[n].length());
                    continue;
                }
                String string3 = string2.substring(string2.lastIndexOf("\n") + 1);
                int n2 = this.getIndentionLength(string3);
                String string4 = this.getIndentionString(string3);
                string2 = string2.substring(0, string2.lastIndexOf("\n") + 1);
                stringBuffer.append(string2);
                stringBuffer.append(this.indent(this.m_StartTag[n], n2, string4) + "\n");
                stringBuffer.append(this.indent(this.generateJavadoc(n), n2, string4));
                stringBuffer.append(this.indent(this.m_EndTag[n], n2, string4));
                string = string.substring(string.indexOf(this.m_EndTag[n]));
                string = string.substring(this.m_EndTag[n].length());
                continue;
            }
            stringBuffer.append(string);
            string = "";
        }
        return stringBuffer.toString().trim();
    }

    protected String updateJavadoc(String string) throws Exception {
        String string2 = string;
        for (int i = 0; i < this.m_StartTag.length; ++i) {
            string2 = this.updateJavadoc(string2, i);
        }
        return string2;
    }

    public String updateJavadoc() throws Exception {
        String string = "";
        File file = new File(this.getDir() + "/" + this.getClassname().replaceAll("\\.", "/") + ".java");
        if (!file.exists()) {
            this.println("File '" + file.getAbsolutePath() + "' doesn't exist!");
            return string;
        }
        try {
            String string2;
            BufferedReader bufferedReader = new BufferedReader(new FileReader(file));
            StringBuffer stringBuffer = new StringBuffer();
            while ((string2 = bufferedReader.readLine()) != null) {
                stringBuffer.append(string2 + "\n");
            }
            bufferedReader.close();
            string = this.updateJavadoc(stringBuffer.toString());
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        return string.trim();
    }

    public String generate() throws Exception {
        if (this.getDir().length() == 0) {
            return this.generateJavadoc();
        }
        return this.updateJavadoc();
    }

    public String generateHelp() {
        String string = this.getClass().getName().replaceAll(".*\\.", "") + " Options:\n\n";
        Enumeration enumeration = this.listOptions();
        while (enumeration.hasMoreElements()) {
            Option option = (Option)enumeration.nextElement();
            string = string + option.synopsis() + "\n" + option.description() + "\n";
        }
        return string;
    }

    protected static void runJavadoc(Javadoc javadoc, String[] stringArray) {
        try {
            try {
                if (Utils.getFlag('h', stringArray)) {
                    throw new Exception("Help requested");
                }
                javadoc.setOptions(stringArray);
                Utils.checkForRemainingOptions(stringArray);
                if (javadoc.getDir().length() == 0) {
                    throw new Exception("No directory provided!");
                }
            }
            catch (Exception exception) {
                String string = "\n" + exception.getMessage() + "\n\n" + javadoc.generateHelp();
                throw new Exception(string);
            }
            System.out.println(javadoc.generate() + "\n");
        }
        catch (Exception exception) {
            System.err.println(exception.getMessage());
        }
    }
}

