/*
 * Decompiled with CFR 0.152.
 */
package weka.core.parser.JFlex;

import java.util.Vector;
import weka.core.parser.JFlex.CharClassInterval;
import weka.core.parser.JFlex.IntCharSet;
import weka.core.parser.JFlex.Interval;
import weka.core.parser.JFlex.Out;

public class CharClasses {
    private static final boolean DEBUG = false;
    public static final char maxChar = '\uffff';
    private Vector classes;
    private char maxCharUsed;

    public CharClasses(int n) {
        if (n < 0 || n > 65535) {
            throw new IllegalArgumentException();
        }
        this.maxCharUsed = (char)n;
        this.classes = new Vector();
        this.classes.addElement(new IntCharSet(new Interval('\u0000', '\uffff')));
    }

    public char getMaxCharCode() {
        return this.maxCharUsed;
    }

    public void setMaxCharCode(int n) {
        if (n < 0 || n > 65535) {
            throw new IllegalArgumentException();
        }
        this.maxCharUsed = (char)n;
    }

    public int getNumClasses() {
        return this.classes.size();
    }

    public void makeClass(IntCharSet intCharSet, boolean bl) {
        if (bl) {
            intCharSet = intCharSet.getCaseless();
        }
        int n = this.classes.size();
        for (int i = 0; i < n; ++i) {
            IntCharSet intCharSet2 = (IntCharSet)this.classes.elementAt(i);
            if (intCharSet2.equals(intCharSet)) {
                return;
            }
            IntCharSet intCharSet3 = intCharSet2.and(intCharSet);
            if (!intCharSet3.containsElements()) continue;
            if (intCharSet2.equals(intCharSet3)) {
                intCharSet.sub(intCharSet3);
                continue;
            }
            if (intCharSet.equals(intCharSet3)) {
                intCharSet2.sub(intCharSet3);
                this.classes.addElement(intCharSet3);
                return;
            }
            intCharSet.sub(intCharSet3);
            intCharSet2.sub(intCharSet3);
            this.classes.addElement(intCharSet3);
        }
    }

    public int getClassCode(char c) {
        IntCharSet intCharSet;
        int n = -1;
        while (!(intCharSet = (IntCharSet)this.classes.elementAt(++n)).contains(c)) {
        }
        return n;
    }

    public void dump() {
        Out.dump(this.toString());
    }

    public String toString(int n) {
        return this.classes.elementAt(n).toString();
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer("CharClasses:");
        stringBuffer.append(Out.NL);
        for (int i = 0; i < this.classes.size(); ++i) {
            stringBuffer.append("class " + i + ":" + Out.NL + this.classes.elementAt(i) + Out.NL);
        }
        return stringBuffer.toString();
    }

    public void makeClass(char c, boolean bl) {
        this.makeClass(new IntCharSet(c), bl);
    }

    public void makeClass(String string, boolean bl) {
        for (int i = 0; i < string.length(); ++i) {
            this.makeClass(string.charAt(i), bl);
        }
    }

    public void makeClass(Vector vector, boolean bl) {
        this.makeClass(new IntCharSet(vector), bl);
    }

    public void makeClassNot(Vector vector, boolean bl) {
        this.makeClass(new IntCharSet(vector), bl);
    }

    private int[] getClassCodes(IntCharSet intCharSet, boolean bl) {
        int n = this.classes.size();
        int[] nArray = new int[n];
        int n2 = 0;
        for (int i = 0; i < n; ++i) {
            IntCharSet intCharSet2 = (IntCharSet)this.classes.elementAt(i);
            if (bl) {
                if (intCharSet.and(intCharSet2).containsElements()) continue;
                nArray[n2++] = i;
                continue;
            }
            if (!intCharSet.and(intCharSet2).containsElements()) continue;
            nArray[n2++] = i;
        }
        int[] nArray2 = new int[n2];
        System.arraycopy(nArray, 0, nArray2, 0, n2);
        return nArray2;
    }

    public int[] getClassCodes(Vector vector) {
        return this.getClassCodes(new IntCharSet(vector), false);
    }

    public int[] getNotClassCodes(Vector vector) {
        return this.getClassCodes(new IntCharSet(vector), true);
    }

    public void check() {
        int n;
        for (n = 0; n < this.classes.size(); ++n) {
            for (int i = n + 1; i < this.classes.size(); ++i) {
                IntCharSet intCharSet;
                IntCharSet intCharSet2 = (IntCharSet)this.classes.elementAt(n);
                if (!intCharSet2.and(intCharSet = (IntCharSet)this.classes.elementAt(i)).containsElements()) continue;
                System.out.println("Error: non disjoint char classes " + n + " and " + i);
                System.out.println("class " + n + ": " + intCharSet2);
                System.out.println("class " + i + ": " + intCharSet);
            }
        }
        for (n = 0; n < 65535; n = (int)((char)(n + 1))) {
            this.getClassCode((char)n);
            if (n % 100 != 0) continue;
            System.out.print(".");
        }
        this.getClassCode('\uffff');
    }

    public CharClassInterval[] getIntervalls() {
        int n;
        int n2 = this.classes.size();
        int n3 = 0;
        for (n = 0; n < n2; ++n) {
            n3 += ((IntCharSet)this.classes.elementAt(n)).numIntervalls();
        }
        CharClassInterval[] charClassIntervalArray = new CharClassInterval[n3];
        n = 0;
        int n4 = 0;
        while (n < n3) {
            int n5 = this.getClassCode((char)n4);
            IntCharSet intCharSet = (IntCharSet)this.classes.elementAt(n5);
            Interval interval = intCharSet.getNext();
            charClassIntervalArray[n++] = new CharClassInterval(interval.start, interval.end, n5);
            n4 = interval.end + '\u0001';
        }
        return charClassIntervalArray;
    }
}

