/*
 * Decompiled with CFR 0.152.
 */
package weka.gui.sql;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.util.Properties;
import javax.swing.BorderFactory;
import javax.swing.DefaultListModel;
import javax.swing.JFrame;
import javax.swing.JPanel;
import weka.core.Memory;
import weka.gui.LookAndFeel;
import weka.gui.sql.ConnectionPanel;
import weka.gui.sql.InfoPanel;
import weka.gui.sql.QueryPanel;
import weka.gui.sql.ResultPanel;
import weka.gui.sql.ResultSetHelper;
import weka.gui.sql.event.ConnectionEvent;
import weka.gui.sql.event.ConnectionListener;
import weka.gui.sql.event.HistoryChangedEvent;
import weka.gui.sql.event.HistoryChangedListener;
import weka.gui.sql.event.QueryExecuteEvent;
import weka.gui.sql.event.QueryExecuteListener;
import weka.gui.sql.event.ResultChangedEvent;
import weka.gui.sql.event.ResultChangedListener;

public class SqlViewer
extends JPanel
implements ConnectionListener,
HistoryChangedListener,
QueryExecuteListener,
ResultChangedListener {
    private static final long serialVersionUID = -4395028775566514329L;
    protected static final String HISTORY_FILE = "SqlViewerHistory.props";
    public static final String WIDTH = "width";
    public static final String HEIGHT = "height";
    protected JFrame m_Parent;
    protected ConnectionPanel m_ConnectionPanel;
    protected QueryPanel m_QueryPanel;
    protected ResultPanel m_ResultPanel;
    protected InfoPanel m_InfoPanel;
    protected String m_URL;
    protected String m_User;
    protected String m_Password;
    protected String m_Query;
    protected Properties m_History;
    private static Memory m_Memory = new Memory(true);
    private static SqlViewer m_Viewer;

    public SqlViewer(JFrame jFrame) {
        this.m_Parent = jFrame;
        this.m_URL = "";
        this.m_User = "";
        this.m_Password = "";
        this.m_Query = "";
        this.m_History = new Properties();
        this.createPanel();
    }

    protected void createPanel() {
        this.setLayout(new BorderLayout());
        this.m_ConnectionPanel = new ConnectionPanel(this.m_Parent);
        JPanel jPanel = new JPanel(new BorderLayout());
        this.add((Component)jPanel, "North");
        jPanel.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createTitledBorder("Connection"), BorderFactory.createEmptyBorder(0, 5, 5, 5)));
        jPanel.add((Component)this.m_ConnectionPanel, "Center");
        this.m_QueryPanel = new QueryPanel(this.m_Parent);
        jPanel = new JPanel(new BorderLayout());
        this.add((Component)jPanel, "Center");
        JPanel jPanel2 = new JPanel(new BorderLayout());
        jPanel2.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createTitledBorder("Query"), BorderFactory.createEmptyBorder(0, 5, 5, 5)));
        jPanel2.add((Component)this.m_QueryPanel, "North");
        jPanel.add((Component)jPanel2, "North");
        this.m_ResultPanel = new ResultPanel(this.m_Parent);
        this.m_ResultPanel.setQueryPanel(this.m_QueryPanel);
        jPanel2 = new JPanel(new BorderLayout());
        jPanel2.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createTitledBorder("Result"), BorderFactory.createEmptyBorder(0, 5, 5, 5)));
        jPanel2.add((Component)this.m_ResultPanel, "Center");
        jPanel.add((Component)jPanel2, "Center");
        this.m_InfoPanel = new InfoPanel(this.m_Parent);
        jPanel = new JPanel(new BorderLayout());
        this.add((Component)jPanel, "South");
        jPanel.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createTitledBorder("Info"), BorderFactory.createEmptyBorder(0, 5, 5, 5)));
        jPanel.add((Component)this.m_InfoPanel, "Center");
        this.addConnectionListener(this);
        this.addConnectionListener(this.m_QueryPanel);
        this.addQueryExecuteListener(this);
        this.addQueryExecuteListener(this.m_ResultPanel);
        this.addResultChangedListener(this);
        this.addHistoryChangedListener(this);
        this.loadHistory(true);
    }

    public void connectionChange(ConnectionEvent connectionEvent) {
        if (connectionEvent.getType() == 1) {
            this.m_InfoPanel.append("disconnect from: " + connectionEvent.getDbUtils().getDatabaseURL(), "information_small.gif");
        } else {
            this.m_InfoPanel.append("connecting to: " + connectionEvent.getDbUtils().getDatabaseURL() + " = " + connectionEvent.isConnected(), "information_small.gif");
        }
        if (connectionEvent.getException() != null) {
            this.m_InfoPanel.append("exception: " + connectionEvent.getException(), "error_small.gif");
        }
        if (connectionEvent.isConnected()) {
            this.m_QueryPanel.setFocus();
        } else {
            this.m_ConnectionPanel.setFocus();
        }
    }

    public void queryExecuted(QueryExecuteEvent queryExecuteEvent) {
        if (queryExecuteEvent.failed()) {
            this.m_InfoPanel.append("Query:" + queryExecuteEvent.getQuery(), "error_small.gif");
            this.m_InfoPanel.append("exception: " + queryExecuteEvent.getException(), "error_small.gif");
        } else {
            this.m_InfoPanel.append("Query: " + queryExecuteEvent.getQuery(), "information_small.gif");
            try {
                if (queryExecuteEvent.hasResult()) {
                    ResultSetHelper resultSetHelper = new ResultSetHelper(queryExecuteEvent.getResultSet());
                    if (queryExecuteEvent.getMaxRows() > 0 && resultSetHelper.getRowCount() >= queryExecuteEvent.getMaxRows()) {
                        this.m_InfoPanel.append(resultSetHelper.getRowCount() + " rows selected (" + queryExecuteEvent.getMaxRows() + " displayed).", "information_small.gif");
                    } else if (resultSetHelper.getRowCount() == -1) {
                        this.m_InfoPanel.append("Unknown number of rows selected (due to JDBC driver restrictions).", "information_small.gif");
                    } else {
                        this.m_InfoPanel.append(resultSetHelper.getRowCount() + " rows selected.", "information_small.gif");
                    }
                }
                this.loadHistory(false);
                this.m_History.setProperty("max_rows", Integer.toString(queryExecuteEvent.getMaxRows()));
                this.saveHistory();
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
    }

    public void resultChanged(ResultChangedEvent resultChangedEvent) {
        this.m_URL = resultChangedEvent.getURL();
        this.m_User = resultChangedEvent.getUser();
        this.m_Password = resultChangedEvent.getPassword();
        this.m_Query = resultChangedEvent.getQuery();
    }

    public void historyChanged(HistoryChangedEvent historyChangedEvent) {
        this.loadHistory(false);
        this.m_History.setProperty(historyChangedEvent.getHistoryName(), this.modelToString(historyChangedEvent.getHistory()));
        this.saveHistory();
    }

    protected String getHistoryFilename() {
        return System.getProperties().getProperty("user.home") + File.separatorChar + HISTORY_FILE;
    }

    protected DefaultListModel stringToModel(String string) {
        String string2;
        int n;
        DefaultListModel<String> defaultListModel = new DefaultListModel<String>();
        String[] stringArray = new String[]{"\"\"", "\\n", "\\r", "\\t"};
        String[] stringArray2 = new String[]{"\"", "\n", "\r", "\t"};
        for (n = 0; n < stringArray.length; ++n) {
            string2 = "";
            while (string.length() > 0) {
                int n2 = string.indexOf(stringArray[n]);
                if (n2 > -1) {
                    string2 = string2 + string.substring(0, n2) + stringArray2[n];
                    string = string.substring(n2 + 2);
                    continue;
                }
                string2 = string2 + string;
                string = "";
            }
            string = string2;
        }
        boolean bl = false;
        string2 = "";
        for (n = 0; n < string.length(); ++n) {
            if (string.charAt(n) == '\"') {
                bl = !bl;
                string2 = string2 + "" + string.charAt(n);
                continue;
            }
            if (string.charAt(n) == ',') {
                if (bl) {
                    string2 = string2 + "" + string.charAt(n);
                    continue;
                }
                if (string2.startsWith("\"")) {
                    string2 = string2.substring(1, string2.length() - 1);
                }
                defaultListModel.addElement(string2);
                string2 = "";
                continue;
            }
            string2 = string2 + "" + string.charAt(n);
        }
        if (!string2.equals("")) {
            if (string2.startsWith("\"")) {
                string2 = string2.substring(1, string2.length() - 1);
            }
            defaultListModel.addElement(string2);
        }
        return defaultListModel;
    }

    protected String modelToString(DefaultListModel defaultListModel) {
        String string = "";
        for (int i = 0; i < defaultListModel.size(); ++i) {
            String string2;
            boolean bl;
            if (i > 0) {
                string = string + ",";
            }
            boolean bl2 = bl = (string2 = defaultListModel.get(i).toString()).indexOf(",") > -1 || string2.indexOf(" ") > -1;
            if (bl) {
                string = string + "\"";
            }
            for (int j = 0; j < string2.length(); ++j) {
                string = string2.charAt(j) == '\"' ? string + "\"\"" : string + "" + string2.charAt(j);
            }
            if (!bl) continue;
            string = string + "\"";
        }
        return string;
    }

    protected void loadHistory(boolean bl) {
        try {
            File file = new File(this.getHistoryFilename());
            if (file.exists()) {
                BufferedInputStream bufferedInputStream = new BufferedInputStream(new FileInputStream(this.getHistoryFilename()));
                this.m_History.load(bufferedInputStream);
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        if (bl) {
            this.m_ConnectionPanel.setHistory(this.stringToModel(this.m_History.getProperty("connection", "")));
            this.m_QueryPanel.setHistory(this.stringToModel(this.m_History.getProperty("query", "")));
            this.m_QueryPanel.setMaxRows(Integer.parseInt(this.m_History.getProperty("max_rows", "100")));
            int n = Integer.parseInt(this.m_History.getProperty(WIDTH, "0"));
            int n2 = Integer.parseInt(this.m_History.getProperty(HEIGHT, "0"));
            if (n != 0 && n2 != 0) {
                this.setPreferredSize(new Dimension(n, n2));
            }
        }
    }

    protected void saveHistory() {
        try {
            BufferedOutputStream bufferedOutputStream = new BufferedOutputStream(new FileOutputStream(this.getHistoryFilename()));
            this.m_History.store(bufferedOutputStream, "SQL-Viewer-History");
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public void saveSize() {
        this.m_History.setProperty(WIDTH, "" + this.getSize().width);
        this.m_History.setProperty(HEIGHT, "" + this.getSize().height);
        this.saveHistory();
    }

    public void clear() {
        this.m_ConnectionPanel.clear();
        this.m_QueryPanel.clear();
        this.m_ResultPanel.clear();
        this.m_InfoPanel.clear();
    }

    public String getURL() {
        return this.m_URL;
    }

    public String getUser() {
        return this.m_User;
    }

    public String getPassword() {
        return this.m_Password;
    }

    public String getQuery() {
        return this.m_Query;
    }

    public void addConnectionListener(ConnectionListener connectionListener) {
        this.m_ConnectionPanel.addConnectionListener(connectionListener);
    }

    public void removeConnectionListener(ConnectionListener connectionListener) {
        this.m_ConnectionPanel.removeConnectionListener(connectionListener);
    }

    public void addQueryExecuteListener(QueryExecuteListener queryExecuteListener) {
        this.m_QueryPanel.addQueryExecuteListener(queryExecuteListener);
    }

    public void removeQueryExecuteListener(QueryExecuteListener queryExecuteListener) {
        this.m_QueryPanel.removeQueryExecuteListener(queryExecuteListener);
    }

    public void addResultChangedListener(ResultChangedListener resultChangedListener) {
        this.m_ResultPanel.addResultChangedListener(resultChangedListener);
    }

    public void removeResultChangedListener(ResultChangedListener resultChangedListener) {
        this.m_ResultPanel.removeResultChangedListener(resultChangedListener);
    }

    public void addHistoryChangedListener(HistoryChangedListener historyChangedListener) {
        this.m_ConnectionPanel.addHistoryChangedListener(historyChangedListener);
        this.m_QueryPanel.addHistoryChangedListener(historyChangedListener);
    }

    public void removeHistoryChangedListener(HistoryChangedListener historyChangedListener) {
        this.m_ConnectionPanel.removeHistoryChangedListener(historyChangedListener);
        this.m_QueryPanel.removeHistoryChangedListener(historyChangedListener);
    }

    public static void main(String[] stringArray) {
        LookAndFeel.setLookAndFeel();
        try {
            final JFrame jFrame = new JFrame("Weka SQL-Viewer");
            m_Viewer = new SqlViewer(jFrame);
            jFrame.getContentPane().setLayout(new BorderLayout());
            jFrame.getContentPane().add((Component)m_Viewer, "Center");
            jFrame.addWindowListener(new WindowAdapter(){

                public void windowClosing(WindowEvent windowEvent) {
                    m_Viewer.saveSize();
                    jFrame.dispose();
                    System.exit(0);
                }
            });
            jFrame.pack();
            jFrame.setSize(800, 600);
            jFrame.setVisible(true);
            Thread thread = new Thread(){

                public void run() {
                    while (true) {
                        try {
                            while (true) {
                                2.sleep(4000L);
                                System.gc();
                                if (!m_Memory.isOutOfMemory()) continue;
                                jFrame.dispose();
                                m_Viewer = null;
                                System.gc();
                                m_Memory.stopThreads();
                                System.err.println("\ndisplayed message:");
                                m_Memory.showOutOfMemory();
                                System.err.println("\nexiting");
                                System.exit(-1);
                            }
                        }
                        catch (InterruptedException interruptedException) {
                            interruptedException.printStackTrace();
                            continue;
                        }
                        break;
                    }
                }
            };
            thread.setPriority(10);
            thread.start();
        }
        catch (Exception exception) {
            exception.printStackTrace();
            System.err.println(exception.getMessage());
        }
    }
}

