/*
 * Decompiled with CFR 0.152.
 */
package weka.classifiers.functions.supportVector;

import java.util.Enumeration;
import java.util.Random;
import java.util.Vector;
import weka.classifiers.functions.supportVector.Kernel;
import weka.classifiers.functions.supportVector.KernelEvaluation;
import weka.classifiers.functions.supportVector.RBFKernel;
import weka.core.CheckScheme;
import weka.core.FastVector;
import weka.core.Instances;
import weka.core.MultiInstanceCapabilitiesHandler;
import weka.core.Option;
import weka.core.OptionHandler;
import weka.core.RevisionUtils;
import weka.core.SerializationHelper;
import weka.core.TestInstances;
import weka.core.Utils;
import weka.core.WeightedInstancesHandler;

public class CheckKernel
extends CheckScheme {
    protected Kernel m_Kernel = new RBFKernel();

    public Enumeration listOptions() {
        Vector vector = new Vector();
        Enumeration enumeration = super.listOptions();
        while (enumeration.hasMoreElements()) {
            vector.addElement(enumeration.nextElement());
        }
        vector.addElement(new Option("\tFull name of the kernel analysed.\n\teg: weka.classifiers.functions.supportVector.RBFKernel\n\t(default weka.classifiers.functions.supportVector.RBFKernel)", "W", 1, "-W"));
        if (this.m_Kernel != null && this.m_Kernel instanceof OptionHandler) {
            vector.addElement(new Option("", "", 0, "\nOptions specific to kernel " + this.m_Kernel.getClass().getName() + ":"));
            Enumeration enumeration2 = this.m_Kernel.listOptions();
            while (enumeration2.hasMoreElements()) {
                vector.addElement(enumeration2.nextElement());
            }
        }
        return vector.elements();
    }

    public void setOptions(String[] stringArray) throws Exception {
        super.setOptions(stringArray);
        String string = Utils.getOption('W', stringArray);
        if (string.length() == 0) {
            string = RBFKernel.class.getName();
        }
        this.setKernel((Kernel)this.forName("weka.classifiers.functions.supportVector", Kernel.class, string, Utils.partitionOptions(stringArray)));
    }

    public String[] getOptions() {
        int n;
        Vector<String> vector = new Vector<String>();
        String[] stringArray = super.getOptions();
        for (n = 0; n < stringArray.length; ++n) {
            vector.add(stringArray[n]);
        }
        if (this.getKernel() != null) {
            vector.add("-W");
            vector.add(this.getKernel().getClass().getName());
        }
        if ((stringArray = this.m_Kernel != null && this.m_Kernel instanceof OptionHandler ? this.m_Kernel.getOptions() : new String[]{}).length > 0) {
            vector.add("--");
            for (n = 0; n < stringArray.length; ++n) {
                vector.add(stringArray[n]);
            }
        }
        return vector.toArray(new String[vector.size()]);
    }

    public void doTests() {
        if (this.getKernel() == null) {
            this.println("\n=== No kernel set ===");
            return;
        }
        this.println("\n=== Check on kernel: " + this.getKernel().getClass().getName() + " ===\n");
        this.m_ClasspathProblems = false;
        this.println("--> Checking for interfaces");
        this.canTakeOptions();
        boolean bl = this.weightedInstancesHandler()[0];
        boolean bl2 = this.multiInstanceHandler()[0];
        this.println("--> Kernel tests");
        this.declaresSerialVersionUID();
        this.testsPerClassType(1, bl, bl2);
        this.testsPerClassType(0, bl, bl2);
        this.testsPerClassType(3, bl, bl2);
        this.testsPerClassType(2, bl, bl2);
        this.testsPerClassType(4, bl, bl2);
    }

    public void setKernel(Kernel kernel) {
        this.m_Kernel = kernel;
    }

    public Kernel getKernel() {
        return this.m_Kernel;
    }

    protected void testsPerClassType(int n, boolean bl, boolean bl2) {
        boolean bl3 = this.canPredict(true, false, false, false, false, bl2, n)[0];
        boolean bl4 = this.canPredict(false, true, false, false, false, bl2, n)[0];
        boolean bl5 = this.canPredict(false, false, true, false, false, bl2, n)[0];
        boolean bl6 = this.canPredict(false, false, false, true, false, bl2, n)[0];
        boolean bl7 = !bl2 ? this.canPredict(false, false, false, false, true, bl2, n)[0] : false;
        if (bl3 || bl4 || bl5 || bl6 || bl7) {
            boolean bl8;
            if (bl) {
                this.instanceWeights(bl3, bl4, bl5, bl6, bl7, bl2, n);
            }
            if (n == 1) {
                this.canHandleNClasses(bl3, bl4, bl5, bl6, bl7, bl2, 4);
            }
            if (!bl2) {
                this.canHandleClassAsNthAttribute(bl3, bl4, bl5, bl6, bl7, bl2, n, 0);
                this.canHandleClassAsNthAttribute(bl3, bl4, bl5, bl6, bl7, bl2, n, 1);
            }
            this.canHandleZeroTraining(bl3, bl4, bl5, bl6, bl7, bl2, n);
            boolean bl9 = this.canHandleMissing(bl3, bl4, bl5, bl6, bl7, bl2, n, true, false, 20)[0];
            if (bl9) {
                this.canHandleMissing(bl3, bl4, bl5, bl6, bl7, bl2, n, true, false, 100);
            }
            if (bl8 = this.canHandleMissing(bl3, bl4, bl5, bl6, bl7, bl2, n, false, true, 20)[0]) {
                this.canHandleMissing(bl3, bl4, bl5, bl6, bl7, bl2, n, false, true, 100);
            }
            this.correctBuildInitialisation(bl3, bl4, bl5, bl6, bl7, bl2, n);
            this.datasetIntegrity(bl3, bl4, bl5, bl6, bl7, bl2, n, bl9, bl8);
        }
    }

    protected boolean[] canTakeOptions() {
        boolean[] blArray = new boolean[2];
        this.print("options...");
        if (this.m_Kernel instanceof OptionHandler) {
            this.println("yes");
            if (this.m_Debug) {
                this.println("\n=== Full report ===");
                Enumeration enumeration = this.m_Kernel.listOptions();
                while (enumeration.hasMoreElements()) {
                    Option option = (Option)enumeration.nextElement();
                    this.print(option.synopsis() + "\n" + option.description() + "\n");
                }
                this.println("\n");
            }
            blArray[0] = true;
        } else {
            this.println("no");
            blArray[0] = false;
        }
        return blArray;
    }

    protected boolean[] weightedInstancesHandler() {
        boolean[] blArray = new boolean[2];
        this.print("weighted instances kernel...");
        if (this.m_Kernel instanceof WeightedInstancesHandler) {
            this.println("yes");
            blArray[0] = true;
        } else {
            this.println("no");
            blArray[0] = false;
        }
        return blArray;
    }

    protected boolean[] multiInstanceHandler() {
        boolean[] blArray = new boolean[2];
        this.print("multi-instance kernel...");
        if (this.m_Kernel instanceof MultiInstanceCapabilitiesHandler) {
            this.println("yes");
            blArray[0] = true;
        } else {
            this.println("no");
            blArray[0] = false;
        }
        return blArray;
    }

    protected boolean[] declaresSerialVersionUID() {
        boolean[] blArray = new boolean[2];
        this.print("serialVersionUID...");
        boolean bl = blArray[0] = !SerializationHelper.needsUID(this.m_Kernel.getClass());
        if (blArray[0]) {
            this.println("yes");
        } else {
            this.println("no");
        }
        return blArray;
    }

    protected boolean[] canPredict(boolean bl, boolean bl2, boolean bl3, boolean bl4, boolean bl5, boolean bl6, int n) {
        this.print("basic predict");
        this.printAttributeSummary(bl, bl2, bl3, bl4, bl5, bl6, n);
        this.print("...");
        FastVector fastVector = new FastVector();
        fastVector.addElement("unary");
        fastVector.addElement("binary");
        fastVector.addElement("nominal");
        fastVector.addElement("numeric");
        fastVector.addElement("string");
        fastVector.addElement("date");
        fastVector.addElement("relational");
        fastVector.addElement("multi-instance");
        fastVector.addElement("not in classpath");
        int n2 = this.getNumInstances();
        int n3 = 2;
        int n4 = 0;
        boolean bl7 = false;
        boolean bl8 = false;
        return this.runBasicTest(bl, bl2, bl3, bl4, bl5, bl6, n, n4, bl7, bl8, n2, n3, fastVector);
    }

    protected boolean[] canHandleNClasses(boolean bl, boolean bl2, boolean bl3, boolean bl4, boolean bl5, boolean bl6, int n) {
        this.print("more than two class problems");
        this.printAttributeSummary(bl, bl2, bl3, bl4, bl5, bl6, 1);
        this.print("...");
        FastVector fastVector = new FastVector();
        fastVector.addElement("number");
        fastVector.addElement("class");
        int n2 = this.getNumInstances();
        int n3 = 0;
        boolean bl7 = false;
        boolean bl8 = false;
        return this.runBasicTest(bl, bl2, bl3, bl4, bl5, bl6, 1, n3, bl7, bl8, n2, n, fastVector);
    }

    protected boolean[] canHandleClassAsNthAttribute(boolean bl, boolean bl2, boolean bl3, boolean bl4, boolean bl5, boolean bl6, int n, int n2) {
        if (n2 == -1) {
            this.print("class attribute as last attribute");
        } else {
            this.print("class attribute as " + (n2 + 1) + ". attribute");
        }
        this.printAttributeSummary(bl, bl2, bl3, bl4, bl5, bl6, n);
        this.print("...");
        FastVector fastVector = new FastVector();
        int n3 = this.getNumInstances();
        int n4 = 2;
        int n5 = 0;
        boolean bl7 = false;
        boolean bl8 = false;
        return this.runBasicTest(bl, bl2, bl3, bl4, bl5, bl6, n, n2, n5, bl7, bl8, n3, n4, fastVector);
    }

    protected boolean[] canHandleZeroTraining(boolean bl, boolean bl2, boolean bl3, boolean bl4, boolean bl5, boolean bl6, int n) {
        this.print("handle zero training instances");
        this.printAttributeSummary(bl, bl2, bl3, bl4, bl5, bl6, n);
        this.print("...");
        FastVector fastVector = new FastVector();
        fastVector.addElement("train");
        fastVector.addElement("value");
        int n2 = 0;
        int n3 = 2;
        int n4 = 0;
        boolean bl7 = false;
        boolean bl8 = false;
        return this.runBasicTest(bl, bl2, bl3, bl4, bl5, bl6, n, n4, bl7, bl8, n2, n3, fastVector);
    }

    protected boolean[] correctBuildInitialisation(boolean bl, boolean bl2, boolean bl3, boolean bl4, boolean bl5, boolean bl6, int n) {
        boolean[] blArray;
        block13: {
            blArray = new boolean[2];
            this.print("correct initialisation during buildKernel");
            this.printAttributeSummary(bl, bl2, bl3, bl4, bl5, bl6, n);
            this.print("...");
            int n2 = this.getNumInstances();
            int n3 = 2;
            int n4 = 0;
            boolean bl7 = false;
            boolean bl8 = false;
            Instances instances = null;
            Instances instances2 = null;
            Kernel kernel = null;
            KernelEvaluation kernelEvaluation = null;
            KernelEvaluation kernelEvaluation2 = null;
            KernelEvaluation kernelEvaluation3 = null;
            int n5 = 0;
            try {
                instances = this.makeTestDataset(42, n2, bl ? this.getNumNominal() : 0, bl2 ? this.getNumNumeric() : 0, bl3 ? this.getNumString() : 0, bl4 ? this.getNumDate() : 0, bl5 ? this.getNumRelational() : 0, n3, n, bl6);
                instances2 = this.makeTestDataset(84, n2, bl ? this.getNumNominal() + 1 : 0, bl2 ? this.getNumNumeric() + 1 : 0, bl3 ? this.getNumString() + 1 : 0, bl4 ? this.getNumDate() + 1 : 0, bl5 ? this.getNumRelational() + 1 : 0, n3, n, bl6);
                if (n4 > 0) {
                    this.addMissing(instances, n4, bl7, bl8);
                    this.addMissing(instances2, n4, bl7, bl8);
                }
                kernel = Kernel.makeCopy(this.getKernel());
                kernelEvaluation = new KernelEvaluation();
                kernelEvaluation2 = new KernelEvaluation();
                kernelEvaluation3 = new KernelEvaluation();
            }
            catch (Exception exception) {
                throw new Error("Error setting up for tests: " + exception.getMessage());
            }
            try {
                n5 = 0;
                kernelEvaluation.evaluate(kernel, instances);
                n5 = 1;
                kernelEvaluation3.evaluate(kernel, instances2);
                n5 = 2;
                kernelEvaluation2.evaluate(kernel, instances);
                n5 = 3;
                if (!kernelEvaluation.equals(kernelEvaluation2)) {
                    if (this.m_Debug) {
                        this.println("\n=== Full report ===\n" + kernelEvaluation.toSummaryString("\nFirst buildKernel()") + "\n\n");
                        this.println(kernelEvaluation2.toSummaryString("\nSecond buildKernel()") + "\n\n");
                    }
                    throw new Exception("Results differ between buildKernel calls");
                }
                this.println("yes");
                blArray[0] = true;
            }
            catch (Exception exception) {
                this.println("no");
                blArray[0] = false;
                if (!this.m_Debug) break block13;
                this.println("\n=== Full Report ===");
                this.print("Problem during building");
                switch (n5) {
                    case 0: {
                        this.print(" of dataset 1");
                        break;
                    }
                    case 1: {
                        this.print(" of dataset 2");
                        break;
                    }
                    case 2: {
                        this.print(" of dataset 1 (2nd build)");
                        break;
                    }
                    case 3: {
                        this.print(", comparing results from builds of dataset 1");
                    }
                }
                this.println(": " + exception.getMessage() + "\n");
                this.println("here are the datasets:\n");
                this.println("=== Train1 Dataset ===\n" + instances.toString() + "\n");
                this.println("=== Train2 Dataset ===\n" + instances2.toString() + "\n");
            }
        }
        return blArray;
    }

    protected boolean[] canHandleMissing(boolean bl, boolean bl2, boolean bl3, boolean bl4, boolean bl5, boolean bl6, int n, boolean bl7, boolean bl8, int n2) {
        if (n2 == 100) {
            this.print("100% ");
        }
        this.print("missing");
        if (bl7) {
            this.print(" predictor");
            if (bl8) {
                this.print(" and");
            }
        }
        if (bl8) {
            this.print(" class");
        }
        this.print(" values");
        this.printAttributeSummary(bl, bl2, bl3, bl4, bl5, bl6, n);
        this.print("...");
        FastVector fastVector = new FastVector();
        fastVector.addElement("missing");
        fastVector.addElement("value");
        fastVector.addElement("train");
        int n3 = this.getNumInstances();
        int n4 = 2;
        return this.runBasicTest(bl, bl2, bl3, bl4, bl5, bl6, n, n2, bl7, bl8, n3, n4, fastVector);
    }

    protected boolean[] instanceWeights(boolean bl, boolean bl2, boolean bl3, boolean bl4, boolean bl5, boolean bl6, int n) {
        boolean[] blArray;
        block11: {
            this.print("kernel uses instance weights");
            this.printAttributeSummary(bl, bl2, bl3, bl4, bl5, bl6, n);
            this.print("...");
            int n2 = 2 * this.getNumInstances();
            int n3 = 2;
            int n4 = 0;
            boolean bl7 = false;
            boolean bl8 = false;
            blArray = new boolean[2];
            Instances instances = null;
            Kernel[] kernelArray = null;
            KernelEvaluation kernelEvaluation = null;
            KernelEvaluation kernelEvaluation2 = null;
            boolean bl9 = false;
            try {
                instances = this.makeTestDataset(42, n2, bl ? this.getNumNominal() + 1 : 0, bl2 ? this.getNumNumeric() + 1 : 0, bl3 ? this.getNumString() : 0, bl4 ? this.getNumDate() : 0, bl5 ? this.getNumRelational() : 0, n3, n, bl6);
                if (n4 > 0) {
                    this.addMissing(instances, n4, bl7, bl8);
                }
                kernelArray = Kernel.makeCopies(this.getKernel(), 2);
                kernelEvaluation = new KernelEvaluation();
                kernelEvaluation2 = new KernelEvaluation();
                kernelEvaluation.evaluate(kernelArray[0], instances);
            }
            catch (Exception exception) {
                throw new Error("Error setting up for tests: " + exception.getMessage());
            }
            try {
                for (int i = 0; i < instances.numInstances(); ++i) {
                    instances.instance(i).setWeight(0.0);
                }
                Random random = new Random(1L);
                for (int i = 0; i < instances.numInstances() / 2; ++i) {
                    int n5 = Math.abs(random.nextInt()) % instances.numInstances();
                    int n6 = Math.abs(random.nextInt()) % 10 + 1;
                    instances.instance(n5).setWeight(n6);
                }
                kernelEvaluation2.evaluate(kernelArray[1], instances);
                if (kernelEvaluation.equals(kernelEvaluation2)) {
                    bl9 = true;
                    throw new Exception("evalFail");
                }
                this.println("yes");
                blArray[0] = true;
            }
            catch (Exception exception) {
                this.println("no");
                blArray[0] = false;
                if (!this.m_Debug) break block11;
                this.println("\n=== Full Report ===");
                if (bl9) {
                    this.println("Results don't differ between non-weighted and weighted instance models.");
                    this.println("Here are the results:\n");
                    this.println(kernelEvaluation.toSummaryString("\nboth methods\n"));
                } else {
                    this.print("Problem during building");
                    this.println(": " + exception.getMessage() + "\n");
                }
                this.println("Here is the dataset:\n");
                this.println("=== Train Dataset ===\n" + instances.toString() + "\n");
                this.println("=== Train Weights ===\n");
                for (int i = 0; i < instances.numInstances(); ++i) {
                    this.println(" " + (i + 1) + "    " + instances.instance(i).weight());
                }
            }
        }
        return blArray;
    }

    protected boolean[] datasetIntegrity(boolean bl, boolean bl2, boolean bl3, boolean bl4, boolean bl5, boolean bl6, int n, boolean bl7, boolean bl8) {
        boolean[] blArray;
        block5: {
            this.print("kernel doesn't alter original datasets");
            this.printAttributeSummary(bl, bl2, bl3, bl4, bl5, bl6, n);
            this.print("...");
            int n2 = this.getNumInstances();
            int n3 = 2;
            int n4 = 20;
            blArray = new boolean[2];
            Instances instances = null;
            Kernel kernel = null;
            try {
                instances = this.makeTestDataset(42, n2, bl ? this.getNumNominal() : 0, bl2 ? this.getNumNumeric() : 0, bl3 ? this.getNumString() : 0, bl4 ? this.getNumDate() : 0, bl5 ? this.getNumRelational() : 0, n3, n, bl6);
                if (n4 > 0) {
                    this.addMissing(instances, n4, bl7, bl8);
                }
                kernel = Kernel.makeCopies(this.getKernel(), 1)[0];
            }
            catch (Exception exception) {
                throw new Error("Error setting up for tests: " + exception.getMessage());
            }
            try {
                Instances instances2 = new Instances(instances);
                kernel.buildKernel(instances2);
                this.compareDatasets(instances, instances2);
                this.println("yes");
                blArray[0] = true;
            }
            catch (Exception exception) {
                this.println("no");
                blArray[0] = false;
                if (!this.m_Debug) break block5;
                this.println("\n=== Full Report ===");
                this.print("Problem during building");
                this.println(": " + exception.getMessage() + "\n");
                this.println("Here is the dataset:\n");
                this.println("=== Train Dataset ===\n" + instances.toString() + "\n");
            }
        }
        return blArray;
    }

    protected boolean[] runBasicTest(boolean bl, boolean bl2, boolean bl3, boolean bl4, boolean bl5, boolean bl6, int n, int n2, boolean bl7, boolean bl8, int n3, int n4, FastVector fastVector) {
        return this.runBasicTest(bl, bl2, bl3, bl4, bl5, bl6, n, -1, n2, bl7, bl8, n3, n4, fastVector);
    }

    protected boolean[] runBasicTest(boolean bl, boolean bl2, boolean bl3, boolean bl4, boolean bl5, boolean bl6, int n, int n2, int n3, boolean bl7, boolean bl8, int n4, int n5, FastVector fastVector) {
        boolean[] blArray;
        block10: {
            blArray = new boolean[2];
            Instances instances = null;
            Kernel kernel = null;
            try {
                instances = this.makeTestDataset(42, n4, bl ? this.getNumNominal() : 0, bl2 ? this.getNumNumeric() : 0, bl3 ? this.getNumString() : 0, bl4 ? this.getNumDate() : 0, bl5 ? this.getNumRelational() : 0, n5, n, n2, bl6);
                if (n3 > 0) {
                    this.addMissing(instances, n3, bl7, bl8);
                }
                kernel = Kernel.makeCopies(this.getKernel(), 1)[0];
            }
            catch (Exception exception) {
                exception.printStackTrace();
                throw new Error("Error setting up for tests: " + exception.getMessage());
            }
            try {
                kernel.buildKernel(instances);
                this.println("yes");
                blArray[0] = true;
            }
            catch (Exception exception) {
                int n6;
                boolean bl9 = false;
                String string = exception.getMessage() == null ? "" : exception.getMessage().toLowerCase();
                if (string.indexOf("not in classpath") > -1) {
                    this.m_ClasspathProblems = true;
                }
                for (n6 = 0; n6 < fastVector.size(); ++n6) {
                    if (string.indexOf((String)fastVector.elementAt(n6)) < 0) continue;
                    bl9 = true;
                }
                this.println("no" + (bl9 ? " (OK error message)" : ""));
                blArray[1] = bl9;
                if (!this.m_Debug) break block10;
                this.println("\n=== Full Report ===");
                this.print("Problem during building");
                this.println(": " + exception.getMessage() + "\n");
                if (bl9) break block10;
                if (fastVector.size() > 0) {
                    this.print("Error message doesn't mention ");
                    for (n6 = 0; n6 < fastVector.size(); ++n6) {
                        if (n6 != 0) {
                            this.print(" or ");
                        }
                        this.print('\"' + (String)fastVector.elementAt(n6) + '\"');
                    }
                }
                this.println("here is the dataset:\n");
                this.println("=== Train Dataset ===\n" + instances.toString() + "\n");
            }
        }
        return blArray;
    }

    protected Instances makeTestDataset(int n, int n2, int n3, int n4, int n5, int n6, int n7, int n8, int n9, boolean bl) throws Exception {
        return this.makeTestDataset(n, n2, n3, n4, n5, n6, n7, n8, n9, -1, bl);
    }

    protected Instances makeTestDataset(int n, int n2, int n3, int n4, int n5, int n6, int n7, int n8, int n9, int n10, boolean bl) throws Exception {
        TestInstances testInstances = new TestInstances();
        testInstances.setSeed(n);
        testInstances.setNumInstances(n2);
        testInstances.setNumNominal(n3);
        testInstances.setNumNumeric(n4);
        testInstances.setNumString(n5);
        testInstances.setNumDate(n6);
        testInstances.setNumRelational(n7);
        testInstances.setNumClasses(n8);
        testInstances.setClassType(n9);
        testInstances.setClassIndex(n10);
        testInstances.setNumClasses(n8);
        testInstances.setMultiInstance(bl);
        testInstances.setWords(this.getWords());
        testInstances.setWordSeparators(this.getWordSeparators());
        return this.process(testInstances.generate());
    }

    protected void printAttributeSummary(boolean bl, boolean bl2, boolean bl3, boolean bl4, boolean bl5, boolean bl6, int n) {
        String string = "";
        if (bl2) {
            string = string + " numeric";
        }
        if (bl) {
            if (string.length() > 0) {
                string = string + " &";
            }
            string = string + " nominal";
        }
        if (bl3) {
            if (string.length() > 0) {
                string = string + " &";
            }
            string = string + " string";
        }
        if (bl4) {
            if (string.length() > 0) {
                string = string + " &";
            }
            string = string + " date";
        }
        if (bl5) {
            if (string.length() > 0) {
                string = string + " &";
            }
            string = string + " relational";
        }
        string = string + " predictors)";
        switch (n) {
            case 0: {
                string = " (numeric class," + string;
                break;
            }
            case 1: {
                string = " (nominal class," + string;
                break;
            }
            case 2: {
                string = " (string class," + string;
                break;
            }
            case 3: {
                string = " (date class," + string;
                break;
            }
            case 4: {
                string = " (relational class," + string;
            }
        }
        this.print(string);
    }

    public String getRevision() {
        return RevisionUtils.extract("$Revision: 1.3 $");
    }

    public static void main(String[] stringArray) {
        CheckKernel.runCheck(new CheckKernel(), stringArray);
    }
}

