/*
 * Decompiled with CFR 0.152.
 */
package weka.classifiers.misc.monotone;

import java.util.Arrays;
import weka.classifiers.misc.monotone.CumulativeDiscreteDistribution;
import weka.classifiers.misc.monotone.DiscreteDistribution;
import weka.core.RevisionHandler;
import weka.core.RevisionUtils;
import weka.estimators.DiscreteEstimator;

public class DistributionUtils
implements RevisionHandler {
    private static final int MAX_CLASSES = 20;
    private static final CumulativeDiscreteDistribution[] m_minimalDistributions = new CumulativeDiscreteDistribution[21];
    private static final CumulativeDiscreteDistribution[] m_maximalDistributions = new CumulativeDiscreteDistribution[21];

    public static CumulativeDiscreteDistribution interpolate(CumulativeDiscreteDistribution cumulativeDiscreteDistribution, CumulativeDiscreteDistribution cumulativeDiscreteDistribution2, double d) throws IllegalArgumentException {
        if (cumulativeDiscreteDistribution.getNumSymbols() != cumulativeDiscreteDistribution2.getNumSymbols()) {
            throw new IllegalArgumentException("CumulativeDiscreteDistributions don't have the same size");
        }
        if (d < 0.0 || d > 1.0) {
            throw new IllegalArgumentException("Parameter s exceeds bounds");
        }
        double[] dArray = new double[cumulativeDiscreteDistribution.getNumSymbols()];
        int n = cumulativeDiscreteDistribution.getNumSymbols();
        for (int i = 0; i < n; ++i) {
            dArray[i] = (1.0 - d) * cumulativeDiscreteDistribution.getCumulativeProbability(i) + d * cumulativeDiscreteDistribution2.getCumulativeProbability(i);
        }
        return new CumulativeDiscreteDistribution(dArray);
    }

    public static CumulativeDiscreteDistribution interpolate(CumulativeDiscreteDistribution cumulativeDiscreteDistribution, CumulativeDiscreteDistribution cumulativeDiscreteDistribution2, double[] dArray) throws IllegalArgumentException {
        if (cumulativeDiscreteDistribution.getNumSymbols() != cumulativeDiscreteDistribution2.getNumSymbols()) {
            throw new IllegalArgumentException("CumulativeDiscreteDistributions don't have the same size");
        }
        if (cumulativeDiscreteDistribution.getNumSymbols() > dArray.length) {
            throw new IllegalArgumentException("Array with interpolation parameters is not  long enough");
        }
        double[] dArray2 = new double[cumulativeDiscreteDistribution.getNumSymbols()];
        int n = cumulativeDiscreteDistribution.getNumSymbols();
        for (int i = 0; i < n; ++i) {
            if (dArray[i] < 0.0 || dArray[i] > 1.0) {
                throw new IllegalArgumentException("Interpolation parameter exceeds bounds");
            }
            dArray2[i] = (1.0 - dArray[i]) * cumulativeDiscreteDistribution.getCumulativeProbability(i) + dArray[i] * cumulativeDiscreteDistribution2.getCumulativeProbability(i);
        }
        return new CumulativeDiscreteDistribution(dArray2);
    }

    public static DiscreteDistribution interpolate(DiscreteDistribution discreteDistribution, DiscreteDistribution discreteDistribution2, double d) throws IllegalArgumentException {
        if (discreteDistribution.getNumSymbols() != discreteDistribution2.getNumSymbols()) {
            throw new IllegalArgumentException("DiscreteDistributions don't have the same size");
        }
        if (d < 0.0 || d > 1.0) {
            throw new IllegalArgumentException("Parameter s exceeds bounds");
        }
        double[] dArray = new double[discreteDistribution.getNumSymbols()];
        int n = discreteDistribution.getNumSymbols();
        for (int i = 0; i < n; ++i) {
            dArray[i] = (1.0 - d) * discreteDistribution.getProbability(i) + d * discreteDistribution2.getProbability(i);
        }
        return new DiscreteDistribution(dArray);
    }

    public static CumulativeDiscreteDistribution takeMin(CumulativeDiscreteDistribution cumulativeDiscreteDistribution, CumulativeDiscreteDistribution cumulativeDiscreteDistribution2) throws IllegalArgumentException {
        if (cumulativeDiscreteDistribution.getNumSymbols() != cumulativeDiscreteDistribution2.getNumSymbols()) {
            throw new IllegalArgumentException("Cumulative distributions don't have the same length");
        }
        double[] dArray = new double[cumulativeDiscreteDistribution.getNumSymbols()];
        int n = dArray.length;
        for (int i = 0; i < n; ++i) {
            dArray[i] = Math.min(cumulativeDiscreteDistribution.getCumulativeProbability(i), cumulativeDiscreteDistribution2.getCumulativeProbability(i));
        }
        return new CumulativeDiscreteDistribution(dArray);
    }

    public static CumulativeDiscreteDistribution takeMax(CumulativeDiscreteDistribution cumulativeDiscreteDistribution, CumulativeDiscreteDistribution cumulativeDiscreteDistribution2) throws IllegalArgumentException {
        if (cumulativeDiscreteDistribution.getNumSymbols() != cumulativeDiscreteDistribution2.getNumSymbols()) {
            throw new IllegalArgumentException("Cumulative distributions don't have the same length");
        }
        double[] dArray = new double[cumulativeDiscreteDistribution.getNumSymbols()];
        int n = dArray.length;
        for (int i = 0; i < n; ++i) {
            dArray[i] = Math.max(cumulativeDiscreteDistribution.getCumulativeProbability(i), cumulativeDiscreteDistribution2.getCumulativeProbability(i));
        }
        return new CumulativeDiscreteDistribution(dArray);
    }

    public static double[] getDistributionArray(DiscreteEstimator discreteEstimator) {
        double[] dArray = new double[discreteEstimator.getNumSymbols()];
        for (int i = 0; i < dArray.length; ++i) {
            dArray[i] = discreteEstimator.getProbability(i);
        }
        return dArray;
    }

    public static CumulativeDiscreteDistribution getMinimalCumulativeDiscreteDistribution(int n) throws IllegalArgumentException {
        if (n <= 0) {
            throw new IllegalArgumentException("Number of elements must be positive");
        }
        if (n <= 20) {
            return m_minimalDistributions[n];
        }
        double[] dArray = new double[n];
        Arrays.fill(dArray, 1.0);
        return new CumulativeDiscreteDistribution(dArray);
    }

    public static CumulativeDiscreteDistribution getMaximalCumulativeDiscreteDistribution(int n) throws IllegalArgumentException {
        if (n <= 0) {
            throw new IllegalArgumentException("Number of elements must be positive");
        }
        if (n <= 20) {
            return m_maximalDistributions[n];
        }
        double[] dArray = new double[n];
        dArray[dArray.length - 1] = 1.0;
        return new CumulativeDiscreteDistribution(dArray);
    }

    public String getRevision() {
        return RevisionUtils.extract("$Revision: 1.2 $");
    }

    static {
        for (int i = 1; i <= 20; ++i) {
            double[] dArray = new double[i];
            dArray[dArray.length - 1] = 1.0;
            DistributionUtils.m_maximalDistributions[i] = new CumulativeDiscreteDistribution(dArray);
            Arrays.fill(dArray, 1.0);
            DistributionUtils.m_minimalDistributions[i] = new CumulativeDiscreteDistribution(dArray);
        }
    }
}

