/*
 * Decompiled with CFR 0.152.
 */
package weka.core;

import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import weka.core.RevisionHandler;
import weka.core.RevisionUtils;
import weka.core.Version;

public class Environment
implements RevisionHandler {
    private static Map<String, String> ENV_VARS;

    public static String substitute(String string) throws Exception {
        int n = string.indexOf("${");
        while (n >= 0) {
            int n2 = string.indexOf(125);
            if (n2 >= 0 && n2 > (n += 2) + 1) {
                String string2 = string.substring(n, n2);
                String string3 = ENV_VARS.get(string2);
                if (string3 != null) {
                    String string4 = "${" + string2 + "}";
                    string = string.replace(string4, string3);
                } else {
                    throw new Exception("[Environment] Variable " + string2 + " doesn't seem to be set.");
                }
            }
            n = string.indexOf("${");
        }
        return string;
    }

    public static void addVariable(String string, String string2) {
        ENV_VARS.put(string, string2);
    }

    public static void removeVariable(String string) {
        ENV_VARS.remove(string);
    }

    public static String getVariable(String string) {
        return ENV_VARS.get(string);
    }

    public static void main(String[] stringArray) {
        Environment environment = new Environment();
        if (stringArray.length == 0) {
            System.err.println("Usage: java weka.core.Environment <string> <string> ...");
        } else {
            try {
                for (int i = 0; i < stringArray.length; ++i) {
                    String string = Environment.substitute(stringArray[i]);
                    System.out.println("Original string:\n" + stringArray[i] + "\n\nNew string:\n" + string);
                }
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
    }

    public String getRevision() {
        return RevisionUtils.extract("$Revision: 1.1 $");
    }

    static {
        Object object;
        ENV_VARS = new HashMap<String, String>();
        Map<String, String> map = System.getenv();
        Set<String> set = map.keySet();
        for (String object22 : set) {
            object = map.get(object22);
            ENV_VARS.put(object22, (String)object);
        }
        Properties properties = System.getProperties();
        object = properties.propertyNames();
        while (object.hasMoreElements()) {
            String string = (String)object.nextElement();
            String string2 = properties.getProperty(string);
            ENV_VARS.put(string, string2);
        }
        ENV_VARS.put("weka.version", Version.VERSION);
    }
}

