/*
 * Decompiled with CFR 0.152.
 */
package weka.core.parser.JFlex;

import weka.core.parser.JFlex.Out;

public abstract class PackEmitter {
    protected String name;
    private int UTF8Length;
    private int linepos;
    private static final int maxEntries = 16;
    protected StringBuffer out = new StringBuffer();
    protected int chunks;
    private static final int maxSize = 65529;
    private static final String indent = "    ";

    public PackEmitter(String string) {
        this.name = string;
    }

    protected String constName() {
        return "ZZ_" + this.name.toUpperCase();
    }

    public String toString() {
        return this.out.toString();
    }

    public void emitInit() {
        this.out.append("  private static final int [] ");
        this.out.append(this.constName());
        this.out.append(" = zzUnpack");
        this.out.append(this.name);
        this.out.append("();");
        this.nl();
        this.nextChunk();
    }

    public void emitUC(int n) {
        if (n < 0 || n > 65535) {
            throw new IllegalArgumentException("character value expected");
        }
        char c = (char)n;
        this.printUC(c);
        this.UTF8Length += this.UTF8Length(c);
        ++this.linepos;
    }

    public void breaks() {
        if (this.UTF8Length >= 65529) {
            this.out.append("\";");
            this.nl();
            this.nextChunk();
        } else if (this.linepos >= 16) {
            this.out.append("\"+");
            this.nl();
            this.out.append(indent);
            this.out.append("\"");
            this.linepos = 0;
        }
    }

    public abstract void emitUnpack();

    private void nextChunk() {
        this.nl();
        this.out.append("  private static final String ");
        this.out.append(this.constName());
        this.out.append("_PACKED_");
        this.out.append(this.chunks);
        this.out.append(" =");
        this.nl();
        this.out.append(indent);
        this.out.append("\"");
        this.UTF8Length = 0;
        this.linepos = 0;
        ++this.chunks;
    }

    protected void nl() {
        this.out.append(Out.NL);
    }

    private void printUC(char c) {
        if (c > '\u00ff') {
            this.out.append("\\u");
            if (c < '\u1000') {
                this.out.append("0");
            }
            this.out.append(Integer.toHexString(c));
        } else {
            this.out.append("\\");
            this.out.append(Integer.toOctalString(c));
        }
    }

    private int UTF8Length(char c) {
        if (c == '\u0000') {
            return 2;
        }
        if (c <= '\u007f') {
            return 1;
        }
        if (c < '\u0400') {
            return 2;
        }
        if (c <= '\u07ff') {
            return 3;
        }
        return 3;
    }

    protected void println(String string) {
        this.out.append(string);
        this.nl();
    }
}

