/*
 * Decompiled with CFR 0.152.
 */
package weka.classifiers.bayes.net.search.local;

import java.util.Enumeration;
import java.util.Vector;
import weka.classifiers.bayes.BayesNet;
import weka.classifiers.bayes.net.ParentSet;
import weka.classifiers.bayes.net.search.SearchAlgorithm;
import weka.classifiers.bayes.net.search.local.Scoreable;
import weka.core.Instance;
import weka.core.Instances;
import weka.core.Option;
import weka.core.RevisionUtils;
import weka.core.SelectedTag;
import weka.core.Statistics;
import weka.core.Tag;
import weka.core.Utils;

public class LocalScoreSearchAlgorithm
extends SearchAlgorithm {
    static final long serialVersionUID = 3325995552474190374L;
    BayesNet m_BayesNet;
    double m_fAlpha = 0.5;
    public static final Tag[] TAGS_SCORE_TYPE = new Tag[]{new Tag(0, "BAYES"), new Tag(1, "BDeu"), new Tag(2, "MDL"), new Tag(3, "ENTROPY"), new Tag(4, "AIC")};
    int m_nScoreType = 0;

    public LocalScoreSearchAlgorithm() {
    }

    public LocalScoreSearchAlgorithm(BayesNet bayesNet, Instances instances) {
        this.m_BayesNet = bayesNet;
    }

    public double logScore(int n) {
        if (this.m_BayesNet.m_Distributions == null) {
            return 0.0;
        }
        if (n < 0) {
            n = this.m_nScoreType;
        }
        double d = 0.0;
        Instances instances = this.m_BayesNet.m_Instances;
        block4: for (int i = 0; i < instances.numAttributes(); ++i) {
            int n2 = this.m_BayesNet.getParentSet(i).getCardinalityOfParents();
            for (int j = 0; j < n2; ++j) {
                d += ((Scoreable)((Object)this.m_BayesNet.m_Distributions[i][j])).logScore(n, n2);
            }
            switch (n) {
                case 2: {
                    d -= 0.5 * (double)this.m_BayesNet.getParentSet(i).getCardinalityOfParents() * (double)(instances.attribute(i).numValues() - 1) * Math.log(instances.numInstances());
                    continue block4;
                }
                case 4: {
                    d -= (double)(this.m_BayesNet.getParentSet(i).getCardinalityOfParents() * (instances.attribute(i).numValues() - 1));
                }
            }
        }
        return d;
    }

    public void buildStructure(BayesNet bayesNet, Instances instances) throws Exception {
        this.m_BayesNet = bayesNet;
        super.buildStructure(bayesNet, instances);
    }

    public double calcNodeScore(int n) {
        if (this.m_BayesNet.getUseADTree() && this.m_BayesNet.getADTree() != null) {
            return this.calcNodeScoreADTree(n);
        }
        return this.calcNodeScorePlain(n);
    }

    private double calcNodeScoreADTree(int n) {
        int n2;
        int n3;
        Instances instances = this.m_BayesNet.m_Instances;
        ParentSet parentSet = this.m_BayesNet.getParentSet(n);
        int n4 = parentSet.getNrOfParents();
        int[] nArray = new int[n4 + 1];
        for (int i = 0; i < n4; ++i) {
            nArray[i] = parentSet.getParent(i);
        }
        nArray[n4] = n;
        int[] nArray2 = new int[n4 + 1];
        int n5 = 1;
        nArray2[n4] = 1;
        n5 *= instances.attribute(n).numValues();
        for (n3 = n4 - 1; n3 >= 0; --n3) {
            nArray2[n3] = n5;
            n5 *= instances.attribute(nArray[n3]).numValues();
        }
        for (n3 = 1; n3 < nArray.length; ++n3) {
            for (n2 = n3; n2 > 0 && nArray[n2] < nArray[n2 - 1]; --n2) {
                int n6 = nArray[n2];
                nArray[n2] = nArray[n2 - 1];
                nArray[n2 - 1] = n6;
                n6 = nArray2[n2];
                nArray2[n2] = nArray2[n2 - 1];
                nArray2[n2 - 1] = n6;
            }
        }
        n3 = parentSet.getCardinalityOfParents();
        n2 = instances.attribute(n).numValues();
        int[] nArray3 = new int[n3 * n2];
        this.m_BayesNet.getADTree().getCounts(nArray3, nArray, nArray2, 0, 0, false);
        return this.calcScoreOfCounts(nArray3, n3, n2, instances);
    }

    private double calcNodeScorePlain(int n) {
        Instances instances = this.m_BayesNet.m_Instances;
        ParentSet parentSet = this.m_BayesNet.getParentSet(n);
        int n2 = parentSet.getCardinalityOfParents();
        int n3 = instances.attribute(n).numValues();
        int[] nArray = new int[n2 * n3];
        for (int i = 0; i < n2 * n3; ++i) {
            nArray[i] = 0;
        }
        Enumeration enumeration = instances.enumerateInstances();
        while (enumeration.hasMoreElements()) {
            Instance instance = (Instance)enumeration.nextElement();
            double d = 0.0;
            for (int i = 0; i < parentSet.getNrOfParents(); ++i) {
                int n4 = parentSet.getParent(i);
                d = d * (double)instances.attribute(n4).numValues() + instance.value(n4);
            }
            int n5 = n3 * (int)d + (int)instance.value(n);
            nArray[n5] = nArray[n5] + 1;
        }
        return this.calcScoreOfCounts(nArray, n2, n3, instances);
    }

    protected double calcScoreOfCounts(int[] nArray, int n, int n2, Instances instances) {
        double d = 0.0;
        block9: for (int i = 0; i < n; ++i) {
            switch (this.m_nScoreType) {
                case 0: {
                    int n3;
                    double d2 = 0.0;
                    for (n3 = 0; n3 < n2; ++n3) {
                        if (this.m_fAlpha + (double)nArray[i * n2 + n3] == 0.0) continue;
                        d += Statistics.lnGamma(this.m_fAlpha + (double)nArray[i * n2 + n3]);
                        d2 += this.m_fAlpha + (double)nArray[i * n2 + n3];
                    }
                    if (d2 != 0.0) {
                        d -= Statistics.lnGamma(d2);
                    }
                    if (this.m_fAlpha == 0.0) continue block9;
                    d -= (double)n2 * Statistics.lnGamma(this.m_fAlpha);
                    d += Statistics.lnGamma((double)n2 * this.m_fAlpha);
                    continue block9;
                }
                case 1: {
                    int n3;
                    double d2 = 0.0;
                    for (n3 = 0; n3 < n2; ++n3) {
                        if (this.m_fAlpha + (double)nArray[i * n2 + n3] == 0.0) continue;
                        d += Statistics.lnGamma(1.0 / (double)(n2 * n) + (double)nArray[i * n2 + n3]);
                        d2 += 1.0 / (double)(n2 * n) + (double)nArray[i * n2 + n3];
                    }
                    d -= Statistics.lnGamma(d2);
                    d -= (double)n2 * Statistics.lnGamma(1.0 / (double)(n2 * n));
                    d += Statistics.lnGamma(1.0 / (double)n);
                    continue block9;
                }
                case 2: 
                case 3: 
                case 4: {
                    int n3;
                    double d2 = 0.0;
                    for (n3 = 0; n3 < n2; ++n3) {
                        d2 += (double)nArray[i * n2 + n3];
                    }
                    for (n3 = 0; n3 < n2; ++n3) {
                        if (nArray[i * n2 + n3] <= 0) continue;
                        d += (double)nArray[i * n2 + n3] * Math.log((double)nArray[i * n2 + n3] / d2);
                    }
                    continue block9;
                }
            }
        }
        switch (this.m_nScoreType) {
            case 2: {
                d -= 0.5 * (double)n * (double)(n2 - 1) * Math.log(instances.numInstances());
                break;
            }
            case 4: {
                d -= (double)(n * (n2 - 1));
            }
        }
        return d;
    }

    protected double calcScoreOfCounts2(int[][] nArray, int n, int n2, Instances instances) {
        double d = 0.0;
        block9: for (int i = 0; i < n; ++i) {
            switch (this.m_nScoreType) {
                case 0: {
                    int n3;
                    double d2 = 0.0;
                    for (n3 = 0; n3 < n2; ++n3) {
                        if (this.m_fAlpha + (double)nArray[i][n3] == 0.0) continue;
                        d += Statistics.lnGamma(this.m_fAlpha + (double)nArray[i][n3]);
                        d2 += this.m_fAlpha + (double)nArray[i][n3];
                    }
                    if (d2 != 0.0) {
                        d -= Statistics.lnGamma(d2);
                    }
                    if (this.m_fAlpha == 0.0) continue block9;
                    d -= (double)n2 * Statistics.lnGamma(this.m_fAlpha);
                    d += Statistics.lnGamma((double)n2 * this.m_fAlpha);
                    continue block9;
                }
                case 1: {
                    int n3;
                    double d2 = 0.0;
                    for (n3 = 0; n3 < n2; ++n3) {
                        if (this.m_fAlpha + (double)nArray[i * n2][n3] == 0.0) continue;
                        d += Statistics.lnGamma(1.0 / (double)(n2 * n) + (double)nArray[i * n2][n3]);
                        d2 += 1.0 / (double)(n2 * n) + (double)nArray[i * n2][n3];
                    }
                    d -= Statistics.lnGamma(d2);
                    d -= (double)n2 * Statistics.lnGamma(1.0 / (double)(n * n2));
                    d += Statistics.lnGamma(1.0 / (double)n);
                    continue block9;
                }
                case 2: 
                case 3: 
                case 4: {
                    int n3;
                    double d2 = 0.0;
                    for (n3 = 0; n3 < n2; ++n3) {
                        d2 += (double)nArray[i][n3];
                    }
                    for (n3 = 0; n3 < n2; ++n3) {
                        if (nArray[i][n3] <= 0) continue;
                        d += (double)nArray[i][n3] * Math.log((double)nArray[i][n3] / d2);
                    }
                    continue block9;
                }
            }
        }
        switch (this.m_nScoreType) {
            case 2: {
                d -= 0.5 * (double)n * (double)(n2 - 1) * Math.log(instances.numInstances());
                break;
            }
            case 4: {
                d -= (double)(n * (n2 - 1));
            }
        }
        return d;
    }

    public double calcScoreWithExtraParent(int n, int n2) {
        ParentSet parentSet = this.m_BayesNet.getParentSet(n);
        if (parentSet.contains(n2)) {
            return -1.0E100;
        }
        parentSet.addParent(n2, this.m_BayesNet.m_Instances);
        double d = this.calcNodeScore(n);
        parentSet.deleteLastParent(this.m_BayesNet.m_Instances);
        return d;
    }

    public double calcScoreWithMissingParent(int n, int n2) {
        ParentSet parentSet = this.m_BayesNet.getParentSet(n);
        if (!parentSet.contains(n2)) {
            return -1.0E100;
        }
        int n3 = parentSet.deleteParent(n2, this.m_BayesNet.m_Instances);
        double d = this.calcNodeScore(n);
        parentSet.addParent(n2, n3, this.m_BayesNet.m_Instances);
        return d;
    }

    public void setScoreType(SelectedTag selectedTag) {
        if (selectedTag.getTags() == TAGS_SCORE_TYPE) {
            this.m_nScoreType = selectedTag.getSelectedTag().getID();
        }
    }

    public SelectedTag getScoreType() {
        return new SelectedTag(this.m_nScoreType, TAGS_SCORE_TYPE);
    }

    public void setMarkovBlanketClassifier(boolean bl) {
        super.setMarkovBlanketClassifier(bl);
    }

    public boolean getMarkovBlanketClassifier() {
        return super.getMarkovBlanketClassifier();
    }

    public Enumeration listOptions() {
        Vector<Option> vector = new Vector<Option>();
        vector.addElement(new Option("\tApplies a Markov Blanket correction to the network structure, \n\tafter a network structure is learned. This ensures that all \n\tnodes in the network are part of the Markov blanket of the \n\tclassifier node.", "mbc", 0, "-mbc"));
        vector.addElement(new Option("\tScore type (BAYES, BDeu, MDL, ENTROPY and AIC)", "S", 1, "-S [BAYES|MDL|ENTROPY|AIC|CROSS_CLASSIC|CROSS_BAYES]"));
        return vector.elements();
    }

    public void setOptions(String[] stringArray) throws Exception {
        this.setMarkovBlanketClassifier(Utils.getFlag("mbc", stringArray));
        String string = Utils.getOption('S', stringArray);
        if (string.compareTo("BAYES") == 0) {
            this.setScoreType(new SelectedTag(0, TAGS_SCORE_TYPE));
        }
        if (string.compareTo("BDeu") == 0) {
            this.setScoreType(new SelectedTag(1, TAGS_SCORE_TYPE));
        }
        if (string.compareTo("MDL") == 0) {
            this.setScoreType(new SelectedTag(2, TAGS_SCORE_TYPE));
        }
        if (string.compareTo("ENTROPY") == 0) {
            this.setScoreType(new SelectedTag(3, TAGS_SCORE_TYPE));
        }
        if (string.compareTo("AIC") == 0) {
            this.setScoreType(new SelectedTag(4, TAGS_SCORE_TYPE));
        }
    }

    public String[] getOptions() {
        String[] stringArray = super.getOptions();
        String[] stringArray2 = new String[3 + stringArray.length];
        int n = 0;
        if (this.getMarkovBlanketClassifier()) {
            stringArray2[n++] = "-mbc";
        }
        stringArray2[n++] = "-S";
        switch (this.m_nScoreType) {
            case 0: {
                stringArray2[n++] = "BAYES";
                break;
            }
            case 1: {
                stringArray2[n++] = "BDeu";
                break;
            }
            case 2: {
                stringArray2[n++] = "MDL";
                break;
            }
            case 3: {
                stringArray2[n++] = "ENTROPY";
                break;
            }
            case 4: {
                stringArray2[n++] = "AIC";
            }
        }
        for (int i = 0; i < stringArray.length; ++i) {
            stringArray2[n++] = stringArray[i];
        }
        while (n < stringArray2.length) {
            stringArray2[n++] = "";
        }
        return stringArray2;
    }

    public String scoreTypeTipText() {
        return "The score type determines the measure used to judge the quality of a network structure. It can be one of Bayes, BDeu, Minimum Description Length (MDL), Akaike Information Criterion (AIC), and Entropy.";
    }

    public String markovBlanketClassifierTipText() {
        return super.markovBlanketClassifierTipText();
    }

    public String globalInfo() {
        return "The ScoreBasedSearchAlgorithm class supports Bayes net structure search algorithms that are based on maximizing scores (as opposed to for example conditional independence based search algorithms).";
    }

    public String getRevision() {
        return RevisionUtils.extract("$Revision: 1.8 $");
    }
}

