/*
 * Decompiled with CFR 0.152.
 */
package weka.classifiers.misc.monotone;

import weka.classifiers.misc.monotone.BitMatrix;
import weka.core.RevisionHandler;
import weka.core.RevisionUtils;

public class BooleanBitMatrix
implements BitMatrix,
RevisionHandler {
    private boolean[][] m_bits;
    private int m_rows;
    private int m_columns;

    public BooleanBitMatrix(int n, int n2) {
        this.m_bits = new boolean[n][n2];
        this.m_rows = n;
        this.m_columns = n2;
    }

    public BooleanBitMatrix(BooleanBitMatrix booleanBitMatrix) {
        this(booleanBitMatrix.m_rows, booleanBitMatrix.m_columns);
        for (int i = 0; i < this.m_rows; ++i) {
            System.arraycopy(booleanBitMatrix.m_bits[i], 0, this.m_bits[i], 0, this.m_columns);
        }
    }

    public boolean get(int n, int n2) {
        return this.m_bits[n][n2];
    }

    public boolean set(int n, int n2, boolean bl) {
        this.m_bits[n][n2] = bl;
        return bl;
    }

    public boolean set(int n, int n2) {
        return !this.get(n, n2) && this.set(n, n2, true);
    }

    public boolean clear(int n, int n2) {
        return this.get(n, n2) && !this.set(n, n2, false);
    }

    public int rows() {
        return this.m_rows;
    }

    public int columns() {
        return this.m_columns;
    }

    public int columnCount(int n) {
        int n2 = 0;
        for (int i = 0; i < this.m_rows; ++i) {
            n2 += this.m_bits[i][n] ? 1 : 0;
        }
        return n2;
    }

    public int rowCount(int n) {
        int n2 = 0;
        for (int i = 0; i < this.m_columns; ++i) {
            n2 += this.m_bits[n][i] ? 1 : 0;
        }
        return n2;
    }

    public BooleanBitMatrix transpose() {
        BooleanBitMatrix booleanBitMatrix = new BooleanBitMatrix(this.m_columns, this.m_rows);
        for (int i = 0; i < this.m_rows; ++i) {
            for (int j = 0; j < this.m_columns; ++j) {
                booleanBitMatrix.set(j, i, this.get(i, j));
            }
        }
        return booleanBitMatrix;
    }

    public void transposeInPlace() throws IllegalArgumentException {
        if (this.m_rows != this.m_columns) {
            throw new IllegalArgumentException("The BooleanBitMatrix is not square");
        }
        for (int i = 0; i < this.m_rows; ++i) {
            for (int j = i + 1; j < this.m_columns; ++j) {
                this.swap(i, j, j, i);
            }
        }
    }

    private void swap(int n, int n2, int n3, int n4) {
        boolean bl = this.get(n, n2);
        this.set(n, n2, this.get(n3, n4));
        this.set(n3, n4, bl);
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer(this.m_rows * (this.m_columns + 1));
        for (int i = 0; i < this.m_rows; ++i) {
            for (int j = 0; j < this.m_columns; ++j) {
                stringBuffer.append(this.get(i, j) ? 1 : 0);
            }
            stringBuffer.append("\n");
        }
        return stringBuffer.toString();
    }

    public String getRevision() {
        return RevisionUtils.extract("$Revision: 1.2 $");
    }
}

