/*
 * Decompiled with CFR 0.152.
 */
package weka.core;

import weka.core.RevisionHandler;

public class RevisionUtils {
    public static String extract(RevisionHandler revisionHandler) {
        return RevisionUtils.extract(revisionHandler.getRevision());
    }

    public static String extract(String string) {
        String string2 = string;
        string2 = string2.replaceAll("\\$Revision:", "");
        string2 = string2.replaceAll("\\$", "");
        string2 = string2.replaceAll(" ", "");
        return string2;
    }

    public static Type getType(RevisionHandler revisionHandler) {
        return RevisionUtils.getType(RevisionUtils.extract(revisionHandler));
    }

    public static Type getType(String string) {
        Type type = Type.UNKNOWN;
        try {
            Integer.parseInt(string);
            type = Type.SUBVERSION;
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (type == Type.UNKNOWN) {
            try {
                if (string.indexOf(46) == -1) {
                    throw new Exception("invalid CVS revision - not dots!");
                }
                String[] stringArray = string.split("\\.");
                if (stringArray.length < 2) {
                    throw new Exception("invalid CVS revision - not enough parts separated by dots!");
                }
                for (int i = 0; i < stringArray.length; ++i) {
                    Integer.parseInt(stringArray[i]);
                }
                type = Type.CVS;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return type;
    }

    public static void main(String[] stringArray) throws Exception {
        if (stringArray.length != 1) {
            System.err.println("\nUsage: " + RevisionUtils.class.getName() + " <classname>\n");
            System.exit(1);
        }
        RevisionHandler revisionHandler = (RevisionHandler)Class.forName(stringArray[0]).newInstance();
        System.out.println("Type: " + (Object)((Object)RevisionUtils.getType(revisionHandler)));
        System.out.println("Revision: " + RevisionUtils.extract(revisionHandler));
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Type {
        UNKNOWN,
        CVS,
        SUBVERSION;

    }
}

