/*
 * Decompiled with CFR 0.152.
 */
package weka.core.parser.JFlex;

import java.awt.TextArea;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.OutputStream;
import weka.core.parser.JFlex.ErrorMessages;
import weka.core.parser.JFlex.GeneratorException;
import weka.core.parser.JFlex.Options;
import weka.core.parser.JFlex.StdOutWriter;
import weka.core.parser.JFlex.Timer;

public final class Out {
    public static final String NL = System.getProperty("line.separator");
    private static int warnings;
    private static int errors;
    private static StdOutWriter out;

    public static void setGUIMode(TextArea textArea) {
        out.setGUIMode(textArea);
    }

    public static void setOutputStream(OutputStream outputStream) {
        out = new StdOutWriter(outputStream);
        out.setGUIMode(null);
    }

    public static void time(ErrorMessages errorMessages, Timer timer) {
        if (Options.time) {
            String string = ErrorMessages.get(errorMessages, timer.toString());
            out.println(string);
        }
    }

    public static void time(String string) {
        if (Options.time) {
            out.println(string);
        }
    }

    public static void println(String string) {
        if (Options.verbose) {
            out.println(string);
        }
    }

    public static void println(ErrorMessages errorMessages, String string) {
        if (Options.verbose) {
            out.println(ErrorMessages.get(errorMessages, string));
        }
    }

    public static void println(ErrorMessages errorMessages, int n) {
        if (Options.verbose) {
            out.println(ErrorMessages.get(errorMessages, n));
        }
    }

    public static void print(String string) {
        if (Options.verbose) {
            out.print(string);
        }
    }

    public static void debug(String string) {
    }

    public static void dump(String string) {
        if (Options.dump) {
            out.println(string);
        }
    }

    private static void err(String string) {
        out.println(string);
    }

    public static void checkErrors() {
        if (errors > 0) {
            throw new GeneratorException();
        }
    }

    public static void statistics() {
        StringBuffer stringBuffer = new StringBuffer(errors + " error");
        if (errors != 1) {
            stringBuffer.append("s");
        }
        stringBuffer.append(", " + warnings + " warning");
        if (warnings != 1) {
            stringBuffer.append("s");
        }
        stringBuffer.append(".");
        Out.err(stringBuffer.toString());
    }

    public static void resetCounters() {
        errors = 0;
        warnings = 0;
    }

    public static void warning(String string) {
        ++warnings;
        Out.err(NL + "Warning : " + string);
    }

    public static void warning(ErrorMessages errorMessages, int n) {
        ++warnings;
        String string = NL + "Warning";
        if (n > 0) {
            string = string + " in line " + (n + 1);
        }
        Out.err(string + ": " + ErrorMessages.get(errorMessages));
    }

    public static void warning(File file, ErrorMessages errorMessages, int n, int n2) {
        String string = NL + "Warning";
        if (file != null) {
            string = string + " in file \"" + file + "\"";
        }
        if (n >= 0) {
            string = string + " (line " + (n + 1) + ")";
        }
        try {
            Out.err(string + ": " + NL + ErrorMessages.get(errorMessages));
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            Out.err(string);
        }
        ++warnings;
        if (n >= 0) {
            if (n2 >= 0) {
                Out.showPosition(file, n, n2);
            } else {
                Out.showPosition(file, n);
            }
        }
    }

    public static void error(String string) {
        ++errors;
        Out.err(NL + string);
    }

    public static void error(ErrorMessages errorMessages) {
        ++errors;
        Out.err(NL + "Error: " + ErrorMessages.get(errorMessages));
    }

    public static void error(ErrorMessages errorMessages, String string) {
        ++errors;
        Out.err(NL + "Error: " + ErrorMessages.get(errorMessages, string));
    }

    public static void error(ErrorMessages errorMessages, File file) {
        ++errors;
        Out.err(NL + "Error: " + ErrorMessages.get(errorMessages) + " (" + file + ")");
    }

    public static void error(File file, ErrorMessages errorMessages, int n, int n2) {
        String string = NL + "Error";
        if (file != null) {
            string = string + " in file \"" + file + "\"";
        }
        if (n >= 0) {
            string = string + " (line " + (n + 1) + ")";
        }
        try {
            Out.err(string + ": " + NL + ErrorMessages.get(errorMessages));
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            Out.err(string);
        }
        ++errors;
        if (n >= 0) {
            if (n2 >= 0) {
                Out.showPosition(file, n, n2);
            } else {
                Out.showPosition(file, n);
            }
        }
    }

    public static void showPosition(File file, int n, int n2) {
        try {
            String string = Out.getLine(file, n);
            if (string != null) {
                Out.err(string);
                if (n2 < 0) {
                    return;
                }
                String string2 = "^";
                for (int i = 0; i < n2; ++i) {
                    string2 = " " + string2;
                }
                Out.err(string2);
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public static void showPosition(File file, int n) {
        try {
            String string = Out.getLine(file, n);
            if (string != null) {
                Out.err(string);
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    private static String getLine(File file, int n) throws IOException {
        BufferedReader bufferedReader = new BufferedReader(new FileReader(file));
        String string = "";
        for (int i = 0; i <= n; ++i) {
            string = bufferedReader.readLine();
        }
        bufferedReader.close();
        return string;
    }

    public static void printSystemInfo() {
        Out.err("Java version:  " + System.getProperty("java.version"));
        Out.err("Runtime name:  " + System.getProperty("java.runtime.name"));
        Out.err("Vendor:        " + System.getProperty("java.vendor"));
        Out.err("VM version:    " + System.getProperty("java.vm.version"));
        Out.err("VM vendor:     " + System.getProperty("java.vm.vendor"));
        Out.err("VM name:       " + System.getProperty("java.vm.name"));
        Out.err("VM info:       " + System.getProperty("java.vm.info"));
        Out.err("OS name:       " + System.getProperty("os.name"));
        Out.err("OS arch:       " + System.getProperty("os.arch"));
        Out.err("OS version:    " + System.getProperty("os.version"));
        Out.err("Encoding:      " + System.getProperty("file.encoding"));
        Out.err("JFlex version: 1.4.1");
    }

    public static void requestBugReport(Error error) {
        Out.err("An unexpected error occurred. Please send a report of this to");
        Out.err("<bugs@jflex.de> and include the following information:");
        Out.err("");
        Out.printSystemInfo();
        Out.err("Exception:");
        error.printStackTrace(out);
        Out.err("");
        Out.err("Please also include a specification (as small as possible)");
        Out.err("that triggers this error. You may also want to check at");
        Out.err("http://www.jflex.de if there is a newer version available");
        Out.err("that doesn't have this problem");
        Out.err("");
        Out.err("Thanks for your support.");
    }

    static {
        out = new StdOutWriter();
    }
}

