/*
 * Decompiled with CFR 0.152.
 */
package weka.filters.unsupervised.attribute;

import weka.core.Capabilities;
import weka.core.Instance;
import weka.core.Instances;
import weka.core.RevisionUtils;
import weka.core.SparseInstance;
import weka.core.Utils;
import weka.filters.Sourcable;
import weka.filters.UnsupervisedFilter;
import weka.filters.unsupervised.attribute.PotentialClassIgnorer;

public class Center
extends PotentialClassIgnorer
implements UnsupervisedFilter,
Sourcable {
    private static final long serialVersionUID = -9101338448900581023L;
    private double[] m_Means;

    public String globalInfo() {
        return "Centers all numeric attributes in the given dataset to have zero mean (apart from the class attribute, if set).";
    }

    public Capabilities getCapabilities() {
        Capabilities capabilities = super.getCapabilities();
        capabilities.enableAllAttributes();
        capabilities.enable(Capabilities.Capability.MISSING_VALUES);
        capabilities.enableAllClasses();
        capabilities.enable(Capabilities.Capability.MISSING_CLASS_VALUES);
        capabilities.enable(Capabilities.Capability.NO_CLASS);
        return capabilities;
    }

    public boolean setInputFormat(Instances instances) throws Exception {
        super.setInputFormat(instances);
        this.setOutputFormat(instances);
        this.m_Means = null;
        return true;
    }

    public boolean input(Instance instance) {
        if (this.getInputFormat() == null) {
            throw new IllegalStateException("No input instance format defined");
        }
        if (this.m_NewBatch) {
            this.resetQueue();
            this.m_NewBatch = false;
        }
        if (this.m_Means == null) {
            this.bufferInput(instance);
            return false;
        }
        this.convertInstance(instance);
        return true;
    }

    public boolean batchFinished() {
        if (this.getInputFormat() == null) {
            throw new IllegalStateException("No input instance format defined");
        }
        if (this.m_Means == null) {
            int n;
            Instances instances = this.getInputFormat();
            this.m_Means = new double[instances.numAttributes()];
            for (n = 0; n < instances.numAttributes(); ++n) {
                if (!instances.attribute(n).isNumeric() || instances.classIndex() == n) continue;
                this.m_Means[n] = instances.meanOrMode(n);
            }
            for (n = 0; n < instances.numInstances(); ++n) {
                this.convertInstance(instances.instance(n));
            }
        }
        this.flushInput();
        this.m_NewBatch = true;
        return this.numPendingOutput() != 0;
    }

    private void convertInstance(Instance instance) {
        Instance instance2 = null;
        if (instance instanceof SparseInstance) {
            double[] dArray = new double[instance.numAttributes()];
            int[] nArray = new int[instance.numAttributes()];
            double[] dArray2 = instance.toDoubleArray();
            int n = 0;
            for (int i = 0; i < instance.numAttributes(); ++i) {
                double d;
                if (instance.attribute(i).isNumeric() && !Instance.isMissingValue(dArray2[i]) && this.getInputFormat().classIndex() != i) {
                    d = dArray2[i] - this.m_Means[i];
                    if (d == 0.0) continue;
                    dArray[n] = d;
                    nArray[n] = i;
                    ++n;
                    continue;
                }
                d = dArray2[i];
                if (d == 0.0) continue;
                dArray[n] = d;
                nArray[n] = i;
                ++n;
            }
            double[] dArray3 = new double[n];
            int[] nArray2 = new int[n];
            System.arraycopy(dArray, 0, dArray3, 0, n);
            System.arraycopy(nArray, 0, nArray2, 0, n);
            instance2 = new SparseInstance(instance.weight(), dArray3, nArray2, instance.numAttributes());
        } else {
            double[] dArray = instance.toDoubleArray();
            for (int i = 0; i < this.getInputFormat().numAttributes(); ++i) {
                if (!instance.attribute(i).isNumeric() || Instance.isMissingValue(dArray[i]) || this.getInputFormat().classIndex() == i) continue;
                dArray[i] = dArray[i] - this.m_Means[i];
            }
            instance2 = new Instance(instance.weight(), dArray);
        }
        instance2.setDataset(instance.dataset());
        this.push(instance2);
    }

    public String toSource(String string, Instances instances) throws Exception {
        StringBuffer stringBuffer = new StringBuffer();
        boolean[] blArray = new boolean[instances.numAttributes()];
        for (int i = 0; i < instances.numAttributes(); ++i) {
            blArray[i] = instances.attribute(i).isNumeric() && i != instances.classIndex();
        }
        stringBuffer.append("class " + string + " {\n");
        stringBuffer.append("\n");
        stringBuffer.append("  /** lists which attributes will be processed */\n");
        stringBuffer.append("  protected final static boolean[] PROCESS = new boolean[]{" + Utils.arrayToString(blArray) + "};\n");
        stringBuffer.append("\n");
        stringBuffer.append("  /** the computed means */\n");
        stringBuffer.append("  protected final static double[] MEANS = new double[]{" + Utils.arrayToString(this.m_Means) + "};\n");
        stringBuffer.append("\n");
        stringBuffer.append("  /**\n");
        stringBuffer.append("   * filters a single row\n");
        stringBuffer.append("   * \n");
        stringBuffer.append("   * @param i the row to process\n");
        stringBuffer.append("   * @return the processed row\n");
        stringBuffer.append("   */\n");
        stringBuffer.append("  public static Object[] filter(Object[] i) {\n");
        stringBuffer.append("    Object[] result;\n");
        stringBuffer.append("\n");
        stringBuffer.append("    result = new Object[i.length];\n");
        stringBuffer.append("    for (int n = 0; n < i.length; n++) {\n");
        stringBuffer.append("      if (PROCESS[n] && (i[n] != null))\n");
        stringBuffer.append("        result[n] = ((Double) i[n]) - MEANS[n];\n");
        stringBuffer.append("      else\n");
        stringBuffer.append("        result[n] = i[n];\n");
        stringBuffer.append("    }\n");
        stringBuffer.append("\n");
        stringBuffer.append("    return result;\n");
        stringBuffer.append("  }\n");
        stringBuffer.append("\n");
        stringBuffer.append("  /**\n");
        stringBuffer.append("   * filters multiple rows\n");
        stringBuffer.append("   * \n");
        stringBuffer.append("   * @param i the rows to process\n");
        stringBuffer.append("   * @return the processed rows\n");
        stringBuffer.append("   */\n");
        stringBuffer.append("  public static Object[][] filter(Object[][] i) {\n");
        stringBuffer.append("    Object[][] result;\n");
        stringBuffer.append("\n");
        stringBuffer.append("    result = new Object[i.length][];\n");
        stringBuffer.append("    for (int n = 0; n < i.length; n++) {\n");
        stringBuffer.append("      result[n] = filter(i[n]);\n");
        stringBuffer.append("    }\n");
        stringBuffer.append("\n");
        stringBuffer.append("    return result;\n");
        stringBuffer.append("  }\n");
        stringBuffer.append("}\n");
        return stringBuffer.toString();
    }

    public String getRevision() {
        return RevisionUtils.extract("$Revision: 1.5 $");
    }

    public static void main(String[] stringArray) {
        Center.runFilter(new Center(), stringArray);
    }
}

