/*
 * Decompiled with CFR 0.152.
 */
package weka.filters.unsupervised.attribute;

import java.util.Enumeration;
import java.util.Random;
import java.util.Vector;
import weka.core.Attribute;
import weka.core.Capabilities;
import weka.core.FastVector;
import weka.core.Instance;
import weka.core.Instances;
import weka.core.Option;
import weka.core.OptionHandler;
import weka.core.RevisionUtils;
import weka.core.SelectedTag;
import weka.core.Tag;
import weka.core.TechnicalInformation;
import weka.core.TechnicalInformationHandler;
import weka.core.Utils;
import weka.filters.Filter;
import weka.filters.UnsupervisedFilter;
import weka.filters.unsupervised.attribute.NominalToBinary;
import weka.filters.unsupervised.attribute.ReplaceMissingValues;

public class RandomProjection
extends Filter
implements UnsupervisedFilter,
OptionHandler,
TechnicalInformationHandler {
    static final long serialVersionUID = 4428905532728645880L;
    protected int m_k = 10;
    protected double m_percent = 0.0;
    protected boolean m_useGaussian = false;
    public static final int SPARSE1 = 1;
    public static final int SPARSE2 = 2;
    public static final int GAUSSIAN = 3;
    public static final Tag[] TAGS_DSTRS_TYPE = new Tag[]{new Tag(1, "Sparse 1"), new Tag(2, "Sparse 2"), new Tag(3, "Gaussian")};
    protected int m_distribution = 1;
    protected boolean m_useReplaceMissing = false;
    protected boolean m_OutputFormatDefined = false;
    protected Filter m_ntob;
    protected Filter m_replaceMissing;
    protected long m_rndmSeed = 42L;
    protected double[][] m_rmatrix;
    protected Random m_random;
    private static final int[] weights = new int[]{1, 1, 4};
    private static final int[] vals = new int[]{-1, 1, 0};
    private static final int[] weights2 = new int[]{1, 1};
    private static final int[] vals2 = new int[]{-1, 1};
    private static final double sqrt3 = Math.sqrt(3.0);

    public Enumeration listOptions() {
        Vector<Option> vector = new Vector<Option>(2);
        vector.addElement(new Option("\tThe number of dimensions (attributes) the data should be reduced to\n\t(default 10; exclusive of the class attribute, if it is set).", "N", 1, "-N <number>"));
        vector.addElement(new Option("\tThe distribution to use for calculating the random matrix.\n\tSparse1 is:\n\t  sqrt(3)*{-1 with prob(1/6), 0 with prob(2/3), +1 with prob(1/6)}\n\tSparse2 is:\n\t  {-1 with prob(1/2), +1 with prob(1/2)}\n", "D", 1, "-D [SPARSE1|SPARSE2|GAUSSIAN]"));
        vector.addElement(new Option("\tThe percentage of dimensions (attributes) the data should\n\tbe reduced to (exclusive of the class attribute, if it is set). This -N\n\toption is ignored if this option is present or is greater\n\tthan zero.", "P", 1, "-P <percent>"));
        vector.addElement(new Option("\tReplace missing values using the ReplaceMissingValues filter", "M", 0, "-M"));
        vector.addElement(new Option("\tThe random seed for the random number generator used for\n\tcalculating the random matrix (default 42).", "R", 0, "-R <num>"));
        return vector.elements();
    }

    public void setOptions(String[] stringArray) throws Exception {
        String string = Utils.getOption('P', stringArray);
        if (string.length() != 0) {
            this.setPercent(Double.parseDouble(string));
        } else {
            this.setPercent(0.0);
            string = Utils.getOption('N', stringArray);
            if (string.length() != 0) {
                this.setNumberOfAttributes(Integer.parseInt(string));
            } else {
                this.setNumberOfAttributes(10);
            }
        }
        string = Utils.getOption('R', stringArray);
        if (string.length() != 0) {
            this.setRandomSeed(Long.parseLong(string));
        }
        if ((string = Utils.getOption('D', stringArray)).length() != 0) {
            if (string.equalsIgnoreCase("sparse1")) {
                this.setDistribution(new SelectedTag(1, TAGS_DSTRS_TYPE));
            } else if (string.equalsIgnoreCase("sparse2")) {
                this.setDistribution(new SelectedTag(2, TAGS_DSTRS_TYPE));
            } else if (string.equalsIgnoreCase("gaussian")) {
                this.setDistribution(new SelectedTag(3, TAGS_DSTRS_TYPE));
            }
        }
        if (Utils.getFlag('M', stringArray)) {
            this.setReplaceMissingValues(true);
        } else {
            this.setReplaceMissingValues(false);
        }
    }

    public String[] getOptions() {
        String[] stringArray = new String[10];
        int n = 0;
        if (this.getReplaceMissingValues()) {
            stringArray[n++] = "-M";
        }
        if (this.getPercent() == 0.0) {
            stringArray[n++] = "-N";
            stringArray[n++] = "" + this.getNumberOfAttributes();
        } else {
            stringArray[n++] = "-P";
            stringArray[n++] = "" + this.getPercent();
        }
        stringArray[n++] = "-R";
        stringArray[n++] = "" + this.getRandomSeed();
        SelectedTag selectedTag = this.getDistribution();
        stringArray[n++] = "-D";
        stringArray[n++] = "" + selectedTag.getSelectedTag().getReadable();
        while (n < stringArray.length) {
            stringArray[n++] = "";
        }
        return stringArray;
    }

    public String globalInfo() {
        return "Reduces the dimensionality of the data by projecting it onto a lower dimensional subspace using a random matrix with columns of unit length (i.e. It will reduce the number of attributes in the data while preserving much of its variation like PCA, but at a much less computational cost).\nIt first applies the  NominalToBinary filter to convert all attributes to numeric before reducing the dimension. It preserves the class attribute.\n\nFor more information, see:\n\n" + this.getTechnicalInformation().toString();
    }

    public TechnicalInformation getTechnicalInformation() {
        TechnicalInformation technicalInformation = new TechnicalInformation(TechnicalInformation.Type.INPROCEEDINGS);
        technicalInformation.setValue(TechnicalInformation.Field.AUTHOR, "Dmitriy Fradkin and David Madigan");
        technicalInformation.setValue(TechnicalInformation.Field.TITLE, "Experiments with random projections for machine learning");
        technicalInformation.setValue(TechnicalInformation.Field.BOOKTITLE, "KDD '03: Proceedings of the ninth ACM SIGKDD international conference on Knowledge discovery and data mining");
        technicalInformation.setValue(TechnicalInformation.Field.YEAR, "003");
        technicalInformation.setValue(TechnicalInformation.Field.PAGES, "517-522");
        technicalInformation.setValue(TechnicalInformation.Field.PUBLISHER, "ACM Press");
        technicalInformation.setValue(TechnicalInformation.Field.ADDRESS, "New York, NY, USA");
        return technicalInformation;
    }

    public String numberOfAttributesTipText() {
        return "The number of dimensions (attributes) the data should be reduced to.";
    }

    public void setNumberOfAttributes(int n) {
        this.m_k = n;
    }

    public int getNumberOfAttributes() {
        return this.m_k;
    }

    public String percentTipText() {
        return " The percentage of dimensions (attributes) the data should be reduced to  (inclusive of the class attribute). This  NumberOfAttributes option is ignored if this option is present or is greater than zero.";
    }

    public void setPercent(double d) {
        if (d > 0.0) {
            d /= 100.0;
        }
        this.m_percent = d;
    }

    public double getPercent() {
        return this.m_percent * 100.0;
    }

    public String randomSeedTipText() {
        return "The random seed used by the random number generator used for generating the random matrix ";
    }

    public void setRandomSeed(long l) {
        this.m_rndmSeed = l;
    }

    public long getRandomSeed() {
        return this.m_rndmSeed;
    }

    public String distributionTipText() {
        return "The distribution to use for calculating the random matrix.\nSparse1 is:\n sqrt(3) * { -1 with prob(1/6), \n               0 with prob(2/3),  \n              +1 with prob(1/6) } \nSparse2 is:\n { -1 with prob(1/2), \n   +1 with prob(1/2) } ";
    }

    public void setDistribution(SelectedTag selectedTag) {
        if (selectedTag.getTags() == TAGS_DSTRS_TYPE) {
            this.m_distribution = selectedTag.getSelectedTag().getID();
        }
    }

    public SelectedTag getDistribution() {
        return new SelectedTag(this.m_distribution, TAGS_DSTRS_TYPE);
    }

    public String replaceMissingValuesTipText() {
        return "If set the filter uses weka.filters.unsupervised.attribute.ReplaceMissingValues to replace the missing values";
    }

    public void setReplaceMissingValues(boolean bl) {
        this.m_useReplaceMissing = bl;
    }

    public boolean getReplaceMissingValues() {
        return this.m_useReplaceMissing;
    }

    public Capabilities getCapabilities() {
        Capabilities capabilities = super.getCapabilities();
        capabilities.enableAllAttributes();
        capabilities.enable(Capabilities.Capability.MISSING_VALUES);
        capabilities.enableAllClasses();
        capabilities.enable(Capabilities.Capability.MISSING_CLASS_VALUES);
        capabilities.enable(Capabilities.Capability.NO_CLASS);
        return capabilities;
    }

    public boolean setInputFormat(Instances instances) throws Exception {
        int n;
        super.setInputFormat(instances);
        for (n = 0; n < instances.numAttributes(); ++n) {
            if (n == instances.classIndex() || !instances.attribute(n).isNominal()) continue;
            if (instances.classIndex() >= 0) {
                this.m_ntob = new weka.filters.supervised.attribute.NominalToBinary();
                break;
            }
            this.m_ntob = new NominalToBinary();
            break;
        }
        n = 1;
        if (this.m_replaceMissing != null) {
            this.m_replaceMissing = new ReplaceMissingValues();
            n = this.m_replaceMissing.setInputFormat(instances) ? 1 : 0;
        }
        if (this.m_ntob != null) {
            if (this.m_ntob.setInputFormat(instances)) {
                this.setOutputFormat();
                return n != 0;
            }
            return false;
        }
        this.setOutputFormat();
        return n != 0;
    }

    public boolean input(Instance instance) throws Exception {
        Instance instance2 = null;
        if (this.getInputFormat() == null) {
            throw new IllegalStateException("No input instance format defined");
        }
        if (this.m_NewBatch) {
            this.resetQueue();
            this.m_NewBatch = false;
        }
        boolean bl = false;
        if (this.m_replaceMissing != null) {
            if (this.m_replaceMissing.input(instance)) {
                if (!this.m_OutputFormatDefined) {
                    this.setOutputFormat();
                }
                instance2 = this.m_replaceMissing.output();
                bl = true;
            } else {
                return false;
            }
        }
        if (this.m_ntob != null) {
            if (!bl) {
                instance2 = instance;
            }
            if (this.m_ntob.input(instance2)) {
                if (!this.m_OutputFormatDefined) {
                    this.setOutputFormat();
                }
                instance2 = this.m_ntob.output();
                instance2 = this.convertInstance(instance2);
                this.push(instance2);
                return true;
            }
            return false;
        }
        if (!bl) {
            instance2 = instance;
        }
        instance2 = this.convertInstance(instance2);
        this.push(instance2);
        return true;
    }

    public boolean batchFinished() throws Exception {
        Instance instance;
        Instance instance2;
        if (this.getInputFormat() == null) {
            throw new NullPointerException("No input instance format defined");
        }
        boolean bl = false;
        if (this.m_replaceMissing != null && this.m_replaceMissing.batchFinished()) {
            while ((instance2 = this.m_replaceMissing.output()) != null) {
                if (!this.m_OutputFormatDefined) {
                    this.setOutputFormat();
                }
                if (this.m_ntob != null) {
                    this.m_ntob.input(instance2);
                    continue;
                }
                instance = this.convertInstance(instance2);
                this.push(instance);
            }
            if (this.m_ntob != null && this.m_ntob.batchFinished()) {
                while ((instance2 = this.m_ntob.output()) != null) {
                    if (!this.m_OutputFormatDefined) {
                        this.setOutputFormat();
                    }
                    instance = this.convertInstance(instance2);
                    this.push(instance);
                }
                this.m_ntob = null;
            }
            this.m_replaceMissing = null;
            bl = true;
        }
        if (!bl && this.m_ntob != null && this.m_ntob.batchFinished()) {
            while ((instance2 = this.m_ntob.output()) != null) {
                if (!this.m_OutputFormatDefined) {
                    this.setOutputFormat();
                }
                instance = this.convertInstance(instance2);
                this.push(instance);
            }
            this.m_ntob = null;
        }
        this.m_OutputFormatDefined = false;
        return super.batchFinished();
    }

    protected void setOutputFormat() {
        int n;
        Instances instances = this.m_ntob != null ? this.m_ntob.getOutputFormat() : this.getInputFormat();
        if (this.m_percent > 0.0) {
            this.m_k = (int)((double)(this.getInputFormat().numAttributes() - 1) * this.m_percent);
        }
        int n2 = -1;
        FastVector fastVector = new FastVector();
        for (n = 0; n < this.m_k; ++n) {
            fastVector.addElement(new Attribute("K" + (n + 1)));
        }
        if (instances.classIndex() != -1) {
            fastVector.addElement(instances.attribute(instances.classIndex()));
            n2 = fastVector.size() - 1;
        }
        Instances instances2 = new Instances(instances.relationName(), fastVector, 0);
        if (n2 != -1) {
            instances2.setClassIndex(n2);
        }
        this.m_OutputFormatDefined = true;
        this.m_random = new Random();
        this.m_random.setSeed(this.m_rndmSeed);
        this.m_rmatrix = new double[this.m_k][instances.numAttributes()];
        if (this.m_distribution == 3) {
            for (n = 0; n < this.m_rmatrix.length; ++n) {
                for (int i = 0; i < this.m_rmatrix[n].length; ++i) {
                    this.m_rmatrix[n][i] = this.m_random.nextGaussian();
                }
            }
        } else {
            n = this.m_distribution == 1 ? 1 : 0;
            for (int i = 0; i < this.m_rmatrix.length; ++i) {
                for (int j = 0; j < this.m_rmatrix[i].length; ++j) {
                    this.m_rmatrix[i][j] = this.rndmNum(n != 0);
                }
            }
        }
        this.setOutputFormat(instances2);
    }

    protected Instance convertInstance(Instance instance) {
        double[] dArray = new double[this.getOutputFormat().numAttributes()];
        int n = this.m_ntob == null ? this.getInputFormat().classIndex() : this.m_ntob.getOutputFormat().classIndex();
        for (int i = 0; i < this.m_k; ++i) {
            dArray[i] = this.computeRandomProjection(i, n, instance);
        }
        if (n != -1) {
            dArray[this.m_k] = instance.value(n);
        }
        Instance instance2 = new Instance(instance.weight(), dArray);
        instance2.setDataset(this.getOutputFormat());
        return instance2;
    }

    protected double computeRandomProjection(int n, int n2, Instance instance) {
        double d = 0.0;
        for (int i = 0; i < instance.numValues(); ++i) {
            double d2;
            int n3 = instance.index(i);
            if (n3 == n2 || Instance.isMissingValue(d2 = instance.valueSparse(i))) continue;
            d += this.m_rmatrix[n][n3] * d2;
        }
        return d;
    }

    protected double rndmNum(boolean bl) {
        if (bl) {
            return sqrt3 * (double)vals[this.weightedDistribution(weights)];
        }
        return vals2[this.weightedDistribution(weights2)];
    }

    protected int weightedDistribution(int[] nArray) {
        int n;
        int n2 = 0;
        for (n = 0; n < nArray.length; ++n) {
            n2 += nArray[n];
        }
        n = (int)Math.floor(this.m_random.nextDouble() * (double)n2);
        for (int i = 0; i < nArray.length; ++i) {
            if ((n -= nArray[i]) >= 0) continue;
            return i;
        }
        return -1;
    }

    public String getRevision() {
        return RevisionUtils.extract("$Revision: 1.11 $");
    }

    public static void main(String[] stringArray) {
        RandomProjection.runFilter(new RandomProjection(), stringArray);
    }
}

