/*
 * Decompiled with CFR 0.152.
 */
package weka.associations;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.PriorityQueue;
import java.util.Vector;
import weka.associations.AbstractAssociator;
import weka.associations.Associator;
import weka.core.Capabilities;
import weka.core.CapabilitiesHandler;
import weka.core.Drawable;
import weka.core.Instance;
import weka.core.Instances;
import weka.core.Option;
import weka.core.OptionHandler;
import weka.core.RevisionHandler;
import weka.core.RevisionUtils;
import weka.core.SingleIndex;
import weka.core.Utils;

public class HotSpot
implements Associator,
OptionHandler,
RevisionHandler,
CapabilitiesHandler,
Drawable,
Serializable {
    static final long serialVersionUID = 42972325096347677L;
    protected SingleIndex m_targetSI = new SingleIndex("last");
    protected int m_target;
    protected double m_support;
    private int m_supportCount;
    protected double m_globalTarget;
    protected double m_minImprovement;
    protected int m_globalSupport;
    protected SingleIndex m_targetIndexSI = new SingleIndex("first");
    protected int m_targetIndex;
    protected int m_maxBranchingFactor;
    protected int m_numInstances;
    protected HotNode m_head;
    protected Instances m_header;
    protected int m_lookups = 0;
    protected int m_insertions = 0;
    protected int m_hits = 0;
    protected boolean m_debug;
    protected boolean m_minimize;
    protected String m_errorMessage;
    protected HashMap<HotSpotHashKey, String> m_ruleLookup;

    public HotSpot() {
        this.resetOptions();
    }

    public String globalInfo() {
        return "HotSpot learns a set of rules (displayed in a tree-like structure) that maximize/minimize a target variable/value of interest. With a nominal target, one might want to look for segments of the data where there is a high probability of a minority value occuring (given the constraint of a minimum support). For a numeric target, one might be interested in finding segments where this is higher on average than in the whole data set. For example, in a health insurance scenario, find which health insurance groups are at the highest risk (have the highest claim ratio), or, which groups have the highest average insurance payout.";
    }

    public Capabilities getCapabilities() {
        Capabilities capabilities = new Capabilities(this);
        capabilities.enable(Capabilities.Capability.NOMINAL_ATTRIBUTES);
        capabilities.enable(Capabilities.Capability.NUMERIC_ATTRIBUTES);
        capabilities.enable(Capabilities.Capability.MISSING_VALUES);
        capabilities.enable(Capabilities.Capability.NUMERIC_CLASS);
        capabilities.enable(Capabilities.Capability.NOMINAL_CLASS);
        return capabilities;
    }

    public void buildAssociations(Instances instances) throws Exception {
        double[] dArray;
        this.m_errorMessage = null;
        this.m_targetSI.setUpper(instances.numAttributes() - 1);
        this.m_target = this.m_targetSI.getIndex();
        Instances instances2 = new Instances(instances);
        instances2.setClassIndex(this.m_target);
        instances2.deleteWithMissingClass();
        this.getCapabilities().testWithFail(instances2);
        if (instances2.attribute(this.m_target).isNominal()) {
            this.m_targetIndexSI.setUpper(instances2.attribute(this.m_target).numValues() - 1);
            this.m_targetIndex = this.m_targetIndexSI.getIndex();
        } else {
            this.m_targetIndexSI.setUpper(1);
        }
        if (this.m_support <= 0.0) {
            throw new Exception("Support must be greater than zero.");
        }
        this.m_numInstances = instances2.numInstances();
        if (this.m_support >= 1.0) {
            this.m_supportCount = (int)this.m_support;
            this.m_support /= (double)this.m_numInstances;
        }
        this.m_supportCount = (int)Math.floor(this.m_support * (double)this.m_numInstances + 0.5);
        if (this.m_supportCount < 1) {
            this.m_supportCount = 1;
        }
        this.m_header = new Instances(instances2, 0);
        if (instances2.attribute(this.m_target).isNumeric()) {
            if (this.m_supportCount > this.m_numInstances) {
                this.m_errorMessage = "Error: support set to more instances than there are in the data!";
                return;
            }
            this.m_globalTarget = instances2.meanOrMode(this.m_target);
        } else {
            dArray = new double[instances2.attributeStats((int)this.m_target).nominalCounts.length];
            for (int i = 0; i < dArray.length; ++i) {
                dArray[i] = instances2.attributeStats((int)this.m_target).nominalCounts[i];
            }
            this.m_globalSupport = (int)dArray[this.m_targetIndex];
            if (this.m_globalSupport < this.m_supportCount) {
                this.m_errorMessage = "Error: minimum support " + this.m_supportCount + " is too high. Target value " + this.m_header.attribute(this.m_target).value(this.m_targetIndex) + " has support " + this.m_globalSupport + ".";
            }
            Utils.normalize(dArray);
            this.m_globalTarget = dArray[this.m_targetIndex];
        }
        this.m_ruleLookup = new HashMap();
        dArray = new double[this.m_header.numAttributes()];
        byte[] byArray = new byte[this.m_header.numAttributes()];
        this.m_head = new HotNode(instances2, this.m_globalTarget, dArray, byArray);
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("\nHot Spot\n========");
        if (this.m_errorMessage != null) {
            stringBuffer.append("\n\n" + this.m_errorMessage + "\n\n");
            return stringBuffer.toString();
        }
        if (this.m_head == null) {
            stringBuffer.append("No model built!");
            return stringBuffer.toString();
        }
        stringBuffer.append("\nTotal population: ");
        stringBuffer.append("" + this.m_numInstances + " instances");
        stringBuffer.append("\nTarget attribute: " + this.m_header.attribute(this.m_target).name());
        if (this.m_header.attribute(this.m_target).isNominal()) {
            stringBuffer.append("\nTarget value: " + this.m_header.attribute(this.m_target).value(this.m_targetIndex));
            stringBuffer.append(" [value count in total population: " + this.m_globalSupport + " instances (" + Utils.doubleToString(this.m_globalTarget * 100.0, 2) + "%)]");
            stringBuffer.append("\nMinimum value count for segments: ");
        } else {
            stringBuffer.append("\nMinimum segment size: ");
        }
        stringBuffer.append("" + this.m_supportCount + " instances (" + Utils.doubleToString(this.m_support * 100.0, 2) + "% of total population)");
        stringBuffer.append("\nMaximum branching factor: " + this.m_maxBranchingFactor);
        stringBuffer.append("\nMinimum improvement in target: " + Utils.doubleToString(this.m_minImprovement * 100.0, 2) + "%");
        stringBuffer.append("\n\n");
        stringBuffer.append(this.m_header.attribute(this.m_target).name());
        if (this.m_header.attribute(this.m_target).isNumeric()) {
            stringBuffer.append(" (" + Utils.doubleToString(this.m_globalTarget, 4) + ")");
        } else {
            stringBuffer.append("=" + this.m_header.attribute(this.m_target).value(this.m_targetIndex) + " (");
            stringBuffer.append("" + Utils.doubleToString(this.m_globalTarget * 100.0, 2) + "% [");
            stringBuffer.append("" + this.m_globalSupport + "/" + this.m_numInstances + "])");
        }
        this.m_head.dumpTree(0, stringBuffer);
        stringBuffer.append("\n");
        if (this.m_debug) {
            stringBuffer.append("\n=== Duplicate rule lookup hashtable stats ===\n");
            stringBuffer.append("Insertions: " + this.m_insertions);
            stringBuffer.append("\nLookups : " + this.m_lookups);
            stringBuffer.append("\nHits: " + this.m_hits);
            stringBuffer.append("\n");
        }
        return stringBuffer.toString();
    }

    public String graph() throws Exception {
        System.err.println("Here");
        this.m_head.assignIDs(-1);
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("digraph HotSpot {\n");
        stringBuffer.append("rankdir=LR;\n");
        stringBuffer.append("N0 [label=\"" + this.m_header.attribute(this.m_target).name());
        if (this.m_header.attribute(this.m_target).isNumeric()) {
            stringBuffer.append("\\n(" + Utils.doubleToString(this.m_globalTarget, 4) + ")");
        } else {
            stringBuffer.append("=" + this.m_header.attribute(this.m_target).value(this.m_targetIndex) + "\\n(");
            stringBuffer.append("" + Utils.doubleToString(this.m_globalTarget * 100.0, 2) + "% [");
            stringBuffer.append("" + this.m_globalSupport + "/" + this.m_numInstances + "])");
        }
        stringBuffer.append("\" shape=plaintext]\n");
        this.m_head.graphHotSpot(stringBuffer);
        stringBuffer.append("}\n");
        return stringBuffer.toString();
    }

    public String targetTipText() {
        return "The target attribute of interest.";
    }

    public void setTarget(String string) {
        this.m_targetSI.setSingleIndex(string);
    }

    public String getTarget() {
        return this.m_targetSI.getSingleIndex();
    }

    public String targetIndexTipText() {
        return "The value of the target (nominal attributes only) of interest.";
    }

    public void setTargetIndex(String string) {
        this.m_targetIndexSI.setSingleIndex(string);
    }

    public String getTargetIndex() {
        return this.m_targetIndexSI.getSingleIndex();
    }

    public String minimizeTargetTipText() {
        return "Minimize rather than maximize the target.";
    }

    public void setMinimizeTarget(boolean bl) {
        this.m_minimize = bl;
    }

    public boolean getMinimizeTarget() {
        return this.m_minimize;
    }

    public String supportTipText() {
        return "The minimum support. Values between 0 and 1 are interpreted as a percentage of the total population; values > 1 are interpreted as an absolute number of instances";
    }

    public double getSupport() {
        return this.m_support;
    }

    public void setSupport(double d) {
        this.m_support = d;
    }

    public String maxBranchingFactorTipText() {
        return "Maximum branching factor. The maximum number of children to consider extending each node with.";
    }

    public void setMaxBranchingFactor(int n) {
        this.m_maxBranchingFactor = n;
    }

    public int getMaxBranchingFactor() {
        return this.m_maxBranchingFactor;
    }

    public String minImprovementTipText() {
        return "Minimum improvement in target value in order to consider adding a new branch/test";
    }

    public void setMinImprovement(double d) {
        this.m_minImprovement = d;
    }

    public double getMinImprovement() {
        return this.m_minImprovement;
    }

    public String debugTipText() {
        return "Output debugging info (duplicate rule lookup hash table stats).";
    }

    public void setDebug(boolean bl) {
        this.m_debug = bl;
    }

    public boolean getDebug() {
        return this.m_debug;
    }

    public Enumeration listOptions() {
        Vector<Option> vector = new Vector<Option>();
        vector.addElement(new Option("\tThe target index. (default = last)", "c", 1, "-c <num | first | last>"));
        vector.addElement(new Option("\tThe target value (nominal target only, default = first)", "V", 1, "-V <num | first | last>"));
        vector.addElement(new Option("\tMinimize rather than maximize.", "L", 0, "-L"));
        vector.addElement(new Option("\tMinimum value count (nominal target)/segment size (numeric target).\n\tValues between 0 and 1 are \n\tinterpreted as a percentage of \n\tthe total population; values > 1 are \n\tinterpreted as an absolute number of \n\tinstances (default = 0.3)", "-S", 1, "-S <num>"));
        vector.addElement(new Option("\tMaximum branching factor (default = 2)", "-M", 1, "-M <num>"));
        vector.addElement(new Option("\tMinimum improvement in target value in order \n\tto add a new branch/test (default = 0.01 (1%))", "-I", 1, "-I <num>"));
        vector.addElement(new Option("\tOutput debugging info (duplicate rule lookup \n\thash table stats)", "-D", 0, "-D"));
        return vector.elements();
    }

    public void resetOptions() {
        this.m_support = 0.33;
        this.m_minImprovement = 0.01;
        this.m_maxBranchingFactor = 2;
        this.m_minimize = false;
        this.m_debug = false;
        this.setTarget("last");
        this.setTargetIndex("first");
        this.m_errorMessage = null;
    }

    public void setOptions(String[] stringArray) throws Exception {
        this.resetOptions();
        String string = Utils.getOption('c', stringArray);
        if (string.length() != 0) {
            this.setTarget(string);
        }
        if ((string = Utils.getOption('V', stringArray)).length() != 0) {
            this.setTargetIndex(string);
        }
        this.setMinimizeTarget(Utils.getFlag('L', stringArray));
        string = Utils.getOption('S', stringArray);
        if (string.length() != 0) {
            this.setSupport(Double.parseDouble(string));
        }
        if ((string = Utils.getOption('M', stringArray)).length() != 0) {
            this.setMaxBranchingFactor(Integer.parseInt(string));
        }
        if ((string = Utils.getOption('I', stringArray)).length() != 0) {
            this.setMinImprovement(Double.parseDouble(string));
        }
        this.setDebug(Utils.getFlag('D', stringArray));
    }

    public String[] getOptions() {
        String[] stringArray = new String[12];
        int n = 0;
        stringArray[n++] = "-c";
        stringArray[n++] = this.getTarget();
        stringArray[n++] = "-V";
        stringArray[n++] = this.getTargetIndex();
        if (this.getMinimizeTarget()) {
            stringArray[n++] = "-L";
        }
        stringArray[n++] = "-S";
        stringArray[n++] = "" + this.getSupport();
        stringArray[n++] = "-M";
        stringArray[n++] = "" + this.getMaxBranchingFactor();
        stringArray[n++] = "-I";
        stringArray[n++] = "" + this.getMinImprovement();
        if (this.getDebug()) {
            stringArray[n++] = "-D";
        }
        while (n < stringArray.length) {
            stringArray[n++] = "";
        }
        return stringArray;
    }

    public String getRevision() {
        return RevisionUtils.extract("$Revision: 1.6 $");
    }

    public int graphType() {
        return 1;
    }

    public static void main(String[] stringArray) {
        try {
            HotSpot hotSpot = new HotSpot();
            AbstractAssociator.runAssociator(new HotSpot(), stringArray);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected class HotNode
    implements Serializable {
        protected Instances m_insts;
        protected double m_targetValue;
        protected HotNode[] m_children;
        protected HotTestDetails[] m_testDetails;
        public int m_id;

        public HotNode(Instances instances, double d, double[] dArray, byte[] byArray) {
            int n;
            this.m_insts = instances;
            this.m_targetValue = d;
            PriorityQueue<HotTestDetails> priorityQueue = new PriorityQueue<HotTestDetails>();
            for (n = 0; n < this.m_insts.numAttributes(); ++n) {
                if (n == HotSpot.this.m_target) continue;
                if (this.m_insts.attribute(n).isNominal()) {
                    this.evaluateNominal(n, priorityQueue);
                    continue;
                }
                this.evaluateNumeric(n, priorityQueue);
            }
            if (priorityQueue.size() > 0) {
                Object object;
                Serializable serializable;
                int n2;
                n = priorityQueue.size();
                ArrayList<HotTestDetails> arrayList = new ArrayList<HotTestDetails>();
                ArrayList<HotSpotHashKey> arrayList2 = new ArrayList<HotSpotHashKey>();
                for (n2 = 0; n2 < n && arrayList.size() < HotSpot.this.m_maxBranchingFactor; ++n2) {
                    serializable = priorityQueue.poll();
                    object = (double[])dArray.clone();
                    byte[] byArray2 = (byte[])byArray.clone();
                    object[serializable.m_splitAttIndex] = serializable.m_splitValue + 1.0;
                    byArray2[serializable.m_splitAttIndex] = HotSpot.this.m_header.attribute(serializable.m_splitAttIndex).isNominal() ? 2 : (serializable.m_lessThan ? 1 : 3);
                    HotSpotHashKey hotSpotHashKey = new HotSpotHashKey((double[])object, byArray2);
                    ++HotSpot.this.m_lookups;
                    if (!HotSpot.this.m_ruleLookup.containsKey(hotSpotHashKey)) {
                        HotSpot.this.m_ruleLookup.put(hotSpotHashKey, "");
                        arrayList.add((HotTestDetails)serializable);
                        arrayList2.add(hotSpotHashKey);
                        ++HotSpot.this.m_insertions;
                        continue;
                    }
                    ++HotSpot.this.m_hits;
                }
                this.m_children = new HotNode[arrayList.size() < HotSpot.this.m_maxBranchingFactor ? arrayList.size() : HotSpot.this.m_maxBranchingFactor];
                this.m_testDetails = new HotTestDetails[this.m_children.length];
                for (n2 = 0; n2 < this.m_children.length; ++n2) {
                    this.m_testDetails[n2] = (HotTestDetails)arrayList.get(n2);
                }
                priorityQueue = null;
                arrayList = null;
                this.m_insts = new Instances(this.m_insts, 0);
                for (n2 = 0; n2 < this.m_children.length; ++n2) {
                    serializable = this.subset(instances, this.m_testDetails[n2]);
                    object = (HotSpotHashKey)arrayList2.get(n2);
                    this.m_children[n2] = new HotNode((Instances)serializable, this.m_testDetails[n2].m_merit, object.m_splitValues, object.m_testTypes);
                }
            }
        }

        private Instances subset(Instances instances, HotTestDetails hotTestDetails) {
            Instances instances2 = new Instances(instances, instances.numInstances());
            for (int i = 0; i < instances.numInstances(); ++i) {
                Instance instance = instances.instance(i);
                if (instance.isMissing(hotTestDetails.m_splitAttIndex)) continue;
                if (instances.attribute(hotTestDetails.m_splitAttIndex).isNominal()) {
                    if (instance.value(hotTestDetails.m_splitAttIndex) != hotTestDetails.m_splitValue) continue;
                    instances2.add(instance);
                    continue;
                }
                if (hotTestDetails.m_lessThan) {
                    if (!(instance.value(hotTestDetails.m_splitAttIndex) <= hotTestDetails.m_splitValue)) continue;
                    instances2.add(instance);
                    continue;
                }
                if (!(instance.value(hotTestDetails.m_splitAttIndex) > hotTestDetails.m_splitValue)) continue;
                instances2.add(instance);
            }
            instances2.compactify();
            return instances2;
        }

        private void evaluateNumeric(int n, PriorityQueue<HotTestDetails> priorityQueue) {
            double d;
            Instances instances = this.m_insts;
            instances.sort(n);
            double d2 = 0.0;
            double d3 = 0.0;
            int n2 = 0;
            for (int i = instances.numInstances() - 1; i >= 0; --i) {
                if (!instances.instance(i).isMissing(n)) {
                    d3 += instances.attribute(HotSpot.this.m_target).isNumeric() ? instances.instance(i).value(HotSpot.this.m_target) : (double)(instances.instance(i).value(HotSpot.this.m_target) == (double)HotSpot.this.m_targetIndex ? 1 : 0);
                    continue;
                }
                ++n2;
            }
            if (instances.numInstances() - n2 <= HotSpot.this.m_supportCount) {
                return;
            }
            double d4 = 0.0;
            double d5 = 0.0;
            double d6 = 0.0;
            double d7 = 0.0;
            boolean bl = true;
            double d8 = 0.0;
            double d9 = instances.numInstances() - n2;
            for (int i = 0; i < instances.numInstances() - n2; ++i) {
                double d10;
                Instance instance = instances.instance(i);
                if (instances.attribute(HotSpot.this.m_target).isNumeric()) {
                    d2 += instance.value(HotSpot.this.m_target);
                    d3 -= instance.value(HotSpot.this.m_target);
                } else if ((int)instance.value(HotSpot.this.m_target) == HotSpot.this.m_targetIndex) {
                    d2 += 1.0;
                    d3 -= 1.0;
                }
                d8 += 1.0;
                d9 -= 1.0;
                if (i < instances.numInstances() - 1 && instance.value(n) == instances.instance(i + 1).value(n)) continue;
                if (instances.attribute(HotSpot.this.m_target).isNominal()) {
                    if (d2 >= (double)HotSpot.this.m_supportCount) {
                        double d11 = d10 = HotSpot.this.m_minimize ? d4 - d2 / d8 : d2 / d8 - d4;
                        if (d10 > 0.0) {
                            d4 = d2 / d8;
                            d5 = instance.value(n);
                            d6 = d2;
                            d7 = d8;
                            bl = true;
                        } else if (d10 == 0.0 && d2 > d6) {
                            d4 = d2 / d8;
                            d5 = instance.value(n);
                            d6 = d2;
                            d7 = d8;
                            bl = true;
                        }
                    }
                    if (!(d3 >= (double)HotSpot.this.m_supportCount)) continue;
                    double d12 = d10 = HotSpot.this.m_minimize ? d4 - d3 / d9 : d3 / d9 - d4;
                    if (d10 > 0.0) {
                        d4 = d3 / d9;
                        d5 = instance.value(n);
                        d6 = d3;
                        d7 = d9;
                        bl = false;
                        continue;
                    }
                    if (d10 != 0.0 || !(d3 > d6)) continue;
                    d4 = d3 / d9;
                    d5 = instance.value(n);
                    d6 = d3;
                    d7 = d9;
                    bl = false;
                    continue;
                }
                if (d8 >= (double)HotSpot.this.m_supportCount) {
                    double d13 = d10 = HotSpot.this.m_minimize ? d4 - d2 / d8 : d2 / d8 - d4;
                    if (d10 > 0.0) {
                        d4 = d2 / d8;
                        d5 = instance.value(n);
                        d6 = d8;
                        d7 = d8;
                        bl = true;
                    } else if (d10 == 0.0 && d8 > d6) {
                        d4 = d2 / d8;
                        d5 = instance.value(n);
                        d6 = d8;
                        d7 = d8;
                        bl = true;
                    }
                }
                if (!(d9 >= (double)HotSpot.this.m_supportCount)) continue;
                double d14 = d10 = HotSpot.this.m_minimize ? d4 - d3 / d9 : d3 / d9 - d4;
                if (d10 > 0.0) {
                    d4 = d3 / d9;
                    d5 = instance.value(n);
                    d6 = d9;
                    d7 = d9;
                    bl = false;
                    continue;
                }
                if (d10 != 0.0 || !(d9 > d6)) continue;
                d4 = d3 / d9;
                d5 = instance.value(n);
                d6 = d9;
                d7 = d9;
                bl = false;
            }
            double d15 = d = HotSpot.this.m_minimize ? this.m_targetValue - d4 : d4 - this.m_targetValue;
            if (d6 > 0.0 && d / this.m_targetValue >= HotSpot.this.m_minImprovement) {
                HotTestDetails hotTestDetails = new HotTestDetails(n, d5, bl, (int)d6, (int)d7, d4);
                priorityQueue.add(hotTestDetails);
            }
        }

        private void evaluateNominal(int n, PriorityQueue<HotTestDetails> priorityQueue) {
            int[] nArray = this.m_insts.attributeStats((int)n).nominalCounts;
            boolean bl = false;
            for (int i = 0; i < this.m_insts.attribute(n).numValues(); ++i) {
                if (nArray[i] < HotSpot.this.m_supportCount) continue;
                bl = true;
                break;
            }
            if (bl) {
                int n2;
                double[] dArray = new double[this.m_insts.attribute(n).numValues()];
                for (n2 = 0; n2 < this.m_insts.numInstances(); ++n2) {
                    Instance instance = this.m_insts.instance(n2);
                    if (instance.isMissing(n)) continue;
                    int n3 = (int)instance.value(n);
                    if (this.m_insts.attribute(HotSpot.this.m_target).isNumeric()) {
                        int n4 = n3;
                        dArray[n4] = dArray[n4] + instance.value(HotSpot.this.m_target);
                        continue;
                    }
                    int n5 = n3;
                    dArray[n5] = dArray[n5] + ((int)instance.value(HotSpot.this.m_target) == HotSpot.this.m_targetIndex ? 1.0 : 0.0);
                }
                for (n2 = 0; n2 < this.m_insts.attribute(n).numValues(); ++n2) {
                    double d;
                    if (nArray[n2] < HotSpot.this.m_supportCount || this.m_insts.attribute(HotSpot.this.m_target).isNominal() && !(dArray[n2] >= (double)HotSpot.this.m_supportCount)) continue;
                    double d2 = dArray[n2] / (double)nArray[n2];
                    double d3 = d = HotSpot.this.m_minimize ? this.m_targetValue - d2 : d2 - this.m_targetValue;
                    if (!(d / this.m_targetValue >= HotSpot.this.m_minImprovement)) continue;
                    double d4 = this.m_insts.attribute(HotSpot.this.m_target).isNominal() ? dArray[n2] : (double)nArray[n2];
                    HotTestDetails hotTestDetails = new HotTestDetails(n, n2, false, (int)d4, nArray[n2], d2);
                    priorityQueue.add(hotTestDetails);
                }
            }
        }

        public int assignIDs(int n) {
            int n2;
            this.m_id = n2 = n + 1;
            if (this.m_children != null) {
                for (int i = 0; i < this.m_children.length; ++i) {
                    n2 = this.m_children[i].assignIDs(n2);
                }
            }
            return n2;
        }

        private void addNodeDetails(StringBuffer stringBuffer, int n, String string) {
            stringBuffer.append(HotSpot.this.m_header.attribute(this.m_testDetails[n].m_splitAttIndex).name());
            if (HotSpot.this.m_header.attribute(this.m_testDetails[n].m_splitAttIndex).isNumeric()) {
                if (this.m_testDetails[n].m_lessThan) {
                    stringBuffer.append(" <= ");
                } else {
                    stringBuffer.append(" > ");
                }
                stringBuffer.append(Utils.doubleToString(this.m_testDetails[n].m_splitValue, 4));
            } else {
                stringBuffer.append(" = " + HotSpot.this.m_header.attribute(this.m_testDetails[n].m_splitAttIndex).value((int)this.m_testDetails[n].m_splitValue));
            }
            if (HotSpot.this.m_header.attribute(HotSpot.this.m_target).isNumeric()) {
                stringBuffer.append(string + "(" + Utils.doubleToString(this.m_testDetails[n].m_merit, 4) + " [" + this.m_testDetails[n].m_support + "])");
            } else {
                stringBuffer.append(string + "(" + Utils.doubleToString(this.m_testDetails[n].m_merit * 100.0, 2) + "% [" + this.m_testDetails[n].m_support + "/" + this.m_testDetails[n].m_subsetSize + "])");
            }
        }

        private void graphHotSpot(StringBuffer stringBuffer) {
            if (this.m_children != null) {
                for (int i = 0; i < this.m_children.length; ++i) {
                    stringBuffer.append("N" + this.m_children[i].m_id);
                    stringBuffer.append(" [label=\"");
                    this.addNodeDetails(stringBuffer, i, "\\n");
                    stringBuffer.append("\" shape=plaintext]\n");
                    this.m_children[i].graphHotSpot(stringBuffer);
                    stringBuffer.append("N" + this.m_id + "->" + "N" + this.m_children[i].m_id + "\n");
                }
            }
        }

        protected void dumpTree(int n, StringBuffer stringBuffer) {
            if (this.m_children != null) {
                for (int i = 0; i < this.m_children.length; ++i) {
                    stringBuffer.append("\n  ");
                    for (int j = 0; j < n; ++j) {
                        stringBuffer.append("|   ");
                    }
                    this.addNodeDetails(stringBuffer, i, " ");
                    this.m_children[i].dumpTree(n + 1, stringBuffer);
                }
            }
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        protected class HotTestDetails
        implements Comparable<HotTestDetails>,
        Serializable {
            public double m_merit;
            public int m_support;
            public int m_subsetSize;
            public int m_splitAttIndex;
            public double m_splitValue;
            public boolean m_lessThan;

            public HotTestDetails(int n, double d, boolean bl, int n2, int n3, double d2) {
                this.m_merit = d2;
                this.m_splitAttIndex = n;
                this.m_splitValue = d;
                this.m_lessThan = bl;
                this.m_support = n2;
                this.m_subsetSize = n3;
            }

            @Override
            public int compareTo(HotTestDetails hotTestDetails) {
                int n = 0;
                if (HotSpot.this.m_minimize) {
                    if (this.m_merit == hotTestDetails.m_merit) {
                        if (this.m_support != hotTestDetails.m_support) {
                            n = this.m_support > hotTestDetails.m_support ? -1 : 1;
                        }
                    } else {
                        n = this.m_merit < hotTestDetails.m_merit ? -1 : 1;
                    }
                } else if (this.m_merit == hotTestDetails.m_merit) {
                    if (this.m_support != hotTestDetails.m_support) {
                        n = this.m_support > hotTestDetails.m_support ? -1 : 1;
                    }
                } else {
                    n = this.m_merit < hotTestDetails.m_merit ? 1 : -1;
                }
                return n;
            }
        }
    }

    protected class HotSpotHashKey {
        protected double[] m_splitValues;
        protected byte[] m_testTypes;
        protected boolean m_computed = false;
        protected int m_key;

        public HotSpotHashKey(double[] dArray, byte[] byArray) {
            this.m_splitValues = (double[])dArray.clone();
            this.m_testTypes = (byte[])byArray.clone();
        }

        public boolean equals(Object object) {
            if (object == null || !object.getClass().equals(this.getClass())) {
                return false;
            }
            HotSpotHashKey hotSpotHashKey = (HotSpotHashKey)object;
            boolean bl = true;
            for (int i = 0; i < this.m_splitValues.length; ++i) {
                if (this.m_splitValues[i] == hotSpotHashKey.m_splitValues[i] && this.m_testTypes[i] == hotSpotHashKey.m_testTypes[i]) continue;
                bl = false;
                break;
            }
            return bl;
        }

        public int hashCode() {
            if (this.m_computed) {
                return this.m_key;
            }
            int n = 0;
            for (int i = 0; i < this.m_splitValues.length; ++i) {
                n = (int)((double)n + this.m_splitValues[i] * 5.0 * (double)i);
                n += this.m_testTypes[i] * i * 3;
            }
            this.m_computed = true;
            this.m_key = n;
            return this.m_key;
        }
    }
}

