/*
 * Decompiled with CFR 0.152.
 */
package weka.classifiers.functions.supportVector;

import java.io.File;
import java.io.FileReader;
import java.util.Enumeration;
import java.util.Vector;
import weka.classifiers.functions.supportVector.Kernel;
import weka.core.Capabilities;
import weka.core.Instance;
import weka.core.Instances;
import weka.core.Option;
import weka.core.RevisionUtils;
import weka.core.Utils;
import weka.core.matrix.Matrix;

public class PrecomputedKernelMatrixKernel
extends Kernel {
    static final long serialVersionUID = -321831645846363333L;
    protected File m_KernelMatrixFile = new File("kernelMatrix.matrix");
    protected Matrix m_KernelMatrix;
    protected int m_Counter;

    public String globalInfo() {
        return "This kernel is based on a static kernel matrix that is read from a file. Instances must have a single nominal attribute (excluding the class). This attribute must be the first attribute in the file and its values are used to reference rows/columns in the kernel matrix. The second attribute must be the class attribute.";
    }

    public Enumeration listOptions() {
        Vector vector = new Vector();
        Enumeration enumeration = super.listOptions();
        while (enumeration.hasMoreElements()) {
            vector.addElement(enumeration.nextElement());
        }
        vector.addElement(new Option("\tThe file name of the file that holds the kernel matrix.\n\t(default: kernelMatrix.matrix)", "M", 1, "-M <file name>"));
        return vector.elements();
    }

    public void setOptions(String[] stringArray) throws Exception {
        String string = Utils.getOption('M', stringArray);
        if (string.length() != 0) {
            this.setKernelMatrixFile(new File(string));
        } else {
            this.setKernelMatrixFile(new File("kernelMatrix.matrix"));
        }
        super.setOptions(stringArray);
    }

    public String[] getOptions() {
        Vector<String> vector = new Vector<String>();
        String[] stringArray = super.getOptions();
        for (int i = 0; i < stringArray.length; ++i) {
            vector.add(stringArray[i]);
        }
        vector.add("-M");
        vector.add("" + this.getKernelMatrixFile());
        return vector.toArray(new String[vector.size()]);
    }

    public double eval(int n, int n2, Instance instance) throws Exception {
        if (this.m_KernelMatrix == null) {
            throw new IllegalArgumentException("Kernel matrix has not been loaded successfully.");
        }
        int n3 = -1;
        n3 = n > -1 ? (int)this.m_data.instance(n).value(0) : (int)instance.value(0);
        int n4 = (int)this.m_data.instance(n2).value(0);
        return this.m_KernelMatrix.get(n3, n4);
    }

    protected void initVars(Instances instances) {
        super.initVars(instances);
        try {
            if (this.m_KernelMatrix == null) {
                this.m_KernelMatrix = new Matrix(new FileReader(this.m_KernelMatrixFile));
            }
        }
        catch (Exception exception) {
            System.err.println("Problem reading matrix from " + this.m_KernelMatrixFile);
        }
        ++this.m_Counter;
    }

    public Capabilities getCapabilities() {
        Capabilities capabilities = super.getCapabilities();
        capabilities.enable(Capabilities.Capability.NOMINAL_ATTRIBUTES);
        capabilities.enableAllClasses();
        capabilities.enable(Capabilities.Capability.MISSING_CLASS_VALUES);
        return capabilities;
    }

    public void setKernelMatrixFile(File file) {
        this.m_KernelMatrixFile = file;
    }

    public File getKernelMatrixFile() {
        return this.m_KernelMatrixFile;
    }

    public String kernelMatrixFileTipText() {
        return "The file holding the kernel matrix.";
    }

    protected void setKernelMatrix(Matrix matrix) {
        this.m_KernelMatrix = matrix;
    }

    public String toString() {
        return "Using kernel matrix from file with name: " + this.getKernelMatrixFile();
    }

    public void clean() {
    }

    public int numEvals() {
        return 0;
    }

    public int numCacheHits() {
        return 0;
    }

    public String getRevision() {
        return RevisionUtils.extract("$Revision: 1.1 $");
    }
}

