/*
 * Decompiled with CFR 0.152.
 */
package weka.classifiers;

import java.io.Serializable;
import java.util.Enumeration;
import java.util.Vector;
import weka.classifiers.Evaluation;
import weka.core.Capabilities;
import weka.core.CapabilitiesHandler;
import weka.core.Instance;
import weka.core.Instances;
import weka.core.Option;
import weka.core.OptionHandler;
import weka.core.RevisionHandler;
import weka.core.RevisionUtils;
import weka.core.SerializedObject;
import weka.core.Utils;

public abstract class Classifier
implements Cloneable,
Serializable,
OptionHandler,
CapabilitiesHandler,
RevisionHandler {
    private static final long serialVersionUID = 6502780192411755341L;
    protected boolean m_Debug = false;

    public abstract void buildClassifier(Instances var1) throws Exception;

    public double classifyInstance(Instance instance) throws Exception {
        double[] dArray = this.distributionForInstance(instance);
        if (dArray == null) {
            throw new Exception("Null distribution predicted");
        }
        switch (instance.classAttribute().type()) {
            case 1: {
                double d = 0.0;
                int n = 0;
                for (int i = 0; i < dArray.length; ++i) {
                    if (!(dArray[i] > d)) continue;
                    n = i;
                    d = dArray[i];
                }
                if (d > 0.0) {
                    return n;
                }
                return Instance.missingValue();
            }
            case 0: {
                return dArray[0];
            }
        }
        return Instance.missingValue();
    }

    public double[] distributionForInstance(Instance instance) throws Exception {
        double[] dArray = new double[instance.numClasses()];
        switch (instance.classAttribute().type()) {
            case 1: {
                double d = this.classifyInstance(instance);
                if (Instance.isMissingValue(d)) {
                    return dArray;
                }
                dArray[(int)d] = 1.0;
                return dArray;
            }
            case 0: {
                dArray[0] = this.classifyInstance(instance);
                return dArray;
            }
        }
        return dArray;
    }

    public static Classifier forName(String string, String[] stringArray) throws Exception {
        return (Classifier)Utils.forName(Classifier.class, string, stringArray);
    }

    public static Classifier makeCopy(Classifier classifier) throws Exception {
        return (Classifier)new SerializedObject(classifier).getObject();
    }

    public static Classifier[] makeCopies(Classifier classifier, int n) throws Exception {
        if (classifier == null) {
            throw new Exception("No model classifier set");
        }
        Classifier[] classifierArray = new Classifier[n];
        SerializedObject serializedObject = new SerializedObject(classifier);
        for (int i = 0; i < classifierArray.length; ++i) {
            classifierArray[i] = (Classifier)serializedObject.getObject();
        }
        return classifierArray;
    }

    public Enumeration listOptions() {
        Vector<Option> vector = new Vector<Option>(1);
        vector.addElement(new Option("\tIf set, classifier is run in debug mode and\n\tmay output additional info to the console", "D", 0, "-D"));
        return vector.elements();
    }

    public void setOptions(String[] stringArray) throws Exception {
        this.setDebug(Utils.getFlag('D', stringArray));
    }

    public String[] getOptions() {
        String[] stringArray = this.getDebug() ? new String[]{"-D"} : new String[]{};
        return stringArray;
    }

    public void setDebug(boolean bl) {
        this.m_Debug = bl;
    }

    public boolean getDebug() {
        return this.m_Debug;
    }

    public String debugTipText() {
        return "If set to true, classifier may output additional info to the console.";
    }

    public Capabilities getCapabilities() {
        Capabilities capabilities = new Capabilities(this);
        capabilities.enableAll();
        return capabilities;
    }

    public String getRevision() {
        return RevisionUtils.extract("$Revision: 5536 $");
    }

    protected static void runClassifier(Classifier classifier, String[] stringArray) {
        try {
            System.out.println(Evaluation.evaluateModel(classifier, stringArray));
        }
        catch (Exception exception) {
            if (exception.getMessage() != null && exception.getMessage().indexOf("General options") == -1 || exception.getMessage() == null) {
                exception.printStackTrace();
            }
            System.err.println(exception.getMessage());
        }
    }
}

