/*
 * Decompiled with CFR 0.152.
 */
package weka.core;

import weka.core.Instances;
import weka.core.NormalizableDistance;
import weka.core.RevisionUtils;
import weka.core.TechnicalInformation;
import weka.core.TechnicalInformationHandler;

public class ChebyshevDistance
extends NormalizableDistance
implements TechnicalInformationHandler {
    private static final long serialVersionUID = -7739904999895461429L;

    public ChebyshevDistance() {
    }

    public ChebyshevDistance(Instances instances) {
        super(instances);
    }

    public String globalInfo() {
        return "Implements the Chebyshev distance. The distance between two vectors is the greatest of their differences along any coordinate dimension.\n\nFor more information, see:\n\n" + this.getTechnicalInformation().toString();
    }

    public TechnicalInformation getTechnicalInformation() {
        TechnicalInformation technicalInformation = new TechnicalInformation(TechnicalInformation.Type.MISC);
        technicalInformation.setValue(TechnicalInformation.Field.AUTHOR, "Wikipedia");
        technicalInformation.setValue(TechnicalInformation.Field.TITLE, "Chebyshev distance");
        technicalInformation.setValue(TechnicalInformation.Field.URL, "http://en.wikipedia.org/wiki/Chebyshev_distance");
        return technicalInformation;
    }

    protected double updateDistance(double d, double d2) {
        double d3 = d;
        if ((d2 = Math.abs(d2)) > d3) {
            d3 = d2;
        }
        return d3;
    }

    public String getRevision() {
        return RevisionUtils.extract("$Revision: 1.2 $");
    }
}

