/*
 * Decompiled with CFR 0.152.
 */
package weka.filters.unsupervised.attribute;

import java.util.Enumeration;
import java.util.Vector;
import weka.core.Capabilities;
import weka.core.Instance;
import weka.core.Instances;
import weka.core.Option;
import weka.core.RevisionUtils;
import weka.core.Utils;
import weka.filters.SimpleStreamFilter;

public class ClassAssigner
extends SimpleStreamFilter {
    private static final long serialVersionUID = 1775780193887394115L;
    public static final int FIRST = 0;
    public static final int LAST = -2;
    public static final int UNSET = -1;
    protected int m_ClassIndex = -2;

    public String globalInfo() {
        return "Filter that can set and unset the class index.";
    }

    public Enumeration listOptions() {
        Vector vector = new Vector();
        Enumeration enumeration = super.listOptions();
        while (enumeration.hasMoreElements()) {
            vector.add(enumeration.nextElement());
        }
        vector.addElement(new Option("\tThe index of the class attribute. Index starts with 1, 'first'\n\tand 'last' are accepted, '0' unsets the class index.\n\t(default: last)", "C", 1, "-C <num|first|last|0>"));
        return vector.elements();
    }

    public void setOptions(String[] stringArray) throws Exception {
        super.setOptions(stringArray);
        String string = Utils.getOption("C", stringArray);
        if (string.length() != 0) {
            this.setClassIndex(string);
        } else {
            this.setClassIndex("last");
        }
    }

    public String[] getOptions() {
        Vector<String> vector = new Vector<String>();
        String[] stringArray = super.getOptions();
        for (int i = 0; i < stringArray.length; ++i) {
            vector.add(stringArray[i]);
        }
        vector.add("-C");
        vector.add(this.getClassIndex());
        return vector.toArray(new String[vector.size()]);
    }

    public String classIndexTipText() {
        return "The index of the class attribute, starts with 1, 'first' and 'last' are accepted as well, '0' unsets the class index.";
    }

    public void setClassIndex(String string) {
        if (string.equalsIgnoreCase("first")) {
            this.m_ClassIndex = 0;
        } else if (string.equalsIgnoreCase("last")) {
            this.m_ClassIndex = -2;
        } else if (string.equalsIgnoreCase("0")) {
            this.m_ClassIndex = -1;
        } else {
            try {
                this.m_ClassIndex = Integer.parseInt(string) - 1;
            }
            catch (Exception exception) {
                System.err.println("Error parsing '" + string + "'!");
            }
        }
    }

    public String getClassIndex() {
        if (this.m_ClassIndex == 0) {
            return "first";
        }
        if (this.m_ClassIndex == -2) {
            return "last";
        }
        if (this.m_ClassIndex == -1) {
            return "0";
        }
        return "" + (this.m_ClassIndex + 1);
    }

    public Capabilities getCapabilities() {
        Capabilities capabilities = super.getCapabilities();
        capabilities.disableAll();
        capabilities.enableAllAttributes();
        capabilities.enable(Capabilities.Capability.MISSING_VALUES);
        capabilities.enableAllClasses();
        capabilities.enable(Capabilities.Capability.NO_CLASS);
        capabilities.enable(Capabilities.Capability.MISSING_CLASS_VALUES);
        return capabilities;
    }

    protected Instances determineOutputFormat(Instances instances) throws Exception {
        Instances instances2 = new Instances(instances, 0);
        if (this.m_ClassIndex == 0) {
            instances2.setClassIndex(0);
        } else if (this.m_ClassIndex == -2) {
            instances2.setClassIndex(instances2.numAttributes() - 1);
        } else if (this.m_ClassIndex == -1) {
            instances2.setClassIndex(-1);
        } else {
            instances2.setClassIndex(this.m_ClassIndex);
        }
        return instances2;
    }

    protected Instance process(Instance instance) throws Exception {
        return instance;
    }

    public String getRevision() {
        return RevisionUtils.extract("$Revision: 5543 $");
    }

    public static void main(String[] stringArray) {
        ClassAssigner.runFilter(new ClassAssigner(), stringArray);
    }
}

