/*
 * Decompiled with CFR 0.152.
 */
package weka.filters.unsupervised.attribute;

import java.util.Enumeration;
import java.util.Vector;
import weka.core.Attribute;
import weka.core.Capabilities;
import weka.core.FastVector;
import weka.core.Instance;
import weka.core.Instances;
import weka.core.Option;
import weka.core.OptionHandler;
import weka.core.Range;
import weka.core.RevisionUtils;
import weka.core.SparseInstance;
import weka.core.Utils;
import weka.filters.AllFilter;
import weka.filters.Filter;
import weka.filters.SimpleBatchFilter;
import weka.filters.unsupervised.attribute.Remove;

public class PartitionedMultiFilter
extends SimpleBatchFilter {
    private static final long serialVersionUID = -6293720886005713120L;
    protected Filter[] m_Filters = new Filter[]{new AllFilter()};
    protected Range[] m_Ranges = new Range[]{new Range("first-last")};
    protected boolean m_RemoveUnused = false;
    protected int[] m_IndicesUnused = new int[0];

    public String globalInfo() {
        return "A filter that applies filters on subsets of attributes and assembles the output into a new dataset. Attributes that are not covered by any of the ranges can be either retained or removed from the output.";
    }

    public Enumeration listOptions() {
        Vector vector = new Vector();
        Enumeration enumeration = super.listOptions();
        while (enumeration.hasMoreElements()) {
            vector.add(enumeration.nextElement());
        }
        vector.addElement(new Option("\tA filter to apply (can be specified multiple times).", "F", 1, "-F <classname [options]>"));
        vector.addElement(new Option("\tAn attribute range (can be specified multiple times).\n\tFor each filter a range must be supplied. 'first' and 'last'\n\tare valid indices.", "R", 1, "-R <range>"));
        vector.addElement(new Option("\tFlag for leaving unused attributes out of the output, by default\n\tthese are included in the filter output.", "U", 0, "-U"));
        return vector.elements();
    }

    public void setOptions(String[] stringArray) throws Exception {
        String string;
        super.setOptions(stringArray);
        this.setRemoveUnused(Utils.getFlag("U", stringArray));
        Vector<Object> vector = new Vector<Object>();
        while ((string = Utils.getOption("F", stringArray)).length() != 0) {
            String[] stringArray2 = Utils.splitOptions(string);
            String string2 = stringArray2[0];
            stringArray2[0] = "";
            vector.add(Utils.forName(Filter.class, string2, stringArray2));
        }
        if (vector.size() == 0) {
            vector.add(new AllFilter());
        }
        this.setFilters(vector.toArray(new Filter[vector.size()]));
        vector = new Vector();
        while ((string = Utils.getOption("R", stringArray)).length() != 0) {
            vector.add(new Range(string));
        }
        if (vector.size() == 0) {
            vector.add(new Range("first-last"));
        }
        this.setRanges(vector.toArray(new Range[vector.size()]));
        this.checkDimensions();
    }

    public String[] getOptions() {
        int n;
        Vector<String> vector = new Vector<String>();
        String[] stringArray = super.getOptions();
        for (n = 0; n < stringArray.length; ++n) {
            vector.add(stringArray[n]);
        }
        if (this.getRemoveUnused()) {
            vector.add("-U");
        }
        for (n = 0; n < this.getFilters().length; ++n) {
            vector.add("-F");
            vector.add(this.getFilterSpec(this.getFilter(n)));
        }
        for (n = 0; n < this.getRanges().length; ++n) {
            vector.add("-R");
            vector.add("" + this.getRange(n).getRanges());
        }
        return vector.toArray(new String[vector.size()]);
    }

    protected void checkDimensions() throws Exception {
        if (this.getFilters().length != this.getRanges().length) {
            throw new IllegalArgumentException("Number of filters (= " + this.getFilters().length + ") " + "and ranges (= " + this.getRanges().length + ") don't match!");
        }
    }

    public Capabilities getCapabilities() {
        Capabilities capabilities;
        if (this.getFilters().length == 0) {
            capabilities = super.getCapabilities();
            capabilities.disableAll();
        } else {
            capabilities = this.getFilters()[0].getCapabilities();
        }
        capabilities.disable(Capabilities.Capability.STRING_ATTRIBUTES);
        capabilities.disableDependency(Capabilities.Capability.STRING_ATTRIBUTES);
        capabilities.disable(Capabilities.Capability.RELATIONAL_ATTRIBUTES);
        capabilities.disableDependency(Capabilities.Capability.RELATIONAL_ATTRIBUTES);
        return capabilities;
    }

    public void setRemoveUnused(boolean bl) {
        this.m_RemoveUnused = bl;
    }

    public boolean getRemoveUnused() {
        return this.m_RemoveUnused;
    }

    public String removeUnusedTipText() {
        return "If true then unused attributes (ones that are not covered by any of the ranges) will be removed from the output.";
    }

    public void setFilters(Filter[] filterArray) {
        this.m_Filters = filterArray;
        this.reset();
    }

    public Filter[] getFilters() {
        return this.m_Filters;
    }

    public String filtersTipText() {
        return "The base filters to be used.";
    }

    public Filter getFilter(int n) {
        return this.m_Filters[n];
    }

    protected String getFilterSpec(Filter filter) {
        String string;
        if (filter == null) {
            string = "";
        } else {
            string = filter.getClass().getName();
            if (filter instanceof OptionHandler) {
                string = string + " " + Utils.joinOptions(((OptionHandler)((Object)filter)).getOptions());
            }
        }
        return string;
    }

    public void setRanges(Range[] rangeArray) {
        this.m_Ranges = rangeArray;
        this.reset();
    }

    public Range[] getRanges() {
        return this.m_Ranges;
    }

    public String rangesTipText() {
        return "The attribute ranges to be used.";
    }

    public Range getRange(int n) {
        return this.m_Ranges[n];
    }

    protected void determineUnusedIndices(Instances instances) {
        int n;
        Vector<Integer> vector = new Vector<Integer>();
        for (n = 0; n < instances.numAttributes(); ++n) {
            if (n == instances.classIndex()) continue;
            boolean bl = false;
            for (int i = 0; i < this.getRanges().length; ++i) {
                if (!this.getRanges()[i].isInRange(n)) continue;
                bl = true;
                break;
            }
            if (bl) continue;
            vector.add(new Integer(n));
        }
        this.m_IndicesUnused = new int[vector.size()];
        for (n = 0; n < vector.size(); ++n) {
            this.m_IndicesUnused[n] = (Integer)vector.get(n);
        }
        if (this.getDebug()) {
            System.out.println("Unused indices: " + Utils.arrayToString(this.m_IndicesUnused));
        }
    }

    protected Instances generateSubset(Instances instances, Range range) throws Exception {
        String string = range.getRanges();
        if (instances.classIndex() > -1 && !range.isInRange(instances.classIndex())) {
            string = string + "," + (instances.classIndex() + 1);
        }
        Remove remove = new Remove();
        remove.setAttributeIndices(string);
        remove.setInvertSelection(true);
        remove.setInputFormat(instances);
        Instances instances2 = Filter.useFilter(instances, remove);
        return instances2;
    }

    protected Instances renameAttributes(Instances instances, String string) throws Exception {
        int n;
        FastVector fastVector = new FastVector();
        for (n = 0; n < instances.numAttributes(); ++n) {
            if (n == instances.classIndex()) {
                fastVector.addElement(instances.attribute(n).copy());
                continue;
            }
            fastVector.addElement(instances.attribute(n).copy(string + instances.attribute(n).name()));
        }
        Instances instances2 = new Instances(instances.relationName(), fastVector, instances.numInstances());
        for (n = 0; n < instances.numInstances(); ++n) {
            instances2.add((Instance)instances.instance(n).copy());
        }
        if (instances.classIndex() > -1) {
            instances2.setClassIndex(instances.classIndex());
        }
        return instances2;
    }

    protected Instances determineOutputFormat(Instances instances) throws Exception {
        Instances instances2;
        if (!this.isFirstBatchDone()) {
            int n;
            if (instances.numInstances() == 0) {
                return null;
            }
            this.checkDimensions();
            this.determineUnusedIndices(instances);
            FastVector fastVector = new FastVector();
            for (n = 0; n < this.getFilters().length; ++n) {
                Instances instances3;
                if (!this.isFirstBatchDone()) {
                    instances3 = this.generateSubset(instances, this.getRange(n));
                    if (!this.getFilter(n).setInputFormat(instances3)) {
                        Filter.useFilter(instances3, this.getFilter(n));
                    }
                }
                instances3 = this.getFilter(n).getOutputFormat();
                instances3 = this.renameAttributes(instances3, "filtered-" + n + "-");
                for (int i = 0; i < instances3.numAttributes(); ++i) {
                    if (i == instances3.classIndex()) continue;
                    fastVector.addElement(instances3.attribute(i).copy());
                }
            }
            if (!this.getRemoveUnused()) {
                for (n = 0; n < this.m_IndicesUnused.length; ++n) {
                    Attribute attribute = instances.attribute(this.m_IndicesUnused[n]);
                    fastVector.addElement(attribute.copy("unfiltered-" + attribute.name()));
                }
            }
            if (instances.classIndex() > -1) {
                fastVector.addElement(instances.classAttribute().copy());
            }
            instances2 = new Instances(instances.relationName(), fastVector, 0);
            if (instances.classIndex() > -1) {
                instances2.setClassIndex(instances2.numAttributes() - 1);
            }
        } else {
            instances2 = this.getOutputFormat();
        }
        return instances2;
    }

    protected Instances process(Instances instances) throws Exception {
        Instances instances2;
        int n;
        if (!this.isFirstBatchDone()) {
            this.checkDimensions();
            for (n = 0; n < this.m_Ranges.length; ++n) {
                this.m_Ranges[n].setUpper(instances.numAttributes() - 1);
            }
            this.determineUnusedIndices(instances);
        }
        Instances[] instancesArray = new Instances[this.getFilters().length];
        for (n = 0; n < this.getFilters().length; ++n) {
            instancesArray[n] = this.generateSubset(instances, this.getRange(n));
            if (!this.isFirstBatchDone()) {
                this.getFilter(n).setInputFormat(instancesArray[n]);
            }
            instancesArray[n] = Filter.useFilter(instancesArray[n], this.getFilter(n));
        }
        if (!this.isFirstBatchDone()) {
            instances2 = this.determineOutputFormat(instances);
            this.setOutputFormat(instances2);
        } else {
            instances2 = this.getOutputFormat();
        }
        Vector<Integer> vector = new Vector<Integer>();
        for (n = 0; n < instancesArray.length; ++n) {
            if (instancesArray[n].numInstances() == instances.numInstances()) continue;
            vector.add(new Integer(n));
        }
        if (vector.size() > 0) {
            throw new IllegalStateException("The following filter(s) changed the number of instances: " + vector);
        }
        for (n = 0; n < instances.numInstances(); ++n) {
            int n2;
            Instance instance = instances.instance(n);
            double[] dArray = new double[instances2.numAttributes()];
            int n3 = 0;
            for (n2 = 0; n2 < instancesArray.length; ++n2) {
                for (int i = 0; i < instancesArray[n2].numAttributes(); ++i) {
                    if (i == instancesArray[n2].classIndex()) continue;
                    dArray[n3] = instancesArray[n2].instance(n).value(i);
                    ++n3;
                }
            }
            if (!this.getRemoveUnused()) {
                for (n2 = 0; n2 < this.m_IndicesUnused.length; ++n2) {
                    dArray[n3] = instance.value(this.m_IndicesUnused[n2]);
                    ++n3;
                }
            }
            if (instances.classIndex() > -1) {
                dArray[dArray.length - 1] = instance.value(instances.classIndex());
            }
            Instance instance2 = instance instanceof SparseInstance ? new SparseInstance(instances.instance(n).weight(), dArray) : new Instance(instances.instance(n).weight(), dArray);
            instances2.add(instance2);
        }
        return instances2;
    }

    public String getRevision() {
        return RevisionUtils.extract("$Revision: 5543 $");
    }

    public static void main(String[] stringArray) {
        PartitionedMultiFilter.runFilter(new PartitionedMultiFilter(), stringArray);
    }
}

