/*
 * Decompiled with CFR 0.152.
 */
package weka.gui.beans;

import java.awt.BorderLayout;
import java.awt.Component;
import java.beans.EventSetDescriptor;
import java.io.Serializable;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import javax.swing.JPanel;
import weka.associations.Apriori;
import weka.core.Drawable;
import weka.core.Instances;
import weka.core.OptionHandler;
import weka.core.Utils;
import weka.gui.Logger;
import weka.gui.beans.BeanCommon;
import weka.gui.beans.BeanVisual;
import weka.gui.beans.DataSetEvent;
import weka.gui.beans.DataSourceListener;
import weka.gui.beans.EventConstraints;
import weka.gui.beans.GraphEvent;
import weka.gui.beans.GraphListener;
import weka.gui.beans.KnowledgeFlowApp;
import weka.gui.beans.TextEvent;
import weka.gui.beans.TextListener;
import weka.gui.beans.TrainingSetEvent;
import weka.gui.beans.TrainingSetListener;
import weka.gui.beans.UserRequestAcceptor;
import weka.gui.beans.Visible;
import weka.gui.beans.WekaWrapper;

public class Associator
extends JPanel
implements BeanCommon,
Visible,
WekaWrapper,
EventConstraints,
Serializable,
UserRequestAcceptor,
DataSourceListener,
TrainingSetListener {
    private static final long serialVersionUID = -7843500322130210057L;
    protected BeanVisual m_visual = new BeanVisual("Associator", "weka/gui/beans/icons/DefaultAssociator.gif", "weka/gui/beans/icons/DefaultAssociator_animated.gif");
    private static int IDLE = 0;
    private static int BUILDING_MODEL = 1;
    private int m_state = IDLE;
    private Thread m_buildThread = null;
    protected String m_globalInfo;
    private Hashtable m_listenees = new Hashtable();
    private Vector m_textListeners = new Vector();
    private Vector m_graphListeners = new Vector();
    private weka.associations.Associator m_Associator = new Apriori();
    private transient Logger m_log = null;

    public String globalInfo() {
        return this.m_globalInfo;
    }

    public Associator() {
        this.setLayout(new BorderLayout());
        this.add((Component)this.m_visual, "Center");
        this.setAssociator(this.m_Associator);
    }

    public void setCustomName(String string) {
        this.m_visual.setText(string);
    }

    public String getCustomName() {
        return this.m_visual.getText();
    }

    public void setAssociator(weka.associations.Associator associator) {
        boolean bl = true;
        if (associator.getClass().getName().compareTo(this.m_Associator.getClass().getName()) == 0) {
            bl = false;
        }
        this.m_Associator = associator;
        String string = associator.getClass().toString();
        string = string.substring(string.lastIndexOf(46) + 1, string.length());
        if (bl && !this.m_visual.loadIcons("weka/gui/beans/icons/" + string + ".gif", "weka/gui/beans/icons/" + string + "_animated.gif")) {
            this.useDefaultVisual();
        }
        this.m_visual.setText(string);
        this.m_globalInfo = KnowledgeFlowApp.getGlobalInfo(this.m_Associator);
    }

    public weka.associations.Associator getAssociator() {
        return this.m_Associator;
    }

    public void setWrappedAlgorithm(Object object) {
        if (!(object instanceof weka.associations.Associator)) {
            throw new IllegalArgumentException(object.getClass() + " : incorrect " + "type of algorithm (Associator)");
        }
        this.setAssociator((weka.associations.Associator)object);
    }

    public Object getWrappedAlgorithm() {
        return this.getAssociator();
    }

    public void acceptTrainingSet(TrainingSetEvent trainingSetEvent) {
        Instances instances = trainingSetEvent.getTrainingSet();
        DataSetEvent dataSetEvent = new DataSetEvent(this, instances);
        this.acceptDataSet(dataSetEvent);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void acceptDataSet(DataSetEvent dataSetEvent) {
        block7: {
            if (dataSetEvent.isStructureOnly()) {
                return;
            }
            if (this.m_buildThread == null) {
                try {
                    if (this.m_state != IDLE) break block7;
                    Serializable serializable = this;
                    synchronized (serializable) {
                        this.m_state = BUILDING_MODEL;
                    }
                    serializable = dataSetEvent.getDataSet();
                    this.m_buildThread = new Thread((Instances)serializable, dataSetEvent){
                        final /* synthetic */ Instances val$trainingData;
                        final /* synthetic */ DataSetEvent val$e;
                        {
                            this.val$trainingData = instances;
                            this.val$e = dataSetEvent;
                        }

                        /*
                         * WARNING - Removed try catching itself - possible behaviour change.
                         * Enabled aggressive block sorting
                         * Enabled unnecessary exception pruning
                         * Enabled aggressive exception aggregation
                         */
                        public void run() {
                            try {
                                block19: {
                                    try {
                                        Object object;
                                        String string;
                                        if (this.val$trainingData == null) break block19;
                                        Associator.this.m_visual.setAnimated();
                                        if (Associator.this.m_log != null) {
                                            Associator.this.m_log.statusMessage(Associator.this.statusMessagePrefix() + "Building model...");
                                        }
                                        Associator.this.buildAssociations(this.val$trainingData);
                                        if (Associator.this.m_textListeners.size() > 0) {
                                            string = Associator.this.m_Associator.toString();
                                            String string2 = Associator.this.m_Associator.getClass().getName();
                                            string2 = string2.substring(string2.lastIndexOf(46) + 1, string2.length());
                                            string = "=== Associator model ===\n\nScheme:   " + string2 + "\n" + "Relation: " + this.val$trainingData.relationName() + "\n\n" + string;
                                            string2 = "Model: " + string2;
                                            object = new TextEvent(Associator.this, string, string2);
                                            Associator.this.notifyTextListeners((TextEvent)object);
                                        }
                                        if (!(Associator.this.m_Associator instanceof Drawable) || Associator.this.m_graphListeners.size() <= 0) break block19;
                                        string = ((Drawable)((Object)Associator.this.m_Associator)).graph();
                                        int n = ((Drawable)((Object)Associator.this.m_Associator)).graphType();
                                        object = Associator.this.m_Associator.getClass().getName();
                                        object = ((String)object).substring(((String)object).lastIndexOf(46) + 1, ((String)object).length());
                                        object = " (" + this.val$e.getDataSet().relationName() + ") " + (String)object;
                                        GraphEvent graphEvent = new GraphEvent(Associator.this, string, (String)object, n);
                                        Associator.this.notifyGraphListeners(graphEvent);
                                    }
                                    catch (Exception exception) {
                                        Associator.this.stop();
                                        if (Associator.this.m_log != null) {
                                            Associator.this.m_log.statusMessage(Associator.this.statusMessagePrefix() + "ERROR (See log for details)");
                                            Associator.this.m_log.logMessage("[Associator] " + Associator.this.statusMessagePrefix() + " problem training associator. " + exception.getMessage());
                                        }
                                        exception.printStackTrace();
                                        Object var6_8 = null;
                                        Associator.this.m_visual.setStatic();
                                        Associator.this.m_state = IDLE;
                                        if (this.isInterrupted()) {
                                            if (Associator.this.m_log != null) {
                                                String string = Associator.this.m_Associator.getClass().getName();
                                                string = string.substring(string.lastIndexOf(46) + 1, string.length());
                                                Associator.this.m_log.logMessage("[Associator] " + Associator.this.statusMessagePrefix() + " Build associator interrupted!");
                                                Associator.this.m_log.statusMessage(Associator.this.statusMessagePrefix() + "INTERRUPTED");
                                            }
                                        } else if (Associator.this.m_log != null) {
                                            Associator.this.m_log.statusMessage(Associator.this.statusMessagePrefix() + "Finished.");
                                        }
                                        Associator.this.block(false);
                                        return;
                                    }
                                }
                                Object var6_7 = null;
                                Associator.this.m_visual.setStatic();
                                Associator.this.m_state = IDLE;
                                if (this.isInterrupted()) {
                                    if (Associator.this.m_log != null) {
                                        String string = Associator.this.m_Associator.getClass().getName();
                                        string = string.substring(string.lastIndexOf(46) + 1, string.length());
                                        Associator.this.m_log.logMessage("[Associator] " + Associator.this.statusMessagePrefix() + " Build associator interrupted!");
                                        Associator.this.m_log.statusMessage(Associator.this.statusMessagePrefix() + "INTERRUPTED");
                                    }
                                } else if (Associator.this.m_log != null) {
                                    Associator.this.m_log.statusMessage(Associator.this.statusMessagePrefix() + "Finished.");
                                }
                                Associator.this.block(false);
                                return;
                            }
                            catch (Throwable throwable) {
                                Object var6_9 = null;
                                Associator.this.m_visual.setStatic();
                                Associator.this.m_state = IDLE;
                                if (this.isInterrupted()) {
                                    if (Associator.this.m_log != null) {
                                        String string = Associator.this.m_Associator.getClass().getName();
                                        string = string.substring(string.lastIndexOf(46) + 1, string.length());
                                        Associator.this.m_log.logMessage("[Associator] " + Associator.this.statusMessagePrefix() + " Build associator interrupted!");
                                        Associator.this.m_log.statusMessage(Associator.this.statusMessagePrefix() + "INTERRUPTED");
                                    }
                                } else if (Associator.this.m_log != null) {
                                    Associator.this.m_log.statusMessage(Associator.this.statusMessagePrefix() + "Finished.");
                                }
                                Associator.this.block(false);
                                throw throwable;
                            }
                        }
                    };
                    this.m_buildThread.setPriority(1);
                    this.m_buildThread.start();
                    this.block(true);
                    this.m_buildThread = null;
                    this.m_state = IDLE;
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                }
            }
        }
    }

    private void buildAssociations(Instances instances) throws Exception {
        this.m_Associator.buildAssociations(instances);
    }

    public void setVisual(BeanVisual beanVisual) {
        this.m_visual = beanVisual;
    }

    public BeanVisual getVisual() {
        return this.m_visual;
    }

    public void useDefaultVisual() {
        this.m_visual.loadIcons("weka/gui/beans/icons/DefaultAssociator.gif", "weka/gui/beans/icons/DefaultAssociator_animated.gif");
    }

    public synchronized void addTextListener(TextListener textListener) {
        this.m_textListeners.addElement(textListener);
    }

    public synchronized void removeTextListener(TextListener textListener) {
        this.m_textListeners.remove(textListener);
    }

    public synchronized void addGraphListener(GraphListener graphListener) {
        this.m_graphListeners.addElement(graphListener);
    }

    public synchronized void removeGraphListener(GraphListener graphListener) {
        this.m_graphListeners.remove(graphListener);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void notifyTextListeners(TextEvent textEvent) {
        Vector vector;
        Associator associator = this;
        synchronized (associator) {
            vector = (Vector)this.m_textListeners.clone();
        }
        if (vector.size() > 0) {
            for (int i = 0; i < vector.size(); ++i) {
                ((TextListener)vector.elementAt(i)).acceptText(textEvent);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void notifyGraphListeners(GraphEvent graphEvent) {
        Vector vector;
        Associator associator = this;
        synchronized (associator) {
            vector = (Vector)this.m_graphListeners.clone();
        }
        if (vector.size() > 0) {
            for (int i = 0; i < vector.size(); ++i) {
                ((GraphListener)vector.elementAt(i)).acceptGraph(graphEvent);
            }
        }
    }

    public boolean connectionAllowed(String string) {
        return !this.m_listenees.containsKey(string);
    }

    public boolean connectionAllowed(EventSetDescriptor eventSetDescriptor) {
        return this.connectionAllowed(eventSetDescriptor.getName());
    }

    public synchronized void connectionNotification(String string, Object object) {
        if (this.connectionAllowed(string)) {
            this.m_listenees.put(string, object);
        }
    }

    public synchronized void disconnectionNotification(String string, Object object) {
        this.m_listenees.remove(string);
    }

    private synchronized void block(boolean bl) {
        if (bl) {
            try {
                if (this.m_buildThread.isAlive() && this.m_state != IDLE) {
                    this.wait();
                }
            }
            catch (InterruptedException interruptedException) {}
        } else {
            this.notifyAll();
        }
    }

    public boolean isBusy() {
        return this.m_buildThread != null;
    }

    public void stop() {
        Enumeration enumeration = this.m_listenees.keys();
        while (enumeration.hasMoreElements()) {
            Object v = this.m_listenees.get(enumeration.nextElement());
            if (!(v instanceof BeanCommon)) continue;
            ((BeanCommon)v).stop();
        }
        if (this.m_buildThread != null) {
            this.m_buildThread.interrupt();
            this.m_buildThread.stop();
            this.m_buildThread = null;
            this.m_visual.setStatic();
        }
    }

    public void setLog(Logger logger) {
        this.m_log = logger;
    }

    public Enumeration enumerateRequests() {
        Vector<String> vector = new Vector<String>(0);
        if (this.m_buildThread != null) {
            vector.addElement("Stop");
        }
        return vector.elements();
    }

    public void performRequest(String string) {
        if (string.compareTo("Stop") != 0) {
            throw new IllegalArgumentException(string + " not supported (Associator)");
        }
        this.stop();
    }

    public boolean eventGeneratable(EventSetDescriptor eventSetDescriptor) {
        String string = eventSetDescriptor.getName();
        return this.eventGeneratable(string);
    }

    public boolean eventGeneratable(String string) {
        if (string.compareTo("text") == 0 || string.compareTo("graph") == 0) {
            if (!this.m_listenees.containsKey("dataSet") && !this.m_listenees.containsKey("trainingSet")) {
                return false;
            }
            Object v = this.m_listenees.get("trainingSet");
            if (v != null && v instanceof EventConstraints && !((EventConstraints)v).eventGeneratable("trainingSet")) {
                return false;
            }
            v = this.m_listenees.get("dataSet");
            if (v != null && v instanceof EventConstraints && !((EventConstraints)v).eventGeneratable("dataSet")) {
                return false;
            }
            if (string.compareTo("graph") == 0 && !(this.m_Associator instanceof Drawable)) {
                return false;
            }
        }
        return true;
    }

    private String statusMessagePrefix() {
        return this.getCustomName() + "$" + this.hashCode() + "|" + (this.m_Associator instanceof OptionHandler && Utils.joinOptions(((OptionHandler)((Object)this.m_Associator)).getOptions()).length() > 0 ? Utils.joinOptions(((OptionHandler)((Object)this.m_Associator)).getOptions()) + "|" : "");
    }
}

