/*
 * Decompiled with CFR 0.152.
 */
package weka.gui.beans;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.Customizer;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import weka.classifiers.UpdateableClassifier;
import weka.gui.GenericObjectEditor;
import weka.gui.PropertySheetPanel;
import weka.gui.beans.Classifier;
import weka.gui.beans.CustomizerCloseRequester;
import weka.gui.beans.CustomizerClosingListener;

public class ClassifierCustomizer
extends JPanel
implements Customizer,
CustomizerClosingListener,
CustomizerCloseRequester {
    private static final long serialVersionUID = -6688000820160821429L;
    private PropertyChangeSupport m_pcSupport = new PropertyChangeSupport(this);
    private Classifier m_dsClassifier;
    private PropertySheetPanel m_ClassifierEditor = new PropertySheetPanel();
    private JPanel m_incrementalPanel = new JPanel();
    private JCheckBox m_updateIncrementalClassifier = new JCheckBox("Update classifier on incoming instance stream");
    private boolean m_panelVisible = false;
    private JPanel m_holderPanel = new JPanel();
    private JTextField m_executionSlotsText = new JTextField();
    private JFrame m_parentFrame;
    protected weka.classifiers.Classifier m_backup;

    public ClassifierCustomizer() {
        this.m_ClassifierEditor.setBorder(BorderFactory.createTitledBorder("Classifier options"));
        this.m_updateIncrementalClassifier.setToolTipText("Train the classifier on each individual incoming streamed instance.");
        this.m_updateIncrementalClassifier.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                if (ClassifierCustomizer.this.m_dsClassifier != null) {
                    ClassifierCustomizer.this.m_dsClassifier.setUpdateIncrementalClassifier(ClassifierCustomizer.this.m_updateIncrementalClassifier.isSelected());
                }
            }
        });
        this.m_incrementalPanel.add(this.m_updateIncrementalClassifier);
        this.m_executionSlotsText.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                if (ClassifierCustomizer.this.m_dsClassifier != null && ClassifierCustomizer.this.m_executionSlotsText.getText().length() > 0) {
                    int n = Integer.parseInt(ClassifierCustomizer.this.m_executionSlotsText.getText());
                    ClassifierCustomizer.this.m_dsClassifier.setExecutionSlots(n);
                }
            }
        });
        JPanel jPanel = new JPanel();
        jPanel.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        JLabel jLabel = new JLabel("Execution slots");
        jPanel.setLayout(new BorderLayout());
        jPanel.add((Component)jLabel, "West");
        jPanel.add((Component)this.m_executionSlotsText, "Center");
        this.m_holderPanel.setBorder(BorderFactory.createTitledBorder("More options"));
        this.m_holderPanel.setLayout(new BorderLayout());
        this.m_holderPanel.add((Component)jPanel, "North");
        JPanel jPanel2 = new JPanel();
        jPanel2.setLayout(new BorderLayout());
        jPanel2.add((Component)this.m_holderPanel, "North");
        JButton jButton = new JButton("OK");
        JButton jButton2 = new JButton("Cancel");
        jButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                ClassifierCustomizer.this.m_parentFrame.dispose();
            }
        });
        jButton2.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                if (ClassifierCustomizer.this.m_backup != null) {
                    ClassifierCustomizer.this.m_dsClassifier.setClassifier(ClassifierCustomizer.this.m_backup);
                }
                ClassifierCustomizer.this.m_parentFrame.dispose();
            }
        });
        JPanel jPanel3 = new JPanel();
        jPanel3.setLayout(new GridLayout(1, 2));
        jPanel3.add(jButton);
        jPanel3.add(jButton2);
        jPanel2.add((Component)jPanel3, "South");
        this.setLayout(new BorderLayout());
        this.add((Component)this.m_ClassifierEditor, "Center");
        this.add((Component)jPanel2, "South");
    }

    private void checkOnClassifierType() {
        weka.classifiers.Classifier classifier = this.m_dsClassifier.getClassifier();
        if (classifier instanceof UpdateableClassifier && this.m_dsClassifier.hasIncomingStreamInstances()) {
            if (!this.m_panelVisible) {
                this.m_holderPanel.add((Component)this.m_incrementalPanel, "South");
                this.m_panelVisible = true;
                this.m_executionSlotsText.setEnabled(false);
            }
        } else if (this.m_panelVisible) {
            this.m_holderPanel.remove(this.m_incrementalPanel);
            this.m_executionSlotsText.setEnabled(true);
            this.m_panelVisible = false;
        }
    }

    public void setObject(Object object) {
        this.m_dsClassifier = (Classifier)object;
        try {
            this.m_backup = (weka.classifiers.Classifier)GenericObjectEditor.makeCopy(this.m_dsClassifier.getClassifier());
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.m_ClassifierEditor.setTarget(this.m_dsClassifier.getClassifier());
        this.m_updateIncrementalClassifier.setSelected(this.m_dsClassifier.getUpdateIncrementalClassifier());
        this.m_executionSlotsText.setText("" + this.m_dsClassifier.getExecutionSlots());
        this.checkOnClassifierType();
    }

    public void customizerClosing() {
        if (this.m_executionSlotsText.getText().length() > 0) {
            int n = Integer.parseInt(this.m_executionSlotsText.getText());
            this.m_dsClassifier.setExecutionSlots(n);
        }
    }

    public void addPropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        this.m_pcSupport.addPropertyChangeListener(propertyChangeListener);
    }

    public void removePropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        this.m_pcSupport.removePropertyChangeListener(propertyChangeListener);
    }

    public void setParentFrame(JFrame jFrame) {
        this.m_parentFrame = jFrame;
    }

    static {
        GenericObjectEditor.registerEditors();
    }
}

