/*
 * Decompiled with CFR 0.152.
 */
package weka.gui.treevisualizer;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.FontMetrics;
import java.io.StringReader;
import java.util.Vector;
import weka.core.Instances;
import weka.gui.treevisualizer.Edge;

public class Node {
    private int m_backstyle;
    private int m_shape;
    private Color m_color;
    private String m_label;
    private Vector m_lines;
    private double m_center;
    private double m_top;
    private boolean m_cVisible;
    private boolean m_visible;
    private boolean m_root;
    private Vector m_parent;
    private Vector m_children;
    private String m_refer;
    private String m_data;
    private Instances m_theData;

    public Node(String string, String string2, int n, int n2, Color color, String string3) {
        this.m_label = string;
        this.m_backstyle = n;
        this.m_shape = n2;
        this.m_color = color;
        this.m_refer = string2;
        this.m_center = 0.0;
        this.m_top = 0.0;
        this.m_cVisible = true;
        this.m_visible = true;
        this.m_root = false;
        this.m_parent = new Vector(1, 1);
        this.m_children = new Vector(20, 10);
        this.m_lines = new Vector(4, 2);
        this.breakupLabel();
        this.m_data = string3;
        this.m_theData = null;
    }

    public Instances getInstances() {
        if (this.m_theData == null && this.m_data != null) {
            try {
                this.m_theData = new Instances(new StringReader(this.m_data));
            }
            catch (Exception exception) {
                System.out.println("Error : " + exception);
            }
            this.m_data = null;
        }
        return this.m_theData;
    }

    public boolean getCVisible() {
        return this.m_cVisible;
    }

    private void childVis(Node node) {
        node.setVisible(true);
        if (node.getCVisible()) {
            Edge edge;
            int n = 0;
            while ((edge = node.getChild(n)) != null) {
                this.childVis(edge.getTarget());
                ++n;
            }
        }
    }

    public void setCVisible(boolean bl) {
        this.m_cVisible = bl;
        if (bl) {
            this.childVis(this);
        } else if (!bl) {
            this.childInv(this);
        }
    }

    private void childInv(Node node) {
        Edge edge;
        int n = 0;
        while ((edge = node.getChild(n)) != null) {
            Node node2 = edge.getTarget();
            node2.setVisible(false);
            this.childInv(node2);
            ++n;
        }
    }

    public String getRefer() {
        return this.m_refer;
    }

    public void setRefer(String string) {
        this.m_refer = string;
    }

    public int getShape() {
        return this.m_shape;
    }

    public void setShape(int n) {
        this.m_shape = n;
    }

    public Color getColor() {
        return this.m_color;
    }

    public void setColor(Color color) {
        this.m_color = color;
    }

    public String getLabel() {
        return this.m_label;
    }

    private void breakupLabel() {
        int n;
        int n2 = 0;
        for (n = 0; n < this.m_label.length(); ++n) {
            if (this.m_label.charAt(n) != '\n') continue;
            this.m_lines.addElement(this.m_label.substring(n2, n));
            n2 = n + 1;
        }
        this.m_lines.addElement(this.m_label.substring(n2, n));
    }

    public Dimension stringSize(FontMetrics fontMetrics) {
        String string;
        Dimension dimension = new Dimension();
        int n = 0;
        int n2 = 0;
        while ((string = this.getLine(n2)) != null) {
            ++n2;
            n = fontMetrics.stringWidth(string);
            if (n <= dimension.width) continue;
            dimension.width = n;
        }
        dimension.height = n2 * fontMetrics.getHeight();
        return dimension;
    }

    public String getLine(int n) {
        if (n < this.m_lines.size()) {
            return (String)this.m_lines.elementAt(n);
        }
        return null;
    }

    public double getCenter() {
        return this.m_center;
    }

    public void setCenter(double d) {
        this.m_center = d;
    }

    public void adjustCenter(double d) {
        this.m_center += d;
    }

    public double getTop() {
        return this.m_top;
    }

    public void setTop(double d) {
        this.m_top = d;
    }

    public boolean getVisible() {
        return this.m_visible;
    }

    private void setVisible(boolean bl) {
        this.m_visible = bl;
    }

    public boolean getRoot() {
        return this.m_root;
    }

    public void setRoot(boolean bl) {
        this.m_root = bl;
    }

    public Edge getParent(int n) {
        if (n < this.m_parent.size()) {
            return (Edge)this.m_parent.elementAt(n);
        }
        return null;
    }

    public void setParent(Edge edge) {
        this.m_parent.addElement(edge);
    }

    public Edge getChild(int n) {
        if (n < this.m_children.size()) {
            return (Edge)this.m_children.elementAt(n);
        }
        return null;
    }

    public void addChild(Edge edge) {
        this.m_children.addElement(edge);
    }

    public static int getGCount(Node node, int n) {
        if (node.getChild(0) != null && node.getCVisible()) {
            Edge edge;
            ++n;
            int n2 = 0;
            while ((edge = node.getChild(n2)) != null) {
                n = Node.getGCount(edge.getTarget(), n);
                ++n2;
            }
        }
        return n;
    }

    public static int getTotalGCount(Node node, int n) {
        if (node.getChild(0) != null) {
            Edge edge;
            ++n;
            int n2 = 0;
            while ((edge = node.getChild(n2)) != null) {
                n = Node.getTotalGCount(edge.getTarget(), n);
                ++n2;
            }
        }
        return n;
    }

    public static int getCount(Node node, int n) {
        Edge edge;
        ++n;
        int n2 = 0;
        while ((edge = node.getChild(n2)) != null && node.getCVisible()) {
            n = Node.getCount(edge.getTarget(), n);
            ++n2;
        }
        return n;
    }

    public static int getTotalCount(Node node, int n) {
        Edge edge;
        ++n;
        int n2 = 0;
        while ((edge = node.getChild(n2)) != null) {
            n = Node.getTotalCount(edge.getTarget(), n);
            ++n2;
        }
        return n;
    }

    public static int getHeight(Node node, int n) {
        Edge edge;
        int n2 = ++n;
        int n3 = 0;
        int n4 = 0;
        while ((edge = node.getChild(n4)) != null && node.getCVisible()) {
            n3 = Node.getHeight(edge.getTarget(), n);
            if (n3 > n2) {
                n2 = n3;
            }
            ++n4;
        }
        return n2;
    }

    public static int getTotalHeight(Node node, int n) {
        Edge edge;
        int n2 = ++n;
        int n3 = 0;
        int n4 = 0;
        while ((edge = node.getChild(n4)) != null) {
            n3 = Node.getTotalHeight(edge.getTarget(), n);
            if (n3 > n2) {
                n2 = n3;
            }
            ++n4;
        }
        return n2;
    }
}

