/*
 * Decompiled with CFR 0.152.
 */
package weka.classifiers.trees.ft;

import weka.classifiers.functions.SimpleLinearRegression;
import weka.classifiers.trees.ft.FTtree;
import weka.classifiers.trees.j48.C45ModelSelection;
import weka.classifiers.trees.j48.C45Split;
import weka.classifiers.trees.j48.NoSplit;
import weka.core.Attribute;
import weka.core.Instance;
import weka.core.Instances;
import weka.core.RevisionUtils;
import weka.core.Utils;

public class FTInnerNode
extends FTtree {
    private static final long serialVersionUID = -1125334488640233181L;

    public FTInnerNode(boolean bl, int n, int n2, double d, boolean bl2) {
        this.m_errorOnProbabilities = bl;
        this.m_fixedNumIterations = n;
        this.m_minNumInstances = n2;
        this.m_maxIterations = 200;
        this.setWeightTrimBeta(d);
        this.setUseAIC(bl2);
    }

    public void buildClassifier(Instances instances) throws Exception {
        instances = this.insertNewAttr(instances);
        this.buildTree(instances, null, instances.numInstances(), 0.0);
    }

    public void buildTree(Instances instances, SimpleLinearRegression[][] simpleLinearRegressionArray, double d, double d2) throws Exception {
        this.m_totalInstanceWeight = d;
        this.m_train = new Instances(instances);
        this.m_train = this.removeExtAttributes(this.m_train);
        this.m_isLeaf = true;
        this.m_sons = null;
        this.m_numInstances = this.m_train.numInstances();
        this.m_numClasses = this.m_train.numClasses();
        this.m_numericData = this.getNumericData(this.m_train);
        this.m_numericDataHeader = new Instances(this.m_numericData, 0);
        this.m_regressions = this.initRegressions();
        this.m_numRegressions = 0;
        this.m_higherRegressions = simpleLinearRegressionArray != null ? simpleLinearRegressionArray : new SimpleLinearRegression[this.m_numClasses][0];
        this.m_numHigherRegressions = this.m_higherRegressions[0].length;
        this.m_numParameters = d2;
        if (this.m_numInstances >= m_numFoldsBoosting) {
            if (this.m_fixedNumIterations > 0) {
                this.performBoosting(this.m_fixedNumIterations);
            } else if (this.getUseAIC()) {
                this.performBoostingInfCriterion();
            } else {
                this.performBoostingCV();
            }
        }
        this.m_numParameters += (double)this.m_numRegressions;
        this.m_regressions = this.selectRegressions(this.m_regressions);
        double[][] dArray = this.getFs(this.m_numericData);
        for (int i = 0; i < instances.numInstances(); ++i) {
            double[] dArray2 = this.probs(dArray[i]);
            if (instances.instance(i).classValue() != (double)this.getConstError(dArray2)) {
                this.m_constError += 1.0;
            }
            for (int j = 0; j < instances.classAttribute().numValues(); ++j) {
                instances.instance(i).setValue(j, dArray2[j]);
            }
        }
        this.m_modelSelection = new C45ModelSelection(this.m_minNumInstances, instances);
        this.m_localModel = this.m_modelSelection.selectModel(instances);
        boolean bl = this.m_numInstances > this.m_minNumInstances ? this.m_localModel.numSubsets() > 1 : false;
        this.m_hasConstr = false;
        this.m_train = instances;
        if (bl) {
            this.m_isLeaf = false;
            Instances[] instancesArray = this.m_localModel.split(instances);
            if (((C45Split)this.m_localModel).attIndex() >= 0 && ((C45Split)this.m_localModel).attIndex() < instances.classAttribute().numValues()) {
                this.m_hasConstr = true;
            }
            this.m_sons = new FTInnerNode[this.m_localModel.numSubsets()];
            for (int i = 0; i < this.m_sons.length; ++i) {
                this.m_sons[i] = new FTInnerNode(this.m_errorOnProbabilities, this.m_fixedNumIterations, this.m_minNumInstances, this.getWeightTrimBeta(), this.getUseAIC());
                this.m_sons[i].buildTree(instancesArray[i], this.mergeArrays(this.m_regressions, this.m_higherRegressions), this.m_totalInstanceWeight, this.m_numParameters);
                instancesArray[i] = null;
            }
        } else {
            this.m_leafclass = this.m_localModel.distribution().maxClass();
        }
    }

    public double prune() throws Exception {
        double d = 0.0;
        double d2 = this.getEstimatedErrorsForDistribution(this.m_localModel.distribution());
        if (this.m_isLeaf) {
            return d2;
        }
        double d3 = this.getEtimateConstModel(this.m_localModel.distribution());
        double d4 = 0.0;
        for (int i = 0; i < this.m_sons.length; ++i) {
            double d5 = this.m_localModel.distribution().perBag(i) / this.m_localModel.distribution().total();
            d4 += d5 * this.m_sons[i].prune();
        }
        if (Utils.smOrEq(d2, d4)) {
            this.m_sons = null;
            this.m_isLeaf = true;
            this.m_hasConstr = false;
            this.m_leafclass = this.m_localModel.distribution().maxClass();
            this.m_localModel = new NoSplit(this.m_localModel.distribution());
            d = d2;
        } else {
            d = d4;
        }
        return d;
    }

    public double[] distributionForInstance(Instance instance) throws Exception {
        double[] dArray;
        if (this.m_isLeaf && this.m_hasConstr) {
            dArray = this.modelDistributionForInstance(instance);
        } else if (this.m_isLeaf && !this.m_hasConstr) {
            dArray = new double[instance.numClasses()];
            dArray[this.m_leafclass] = 1.0;
        } else {
            int n;
            dArray = this.modelDistributionForInstance(instance);
            Instance instance2 = new Instance(instance.numAttributes() + instance.numClasses());
            instance2.setDataset(instance.dataset());
            for (n = 0; n < instance.numClasses(); ++n) {
                instance2.dataset().insertAttributeAt(new Attribute("N" + (instance.numClasses() - n)), 0);
                instance2.setValue(n, dArray[n]);
            }
            for (n = 0; n < instance.numAttributes(); ++n) {
                instance2.setValue(n + instance.numClasses(), instance.value(n));
            }
            n = this.m_localModel.whichSubset(instance2);
            for (int i = 0; i < instance.numClasses(); ++i) {
                instance2.dataset().deleteAttributeAt(0);
            }
            dArray = this.m_sons[n].distributionForInstance(instance);
        }
        return dArray;
    }

    public String getRevision() {
        return RevisionUtils.extract("$Revision: 1.4 $");
    }
}

