/*
 * Decompiled with CFR 0.152.
 */
package weka.classifiers;

import java.beans.BeanInfo;
import java.beans.IntrospectionException;
import java.beans.Introspector;
import java.beans.MethodDescriptor;
import java.beans.PropertyDescriptor;
import java.beans.PropertyEditor;
import java.beans.PropertyEditorManager;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import weka.classifiers.Classifier;
import weka.core.RevisionHandler;
import weka.core.RevisionUtils;
import weka.core.Utils;
import weka.gui.GenericObjectEditor;

public class EnsembleLibraryModel
implements Serializable,
RevisionHandler {
    private static final long serialVersionUID = 7932816660173443200L;
    protected Classifier m_Classifier;
    protected String m_DescriptionText;
    protected String m_ErrorText;
    protected boolean m_OptionsWereValid;
    protected String m_StringRepresentation;

    public EnsembleLibraryModel() {
    }

    public EnsembleLibraryModel(Classifier classifier) {
        this.m_Classifier = classifier;
        this.m_StringRepresentation = this.toString();
        this.updateDescriptionText();
    }

    public void testOptions() {
        Classifier classifier = null;
        try {
            classifier = (Classifier)this.m_Classifier.getClass().newInstance();
        }
        catch (InstantiationException instantiationException) {
            instantiationException.printStackTrace();
        }
        catch (IllegalAccessException illegalAccessException) {
            illegalAccessException.printStackTrace();
        }
        this.setOptionsWereValid(true);
        this.setErrorText(null);
        this.updateDescriptionText();
        try {
            classifier.setOptions(this.m_Classifier.getOptions());
        }
        catch (Exception exception) {
            this.setOptionsWereValid(false);
            this.setErrorText(exception.getMessage());
        }
        this.updateDescriptionText();
    }

    public Classifier getClassifier() {
        return this.m_Classifier;
    }

    public String getStringRepresentation() {
        return this.m_StringRepresentation;
    }

    public void setDescriptionText(String string) {
        this.m_DescriptionText = string;
    }

    public String getDescriptionText() {
        return this.m_DescriptionText;
    }

    public void setErrorText(String string) {
        this.m_ErrorText = string;
    }

    public String getErrorText() {
        return this.m_ErrorText;
    }

    public void setOptionsWereValid(boolean bl) {
        this.m_OptionsWereValid = bl;
    }

    public boolean getOptionsWereValid() {
        return this.m_OptionsWereValid;
    }

    public String toString() {
        String string = this.m_Classifier.getClass().getName();
        string = string + " " + Utils.joinOptions(this.m_Classifier.getOptions());
        return string;
    }

    public Class getModelClass() {
        return this.m_Classifier.getClass();
    }

    public String[] getOptions() {
        return this.m_Classifier.getOptions();
    }

    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        objectOutputStream.writeObject(this.m_Classifier);
        objectOutputStream.writeObject(this.m_DescriptionText);
        objectOutputStream.writeObject(this.m_ErrorText);
        objectOutputStream.writeObject(new Boolean(this.m_OptionsWereValid));
        objectOutputStream.writeObject(this.m_StringRepresentation);
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        this.m_Classifier = (Classifier)objectInputStream.readObject();
        this.m_DescriptionText = (String)objectInputStream.readObject();
        this.m_ErrorText = (String)objectInputStream.readObject();
        this.m_OptionsWereValid = (Boolean)objectInputStream.readObject();
        this.m_StringRepresentation = (String)objectInputStream.readObject();
    }

    public void updateDescriptionText() {
        String string = new String("<html>");
        if (!this.m_OptionsWereValid) {
            string = string + "<font COLOR=\"#FF0000\"><b>Invalid Model:</b><br>" + this.m_ErrorText + "<br></font>";
        }
        string = string + "<TABLE>";
        PropertyDescriptor[] propertyDescriptorArray = null;
        MethodDescriptor[] methodDescriptorArray = null;
        try {
            BeanInfo beanInfo = Introspector.getBeanInfo(this.m_Classifier.getClass());
            propertyDescriptorArray = beanInfo.getPropertyDescriptors();
            methodDescriptorArray = beanInfo.getMethodDescriptors();
        }
        catch (IntrospectionException introspectionException) {
            System.err.println("LibraryModel: Couldn't introspect");
            return;
        }
        for (int i = 0; i < propertyDescriptorArray.length; ++i) {
            if (propertyDescriptorArray[i].isHidden() || propertyDescriptorArray[i].isExpert()) continue;
            String string2 = propertyDescriptorArray[i].getDisplayName();
            Class<?> clazz = propertyDescriptorArray[i].getPropertyType();
            Method method = propertyDescriptorArray[i].getReadMethod();
            Method method2 = propertyDescriptorArray[i].getWriteMethod();
            if (method == null || method2 == null) continue;
            try {
                Object[] objectArray = new Object[]{};
                Object object = method.invoke((Object)this.m_Classifier, objectArray);
                PropertyEditor propertyEditor = null;
                Class<?> clazz2 = propertyDescriptorArray[i].getPropertyEditorClass();
                if (clazz2 != null) {
                    try {
                        propertyEditor = (PropertyEditor)clazz2.newInstance();
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
                if (propertyEditor == null) {
                    propertyEditor = PropertyEditorManager.findEditor(clazz);
                }
                if (propertyEditor == null) continue;
                if (propertyEditor instanceof GenericObjectEditor) {
                    ((GenericObjectEditor)propertyEditor).setClassType(clazz);
                }
                if (object == null) continue;
                string = string + "<TR><TD>" + string2 + "</TD><TD>" + object.toString() + "</TD></TR>";
                continue;
            }
            catch (InvocationTargetException invocationTargetException) {
                System.err.println("Skipping property " + string2 + " ; exception on target: " + invocationTargetException.getTargetException());
                invocationTargetException.getTargetException().printStackTrace();
                continue;
            }
            catch (Exception exception) {
                System.err.println("Skipping property " + string2 + " ; exception: " + exception);
                exception.printStackTrace();
            }
        }
        string = string + "</TABLE>";
        this.m_DescriptionText = string = string + "</html>";
    }

    public String getRevision() {
        return RevisionUtils.extract("$Revision: 1.2 $");
    }
}

