/*
 * Decompiled with CFR 0.152.
 */
package weka.clusterers;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.text.DecimalFormat;
import java.util.Calendar;
import java.util.Enumeration;
import java.util.GregorianCalendar;
import java.util.List;
import java.util.Vector;
import weka.clusterers.AbstractClusterer;
import weka.clusterers.forOPTICSAndDBScan.DataObjects.DataObject;
import weka.clusterers.forOPTICSAndDBScan.DataObjects.EuclidianDataObject;
import weka.clusterers.forOPTICSAndDBScan.Databases.Database;
import weka.clusterers.forOPTICSAndDBScan.Databases.SequentialDatabase;
import weka.clusterers.forOPTICSAndDBScan.OPTICS_GUI.OPTICS_Visualizer;
import weka.clusterers.forOPTICSAndDBScan.OPTICS_GUI.SERObject;
import weka.clusterers.forOPTICSAndDBScan.Utils.EpsilonRange_ListElement;
import weka.clusterers.forOPTICSAndDBScan.Utils.UpdateQueue;
import weka.clusterers.forOPTICSAndDBScan.Utils.UpdateQueueElement;
import weka.core.Capabilities;
import weka.core.FastVector;
import weka.core.Instance;
import weka.core.Instances;
import weka.core.Option;
import weka.core.OptionHandler;
import weka.core.RevisionUtils;
import weka.core.TechnicalInformation;
import weka.core.TechnicalInformationHandler;
import weka.core.Utils;
import weka.filters.Filter;
import weka.filters.unsupervised.attribute.ReplaceMissingValues;

public class OPTICS
extends AbstractClusterer
implements OptionHandler,
TechnicalInformationHandler {
    static final long serialVersionUID = 274552680222105221L;
    private double epsilon = 0.9;
    private int minPoints = 6;
    private ReplaceMissingValues replaceMissingValues_Filter;
    private int numberOfGeneratedClusters;
    private String database_distanceType = "weka.clusterers.forOPTICSAndDBScan.DataObjects.EuclidianDataObject";
    private String database_Type = "weka.clusterers.forOPTICSAndDBScan.Databases.SequentialDatabase";
    private Database database;
    private double elapsedTime;
    private boolean writeOPTICSresults = false;
    private FastVector resultVector;
    private boolean showGUI = true;
    private File databaseOutput = new File(".");

    public Capabilities getCapabilities() {
        Capabilities capabilities = super.getCapabilities();
        capabilities.disableAll();
        capabilities.enable(Capabilities.Capability.NO_CLASS);
        capabilities.enable(Capabilities.Capability.NOMINAL_ATTRIBUTES);
        capabilities.enable(Capabilities.Capability.NUMERIC_ATTRIBUTES);
        capabilities.enable(Capabilities.Capability.DATE_ATTRIBUTES);
        capabilities.enable(Capabilities.Capability.MISSING_VALUES);
        return capabilities;
    }

    public void buildClusterer(Instances instances) throws Exception {
        Object object;
        Object object2;
        Object object3;
        this.getCapabilities().testWithFail(instances);
        this.resultVector = new FastVector();
        long l = System.currentTimeMillis();
        this.numberOfGeneratedClusters = 0;
        this.replaceMissingValues_Filter = new ReplaceMissingValues();
        this.replaceMissingValues_Filter.setInputFormat(instances);
        Instances instances2 = Filter.useFilter(instances, this.replaceMissingValues_Filter);
        this.database = this.databaseForName(this.getDatabase_Type(), instances2);
        for (int i = 0; i < this.database.getInstances().numInstances(); ++i) {
            object3 = this.dataObjectForName(this.getDatabase_distanceType(), this.database.getInstances().instance(i), Integer.toString(i), this.database);
            this.database.insert((DataObject)object3);
        }
        this.database.setMinMaxValues();
        UpdateQueue updateQueue = new UpdateQueue();
        object3 = this.database.dataObjectIterator();
        while (object3.hasNext()) {
            DataObject dataObject = (DataObject)object3.next();
            if (dataObject.isProcessed()) continue;
            this.expandClusterOrder(dataObject, updateQueue);
        }
        long l2 = System.currentTimeMillis();
        this.elapsedTime = (double)(l2 - l) / 1000.0;
        if (this.writeOPTICSresults) {
            object2 = "";
            object = new GregorianCalendar();
            String string = ((Calendar)object).get(5) + "-" + (((Calendar)object).get(2) + 1) + "-" + ((Calendar)object).get(1) + "--" + ((Calendar)object).get(11) + "-" + ((Calendar)object).get(12) + "-" + ((Calendar)object).get(13);
            object2 = "OPTICS_" + string + ".TXT";
            FileWriter fileWriter = new FileWriter((String)object2);
            BufferedWriter bufferedWriter = new BufferedWriter(fileWriter);
            for (int i = 0; i < this.resultVector.size(); ++i) {
                bufferedWriter.write(this.format_dataObject((DataObject)this.resultVector.elementAt(i)));
            }
            bufferedWriter.flush();
            bufferedWriter.close();
        }
        if (!this.databaseOutput.isDirectory()) {
            try {
                object2 = new FileOutputStream(this.databaseOutput);
                object = new ObjectOutputStream((OutputStream)object2);
                ((ObjectOutputStream)object).writeObject(this.getSERObject());
                ((ObjectOutputStream)object).flush();
                ((ObjectOutputStream)object).close();
                ((FileOutputStream)object2).close();
            }
            catch (Exception exception) {
                System.err.println("Error writing generated database to file '" + this.getDatabaseOutput() + "': " + exception);
                exception.printStackTrace();
            }
        }
        if (this.showGUI) {
            new OPTICS_Visualizer(this.getSERObject(), "OPTICS Visualizer - Main Window");
        }
    }

    private void expandClusterOrder(DataObject dataObject, UpdateQueue updateQueue) {
        List list = this.database.coreDistance(this.getMinPoints(), this.getEpsilon(), dataObject);
        List list2 = (List)list.get(1);
        dataObject.setReachabilityDistance(2.147483647E9);
        dataObject.setCoreDistance((Double)list.get(2));
        dataObject.setProcessed(true);
        this.resultVector.addElement(dataObject);
        if (dataObject.getCoreDistance() != 2.147483647E9) {
            this.update(updateQueue, list2, dataObject);
            while (updateQueue.hasNext()) {
                UpdateQueueElement updateQueueElement = updateQueue.next();
                DataObject dataObject2 = (DataObject)updateQueueElement.getObject();
                dataObject2.setReachabilityDistance(updateQueueElement.getPriority());
                List list3 = this.database.coreDistance(this.getMinPoints(), this.getEpsilon(), dataObject2);
                List list4 = (List)list3.get(1);
                dataObject2.setCoreDistance((Double)list3.get(2));
                dataObject2.setProcessed(true);
                this.resultVector.addElement(dataObject2);
                if (dataObject2.getCoreDistance() == 2.147483647E9) continue;
                this.update(updateQueue, list4, dataObject2);
            }
        }
    }

    private String format_dataObject(DataObject dataObject) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("(" + Utils.doubleToString(Double.parseDouble(dataObject.getKey()), Integer.toString(this.database.size()).length(), 0) + ".) " + Utils.padRight(dataObject.toString(), 40) + "  -->  c_dist: " + (dataObject.getCoreDistance() == 2.147483647E9 ? Utils.padRight("UNDEFINED", 12) : Utils.padRight(Utils.doubleToString(dataObject.getCoreDistance(), 2, 3), 12)) + " r_dist: " + (dataObject.getReachabilityDistance() == 2.147483647E9 ? Utils.padRight("UNDEFINED", 12) : Utils.doubleToString(dataObject.getReachabilityDistance(), 2, 3)) + "\n");
        return stringBuffer.toString();
    }

    private void update(UpdateQueue updateQueue, List list, DataObject dataObject) {
        double d = dataObject.getCoreDistance();
        double d2 = 2.147483647E9;
        for (int i = 0; i < list.size(); ++i) {
            EpsilonRange_ListElement epsilonRange_ListElement = (EpsilonRange_ListElement)list.get(i);
            DataObject dataObject2 = epsilonRange_ListElement.getDataObject();
            if (dataObject2.isProcessed()) continue;
            d2 = Math.max(d, epsilonRange_ListElement.getDistance());
            updateQueue.add(d2, dataObject2, dataObject2.getKey());
        }
    }

    public int clusterInstance(Instance instance) throws Exception {
        throw new Exception();
    }

    public int numberOfClusters() throws Exception {
        return this.numberOfGeneratedClusters;
    }

    public Enumeration listOptions() {
        Vector<Option> vector = new Vector<Option>();
        vector.addElement(new Option("\tepsilon (default = 0.9)", "E", 1, "-E <double>"));
        vector.addElement(new Option("\tminPoints (default = 6)", "M", 1, "-M <int>"));
        vector.addElement(new Option("\tindex (database) used for OPTICS (default = weka.clusterers.forOPTICSAndDBScan.Databases.SequentialDatabase)", "I", 1, "-I <String>"));
        vector.addElement(new Option("\tdistance-type (default = weka.clusterers.forOPTICSAndDBScan.DataObjects.EuclidianDataObject)", "D", 1, "-D <String>"));
        vector.addElement(new Option("\twrite results to OPTICS_#TimeStamp#.TXT - File", "F", 0, "-F"));
        vector.addElement(new Option("\tsuppress the display of the GUI after building the clusterer", "no-gui", 0, "-no-gui"));
        vector.addElement(new Option("\tThe file to save the generated database to. If a directory\n\tis provided, the database doesn't get saved.\n\tThe generated file can be viewed with the OPTICS Visualizer:\n\t  java " + OPTICS_Visualizer.class.getName() + " [file.ser]\n" + "\t(default: .)", "db-output", 1, "-db-output <file>"));
        return vector.elements();
    }

    public void setOptions(String[] stringArray) throws Exception {
        String string = Utils.getOption('E', stringArray);
        if (string.length() != 0) {
            this.setEpsilon(Double.parseDouble(string));
        } else {
            this.setEpsilon(0.9);
        }
        string = Utils.getOption('M', stringArray);
        if (string.length() != 0) {
            this.setMinPoints(Integer.parseInt(string));
        } else {
            this.setMinPoints(6);
        }
        string = Utils.getOption('I', stringArray);
        if (string.length() != 0) {
            this.setDatabase_Type(string);
        } else {
            this.setDatabase_Type(SequentialDatabase.class.getName());
        }
        string = Utils.getOption('D', stringArray);
        if (string.length() != 0) {
            this.setDatabase_distanceType(string);
        } else {
            this.setDatabase_distanceType(EuclidianDataObject.class.getName());
        }
        this.setWriteOPTICSresults(Utils.getFlag('F', stringArray));
        this.setShowGUI(!Utils.getFlag("no-gui", stringArray));
        string = Utils.getOption("db-output", stringArray);
        if (string.length() != 0) {
            this.setDatabaseOutput(new File(string));
        } else {
            this.setDatabaseOutput(new File("."));
        }
    }

    public String[] getOptions() {
        Vector<String> vector = new Vector<String>();
        vector.add("-E");
        vector.add("" + this.getEpsilon());
        vector.add("-M");
        vector.add("" + this.getMinPoints());
        vector.add("-I");
        vector.add("" + this.getDatabase_Type());
        vector.add("-D");
        vector.add("" + this.getDatabase_distanceType());
        if (this.getWriteOPTICSresults()) {
            vector.add("-F");
        }
        if (!this.getShowGUI()) {
            vector.add("-no-gui");
        }
        vector.add("-db-output");
        vector.add("" + this.getDatabaseOutput());
        return vector.toArray(new String[vector.size()]);
    }

    public Database databaseForName(String string, Instances instances) {
        Object var3_3 = null;
        Constructor<?> constructor = null;
        try {
            constructor = Class.forName(string).getConstructor(Instances.class);
            var3_3 = constructor.newInstance(instances);
        }
        catch (NoSuchMethodException noSuchMethodException) {
            noSuchMethodException.printStackTrace();
        }
        catch (SecurityException securityException) {
            securityException.printStackTrace();
        }
        catch (ClassNotFoundException classNotFoundException) {
            classNotFoundException.printStackTrace();
        }
        catch (InstantiationException instantiationException) {
            instantiationException.printStackTrace();
        }
        catch (IllegalAccessException illegalAccessException) {
            illegalAccessException.printStackTrace();
        }
        catch (InvocationTargetException invocationTargetException) {
            invocationTargetException.printStackTrace();
        }
        return var3_3;
    }

    public DataObject dataObjectForName(String string, Instance instance, String string2, Database database) {
        Object var5_5 = null;
        Constructor<?> constructor = null;
        try {
            constructor = Class.forName(string).getConstructor(Instance.class, String.class, Database.class);
            var5_5 = constructor.newInstance(instance, string2, database);
        }
        catch (NoSuchMethodException noSuchMethodException) {
            noSuchMethodException.printStackTrace();
        }
        catch (SecurityException securityException) {
            securityException.printStackTrace();
        }
        catch (ClassNotFoundException classNotFoundException) {
            classNotFoundException.printStackTrace();
        }
        catch (InstantiationException instantiationException) {
            instantiationException.printStackTrace();
        }
        catch (IllegalAccessException illegalAccessException) {
            illegalAccessException.printStackTrace();
        }
        catch (InvocationTargetException invocationTargetException) {
            invocationTargetException.printStackTrace();
        }
        return var5_5;
    }

    public void setMinPoints(int n) {
        this.minPoints = n;
    }

    public void setEpsilon(double d) {
        this.epsilon = d;
    }

    public double getEpsilon() {
        return this.epsilon;
    }

    public int getMinPoints() {
        return this.minPoints;
    }

    public String getDatabase_distanceType() {
        return this.database_distanceType;
    }

    public String getDatabase_Type() {
        return this.database_Type;
    }

    public void setDatabase_distanceType(String string) {
        this.database_distanceType = string;
    }

    public void setDatabase_Type(String string) {
        this.database_Type = string;
    }

    public boolean getWriteOPTICSresults() {
        return this.writeOPTICSresults;
    }

    public void setWriteOPTICSresults(boolean bl) {
        this.writeOPTICSresults = bl;
    }

    public boolean getShowGUI() {
        return this.showGUI;
    }

    public void setShowGUI(boolean bl) {
        this.showGUI = bl;
    }

    public File getDatabaseOutput() {
        return this.databaseOutput;
    }

    public void setDatabaseOutput(File file) {
        this.databaseOutput = file;
    }

    public FastVector getResultVector() {
        return this.resultVector;
    }

    public String epsilonTipText() {
        return "radius of the epsilon-range-queries";
    }

    public String minPointsTipText() {
        return "minimun number of DataObjects required in an epsilon-range-query";
    }

    public String database_TypeTipText() {
        return "used database";
    }

    public String database_distanceTypeTipText() {
        return "used distance-type";
    }

    public String writeOPTICSresultsTipText() {
        return "if the -F option is set, the results are written to OPTICS_#TimeStamp#.TXT";
    }

    public String showGUITipText() {
        return "Defines whether the OPTICS Visualizer is displayed after the clusterer has been built or not.";
    }

    public String databaseOutputTipText() {
        return "The optional output file for the generated database object - can be viewed with the OPTICS Visualizer.\njava " + OPTICS_Visualizer.class.getName() + " [file.ser]";
    }

    public String globalInfo() {
        return this.getTechnicalInformation().toString();
    }

    public TechnicalInformation getTechnicalInformation() {
        TechnicalInformation technicalInformation = new TechnicalInformation(TechnicalInformation.Type.INPROCEEDINGS);
        technicalInformation.setValue(TechnicalInformation.Field.AUTHOR, "Mihael Ankerst and Markus M. Breunig and Hans-Peter Kriegel and Joerg Sander");
        technicalInformation.setValue(TechnicalInformation.Field.TITLE, "OPTICS: Ordering Points To Identify the Clustering Structure");
        technicalInformation.setValue(TechnicalInformation.Field.BOOKTITLE, "ACM SIGMOD International Conference on Management of Data");
        technicalInformation.setValue(TechnicalInformation.Field.YEAR, "1999");
        technicalInformation.setValue(TechnicalInformation.Field.PAGES, "49-60");
        technicalInformation.setValue(TechnicalInformation.Field.PUBLISHER, "ACM Press");
        return technicalInformation;
    }

    public SERObject getSERObject() {
        SERObject sERObject = new SERObject(this.resultVector, this.database.size(), this.database.getInstances().numAttributes(), this.getEpsilon(), this.getMinPoints(), this.writeOPTICSresults, this.getDatabase_Type(), this.getDatabase_distanceType(), this.numberOfGeneratedClusters, Utils.doubleToString(this.elapsedTime, 3, 3));
        return sERObject;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("OPTICS clustering results\n============================================================================================\n\n");
        stringBuffer.append("Clustered DataObjects: " + this.database.size() + "\n");
        stringBuffer.append("Number of attributes: " + this.database.getInstances().numAttributes() + "\n");
        stringBuffer.append("Epsilon: " + this.getEpsilon() + "; minPoints: " + this.getMinPoints() + "\n");
        stringBuffer.append("Write results to file: " + (this.writeOPTICSresults ? "yes" : "no") + "\n");
        stringBuffer.append("Index: " + this.getDatabase_Type() + "\n");
        stringBuffer.append("Distance-type: " + this.getDatabase_distanceType() + "\n");
        stringBuffer.append("Number of generated clusters: " + this.numberOfGeneratedClusters + "\n");
        DecimalFormat decimalFormat = new DecimalFormat(".##");
        stringBuffer.append("Elapsed time: " + decimalFormat.format(this.elapsedTime) + "\n\n");
        for (int i = 0; i < this.resultVector.size(); ++i) {
            stringBuffer.append(this.format_dataObject((DataObject)this.resultVector.elementAt(i)));
        }
        return stringBuffer.toString() + "\n";
    }

    public String getRevision() {
        return RevisionUtils.extract("$Revision: 5538 $");
    }

    public static void main(String[] stringArray) {
        OPTICS.runClusterer(new OPTICS(), stringArray);
    }
}

