/*
 * Decompiled with CFR 0.152.
 */
package weka.filters;

import weka.core.Capabilities;
import weka.core.Instance;
import weka.core.Instances;
import weka.core.RevisionUtils;
import weka.filters.Filter;
import weka.filters.Sourcable;

public class AllFilter
extends Filter
implements Sourcable {
    static final long serialVersionUID = 5022109283147503266L;

    public String globalInfo() {
        return "An instance filter that passes all instances through unmodified. Primarily for testing purposes.";
    }

    public Capabilities getCapabilities() {
        Capabilities capabilities = super.getCapabilities();
        capabilities.disableAll();
        capabilities.enableAllAttributes();
        capabilities.enable(Capabilities.Capability.MISSING_VALUES);
        capabilities.enableAllClasses();
        capabilities.enable(Capabilities.Capability.MISSING_CLASS_VALUES);
        capabilities.enable(Capabilities.Capability.NO_CLASS);
        return capabilities;
    }

    public boolean setInputFormat(Instances instances) throws Exception {
        super.setInputFormat(instances);
        this.setOutputFormat(instances);
        return true;
    }

    public boolean input(Instance instance) {
        if (this.getInputFormat() == null) {
            throw new IllegalStateException("No input instance format defined");
        }
        if (this.m_NewBatch) {
            this.resetQueue();
            this.m_NewBatch = false;
        }
        this.push((Instance)instance.copy());
        return true;
    }

    public String toSource(String string, Instances instances) throws Exception {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("class " + string + " {\n");
        stringBuffer.append("\n");
        stringBuffer.append("  /**\n");
        stringBuffer.append("   * filters a single row\n");
        stringBuffer.append("   * \n");
        stringBuffer.append("   * @param i the row to process\n");
        stringBuffer.append("   * @return the processed row\n");
        stringBuffer.append("   */\n");
        stringBuffer.append("  public static Object[] filter(Object[] i) {\n");
        stringBuffer.append("    return i;\n");
        stringBuffer.append("  }\n");
        stringBuffer.append("\n");
        stringBuffer.append("  /**\n");
        stringBuffer.append("   * filters multiple rows\n");
        stringBuffer.append("   * \n");
        stringBuffer.append("   * @param i the rows to process\n");
        stringBuffer.append("   * @return the processed rows\n");
        stringBuffer.append("   */\n");
        stringBuffer.append("  public static Object[][] filter(Object[][] i) {\n");
        stringBuffer.append("    return i;\n");
        stringBuffer.append("  }\n");
        stringBuffer.append("}\n");
        return stringBuffer.toString();
    }

    public String getRevision() {
        return RevisionUtils.extract("$Revision: 5550 $");
    }

    public static void main(String[] stringArray) {
        AllFilter.runFilter(new AllFilter(), stringArray);
    }
}

