/*
 * Decompiled with CFR 0.152.
 */
package weka.gui.sql;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Toolkit;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.StringSelection;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import weka.gui.ComponentHelper;
import weka.gui.sql.InfoPanelCellRenderer;

public class InfoPanel
extends JPanel {
    private static final long serialVersionUID = -7701133696481997973L;
    protected JFrame m_Parent;
    protected JList m_Info;
    protected DefaultListModel m_Model;
    protected JButton m_ButtonClear;
    protected JButton m_ButtonCopy;

    public InfoPanel(JFrame jFrame) {
        this.m_Parent = jFrame;
        this.createPanel();
    }

    protected void createPanel() {
        this.setLayout(new BorderLayout());
        this.setPreferredSize(new Dimension(0, 80));
        this.m_Model = new DefaultListModel();
        this.m_Info = new JList(this.m_Model);
        this.m_Info.setCellRenderer(new InfoPanelCellRenderer());
        this.m_Info.addListSelectionListener(new ListSelectionListener(){

            public void valueChanged(ListSelectionEvent listSelectionEvent) {
                InfoPanel.this.setButtons(listSelectionEvent);
            }
        });
        this.add((Component)new JScrollPane(this.m_Info), "Center");
        JPanel jPanel = new JPanel(new BorderLayout());
        this.add((Component)jPanel, "East");
        this.m_ButtonClear = new JButton("Clear");
        this.m_ButtonClear.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                InfoPanel.this.clear();
            }
        });
        jPanel.add((Component)this.m_ButtonClear, "North");
        JPanel jPanel2 = new JPanel(new BorderLayout());
        jPanel.add((Component)jPanel2, "Center");
        this.m_ButtonCopy = new JButton("Copy");
        this.m_ButtonCopy.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                InfoPanel.this.copyToClipboard();
            }
        });
        jPanel2.add((Component)this.m_ButtonCopy, "North");
    }

    protected void setButtons(ListSelectionEvent listSelectionEvent) {
        if (listSelectionEvent == null || listSelectionEvent.getSource() == this.m_Info) {
            this.m_ButtonClear.setEnabled(this.m_Model.getSize() > 0);
            this.m_ButtonCopy.setEnabled(this.m_Info.getSelectedIndices().length == 1);
        }
    }

    public void setFocus() {
        this.m_Info.requestFocus();
    }

    public void clear() {
        this.m_Model.clear();
        this.setButtons(null);
    }

    public boolean copyToClipboard() {
        if (this.m_Info.getSelectedIndices().length != 1) {
            return false;
        }
        StringSelection stringSelection = new StringSelection(((JLabel)this.m_Info.getSelectedValue()).getText());
        Clipboard clipboard = Toolkit.getDefaultToolkit().getSystemClipboard();
        clipboard.setContents(stringSelection, stringSelection);
        return true;
    }

    public void append(String string, String string2) {
        this.append(new JLabel(string, ComponentHelper.getImageIcon(string2), 2));
    }

    public void append(Object object) {
        if (object instanceof String) {
            this.append(object.toString(), "empty_small.gif");
            return;
        }
        this.m_Model.addElement(object);
        this.m_Info.setSelectedIndex(this.m_Model.getSize() - 1);
        this.m_Info.ensureIndexIsVisible(this.m_Info.getSelectedIndex());
        this.setButtons(null);
    }
}

