/*
 * Decompiled with CFR 0.152.
 */
package weka.gui.visualize;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.BufferedReader;
import java.io.FileReader;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import weka.core.Attribute;
import weka.core.FastVector;
import weka.core.Instances;
import weka.gui.visualize.AttributePanelEvent;
import weka.gui.visualize.AttributePanelListener;
import weka.gui.visualize.Plot2D;
import weka.gui.visualize.VisualizeUtils;

public class AttributePanel
extends JScrollPane {
    private static final long serialVersionUID = 3533330317806757814L;
    protected Instances m_plotInstances = null;
    protected double m_maxC;
    protected double m_minC;
    protected int m_cIndex;
    protected int m_xIndex;
    protected int m_yIndex;
    protected FastVector m_colorList;
    protected Color[] m_DefaultColors = new Color[]{Color.blue, Color.red, Color.green, Color.cyan, Color.pink, new Color(255, 0, 255), Color.orange, new Color(255, 0, 0), new Color(0, 255, 0), Color.white};
    protected Color m_backgroundColor = null;
    protected FastVector m_Listeners = new FastVector();
    protected int[] m_heights;
    protected JPanel m_span = null;
    protected Color m_barColour = Color.black;

    private void setProperties() {
        String string;
        String string2;
        String string3;
        if (VisualizeUtils.VISUALIZE_PROPERTIES != null && (string3 = VisualizeUtils.VISUALIZE_PROPERTIES.getProperty(string2 = (string = this.getClass().getName()) + ".barColour")) != null) {
            this.m_barColour = VisualizeUtils.processColour(string3, this.m_barColour);
        }
    }

    public AttributePanel() {
        this((Color)null);
    }

    public AttributePanel(Color color) {
        this.m_backgroundColor = color;
        this.setProperties();
        this.setBackground(Color.blue);
        this.setVerticalScrollBarPolicy(22);
        this.m_colorList = new FastVector(10);
        for (int i = this.m_colorList.size(); i < 10; ++i) {
            Color color2 = this.m_DefaultColors[i % 10];
            int n = i / 10;
            n *= 2;
            for (int j = 0; j < n; ++j) {
                color2 = color2.darker();
            }
            this.m_colorList.addElement(color2);
        }
    }

    public void addAttributePanelListener(AttributePanelListener attributePanelListener) {
        this.m_Listeners.addElement(attributePanelListener);
    }

    public void setCindex(int n, double d, double d2) {
        this.m_cIndex = n;
        this.m_maxC = d;
        this.m_minC = d2;
        if (this.m_span != null) {
            if (this.m_plotInstances.numAttributes() > 0 && this.m_cIndex < this.m_plotInstances.numAttributes() && this.m_plotInstances.attribute(this.m_cIndex).isNominal() && this.m_plotInstances.attribute(this.m_cIndex).numValues() > this.m_colorList.size()) {
                this.extendColourMap();
            }
            this.repaint();
        }
    }

    public void setCindex(int n) {
        this.m_cIndex = n;
        if (this.m_span != null) {
            if (this.m_cIndex < this.m_plotInstances.numAttributes() && this.m_plotInstances.attribute(this.m_cIndex).isNumeric()) {
                double d = Double.POSITIVE_INFINITY;
                double d2 = Double.NEGATIVE_INFINITY;
                for (int i = 0; i < this.m_plotInstances.numInstances(); ++i) {
                    if (this.m_plotInstances.instance(i).isMissing(this.m_cIndex)) continue;
                    double d3 = this.m_plotInstances.instance(i).value(this.m_cIndex);
                    if (d3 < d) {
                        d = d3;
                    }
                    if (!(d3 > d2)) continue;
                    d2 = d3;
                }
                this.m_minC = d;
                this.m_maxC = d2;
            } else if (this.m_plotInstances.attribute(this.m_cIndex).numValues() > this.m_colorList.size()) {
                this.extendColourMap();
            }
            this.repaint();
        }
    }

    private void extendColourMap() {
        if (this.m_plotInstances.attribute(this.m_cIndex).isNominal()) {
            for (int i = this.m_colorList.size(); i < this.m_plotInstances.attribute(this.m_cIndex).numValues(); ++i) {
                Color color = this.m_DefaultColors[i % 10];
                int n = i / 10;
                n *= 2;
                for (int j = 0; j < n; ++j) {
                    color = color.brighter();
                }
                if (this.m_backgroundColor != null) {
                    color = Plot2D.checkAgainstBackground(color, this.m_backgroundColor);
                }
                this.m_colorList.addElement(color);
            }
        }
    }

    public void setColours(FastVector fastVector) {
        this.m_colorList = fastVector;
    }

    protected void setDefaultColourList(Color[] colorArray) {
        this.m_DefaultColors = colorArray;
    }

    public void setInstances(Instances instances) throws Exception {
        if (instances.numAttributes() > 512) {
            throw new Exception("Can't display more than 512 attributes!");
        }
        if (this.m_span == null) {
            this.m_span = new JPanel(){
                private static final long serialVersionUID = 7107576557995451922L;

                public void paintComponent(Graphics graphics) {
                    super.paintComponent(graphics);
                    graphics.setColor(Color.red);
                    if (AttributePanel.this.m_yIndex != AttributePanel.this.m_xIndex) {
                        graphics.drawString("X", 5, AttributePanel.this.m_xIndex * 20 + 16);
                        graphics.drawString("Y", 5, AttributePanel.this.m_yIndex * 20 + 16);
                    } else {
                        graphics.drawString("B", 5, AttributePanel.this.m_xIndex * 20 + 16);
                    }
                }
            };
        }
        this.m_span.removeAll();
        this.m_plotInstances = instances;
        if (instances.numInstances() > 0 && instances.numAttributes() > 0) {
            JPanel jPanel = new JPanel();
            JPanel jPanel2 = new JPanel();
            this.m_heights = new int[instances.numInstances()];
            this.m_cIndex = instances.numAttributes() - 1;
            for (int i = 0; i < instances.numInstances(); ++i) {
                this.m_heights[i] = (int)(Math.random() * 19.0);
            }
            this.m_span.setPreferredSize(new Dimension(this.m_span.getPreferredSize().width, (this.m_cIndex + 1) * 20));
            this.m_span.setMaximumSize(new Dimension(this.m_span.getMaximumSize().width, (this.m_cIndex + 1) * 20));
            GridBagLayout gridBagLayout = new GridBagLayout();
            GridBagLayout gridBagLayout2 = new GridBagLayout();
            GridBagConstraints gridBagConstraints = new GridBagConstraints();
            jPanel.setLayout(gridBagLayout);
            this.m_span.setLayout(gridBagLayout2);
            gridBagConstraints.anchor = 10;
            gridBagConstraints.gridx = 0;
            gridBagConstraints.gridy = 0;
            gridBagConstraints.weightx = 5.0;
            gridBagConstraints.fill = 2;
            gridBagConstraints.gridwidth = 1;
            gridBagConstraints.gridheight = 1;
            gridBagConstraints.insets = new Insets(0, 0, 0, 0);
            jPanel.add((Component)this.m_span, gridBagConstraints);
            gridBagConstraints.gridx = 0;
            gridBagConstraints.gridy = 1;
            gridBagConstraints.weightx = 5.0;
            gridBagConstraints.fill = 1;
            gridBagConstraints.gridwidth = 1;
            gridBagConstraints.gridheight = 1;
            gridBagConstraints.weighty = 5.0;
            gridBagConstraints.insets = new Insets(0, 0, 0, 0);
            jPanel.add((Component)jPanel2, gridBagConstraints);
            gridBagConstraints.weighty = 0.0;
            this.setViewportView(jPanel);
            gridBagConstraints.anchor = 10;
            gridBagConstraints.gridx = 0;
            gridBagConstraints.gridy = 0;
            gridBagConstraints.weightx = 5.0;
            gridBagConstraints.fill = 2;
            gridBagConstraints.gridwidth = 1;
            gridBagConstraints.gridheight = 1;
            gridBagConstraints.weighty = 5.0;
            gridBagConstraints.insets = new Insets(2, 20, 2, 4);
            int n = 0;
            while (n < instances.numAttributes()) {
                AttributeSpacing attributeSpacing = new AttributeSpacing(instances.attribute(n), n);
                gridBagConstraints.gridy = n++;
                this.m_span.add((Component)attributeSpacing, gridBagConstraints);
            }
        }
    }

    public void setX(int n) {
        if (this.m_span != null) {
            this.m_xIndex = n;
            this.m_span.repaint();
        }
    }

    public void setY(int n) {
        if (this.m_span != null) {
            this.m_yIndex = n;
            this.m_span.repaint();
        }
    }

    public static void main(String[] stringArray) {
        try {
            if (stringArray.length < 1) {
                System.err.println("Usage : weka.gui.visualize.AttributePanel <dataset> [class col]");
                System.exit(1);
            }
            final JFrame jFrame = new JFrame("Weka Explorer: Attribute");
            jFrame.setSize(100, 100);
            jFrame.getContentPane().setLayout(new BorderLayout());
            AttributePanel attributePanel = new AttributePanel();
            attributePanel.addAttributePanelListener(new AttributePanelListener(){

                public void attributeSelectionChange(AttributePanelEvent attributePanelEvent) {
                    if (attributePanelEvent.m_xChange) {
                        System.err.println("X index changed to : " + attributePanelEvent.m_indexVal);
                    } else {
                        System.err.println("Y index changed to : " + attributePanelEvent.m_indexVal);
                    }
                }
            });
            jFrame.getContentPane().add((Component)attributePanel, "Center");
            jFrame.addWindowListener(new WindowAdapter(){

                public void windowClosing(WindowEvent windowEvent) {
                    jFrame.dispose();
                    System.exit(0);
                }
            });
            if (stringArray.length >= 1) {
                System.err.println("Loading instances from " + stringArray[0]);
                BufferedReader bufferedReader = new BufferedReader(new FileReader(stringArray[0]));
                Instances instances = new Instances(bufferedReader);
                instances.setClassIndex(instances.numAttributes() - 1);
                attributePanel.setInstances(instances);
            }
            if (stringArray.length > 1) {
                attributePanel.setCindex(Integer.parseInt(stringArray[1]) - 1);
            } else {
                attributePanel.setCindex(0);
            }
            jFrame.setVisible(true);
        }
        catch (Exception exception) {
            exception.printStackTrace();
            System.err.println(exception.getMessage());
        }
    }

    protected class AttributeSpacing
    extends JPanel {
        private static final long serialVersionUID = 7220615894321679898L;
        protected double m_maxVal;
        protected double m_minVal;
        protected Attribute m_attrib;
        protected int m_attribIndex;
        protected int[] m_cached;
        protected boolean[][] m_pointDrawn;
        protected int m_oldWidth = -9000;

        public AttributeSpacing(Attribute attribute, int n) {
            this.m_attrib = attribute;
            this.m_attribIndex = n;
            this.setBackground(AttributePanel.this.m_barColour);
            this.setPreferredSize(new Dimension(0, 20));
            this.setMinimumSize(new Dimension(0, 20));
            this.m_cached = new int[AttributePanel.this.m_plotInstances.numInstances()];
            double d = Double.POSITIVE_INFINITY;
            double d2 = Double.NEGATIVE_INFINITY;
            if (AttributePanel.this.m_plotInstances.attribute(this.m_attribIndex).isNominal()) {
                this.m_minVal = 0.0;
                this.m_maxVal = AttributePanel.this.m_plotInstances.attribute(this.m_attribIndex).numValues() - 1;
            } else {
                for (int i = 0; i < AttributePanel.this.m_plotInstances.numInstances(); ++i) {
                    if (AttributePanel.this.m_plotInstances.instance(i).isMissing(this.m_attribIndex)) continue;
                    double d3 = AttributePanel.this.m_plotInstances.instance(i).value(this.m_attribIndex);
                    if (d3 < d) {
                        d = d3;
                    }
                    if (!(d3 > d2)) continue;
                    d2 = d3;
                }
                this.m_minVal = d;
                this.m_maxVal = d2;
                if (d == d2) {
                    this.m_maxVal += 0.05;
                    this.m_minVal -= 0.05;
                }
            }
            this.addMouseListener(new MouseAdapter(){

                public void mouseClicked(MouseEvent mouseEvent) {
                    block4: {
                        block3: {
                            if ((mouseEvent.getModifiers() & 0x10) != 16) break block3;
                            AttributePanel.this.setX(AttributeSpacing.this.m_attribIndex);
                            if (AttributePanel.this.m_Listeners.size() <= 0) break block4;
                            for (int i = 0; i < AttributePanel.this.m_Listeners.size(); ++i) {
                                AttributePanelListener attributePanelListener = (AttributePanelListener)AttributePanel.this.m_Listeners.elementAt(i);
                                attributePanelListener.attributeSelectionChange(new AttributePanelEvent(true, false, AttributeSpacing.this.m_attribIndex));
                            }
                            break block4;
                        }
                        AttributePanel.this.setY(AttributeSpacing.this.m_attribIndex);
                        if (AttributePanel.this.m_Listeners.size() > 0) {
                            for (int i = 0; i < AttributePanel.this.m_Listeners.size(); ++i) {
                                AttributePanelListener attributePanelListener = (AttributePanelListener)AttributePanel.this.m_Listeners.elementAt(i);
                                attributePanelListener.attributeSelectionChange(new AttributePanelEvent(false, true, AttributeSpacing.this.m_attribIndex));
                            }
                        }
                    }
                }
            });
        }

        private double convertToPanel(double d) {
            double d2 = (d - this.m_minVal) / (this.m_maxVal - this.m_minVal);
            double d3 = d2 * (double)(this.getWidth() - 10);
            return d3 + 4.0;
        }

        public void paintComponent(Graphics graphics) {
            block10: {
                int n;
                super.paintComponent(graphics);
                int n2 = this.getWidth();
                if (AttributePanel.this.m_plotInstances == null || AttributePanel.this.m_plotInstances.numAttributes() <= 0 || AttributePanel.this.m_plotInstances.numInstances() <= 0) break block10;
                if (this.m_oldWidth != n2) {
                    this.m_pointDrawn = new boolean[n2][20];
                    for (n = 0; n < AttributePanel.this.m_plotInstances.numInstances(); ++n) {
                        if (!AttributePanel.this.m_plotInstances.instance(n).isMissing(this.m_attribIndex) && !AttributePanel.this.m_plotInstances.instance(n).isMissing(AttributePanel.this.m_cIndex)) {
                            this.m_cached[n] = (int)this.convertToPanel(AttributePanel.this.m_plotInstances.instance(n).value(this.m_attribIndex));
                            if (this.m_pointDrawn[this.m_cached[n] % n2][AttributePanel.this.m_heights[n]]) {
                                this.m_cached[n] = -9000;
                                continue;
                            }
                            this.m_pointDrawn[this.m_cached[n] % n2][AttributePanel.this.m_heights[n]] = true;
                            continue;
                        }
                        this.m_cached[n] = -9000;
                    }
                    this.m_oldWidth = n2;
                }
                if (AttributePanel.this.m_plotInstances.attribute(AttributePanel.this.m_cIndex).isNominal()) {
                    for (n = 0; n < AttributePanel.this.m_plotInstances.numInstances(); ++n) {
                        if (this.m_cached[n] == -9000) continue;
                        int n3 = this.m_cached[n];
                        int n4 = AttributePanel.this.m_heights[n];
                        if (AttributePanel.this.m_plotInstances.attribute(this.m_attribIndex).isNominal()) {
                            n3 += (int)(Math.random() * 5.0) - 2;
                        }
                        int n5 = (int)AttributePanel.this.m_plotInstances.instance(n).value(AttributePanel.this.m_cIndex);
                        graphics.setColor((Color)AttributePanel.this.m_colorList.elementAt(n5 % AttributePanel.this.m_colorList.size()));
                        graphics.drawRect(n3, n4, 1, 1);
                    }
                } else {
                    for (int i = 0; i < AttributePanel.this.m_plotInstances.numInstances(); ++i) {
                        if (this.m_cached[i] == -9000) continue;
                        double d = (AttributePanel.this.m_plotInstances.instance(i).value(AttributePanel.this.m_cIndex) - AttributePanel.this.m_minC) / (AttributePanel.this.m_maxC - AttributePanel.this.m_minC);
                        d = d * 240.0 + 15.0;
                        graphics.setColor(new Color((int)d, 150, (int)(255.0 - d)));
                        int n6 = this.m_cached[i];
                        int n7 = AttributePanel.this.m_heights[i];
                        if (AttributePanel.this.m_plotInstances.attribute(this.m_attribIndex).isNominal()) {
                            n6 += (int)(Math.random() * 5.0) - 2;
                        }
                        graphics.drawRect(n6, n7, 1, 1);
                    }
                }
            }
        }
    }
}

