/*
 * Decompiled with CFR 0.152.
 */
package weka.classifiers.bayes;

import java.util.Enumeration;
import java.util.Vector;
import weka.classifiers.Classifier;
import weka.classifiers.UpdateableClassifier;
import weka.core.Capabilities;
import weka.core.Instance;
import weka.core.Instances;
import weka.core.Option;
import weka.core.OptionHandler;
import weka.core.RevisionUtils;
import weka.core.TechnicalInformation;
import weka.core.TechnicalInformationHandler;
import weka.core.Utils;
import weka.core.WeightedInstancesHandler;

public class AODEsr
extends Classifier
implements OptionHandler,
WeightedInstancesHandler,
UpdateableClassifier,
TechnicalInformationHandler {
    static final long serialVersionUID = 5602143019183068848L;
    private double[][][] m_CondiCounts;
    private double[][] m_CondiCountsNoClass;
    private double[] m_ClassCounts;
    private double[][] m_SumForCounts;
    private int m_NumClasses;
    private int m_NumAttributes;
    private int m_NumInstances;
    private int m_ClassIndex;
    private Instances m_Instances;
    private int m_TotalAttValues;
    private int[] m_StartAttIndex;
    private int[] m_NumAttValues;
    private double[] m_Frequencies;
    private double m_SumInstances;
    private int m_Limit = 1;
    private boolean m_Debug = false;
    protected double m_MWeight = 1.0;
    private boolean m_Laplace = false;
    private int m_Critical = 50;

    public String globalInfo() {
        return "AODEsr augments AODE with Subsumption Resolution.AODEsr detects specializations between two attribute values at classification time and deletes the generalization attribute value.\nFor more information, see:\n" + this.getTechnicalInformation().toString();
    }

    public TechnicalInformation getTechnicalInformation() {
        TechnicalInformation technicalInformation = new TechnicalInformation(TechnicalInformation.Type.INPROCEEDINGS);
        technicalInformation.setValue(TechnicalInformation.Field.AUTHOR, "Fei Zheng and Geoffrey I. Webb");
        technicalInformation.setValue(TechnicalInformation.Field.YEAR, "2006");
        technicalInformation.setValue(TechnicalInformation.Field.TITLE, "Efficient Lazy Elimination for Averaged-One Dependence Estimators");
        technicalInformation.setValue(TechnicalInformation.Field.PAGES, "1113-1120");
        technicalInformation.setValue(TechnicalInformation.Field.BOOKTITLE, "Proceedings of the Twenty-third International Conference on Machine  Learning (ICML 2006)");
        technicalInformation.setValue(TechnicalInformation.Field.PUBLISHER, "ACM Press");
        technicalInformation.setValue(TechnicalInformation.Field.ISBN, "1-59593-383-2");
        return technicalInformation;
    }

    public Capabilities getCapabilities() {
        Capabilities capabilities = super.getCapabilities();
        capabilities.disableAll();
        capabilities.enable(Capabilities.Capability.NOMINAL_ATTRIBUTES);
        capabilities.enable(Capabilities.Capability.MISSING_VALUES);
        capabilities.enable(Capabilities.Capability.NOMINAL_CLASS);
        capabilities.enable(Capabilities.Capability.MISSING_CLASS_VALUES);
        capabilities.setMinimumNumberInstances(0);
        return capabilities;
    }

    public void buildClassifier(Instances instances) throws Exception {
        int n;
        this.getCapabilities().testWithFail(instances);
        this.m_Instances = new Instances(instances);
        this.m_Instances.deleteWithMissingClass();
        this.m_SumInstances = 0.0;
        this.m_ClassIndex = instances.classIndex();
        this.m_NumInstances = this.m_Instances.numInstances();
        this.m_NumAttributes = instances.numAttributes();
        this.m_NumClasses = instances.numClasses();
        this.m_StartAttIndex = new int[this.m_NumAttributes];
        this.m_NumAttValues = new int[this.m_NumAttributes];
        this.m_TotalAttValues = 0;
        for (n = 0; n < this.m_NumAttributes; ++n) {
            if (n != this.m_ClassIndex) {
                this.m_StartAttIndex[n] = this.m_TotalAttValues;
                this.m_NumAttValues[n] = this.m_Instances.attribute(n).numValues();
                this.m_TotalAttValues += this.m_NumAttValues[n] + 1;
                continue;
            }
            this.m_NumAttValues[n] = this.m_NumClasses;
        }
        this.m_CondiCounts = new double[this.m_NumClasses][this.m_TotalAttValues][this.m_TotalAttValues];
        this.m_ClassCounts = new double[this.m_NumClasses];
        this.m_SumForCounts = new double[this.m_NumClasses][this.m_NumAttributes];
        this.m_Frequencies = new double[this.m_TotalAttValues];
        this.m_CondiCountsNoClass = new double[this.m_TotalAttValues][this.m_TotalAttValues];
        for (n = 0; n < this.m_NumInstances; ++n) {
            this.addToCounts(this.m_Instances.instance(n));
        }
        this.m_Instances = new Instances(this.m_Instances, 0);
    }

    public void updateClassifier(Instance instance) {
        this.addToCounts(instance);
    }

    private void addToCounts(Instance instance) {
        int n;
        if (instance.classIsMissing()) {
            return;
        }
        int n2 = (int)instance.classValue();
        double d = instance.weight();
        int n3 = n2;
        this.m_ClassCounts[n3] = this.m_ClassCounts[n3] + d;
        this.m_SumInstances += d;
        int[] nArray = new int[this.m_NumAttributes];
        for (n = 0; n < this.m_NumAttributes; ++n) {
            nArray[n] = n == this.m_ClassIndex ? -1 : (instance.isMissing(n) ? this.m_StartAttIndex[n] + this.m_NumAttValues[n] : this.m_StartAttIndex[n] + (int)instance.value(n));
        }
        for (n = 0; n < this.m_NumAttributes; ++n) {
            if (nArray[n] == -1) continue;
            int n4 = nArray[n];
            this.m_Frequencies[n4] = this.m_Frequencies[n4] + d;
            if (!instance.isMissing(n)) {
                double[] dArray = this.m_SumForCounts[n2];
                int n5 = n;
                dArray[n5] = dArray[n5] + d;
            }
            double[] dArray = this.m_CondiCounts[n2][nArray[n]];
            double[] dArray2 = this.m_CondiCountsNoClass[nArray[n]];
            for (int i = 0; i < this.m_NumAttributes; ++i) {
                if (nArray[i] == -1) continue;
                int n6 = nArray[i];
                dArray[n6] = dArray[n6] + d;
                int n7 = nArray[i];
                dArray2[n7] = dArray2[n7] + d;
            }
        }
    }

    public double[] distributionForInstance(Instance instance) throws Exception {
        int n;
        double[] dArray = new double[this.m_NumClasses];
        int[] nArray = new int[this.m_NumAttributes];
        int[] nArray2 = new int[this.m_NumAttributes];
        for (n = 0; n < this.m_NumAttributes; ++n) {
            nArray2[n] = instance.isMissing(n) || n == this.m_ClassIndex ? -1 : this.m_StartAttIndex[n] + (int)instance.value(n);
        }
        for (n = 0; n < this.m_NumAttributes; ++n) {
            nArray[n] = -1;
        }
        block2: for (n = 0; n < this.m_NumAttributes; ++n) {
            if (nArray2[n] == -1) continue;
            double[] dArray2 = this.m_CondiCountsNoClass[nArray2[n]];
            for (int i = 0; i < this.m_NumAttributes; ++i) {
                double[] dArray3;
                if (nArray2[i] == -1 || n == i || nArray[i] == n || !((dArray3 = this.m_CondiCountsNoClass[nArray2[i]])[nArray2[i]] > (double)this.m_Critical) || dArray3[nArray2[i]] != dArray2[nArray2[i]] || dArray3[nArray2[i]] == dArray2[nArray2[n]] && n < i) continue;
                nArray[n] = i;
                continue block2;
            }
        }
        for (n = 0; n < this.m_NumClasses; ++n) {
            dArray[n] = 0.0;
            double d = 0.0;
            int n2 = 0;
            double[][] dArray4 = this.m_CondiCounts[n];
            for (int i = 0; i < this.m_NumAttributes; ++i) {
                int n3;
                if (nArray2[i] == -1 || this.m_Frequencies[n3 = nArray2[i]] < (double)this.m_Limit || nArray[i] != -1) continue;
                double[] dArray5 = dArray4[n3];
                nArray2[i] = -1;
                ++n2;
                double d2 = dArray5[n3];
                double d3 = this.m_Frequencies[this.m_StartAttIndex[i] + this.m_NumAttValues[i]];
                d = this.m_Laplace ? this.LaplaceEstimate(d2, this.m_SumInstances - d3, this.m_NumClasses * this.m_NumAttValues[i]) : this.MEstimate(d2, this.m_SumInstances - d3, this.m_NumClasses * this.m_NumAttValues[i]);
                for (int j = 0; j < this.m_NumAttributes; ++j) {
                    if (nArray2[j] == -1 || nArray[j] != -1) continue;
                    double d4 = dArray5[this.m_StartAttIndex[j] + this.m_NumAttValues[j]];
                    if (this.m_Laplace) {
                        d *= this.LaplaceEstimate(dArray5[nArray2[j]], d2 - d4, this.m_NumAttValues[j]);
                        continue;
                    }
                    d *= this.MEstimate(dArray5[nArray2[j]], d2 - d4, this.m_NumAttValues[j]);
                }
                int n4 = n;
                dArray[n4] = dArray[n4] + d;
                nArray2[i] = n3;
            }
            if (n2 < 1) {
                dArray[n] = this.NBconditionalProb(instance, n);
                continue;
            }
            int n5 = n;
            dArray[n5] = dArray[n5] / (double)n2;
        }
        Utils.normalize(dArray);
        return dArray;
    }

    public double NBconditionalProb(Instance instance, int n) throws Exception {
        double d = this.m_Laplace ? this.LaplaceEstimate(this.m_ClassCounts[n], this.m_SumInstances, this.m_NumClasses) : this.MEstimate(this.m_ClassCounts[n], this.m_SumInstances, this.m_NumClasses);
        double[][] dArray = this.m_CondiCounts[n];
        for (int i = 0; i < this.m_NumAttributes; ++i) {
            if (i == this.m_ClassIndex || instance.isMissing(i)) continue;
            int n2 = this.m_StartAttIndex[i] + (int)instance.value(i);
            if (this.m_Laplace) {
                d *= this.LaplaceEstimate(dArray[n2][n2], this.m_SumForCounts[n][i], this.m_NumAttValues[i]);
                continue;
            }
            d *= this.MEstimate(dArray[n2][n2], this.m_SumForCounts[n][i], this.m_NumAttValues[i]);
        }
        return d;
    }

    public double MEstimate(double d, double d2, double d3) {
        return (d + this.m_MWeight / d3) / (d2 + this.m_MWeight);
    }

    public double LaplaceEstimate(double d, double d2, double d3) {
        return (d + 1.0) / (d2 + d3);
    }

    public Enumeration listOptions() {
        Vector<Option> vector = new Vector<Option>(5);
        vector.addElement(new Option("\tOutput debugging information\n", "D", 0, "-D"));
        vector.addElement(new Option("\tImpose a critcal value for specialization-generalization relationship\n\t(default is 50)", "C", 1, "-C"));
        vector.addElement(new Option("\tImpose a frequency limit for superParents\n\t(default is 1)", "F", 2, "-F"));
        vector.addElement(new Option("\tUsing Laplace estimation\n\t(default is m-esimation (m=1))", "L", 3, "-L"));
        vector.addElement(new Option("\tWeight value for m-estimation\n\t(default is 1.0)", "M", 4, "-M"));
        return vector.elements();
    }

    public void setOptions(String[] stringArray) throws Exception {
        this.m_Debug = Utils.getFlag('D', stringArray);
        String string = Utils.getOption('C', stringArray);
        this.m_Critical = string.length() != 0 ? Integer.parseInt(string) : 50;
        String string2 = Utils.getOption('F', stringArray);
        this.m_Limit = string2.length() != 0 ? Integer.parseInt(string2) : 1;
        this.m_Laplace = Utils.getFlag('L', stringArray);
        String string3 = Utils.getOption('M', stringArray);
        if (string3.length() != 0) {
            if (this.m_Laplace) {
                throw new Exception("weight for m-estimate is pointless if using laplace estimation!");
            }
            this.m_MWeight = Double.parseDouble(string3);
        } else {
            this.m_MWeight = 1.0;
        }
        Utils.checkForRemainingOptions(stringArray);
    }

    public String[] getOptions() {
        Vector<String> vector = new Vector<String>();
        if (this.m_Debug) {
            vector.add("-D");
        }
        vector.add("-F");
        vector.add("" + this.m_Limit);
        if (this.m_Laplace) {
            vector.add("-L");
        } else {
            vector.add("-M");
            vector.add("" + this.m_MWeight);
        }
        vector.add("-C");
        vector.add("" + this.m_Critical);
        return vector.toArray(new String[vector.size()]);
    }

    public String mestWeightTipText() {
        return "Set the weight for m-estimate.";
    }

    public void setMestWeight(double d) {
        if (this.getUseLaplace()) {
            System.out.println("Weight is only used in conjunction with m-estimate - ignored!");
        } else if (d > 0.0) {
            this.m_MWeight = d;
        } else {
            System.out.println("M-Estimate Weight must be greater than 0!");
        }
    }

    public double getMestWeight() {
        return this.m_MWeight;
    }

    public String useLaplaceTipText() {
        return "Use Laplace correction instead of m-estimation.";
    }

    public boolean getUseLaplace() {
        return this.m_Laplace;
    }

    public void setUseLaplace(boolean bl) {
        this.m_Laplace = bl;
    }

    public String frequencyLimitTipText() {
        return "Attributes with a frequency in the train set below this value aren't used as parents.";
    }

    public void setFrequencyLimit(int n) {
        this.m_Limit = n;
    }

    public int getFrequencyLimit() {
        return this.m_Limit;
    }

    public String criticalValueTipText() {
        return "Specify critical value for specialization-generalization relationship (default 50).";
    }

    public void setCriticalValue(int n) {
        this.m_Critical = n;
    }

    public int getCriticalValue() {
        return this.m_Critical;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("The AODEsr Classifier");
        if (this.m_Instances == null) {
            stringBuffer.append(": No model built yet.");
        } else {
            try {
                for (int i = 0; i < this.m_NumClasses; ++i) {
                    stringBuffer.append("\nClass " + this.m_Instances.classAttribute().value(i) + ": Prior probability = " + Utils.doubleToString((this.m_ClassCounts[i] + 1.0) / (this.m_SumInstances + (double)this.m_NumClasses), 4, 2) + "\n\n");
                }
                stringBuffer.append("Dataset: " + this.m_Instances.relationName() + "\n" + "Instances: " + this.m_NumInstances + "\n" + "Attributes: " + this.m_NumAttributes + "\n" + "Frequency limit for superParents: " + this.m_Limit + "\n" + "Critical value for the specializtion-generalization " + "relationship: " + this.m_Critical + "\n");
                if (this.m_Laplace) {
                    stringBuffer.append("Using LapLace estimation.");
                } else {
                    stringBuffer.append("Using m-estimation, m = " + this.m_MWeight);
                }
            }
            catch (Exception exception) {
                stringBuffer.append(exception.getMessage());
            }
        }
        return stringBuffer.toString();
    }

    public String getRevision() {
        return RevisionUtils.extract("$Revision: 5516 $");
    }

    public static void main(String[] stringArray) {
        AODEsr.runClassifier(new AODEsr(), stringArray);
    }
}

