/*
 * Decompiled with CFR 0.152.
 */
package weka.classifiers.mi;

import weka.core.Optimization;
import weka.core.RevisionUtils;

class TLDSimple_Optm
extends Optimization {
    private double[] num;
    private double sSq;
    private double[] xBar;

    TLDSimple_Optm() {
    }

    public void setNum(double[] dArray) {
        this.num = dArray;
    }

    public void setSgmSq(double d) {
        this.sSq = d;
    }

    public void setXBar(double[] dArray) {
        this.xBar = dArray;
    }

    protected double objectiveFunction(double[] dArray) {
        int n = this.num.length;
        double d = 0.0;
        double d2 = dArray[0];
        double d3 = dArray[1];
        for (int i = 0; i < n; ++i) {
            if (Double.isNaN(this.xBar[i])) continue;
            double d4 = 0.0;
            if (Double.isNaN(d4 += Math.log(d2 * this.num[i] + this.sSq)) && m_Debug) {
                System.out.println("???????????1: " + d2 + " " + d3 + "|x-: " + this.xBar[i] + "|n: " + this.num[i] + "|S^2: " + this.sSq);
            }
            if (Double.isNaN(d4 += this.num[i] * (d3 - this.xBar[i]) * (d3 - this.xBar[i]) / (d2 * this.num[i] + this.sSq)) && m_Debug) {
                System.out.println("???????????2: " + d2 + " " + d3 + "|x-: " + this.xBar[i] + "|n: " + this.num[i] + "|S^2: " + this.sSq);
            }
            d += d4;
        }
        return d;
    }

    protected double[] evaluateGradient(double[] dArray) {
        double[] dArray2 = new double[dArray.length];
        int n = this.num.length;
        double d = dArray[0];
        double d2 = dArray[1];
        double d3 = 0.0;
        double d4 = 0.0;
        for (int i = 0; i < n; ++i) {
            if (Double.isNaN(this.xBar[i])) continue;
            d3 += this.num[i] / (d * this.num[i] + this.sSq) - this.num[i] * this.num[i] * (d2 - this.xBar[i]) * (d2 - this.xBar[i]) / ((d * this.num[i] + this.sSq) * (d * this.num[i] + this.sSq));
            d4 += 2.0 * this.num[i] * (d2 - this.xBar[i]) / (d * this.num[i] + this.sSq);
        }
        dArray2[0] = d3;
        dArray2[1] = d4;
        return dArray2;
    }

    protected double[] evaluateHessian(double[] dArray, int n) {
        double[] dArray2 = new double[dArray.length];
        int n2 = this.num.length;
        switch (n) {
            case 0: {
                double d = dArray[0];
                double d2 = dArray[1];
                for (int i = 0; i < n2; ++i) {
                    if (Double.isNaN(this.xBar[i])) continue;
                    dArray2[0] = dArray2[0] + (2.0 * Math.pow(this.num[i], 3.0) * (d2 - this.xBar[i]) * (d2 - this.xBar[i]) / Math.pow(d * this.num[i] + this.sSq, 3.0) - this.num[i] * this.num[i] / ((d * this.num[i] + this.sSq) * (d * this.num[i] + this.sSq)));
                    dArray2[1] = dArray2[1] - 2.0 * (d2 - this.xBar[i]) * this.num[i] * this.num[i] / ((this.num[i] * d + this.sSq) * (this.num[i] * d + this.sSq));
                }
                break;
            }
            case 1: {
                double d = dArray[0];
                double d3 = dArray[1];
                for (int i = 0; i < n2; ++i) {
                    if (Double.isNaN(this.xBar[i])) continue;
                    dArray2[0] = dArray2[0] - 2.0 * (d3 - this.xBar[i]) * this.num[i] * this.num[i] / ((this.num[i] * d + this.sSq) * (this.num[i] * d + this.sSq));
                    dArray2[1] = dArray2[1] + 2.0 * this.num[i] / (d * this.num[i] + this.sSq);
                }
                break;
            }
        }
        return dArray2;
    }

    public String getRevision() {
        return RevisionUtils.extract("$Revision: 5527 $");
    }
}

