/*
 * Decompiled with CFR 0.152.
 */
package weka.core.pmml;

import java.util.ArrayList;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import weka.core.Attribute;
import weka.core.FastVector;
import weka.core.pmml.Expression;
import weka.core.pmml.FieldMetaInfo;
import weka.core.pmml.Function;
import weka.core.pmml.TransformationDictionary;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefineFunction
extends Function {
    private static final long serialVersionUID = -1976646917527243888L;
    protected ArrayList<ParameterField> m_parameters = new ArrayList();
    FieldMetaInfo.Optype m_optype = FieldMetaInfo.Optype.NONE;
    protected Expression m_expression = null;

    public DefineFunction(Element element, TransformationDictionary transformationDictionary) throws Exception {
        this.m_functionName = element.getAttribute("name");
        String string = element.getAttribute("optype");
        if (string != null && string.length() > 0) {
            for (Object object : FieldMetaInfo.Optype.values()) {
                if (!object.toString().equals(string)) continue;
                this.m_optype = object;
                break;
            }
        } else {
            throw new Exception("[DefineFunction] no optype specified!!");
        }
        this.m_parameterDefs = new ArrayList();
        NodeList nodeList = element.getElementsByTagName("ParameterField");
        for (int i = 0; i < nodeList.getLength(); ++i) {
            Object object;
            Node node = nodeList.item(i);
            if (node.getNodeType() != 1) continue;
            object = new ParameterField((Element)node);
            this.m_parameters.add((ParameterField)object);
            this.m_parameterDefs.add(((ParameterField)object).getFieldAsAttribute());
        }
        this.m_expression = Expression.getExpression(element, this.m_optype, this.m_parameterDefs, transformationDictionary);
        if (this.m_optype == FieldMetaInfo.Optype.CONTINUOUS && this.m_expression.getOptype() != this.m_optype) {
            throw new Exception("[DefineFunction] optype is continuous but our Expression's optype is not.");
        }
        if ((this.m_optype == FieldMetaInfo.Optype.CATEGORICAL || this.m_optype == FieldMetaInfo.Optype.ORDINAL) != (this.m_expression.getOptype() == FieldMetaInfo.Optype.CATEGORICAL || this.m_expression.getOptype() == FieldMetaInfo.Optype.ORDINAL)) {
            throw new Exception("[DefineFunction] optype is categorical/ordinal but our Expression's optype is not.");
        }
    }

    @Override
    public Attribute getOutputDef() {
        return this.m_expression.getOutputDef();
    }

    @Override
    public String[] getParameterNames() {
        String[] stringArray = new String[this.m_parameters.size()];
        for (int i = 0; i < this.m_parameters.size(); ++i) {
            stringArray[i] = this.m_parameters.get(i).getFieldName();
        }
        return stringArray;
    }

    @Override
    public double getResult(double[] dArray) throws Exception {
        if (dArray.length != this.m_parameters.size()) {
            throw new IllegalArgumentException("[DefineFunction] wrong number of arguments: expected " + this.m_parameters.size() + ", recieved " + dArray.length);
        }
        return this.m_expression.getResult(dArray);
    }

    @Override
    public void setParameterDefs(ArrayList<Attribute> arrayList) throws Exception {
        if (arrayList.size() != this.m_parameters.size()) {
            throw new Exception("[DefineFunction] number of parameter definitions does not match number of parameters!");
        }
        for (int i = 0; i < this.m_parameters.size(); ++i) {
            if (this.m_parameters.get(i).getOptype() == FieldMetaInfo.Optype.CONTINUOUS) {
                if (arrayList.get(i).isNumeric()) continue;
                throw new Exception("[DefineFunction] parameter " + this.m_parameters.get(i).getFieldName() + " is continuous, but corresponding " + "supplied parameter def " + arrayList.get(i).name() + " is not!");
            }
            if (arrayList.get(i).isNominal() || arrayList.get(i).isString()) continue;
            throw new Exception("[DefineFunction] parameter " + this.m_parameters.get(i).getFieldName() + " is categorical/ordinal, but corresponding " + "supplied parameter def " + arrayList.get(i).name() + " is not!");
        }
        ArrayList<Attribute> arrayList2 = new ArrayList<Attribute>();
        for (int i = 0; i < arrayList.size(); ++i) {
            Attribute attribute = arrayList.get(i);
            arrayList2.add(attribute.copy(this.m_parameters.get(i).getFieldName()));
        }
        this.m_parameterDefs = arrayList2;
        this.m_expression.setFieldDefs(this.m_parameterDefs);
    }

    @Override
    public String toString() {
        return this.toString("");
    }

    @Override
    public String toString(String string) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(string + "DefineFunction (" + this.m_functionName + "):\n" + string + "nparameters:\n");
        for (ParameterField parameterField : this.m_parameters) {
            stringBuffer.append(string + parameterField.getFieldAsAttribute() + "\n");
        }
        stringBuffer.append(string + "expression:\n" + this.m_expression.toString(string + "  "));
        return stringBuffer.toString();
    }

    protected class ParameterField
    extends FieldMetaInfo {
        private static final long serialVersionUID = 3918895902507585558L;

        protected ParameterField(Element element) {
            super(element);
        }

        public Attribute getFieldAsAttribute() {
            if (this.m_optype == FieldMetaInfo.Optype.CONTINUOUS) {
                return new Attribute(this.m_fieldName);
            }
            return new Attribute(this.m_fieldName, (FastVector)null);
        }
    }
}

