/*
 * Decompiled with CFR 0.152.
 */
package weka.gui.experiment;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.beans.IntrospectionException;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.beans.PropertyDescriptor;
import java.io.File;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.filechooser.FileFilter;
import weka.classifiers.Classifier;
import weka.core.xml.KOML;
import weka.experiment.CSVResultListener;
import weka.experiment.ClassifierSplitEvaluator;
import weka.experiment.CrossValidationResultProducer;
import weka.experiment.DatabaseResultListener;
import weka.experiment.Experiment;
import weka.experiment.InstancesResultListener;
import weka.experiment.PropertyNode;
import weka.experiment.RandomSplitResultProducer;
import weka.experiment.RegressionSplitEvaluator;
import weka.experiment.SplitEvaluator;
import weka.gui.DatabaseConnectionDialog;
import weka.gui.ExtensionFileFilter;
import weka.gui.experiment.AlgorithmListPanel;
import weka.gui.experiment.DatasetListPanel;
import weka.gui.experiment.ExperimenterDefaults;
import weka.gui.experiment.SetupModePanel;

public class SimpleSetupPanel
extends JPanel {
    private static final long serialVersionUID = 5257424515609176509L;
    protected Experiment m_Exp;
    protected SetupModePanel m_modePanel = null;
    protected String m_destinationDatabaseURL;
    protected String m_destinationFilename = "";
    protected int m_numFolds = 10;
    protected double m_trainPercent = 66.0;
    protected int m_numRepetitions = 10;
    protected boolean m_userHasBeenAskedAboutConversion;
    protected ExtensionFileFilter m_csvFileFilter = new ExtensionFileFilter(".csv", "Comma separated value files");
    protected ExtensionFileFilter m_arffFileFilter = new ExtensionFileFilter(".arff", "ARFF files");
    protected JButton m_OpenBut = new JButton("Open...");
    protected JButton m_SaveBut = new JButton("Save...");
    protected JButton m_NewBut = new JButton("New");
    protected FileFilter m_ExpFilter = new ExtensionFileFilter(Experiment.FILE_EXTENSION, "Experiment configuration files (*" + Experiment.FILE_EXTENSION + ")");
    protected FileFilter m_KOMLFilter = new ExtensionFileFilter(".koml", "Experiment configuration files (*.koml)");
    protected FileFilter m_XMLFilter = new ExtensionFileFilter(".xml", "Experiment configuration files (*.xml)");
    protected JFileChooser m_FileChooser = new JFileChooser(new File(System.getProperty("user.dir")));
    protected JFileChooser m_DestFileChooser = new JFileChooser(new File(System.getProperty("user.dir")));
    protected JComboBox m_ResultsDestinationCBox = new JComboBox();
    protected JLabel m_ResultsDestinationPathLabel = new JLabel("Filename:");
    protected JTextField m_ResultsDestinationPathTField = new JTextField();
    protected JButton m_BrowseDestinationButton = new JButton("Browse...");
    protected JComboBox m_ExperimentTypeCBox = new JComboBox();
    protected JLabel m_ExperimentParameterLabel = new JLabel("Number of folds:");
    protected JTextField m_ExperimentParameterTField = new JTextField();
    protected JRadioButton m_ExpClassificationRBut = new JRadioButton("Classification");
    protected JRadioButton m_ExpRegressionRBut = new JRadioButton("Regression");
    protected JTextField m_NumberOfRepetitionsTField = new JTextField();
    protected JRadioButton m_OrderDatasetsFirstRBut = new JRadioButton("Data sets first");
    protected JRadioButton m_OrderAlgorithmsFirstRBut = new JRadioButton("Algorithms first");
    protected static String DEST_DATABASE_TEXT = "JDBC database";
    protected static String DEST_ARFF_TEXT = "ARFF file";
    protected static String DEST_CSV_TEXT = "CSV file";
    protected static String TYPE_CROSSVALIDATION_TEXT = "Cross-validation";
    protected static String TYPE_RANDOMSPLIT_TEXT = "Train/Test Percentage Split (data randomized)";
    protected static String TYPE_FIXEDSPLIT_TEXT = "Train/Test Percentage Split (order preserved)";
    protected DatasetListPanel m_DatasetListPanel = new DatasetListPanel();
    protected AlgorithmListPanel m_AlgorithmListPanel = new AlgorithmListPanel();
    protected JButton m_NotesButton = new JButton("Notes");
    protected JFrame m_NotesFrame = new JFrame("Notes");
    protected JTextArea m_NotesText = new JTextArea(null, 10, 0);
    protected PropertyChangeSupport m_Support = new PropertyChangeSupport(this);

    public SimpleSetupPanel(Experiment experiment) {
        this();
        this.setExperiment(experiment);
    }

    public SimpleSetupPanel() {
        this.m_ResultsDestinationCBox.setEnabled(false);
        this.m_ResultsDestinationPathLabel.setEnabled(false);
        this.m_ResultsDestinationPathTField.setEnabled(false);
        this.m_BrowseDestinationButton.setEnabled(false);
        this.m_ExperimentTypeCBox.setEnabled(false);
        this.m_ExperimentParameterLabel.setEnabled(false);
        this.m_ExperimentParameterTField.setEnabled(false);
        this.m_ExpClassificationRBut.setEnabled(false);
        this.m_ExpRegressionRBut.setEnabled(false);
        this.m_NumberOfRepetitionsTField.setEnabled(false);
        this.m_OrderDatasetsFirstRBut.setEnabled(false);
        this.m_OrderAlgorithmsFirstRBut.setEnabled(false);
        try {
            this.m_destinationDatabaseURL = new DatabaseResultListener().getDatabaseURL();
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.m_NewBut.setMnemonic('N');
        this.m_NewBut.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                Experiment experiment = new Experiment();
                CrossValidationResultProducer crossValidationResultProducer = new CrossValidationResultProducer();
                crossValidationResultProducer.setNumFolds(10);
                crossValidationResultProducer.setSplitEvaluator(new ClassifierSplitEvaluator());
                experiment.setResultProducer(crossValidationResultProducer);
                experiment.setPropertyArray(new Classifier[0]);
                experiment.setUsePropertyIterator(true);
                SimpleSetupPanel.this.setExperiment(experiment);
                if (ExperimenterDefaults.getUseClassification()) {
                    SimpleSetupPanel.this.m_ExpClassificationRBut.setSelected(true);
                } else {
                    SimpleSetupPanel.this.m_ExpRegressionRBut.setSelected(true);
                }
                SimpleSetupPanel.this.setSelectedItem(SimpleSetupPanel.this.m_ResultsDestinationCBox, ExperimenterDefaults.getDestination());
                SimpleSetupPanel.this.destinationTypeChanged();
                SimpleSetupPanel.this.setSelectedItem(SimpleSetupPanel.this.m_ExperimentTypeCBox, ExperimenterDefaults.getExperimentType());
                SimpleSetupPanel.this.m_numRepetitions = ExperimenterDefaults.getRepetitions();
                SimpleSetupPanel.this.m_NumberOfRepetitionsTField.setText("" + SimpleSetupPanel.this.m_numRepetitions);
                if (ExperimenterDefaults.getExperimentType().equals(TYPE_CROSSVALIDATION_TEXT)) {
                    SimpleSetupPanel.this.m_numFolds = ExperimenterDefaults.getFolds();
                    SimpleSetupPanel.this.m_ExperimentParameterTField.setText("" + SimpleSetupPanel.this.m_numFolds);
                } else {
                    SimpleSetupPanel.this.m_trainPercent = ExperimenterDefaults.getTrainPercentage();
                    SimpleSetupPanel.this.m_ExperimentParameterTField.setText("" + SimpleSetupPanel.this.m_trainPercent);
                }
                if (ExperimenterDefaults.getDatasetsFirst()) {
                    SimpleSetupPanel.this.m_OrderDatasetsFirstRBut.setSelected(true);
                } else {
                    SimpleSetupPanel.this.m_OrderAlgorithmsFirstRBut.setSelected(true);
                }
                SimpleSetupPanel.this.expTypeChanged();
            }
        });
        this.m_SaveBut.setEnabled(false);
        this.m_SaveBut.setMnemonic('S');
        this.m_SaveBut.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                SimpleSetupPanel.this.saveExperiment();
            }
        });
        this.m_OpenBut.setMnemonic('O');
        this.m_OpenBut.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                SimpleSetupPanel.this.openExperiment();
            }
        });
        this.m_FileChooser.addChoosableFileFilter(this.m_ExpFilter);
        if (KOML.isPresent()) {
            this.m_FileChooser.addChoosableFileFilter(this.m_KOMLFilter);
        }
        this.m_FileChooser.addChoosableFileFilter(this.m_XMLFilter);
        if (ExperimenterDefaults.getExtension().equals(".xml")) {
            this.m_FileChooser.setFileFilter(this.m_XMLFilter);
        } else if (KOML.isPresent() && ExperimenterDefaults.getExtension().equals(".koml")) {
            this.m_FileChooser.setFileFilter(this.m_KOMLFilter);
        } else {
            this.m_FileChooser.setFileFilter(this.m_ExpFilter);
        }
        this.m_FileChooser.setFileSelectionMode(0);
        this.m_DestFileChooser.setFileSelectionMode(0);
        this.m_BrowseDestinationButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                if (SimpleSetupPanel.this.m_ResultsDestinationCBox.getSelectedItem() == DEST_DATABASE_TEXT) {
                    SimpleSetupPanel.this.chooseURLUsername();
                } else {
                    SimpleSetupPanel.this.chooseDestinationFile();
                }
            }
        });
        this.m_ExpClassificationRBut.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                SimpleSetupPanel.this.expTypeChanged();
            }
        });
        this.m_ExpRegressionRBut.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                SimpleSetupPanel.this.expTypeChanged();
            }
        });
        this.m_OrderDatasetsFirstRBut.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                if (SimpleSetupPanel.this.m_Exp != null) {
                    SimpleSetupPanel.this.m_Exp.setAdvanceDataSetFirst(true);
                    SimpleSetupPanel.this.m_Support.firePropertyChange("", null, null);
                }
            }
        });
        this.m_OrderAlgorithmsFirstRBut.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                if (SimpleSetupPanel.this.m_Exp != null) {
                    SimpleSetupPanel.this.m_Exp.setAdvanceDataSetFirst(false);
                    SimpleSetupPanel.this.m_Support.firePropertyChange("", null, null);
                }
            }
        });
        this.m_ResultsDestinationPathTField.getDocument().addDocumentListener(new DocumentListener(){

            public void insertUpdate(DocumentEvent documentEvent) {
                SimpleSetupPanel.this.destinationAddressChanged();
            }

            public void removeUpdate(DocumentEvent documentEvent) {
                SimpleSetupPanel.this.destinationAddressChanged();
            }

            public void changedUpdate(DocumentEvent documentEvent) {
                SimpleSetupPanel.this.destinationAddressChanged();
            }
        });
        this.m_ExperimentParameterTField.getDocument().addDocumentListener(new DocumentListener(){

            public void insertUpdate(DocumentEvent documentEvent) {
                SimpleSetupPanel.this.expParamChanged();
            }

            public void removeUpdate(DocumentEvent documentEvent) {
                SimpleSetupPanel.this.expParamChanged();
            }

            public void changedUpdate(DocumentEvent documentEvent) {
                SimpleSetupPanel.this.expParamChanged();
            }
        });
        this.m_NumberOfRepetitionsTField.getDocument().addDocumentListener(new DocumentListener(){

            public void insertUpdate(DocumentEvent documentEvent) {
                SimpleSetupPanel.this.numRepetitionsChanged();
            }

            public void removeUpdate(DocumentEvent documentEvent) {
                SimpleSetupPanel.this.numRepetitionsChanged();
            }

            public void changedUpdate(DocumentEvent documentEvent) {
                SimpleSetupPanel.this.numRepetitionsChanged();
            }
        });
        this.m_NotesFrame.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent windowEvent) {
                SimpleSetupPanel.this.m_NotesButton.setEnabled(true);
            }
        });
        this.m_NotesFrame.getContentPane().add(new JScrollPane(this.m_NotesText));
        this.m_NotesFrame.setSize(600, 400);
        this.m_NotesButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                SimpleSetupPanel.this.m_NotesButton.setEnabled(false);
                SimpleSetupPanel.this.m_NotesFrame.setVisible(true);
            }
        });
        this.m_NotesButton.setEnabled(false);
        this.m_NotesText.setEditable(true);
        this.m_NotesText.addKeyListener(new KeyAdapter(){

            public void keyReleased(KeyEvent keyEvent) {
                SimpleSetupPanel.this.m_Exp.setNotes(SimpleSetupPanel.this.m_NotesText.getText());
            }
        });
        this.m_NotesText.addFocusListener(new FocusAdapter(){

            public void focusLost(FocusEvent focusEvent) {
                SimpleSetupPanel.this.m_Exp.setNotes(SimpleSetupPanel.this.m_NotesText.getText());
            }
        });
        JPanel jPanel = new JPanel();
        GridBagLayout gridBagLayout = new GridBagLayout();
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        jPanel.setBorder(BorderFactory.createEmptyBorder(10, 5, 10, 5));
        jPanel.setLayout(gridBagLayout);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.weightx = 5.0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.insets = new Insets(0, 2, 0, 2);
        jPanel.add((Component)this.m_OpenBut, gridBagConstraints);
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.weightx = 5.0;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridheight = 1;
        jPanel.add((Component)this.m_SaveBut, gridBagConstraints);
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.weightx = 5.0;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridheight = 1;
        jPanel.add((Component)this.m_NewBut, gridBagConstraints);
        JPanel jPanel2 = new JPanel();
        jPanel2.setLayout(new BorderLayout(5, 5));
        jPanel2.add((Component)this.m_ResultsDestinationPathLabel, "West");
        jPanel2.add((Component)this.m_ResultsDestinationPathTField, "Center");
        this.m_ResultsDestinationCBox.addItem(DEST_ARFF_TEXT);
        this.m_ResultsDestinationCBox.addItem(DEST_CSV_TEXT);
        this.m_ResultsDestinationCBox.addItem(DEST_DATABASE_TEXT);
        this.m_ResultsDestinationCBox.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                SimpleSetupPanel.this.destinationTypeChanged();
            }
        });
        JPanel jPanel3 = new JPanel();
        jPanel3.setLayout(new BorderLayout(5, 5));
        jPanel3.add((Component)this.m_ResultsDestinationCBox, "West");
        jPanel3.add((Component)jPanel2, "Center");
        jPanel3.add((Component)this.m_BrowseDestinationButton, "East");
        JPanel jPanel4 = new JPanel();
        jPanel4.setLayout(new BorderLayout());
        jPanel4.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createTitledBorder("Results Destination"), BorderFactory.createEmptyBorder(0, 5, 5, 5)));
        jPanel4.add((Component)jPanel3, "North");
        JPanel jPanel5 = new JPanel();
        jPanel5.setLayout(new BorderLayout(5, 5));
        jPanel5.add((Component)this.m_ExperimentParameterLabel, "West");
        jPanel5.add((Component)this.m_ExperimentParameterTField, "Center");
        ButtonGroup buttonGroup = new ButtonGroup();
        buttonGroup.add(this.m_ExpClassificationRBut);
        buttonGroup.add(this.m_ExpRegressionRBut);
        this.m_ExpClassificationRBut.setSelected(true);
        JPanel jPanel6 = new JPanel();
        jPanel6.setLayout(new GridLayout(1, 0));
        jPanel6.add(this.m_ExpClassificationRBut);
        jPanel6.add(this.m_ExpRegressionRBut);
        this.m_ExperimentTypeCBox.addItem(TYPE_CROSSVALIDATION_TEXT);
        this.m_ExperimentTypeCBox.addItem(TYPE_RANDOMSPLIT_TEXT);
        this.m_ExperimentTypeCBox.addItem(TYPE_FIXEDSPLIT_TEXT);
        this.m_ExperimentTypeCBox.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                SimpleSetupPanel.this.expTypeChanged();
            }
        });
        JPanel jPanel7 = new JPanel();
        jPanel7.setLayout(new GridLayout(0, 1));
        jPanel7.add(this.m_ExperimentTypeCBox);
        jPanel7.add(jPanel5);
        jPanel7.add(jPanel6);
        JPanel jPanel8 = new JPanel();
        jPanel8.setLayout(new BorderLayout());
        jPanel8.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createTitledBorder("Experiment Type"), BorderFactory.createEmptyBorder(0, 5, 5, 5)));
        jPanel8.add((Component)jPanel7, "North");
        ButtonGroup buttonGroup2 = new ButtonGroup();
        buttonGroup2.add(this.m_OrderDatasetsFirstRBut);
        buttonGroup2.add(this.m_OrderAlgorithmsFirstRBut);
        this.m_OrderDatasetsFirstRBut.setSelected(true);
        JPanel jPanel9 = new JPanel();
        jPanel9.setLayout(new BorderLayout(5, 5));
        jPanel9.add((Component)new JLabel("Number of repetitions:"), "West");
        jPanel9.add((Component)this.m_NumberOfRepetitionsTField, "Center");
        JPanel jPanel10 = new JPanel();
        jPanel10.setLayout(new GridLayout(0, 1));
        jPanel10.add(jPanel9);
        jPanel10.add(this.m_OrderDatasetsFirstRBut);
        jPanel10.add(this.m_OrderAlgorithmsFirstRBut);
        JPanel jPanel11 = new JPanel();
        jPanel11.setLayout(new BorderLayout());
        jPanel11.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createTitledBorder("Iteration Control"), BorderFactory.createEmptyBorder(0, 5, 5, 5)));
        jPanel11.add((Component)jPanel10, "North");
        JPanel jPanel12 = new JPanel();
        jPanel12.setLayout(new GridLayout(1, 0));
        jPanel12.add(jPanel8);
        jPanel12.add(jPanel11);
        JPanel jPanel13 = new JPanel();
        jPanel13.setLayout(new BorderLayout());
        jPanel13.add((Component)this.m_NotesButton, "Center");
        JPanel jPanel14 = new JPanel();
        jPanel14.setLayout(new BorderLayout());
        jPanel14.add((Component)jPanel4, "North");
        jPanel14.add((Component)jPanel12, "Center");
        JPanel jPanel15 = new JPanel();
        jPanel15.setLayout(new BorderLayout());
        jPanel15.add((Component)jPanel, "North");
        jPanel15.add((Component)jPanel14, "Center");
        JPanel jPanel16 = new JPanel();
        jPanel16.setLayout(new BorderLayout());
        jPanel16.add((Component)this.m_DatasetListPanel, "Center");
        JPanel jPanel17 = new JPanel();
        jPanel17.setLayout(new BorderLayout());
        jPanel17.add((Component)this.m_AlgorithmListPanel, "Center");
        JPanel jPanel18 = new JPanel();
        jPanel18.setLayout(new GridLayout(1, 0));
        jPanel18.add(jPanel16);
        jPanel18.add(jPanel17);
        this.setLayout(new BorderLayout());
        this.add((Component)jPanel15, "North");
        this.add((Component)jPanel18, "Center");
        this.add((Component)jPanel13, "South");
    }

    protected void setSelectedItem(JComboBox jComboBox, String string) {
        for (int i = 0; i < jComboBox.getItemCount(); ++i) {
            if (!jComboBox.getItemAt(i).toString().equals(string)) continue;
            jComboBox.setSelectedIndex(i);
            break;
        }
    }

    protected void removeNotesFrame() {
        this.m_NotesFrame.setVisible(false);
    }

    private boolean userWantsToConvert() {
        if (this.m_userHasBeenAskedAboutConversion) {
            return true;
        }
        this.m_userHasBeenAskedAboutConversion = true;
        return JOptionPane.showConfirmDialog(this, "This experiment has settings that are too advanced\nto be represented in the simple setup mode.\nDo you want the experiment to be converted,\nlosing some of the advanced settings?\n", "Confirm conversion", 0, 2) == 0;
    }

    public void setModePanel(SetupModePanel setupModePanel) {
        this.m_modePanel = setupModePanel;
    }

    public boolean setExperiment(Experiment experiment) {
        this.m_userHasBeenAskedAboutConversion = false;
        this.m_Exp = null;
        this.m_SaveBut.setEnabled(true);
        if (experiment.getResultListener() instanceof DatabaseResultListener) {
            this.m_ResultsDestinationCBox.setSelectedItem(DEST_DATABASE_TEXT);
            this.m_ResultsDestinationPathLabel.setText("URL:");
            this.m_destinationDatabaseURL = ((DatabaseResultListener)experiment.getResultListener()).getDatabaseURL();
            this.m_ResultsDestinationPathTField.setText(this.m_destinationDatabaseURL);
            this.m_BrowseDestinationButton.setEnabled(true);
        } else if (experiment.getResultListener() instanceof InstancesResultListener) {
            this.m_ResultsDestinationCBox.setSelectedItem(DEST_ARFF_TEXT);
            this.m_ResultsDestinationPathLabel.setText("Filename:");
            this.m_destinationFilename = ((InstancesResultListener)experiment.getResultListener()).outputFileName();
            this.m_ResultsDestinationPathTField.setText(this.m_destinationFilename);
            this.m_BrowseDestinationButton.setEnabled(true);
        } else if (experiment.getResultListener() instanceof CSVResultListener) {
            this.m_ResultsDestinationCBox.setSelectedItem(DEST_CSV_TEXT);
            this.m_ResultsDestinationPathLabel.setText("Filename:");
            this.m_destinationFilename = ((CSVResultListener)experiment.getResultListener()).outputFileName();
            this.m_ResultsDestinationPathTField.setText(this.m_destinationFilename);
            this.m_BrowseDestinationButton.setEnabled(true);
        } else {
            System.out.println("SimpleSetup incompatibility: unrecognised result destination");
            if (this.userWantsToConvert()) {
                this.m_ResultsDestinationCBox.setSelectedItem(DEST_ARFF_TEXT);
                this.m_ResultsDestinationPathLabel.setText("Filename:");
                this.m_destinationFilename = "";
                this.m_ResultsDestinationPathTField.setText(this.m_destinationFilename);
                this.m_BrowseDestinationButton.setEnabled(true);
            } else {
                return false;
            }
        }
        this.m_ResultsDestinationCBox.setEnabled(true);
        this.m_ResultsDestinationPathLabel.setEnabled(true);
        this.m_ResultsDestinationPathTField.setEnabled(true);
        if (experiment.getResultProducer() instanceof CrossValidationResultProducer) {
            CrossValidationResultProducer crossValidationResultProducer = (CrossValidationResultProducer)experiment.getResultProducer();
            this.m_numFolds = crossValidationResultProducer.getNumFolds();
            this.m_ExperimentParameterTField.setText("" + this.m_numFolds);
            if (crossValidationResultProducer.getSplitEvaluator() instanceof ClassifierSplitEvaluator) {
                this.m_ExpClassificationRBut.setSelected(true);
                this.m_ExpRegressionRBut.setSelected(false);
            } else if (crossValidationResultProducer.getSplitEvaluator() instanceof RegressionSplitEvaluator) {
                this.m_ExpClassificationRBut.setSelected(false);
                this.m_ExpRegressionRBut.setSelected(true);
            } else {
                System.out.println("SimpleSetup incompatibility: unrecognised split evaluator");
                if (this.userWantsToConvert()) {
                    this.m_ExpClassificationRBut.setSelected(true);
                    this.m_ExpRegressionRBut.setSelected(false);
                } else {
                    return false;
                }
            }
            this.m_ExperimentTypeCBox.setSelectedItem(TYPE_CROSSVALIDATION_TEXT);
        } else if (experiment.getResultProducer() instanceof RandomSplitResultProducer) {
            RandomSplitResultProducer randomSplitResultProducer = (RandomSplitResultProducer)experiment.getResultProducer();
            if (randomSplitResultProducer.getRandomizeData()) {
                this.m_ExperimentTypeCBox.setSelectedItem(TYPE_RANDOMSPLIT_TEXT);
            } else {
                this.m_ExperimentTypeCBox.setSelectedItem(TYPE_FIXEDSPLIT_TEXT);
            }
            if (randomSplitResultProducer.getSplitEvaluator() instanceof ClassifierSplitEvaluator) {
                this.m_ExpClassificationRBut.setSelected(true);
                this.m_ExpRegressionRBut.setSelected(false);
            } else if (randomSplitResultProducer.getSplitEvaluator() instanceof RegressionSplitEvaluator) {
                this.m_ExpClassificationRBut.setSelected(false);
                this.m_ExpRegressionRBut.setSelected(true);
            } else {
                System.out.println("SimpleSetup incompatibility: unrecognised split evaluator");
                if (this.userWantsToConvert()) {
                    this.m_ExpClassificationRBut.setSelected(true);
                    this.m_ExpRegressionRBut.setSelected(false);
                } else {
                    return false;
                }
            }
            this.m_trainPercent = randomSplitResultProducer.getTrainPercent();
            this.m_ExperimentParameterTField.setText("" + this.m_trainPercent);
        } else {
            System.out.println("SimpleSetup incompatibility: unrecognised resultProducer");
            if (this.userWantsToConvert()) {
                this.m_ExperimentTypeCBox.setSelectedItem(TYPE_CROSSVALIDATION_TEXT);
                this.m_ExpClassificationRBut.setSelected(true);
                this.m_ExpRegressionRBut.setSelected(false);
            } else {
                return false;
            }
        }
        this.m_ExperimentTypeCBox.setEnabled(true);
        this.m_ExperimentParameterLabel.setEnabled(true);
        this.m_ExperimentParameterTField.setEnabled(true);
        this.m_ExpClassificationRBut.setEnabled(true);
        this.m_ExpRegressionRBut.setEnabled(true);
        if (experiment.getRunLower() == 1) {
            this.m_numRepetitions = experiment.getRunUpper();
            this.m_NumberOfRepetitionsTField.setText("" + this.m_numRepetitions);
        } else {
            System.out.println("SimpleSetup incompatibility: runLower is not 1");
            if (this.userWantsToConvert()) {
                experiment.setRunLower(1);
                if (this.m_ExperimentTypeCBox.getSelectedItem() == TYPE_FIXEDSPLIT_TEXT) {
                    experiment.setRunUpper(1);
                    this.m_NumberOfRepetitionsTField.setEnabled(false);
                    this.m_NumberOfRepetitionsTField.setText("1");
                } else {
                    experiment.setRunUpper(10);
                    this.m_numRepetitions = 10;
                    this.m_NumberOfRepetitionsTField.setText("" + this.m_numRepetitions);
                }
            } else {
                return false;
            }
        }
        this.m_NumberOfRepetitionsTField.setEnabled(true);
        this.m_OrderDatasetsFirstRBut.setSelected(experiment.getAdvanceDataSetFirst());
        this.m_OrderAlgorithmsFirstRBut.setSelected(!experiment.getAdvanceDataSetFirst());
        this.m_OrderDatasetsFirstRBut.setEnabled(true);
        this.m_OrderAlgorithmsFirstRBut.setEnabled(true);
        this.m_NotesText.setText(experiment.getNotes());
        this.m_NotesButton.setEnabled(true);
        if (!experiment.getUsePropertyIterator() || !(experiment.getPropertyArray() instanceof Classifier[])) {
            System.out.println("SimpleSetup incompatibility: unrecognised property iteration");
            if (this.userWantsToConvert()) {
                experiment.setPropertyArray(new Classifier[0]);
                experiment.setUsePropertyIterator(true);
            } else {
                return false;
            }
        }
        this.m_DatasetListPanel.setExperiment(experiment);
        this.m_AlgorithmListPanel.setExperiment(experiment);
        this.m_Exp = experiment;
        this.expTypeChanged();
        this.m_Support.firePropertyChange("", null, null);
        return true;
    }

    public Experiment getExperiment() {
        return this.m_Exp;
    }

    private void openExperiment() {
        int n = this.m_FileChooser.showOpenDialog(this);
        if (n != 0) {
            return;
        }
        File file = this.m_FileChooser.getSelectedFile();
        if (this.m_FileChooser.getFileFilter() == this.m_ExpFilter) {
            if (!file.getName().toLowerCase().endsWith(Experiment.FILE_EXTENSION)) {
                file = new File(file.getParent(), file.getName() + Experiment.FILE_EXTENSION);
            }
        } else if (this.m_FileChooser.getFileFilter() == this.m_KOMLFilter) {
            if (!file.getName().toLowerCase().endsWith(".koml")) {
                file = new File(file.getParent(), file.getName() + ".koml");
            }
        } else if (this.m_FileChooser.getFileFilter() == this.m_XMLFilter && !file.getName().toLowerCase().endsWith(".xml")) {
            file = new File(file.getParent(), file.getName() + ".xml");
        }
        try {
            Experiment experiment = Experiment.read(file.getAbsolutePath());
            if (!this.setExperiment(experiment) && this.m_modePanel != null) {
                this.m_modePanel.switchToAdvanced(experiment);
            }
            System.err.println("Opened experiment:\n" + experiment);
        }
        catch (Exception exception) {
            exception.printStackTrace();
            JOptionPane.showMessageDialog(this, "Couldn't open experiment file:\n" + file + "\nReason:\n" + exception.getMessage(), "Open Experiment", 0);
        }
    }

    private void saveExperiment() {
        int n = this.m_FileChooser.showSaveDialog(this);
        if (n != 0) {
            return;
        }
        File file = this.m_FileChooser.getSelectedFile();
        if (this.m_FileChooser.getFileFilter() == this.m_ExpFilter) {
            if (!file.getName().toLowerCase().endsWith(Experiment.FILE_EXTENSION)) {
                file = new File(file.getParent(), file.getName() + Experiment.FILE_EXTENSION);
            }
        } else if (this.m_FileChooser.getFileFilter() == this.m_KOMLFilter) {
            if (!file.getName().toLowerCase().endsWith(".koml")) {
                file = new File(file.getParent(), file.getName() + ".koml");
            }
        } else if (this.m_FileChooser.getFileFilter() == this.m_XMLFilter && !file.getName().toLowerCase().endsWith(".xml")) {
            file = new File(file.getParent(), file.getName() + ".xml");
        }
        try {
            Experiment.write(file.getAbsolutePath(), this.m_Exp);
            System.err.println("Saved experiment:\n" + this.m_Exp);
        }
        catch (Exception exception) {
            exception.printStackTrace();
            JOptionPane.showMessageDialog(this, "Couldn't save experiment file:\n" + file + "\nReason:\n" + exception.getMessage(), "Save Experiment", 0);
        }
    }

    public void addPropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        this.m_Support.addPropertyChangeListener(propertyChangeListener);
    }

    public void removePropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        this.m_Support.removePropertyChangeListener(propertyChangeListener);
    }

    private void destinationTypeChanged() {
        if (this.m_Exp == null) {
            return;
        }
        String string = "";
        if (this.m_ResultsDestinationCBox.getSelectedItem() == DEST_DATABASE_TEXT) {
            this.m_ResultsDestinationPathLabel.setText("URL:");
            string = this.m_destinationDatabaseURL;
            this.m_BrowseDestinationButton.setEnabled(true);
            this.m_BrowseDestinationButton.setText("User...");
        } else {
            int n;
            this.m_ResultsDestinationPathLabel.setText("Filename:");
            if (this.m_ResultsDestinationCBox.getSelectedItem() == DEST_ARFF_TEXT && (n = this.m_destinationFilename.lastIndexOf(".csv")) > -1) {
                this.m_destinationFilename = this.m_destinationFilename.substring(0, n) + ".arff";
            }
            if (this.m_ResultsDestinationCBox.getSelectedItem() == DEST_CSV_TEXT && (n = this.m_destinationFilename.lastIndexOf(".arff")) > -1) {
                this.m_destinationFilename = this.m_destinationFilename.substring(0, n) + ".csv";
            }
            string = this.m_destinationFilename;
            if (this.m_ResultsDestinationCBox.getSelectedItem() == DEST_ARFF_TEXT && (n = string.lastIndexOf(".csv")) > -1) {
                string = string.substring(0, n) + ".arff";
            }
            if (this.m_ResultsDestinationCBox.getSelectedItem() == DEST_CSV_TEXT && (n = string.lastIndexOf(".arff")) > -1) {
                string = string.substring(0, n) + ".csv";
            }
            this.m_BrowseDestinationButton.setEnabled(true);
            this.m_BrowseDestinationButton.setText("Browse...");
        }
        if (this.m_ResultsDestinationCBox.getSelectedItem() == DEST_DATABASE_TEXT) {
            DatabaseResultListener databaseResultListener = null;
            try {
                databaseResultListener = new DatabaseResultListener();
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
            databaseResultListener.setDatabaseURL(this.m_destinationDatabaseURL);
            this.m_Exp.setResultListener(databaseResultListener);
        } else if (this.m_ResultsDestinationCBox.getSelectedItem() == DEST_ARFF_TEXT) {
            InstancesResultListener instancesResultListener = new InstancesResultListener();
            if (!this.m_destinationFilename.equals("")) {
                instancesResultListener.setOutputFile(new File(this.m_destinationFilename));
            }
            this.m_Exp.setResultListener(instancesResultListener);
        } else if (this.m_ResultsDestinationCBox.getSelectedItem() == DEST_CSV_TEXT) {
            CSVResultListener cSVResultListener = new CSVResultListener();
            if (!this.m_destinationFilename.equals("")) {
                cSVResultListener.setOutputFile(new File(this.m_destinationFilename));
            }
            this.m_Exp.setResultListener(cSVResultListener);
        }
        this.m_ResultsDestinationPathTField.setText(string);
        this.m_Support.firePropertyChange("", null, null);
    }

    private void destinationAddressChanged() {
        if (this.m_Exp == null) {
            return;
        }
        if (this.m_ResultsDestinationCBox.getSelectedItem() == DEST_DATABASE_TEXT) {
            this.m_destinationDatabaseURL = this.m_ResultsDestinationPathTField.getText();
            if (this.m_Exp.getResultListener() instanceof DatabaseResultListener) {
                ((DatabaseResultListener)this.m_Exp.getResultListener()).setDatabaseURL(this.m_destinationDatabaseURL);
            }
        } else {
            File file = null;
            this.m_destinationFilename = this.m_ResultsDestinationPathTField.getText();
            if (this.m_destinationFilename.equals("")) {
                try {
                    if (this.m_ResultsDestinationCBox.getSelectedItem() == DEST_ARFF_TEXT) {
                        file = File.createTempFile("weka_experiment", ".arff");
                    }
                    if (this.m_ResultsDestinationCBox.getSelectedItem() == DEST_CSV_TEXT) {
                        file = File.createTempFile("weka_experiment", ".csv");
                    }
                    file.deleteOnExit();
                }
                catch (Exception exception) {
                    System.err.println("Cannot create temp file, writing to standard out.");
                    file = new File("-");
                }
            } else {
                if (this.m_ResultsDestinationCBox.getSelectedItem() == DEST_ARFF_TEXT && !this.m_destinationFilename.endsWith(".arff")) {
                    this.m_destinationFilename = this.m_destinationFilename + ".arff";
                }
                if (this.m_ResultsDestinationCBox.getSelectedItem() == DEST_CSV_TEXT && !this.m_destinationFilename.endsWith(".csv")) {
                    this.m_destinationFilename = this.m_destinationFilename + ".csv";
                }
                file = new File(this.m_destinationFilename);
            }
            ((CSVResultListener)this.m_Exp.getResultListener()).setOutputFile(file);
            ((CSVResultListener)this.m_Exp.getResultListener()).setOutputFileName(this.m_destinationFilename);
        }
        this.m_Support.firePropertyChange("", null, null);
    }

    private void expTypeChanged() {
        if (this.m_Exp == null) {
            return;
        }
        if (this.m_ExperimentTypeCBox.getSelectedItem() == TYPE_CROSSVALIDATION_TEXT) {
            this.m_ExperimentParameterLabel.setText("Number of folds:");
            this.m_ExperimentParameterTField.setText("" + this.m_numFolds);
        } else {
            this.m_ExperimentParameterLabel.setText("Train percentage:");
            this.m_ExperimentParameterTField.setText("" + this.m_trainPercent);
        }
        if (this.m_ExperimentTypeCBox.getSelectedItem() == TYPE_FIXEDSPLIT_TEXT) {
            this.m_NumberOfRepetitionsTField.setEnabled(false);
            this.m_NumberOfRepetitionsTField.setText("1");
            this.m_Exp.setRunLower(1);
            this.m_Exp.setRunUpper(1);
        } else {
            this.m_NumberOfRepetitionsTField.setText("" + this.m_numRepetitions);
            this.m_NumberOfRepetitionsTField.setEnabled(true);
            this.m_Exp.setRunLower(1);
            this.m_Exp.setRunUpper(this.m_numRepetitions);
        }
        SplitEvaluator splitEvaluator = null;
        Classifier classifier = null;
        if (this.m_ExpClassificationRBut.isSelected()) {
            splitEvaluator = new ClassifierSplitEvaluator();
            classifier = ((ClassifierSplitEvaluator)splitEvaluator).getClassifier();
        } else {
            splitEvaluator = new RegressionSplitEvaluator();
            classifier = ((RegressionSplitEvaluator)splitEvaluator).getClassifier();
        }
        if (this.m_ExperimentTypeCBox.getSelectedItem() == TYPE_CROSSVALIDATION_TEXT) {
            CrossValidationResultProducer crossValidationResultProducer = new CrossValidationResultProducer();
            crossValidationResultProducer.setNumFolds(this.m_numFolds);
            crossValidationResultProducer.setSplitEvaluator(splitEvaluator);
            PropertyNode[] propertyNodeArray = new PropertyNode[2];
            try {
                propertyNodeArray[0] = new PropertyNode(splitEvaluator, new PropertyDescriptor("splitEvaluator", CrossValidationResultProducer.class), CrossValidationResultProducer.class);
                propertyNodeArray[1] = new PropertyNode(classifier, new PropertyDescriptor("classifier", splitEvaluator.getClass()), splitEvaluator.getClass());
            }
            catch (IntrospectionException introspectionException) {
                introspectionException.printStackTrace();
            }
            this.m_Exp.setResultProducer(crossValidationResultProducer);
            this.m_Exp.setPropertyPath(propertyNodeArray);
        } else {
            RandomSplitResultProducer randomSplitResultProducer = new RandomSplitResultProducer();
            randomSplitResultProducer.setRandomizeData(this.m_ExperimentTypeCBox.getSelectedItem() == TYPE_RANDOMSPLIT_TEXT);
            randomSplitResultProducer.setTrainPercent(this.m_trainPercent);
            randomSplitResultProducer.setSplitEvaluator(splitEvaluator);
            PropertyNode[] propertyNodeArray = new PropertyNode[2];
            try {
                propertyNodeArray[0] = new PropertyNode(splitEvaluator, new PropertyDescriptor("splitEvaluator", RandomSplitResultProducer.class), RandomSplitResultProducer.class);
                propertyNodeArray[1] = new PropertyNode(classifier, new PropertyDescriptor("classifier", splitEvaluator.getClass()), splitEvaluator.getClass());
            }
            catch (IntrospectionException introspectionException) {
                introspectionException.printStackTrace();
            }
            this.m_Exp.setResultProducer(randomSplitResultProducer);
            this.m_Exp.setPropertyPath(propertyNodeArray);
        }
        this.m_Exp.setUsePropertyIterator(true);
        this.m_Support.firePropertyChange("", null, null);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void expParamChanged() {
        if (this.m_Exp == null) {
            return;
        }
        if (this.m_ExperimentTypeCBox.getSelectedItem() == TYPE_CROSSVALIDATION_TEXT) {
            try {
                this.m_numFolds = Integer.parseInt(this.m_ExperimentParameterTField.getText());
            }
            catch (NumberFormatException numberFormatException) {
                return;
            }
        }
        try {
            this.m_trainPercent = Double.parseDouble(this.m_ExperimentParameterTField.getText());
        }
        catch (NumberFormatException numberFormatException) {
            return;
        }
        if (this.m_ExperimentTypeCBox.getSelectedItem() == TYPE_CROSSVALIDATION_TEXT) {
            if (!(this.m_Exp.getResultProducer() instanceof CrossValidationResultProducer)) return;
            CrossValidationResultProducer crossValidationResultProducer = (CrossValidationResultProducer)this.m_Exp.getResultProducer();
            crossValidationResultProducer.setNumFolds(this.m_numFolds);
        } else {
            if (!(this.m_Exp.getResultProducer() instanceof RandomSplitResultProducer)) return;
            RandomSplitResultProducer randomSplitResultProducer = (RandomSplitResultProducer)this.m_Exp.getResultProducer();
            randomSplitResultProducer.setRandomizeData(this.m_ExperimentTypeCBox.getSelectedItem() == TYPE_RANDOMSPLIT_TEXT);
            randomSplitResultProducer.setTrainPercent(this.m_trainPercent);
        }
        this.m_Support.firePropertyChange("", null, null);
    }

    private void numRepetitionsChanged() {
        if (this.m_Exp == null || !this.m_NumberOfRepetitionsTField.isEnabled()) {
            return;
        }
        try {
            this.m_numRepetitions = Integer.parseInt(this.m_NumberOfRepetitionsTField.getText());
        }
        catch (NumberFormatException numberFormatException) {
            return;
        }
        this.m_Exp.setRunLower(1);
        this.m_Exp.setRunUpper(this.m_numRepetitions);
        this.m_Support.firePropertyChange("", null, null);
    }

    private void chooseURLUsername() {
        String string = ((DatabaseResultListener)this.m_Exp.getResultListener()).getDatabaseURL();
        String string2 = ((DatabaseResultListener)this.m_Exp.getResultListener()).getUsername();
        DatabaseConnectionDialog databaseConnectionDialog = new DatabaseConnectionDialog(null, string, string2);
        databaseConnectionDialog.setVisible(true);
        if (databaseConnectionDialog.getReturnValue() == -1) {
            return;
        }
        ((DatabaseResultListener)this.m_Exp.getResultListener()).setUsername(databaseConnectionDialog.getUsername());
        ((DatabaseResultListener)this.m_Exp.getResultListener()).setPassword(databaseConnectionDialog.getPassword());
        ((DatabaseResultListener)this.m_Exp.getResultListener()).setDatabaseURL(databaseConnectionDialog.getURL());
        ((DatabaseResultListener)this.m_Exp.getResultListener()).setDebug(databaseConnectionDialog.getDebug());
        this.m_ResultsDestinationPathTField.setText(databaseConnectionDialog.getURL());
    }

    private void chooseDestinationFile() {
        ExtensionFileFilter extensionFileFilter = null;
        extensionFileFilter = this.m_ResultsDestinationCBox.getSelectedItem() == DEST_CSV_TEXT ? this.m_csvFileFilter : this.m_arffFileFilter;
        this.m_DestFileChooser.setFileFilter(extensionFileFilter);
        int n = this.m_DestFileChooser.showSaveDialog(this);
        if (n != 0) {
            return;
        }
        this.m_ResultsDestinationPathTField.setText(this.m_DestFileChooser.getSelectedFile().toString());
    }
}

