/*
 * Decompiled with CFR 0.152.
 */
package weka.gui.beans;

import java.awt.BorderLayout;
import java.awt.Component;
import java.beans.EventSetDescriptor;
import java.util.ArrayList;
import javax.swing.JPanel;
import weka.core.Instance;
import weka.core.Instances;
import weka.gui.Logger;
import weka.gui.beans.BeanCommon;
import weka.gui.beans.BeanVisual;
import weka.gui.beans.DataSetEvent;
import weka.gui.beans.DataSource;
import weka.gui.beans.DataSourceListener;
import weka.gui.beans.EventConstraints;
import weka.gui.beans.InstanceEvent;
import weka.gui.beans.InstanceListener;
import weka.gui.beans.Visible;

public class InstanceStreamToBatchMaker
extends JPanel
implements BeanCommon,
Visible,
InstanceListener,
EventConstraints,
DataSource {
    private static final long serialVersionUID = -7037141087208627799L;
    protected BeanVisual m_visual = new BeanVisual("InstanceStreamToBatchMaker", "weka/gui/beans/icons/InstanceStreamToBatchMaker.gif", "weka/gui/beans/icons/InstanceStreamToBatchMaker_animated.gif");
    private transient Logger m_log;
    private Object m_listenee;
    private ArrayList<DataSourceListener> m_dataListeners = new ArrayList();
    private ArrayList<Instance> m_batch;
    private Instances m_structure;

    public InstanceStreamToBatchMaker() {
        this.setLayout(new BorderLayout());
        this.add((Component)this.m_visual, "Center");
    }

    public void acceptInstance(InstanceEvent instanceEvent) {
        if (instanceEvent.getStatus() == 0) {
            this.m_batch = new ArrayList();
            this.m_structure = instanceEvent.getStructure();
            if (this.m_log != null) {
                this.m_log.logMessage("[InstanceStreamToBatch] passing on structure.");
            }
            DataSetEvent dataSetEvent = new DataSetEvent(this, this.m_structure);
            this.notifyDataListeners(dataSetEvent);
        } else if (instanceEvent.getStatus() == 1) {
            this.m_batch.add(instanceEvent.getInstance());
        } else {
            this.m_batch.add(instanceEvent.getInstance());
            Instances instances = new Instances(this.m_structure, this.m_batch.size());
            for (Instance instance : this.m_batch) {
                instances.add(instance);
            }
            instances.compactify();
            this.m_batch = null;
            if (this.m_log != null) {
                this.m_log.logMessage("[InstanceStreamToBatch] sending batch to listeners.");
            }
            DataSetEvent dataSetEvent = new DataSetEvent(this, instances);
            this.notifyDataListeners(dataSetEvent);
        }
    }

    public boolean connectionAllowed(EventSetDescriptor eventSetDescriptor) {
        return this.connectionAllowed(eventSetDescriptor.getName());
    }

    public boolean connectionAllowed(String string) {
        return this.m_listenee == null && string.equals("instance");
    }

    public void connectionNotification(String string, Object object) {
        if (this.connectionAllowed(string)) {
            this.m_listenee = object;
        }
    }

    public void disconnectionNotification(String string, Object object) {
        this.m_listenee = null;
    }

    public boolean eventGeneratable(String string) {
        if (!string.equals("dataSet")) {
            return false;
        }
        if (this.m_listenee == null) {
            return false;
        }
        return !(this.m_listenee instanceof EventConstraints) || ((EventConstraints)this.m_listenee).eventGeneratable("instance");
    }

    public String getCustomName() {
        return this.m_visual.getText();
    }

    public void setCustomName(String string) {
        this.m_visual.setText(string);
    }

    public void setLog(Logger logger) {
        this.m_log = logger;
    }

    public boolean isBusy() {
        return false;
    }

    public void stop() {
    }

    public BeanVisual getVisual() {
        return this.m_visual;
    }

    public void setVisual(BeanVisual beanVisual) {
        this.m_visual = beanVisual;
    }

    public void useDefaultVisual() {
        this.m_visual.loadIcons("weka/gui/beans/icons/InstanceStreamToBatchMaker.gif", "weka/gui/beans/icons/InstanceStreamToBatchMaker_animated.gif");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void notifyDataListeners(DataSetEvent dataSetEvent) {
        ArrayList arrayList;
        InstanceStreamToBatchMaker instanceStreamToBatchMaker = this;
        synchronized (instanceStreamToBatchMaker) {
            arrayList = (ArrayList)this.m_dataListeners.clone();
        }
        if (arrayList.size() > 0) {
            for (int i = 0; i < arrayList.size(); ++i) {
                ((DataSourceListener)arrayList.get(i)).acceptDataSet(dataSetEvent);
            }
        }
    }

    public synchronized void addDataSourceListener(DataSourceListener dataSourceListener) {
        this.m_dataListeners.add(dataSourceListener);
        if (this.m_structure != null) {
            DataSetEvent dataSetEvent = new DataSetEvent(this, this.m_structure);
            dataSourceListener.acceptDataSet(dataSetEvent);
        }
    }

    public synchronized void removeDataSourceListener(DataSourceListener dataSourceListener) {
        this.m_dataListeners.remove(dataSourceListener);
    }

    public synchronized void addInstanceListener(InstanceListener instanceListener) {
    }

    public synchronized void removeInstanceListener(InstanceListener instanceListener) {
    }
}

