/*
 * Decompiled with CFR 0.152.
 */
package weka.core.pmml;

import java.io.Serializable;
import org.w3c.dom.Element;
import weka.core.Attribute;

public abstract class FieldMetaInfo
implements Serializable {
    protected String m_fieldName;
    protected Optype m_optype = Optype.NONE;

    public Optype getOptype() {
        return this.m_optype;
    }

    public String getFieldName() {
        return this.m_fieldName;
    }

    public FieldMetaInfo(Element element) {
        this.m_fieldName = element.getAttribute("name");
        String string = element.getAttribute("optype");
        if (string != null && string.length() > 0) {
            for (Optype optype : Optype.values()) {
                if (!optype.toString().equals(string)) continue;
                this.m_optype = optype;
                break;
            }
        }
    }

    public abstract Attribute getFieldAsAttribute();

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Optype {
        NONE("none"),
        CONTINUOUS("continuous"),
        CATEGORICAL("categorical"),
        ORDINAL("ordinal");

        private final String m_stringVal;

        private Optype(String string2) {
            this.m_stringVal = string2;
        }

        public String toString() {
            return this.m_stringVal;
        }
    }

    public static class Interval
    implements Serializable {
        private static final long serialVersionUID = -7339790632684638012L;
        protected double m_leftMargin = Double.NEGATIVE_INFINITY;
        protected double m_rightMargin = Double.POSITIVE_INFINITY;
        protected Closure m_closure = Closure.OPENOPEN;

        protected Interval(Element element) throws Exception {
            String string = element.getAttribute("leftMargin");
            try {
                this.m_leftMargin = Double.parseDouble(string);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                throw new Exception("[Interval] Can't parse left margin as a number");
            }
            String string2 = element.getAttribute("rightMargin");
            try {
                this.m_rightMargin = Double.parseDouble(string2);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                throw new Exception("[Interval] Can't parse right margin as a number");
            }
            String string3 = element.getAttribute("closure");
            if (string3 == null || string3.length() == 0) {
                throw new Exception("[Interval] No closure specified!");
            }
            for (Closure closure : Closure.values()) {
                if (!closure.toString().equals(string3)) continue;
                this.m_closure = closure;
                break;
            }
        }

        public boolean containsValue(double d) {
            boolean bl = false;
            switch (this.m_closure) {
                case OPENCLOSED: {
                    if (!(d > this.m_leftMargin) || !(d <= this.m_rightMargin)) break;
                    bl = true;
                    break;
                }
                case OPENOPEN: {
                    if (!(d > this.m_leftMargin) || !(d < this.m_rightMargin)) break;
                    bl = true;
                    break;
                }
                case CLOSEDOPEN: {
                    if (!(d >= this.m_leftMargin) || !(d < this.m_rightMargin)) break;
                    bl = true;
                    break;
                }
                case CLOSEDCLOSED: {
                    if (!(d >= this.m_leftMargin) || !(d <= this.m_rightMargin)) break;
                    bl = true;
                    break;
                }
                default: {
                    bl = false;
                }
            }
            return bl;
        }

        public String toString() {
            return this.m_closure.toString(this.m_leftMargin, this.m_rightMargin);
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public static enum Closure {
            OPENCLOSED("openClosed", "(", "]"),
            OPENOPEN("openOpen", "(", ")"),
            CLOSEDOPEN("closedOpen", "[", ")"),
            CLOSEDCLOSED("closedClosed", "[", "]");

            private final String m_stringVal;
            private final String m_left;
            private final String m_right;

            private Closure(String string2, String string3, String string4) {
                this.m_stringVal = string2;
                this.m_left = string3;
                this.m_right = string4;
            }

            public String toString() {
                return this.m_stringVal;
            }

            public String toString(double d, double d2) {
                return this.m_left + d + "-" + d2 + this.m_right;
            }
        }
    }

    public static class Value
    implements Serializable {
        private static final long serialVersionUID = -3981030320273649739L;
        protected String m_value;
        protected String m_displayValue;
        protected Property m_property = Property.VALID;

        protected Value(Element element) throws Exception {
            String string;
            this.m_value = element.getAttribute("value");
            String string2 = element.getAttribute("displayValue");
            if (string2 != null && string2.length() > 0) {
                this.m_displayValue = string2;
            }
            if ((string = element.getAttribute("property")) != null && string.length() > 0) {
                for (Property property : Property.values()) {
                    if (!property.toString().equals(string)) continue;
                    this.m_property = property;
                    break;
                }
            }
        }

        public String toString() {
            String string = this.m_value;
            if (this.m_displayValue != null) {
                string = string + "(" + this.m_displayValue + "): " + this.m_property.toString();
            }
            return string;
        }

        public String getValue() {
            return this.m_value;
        }

        public String getDisplayValue() {
            return this.m_displayValue;
        }

        public Property getProperty() {
            return this.m_property;
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public static enum Property {
            VALID("valid"),
            INVALID("invalid"),
            MISSING("missing");

            private final String m_stringVal;

            private Property(String string2) {
                this.m_stringVal = string2;
            }

            public String toString() {
                return this.m_stringVal;
            }
        }
    }
}

