/*
 * Decompiled with CFR 0.152.
 */
package weka.datagenerators.clusterers;

import java.util.Enumeration;
import java.util.Random;
import java.util.Vector;
import weka.core.Attribute;
import weka.core.FastVector;
import weka.core.Instance;
import weka.core.Instances;
import weka.core.Option;
import weka.core.Range;
import weka.core.RevisionUtils;
import weka.core.Tag;
import weka.core.Utils;
import weka.datagenerators.ClusterDefinition;
import weka.datagenerators.ClusterGenerator;
import weka.datagenerators.clusterers.SubspaceClusterDefinition;

public class SubspaceCluster
extends ClusterGenerator {
    static final long serialVersionUID = -3454999858505621128L;
    protected double m_NoiseRate;
    protected ClusterDefinition[] m_Clusters;
    protected int[] m_numValues;
    protected double[] m_globalMinValue;
    protected double[] m_globalMaxValue;
    public static final int UNIFORM_RANDOM = 0;
    public static final int TOTAL_UNIFORM = 1;
    public static final int GAUSSIAN = 2;
    public static final Tag[] TAGS_CLUSTERTYPE = new Tag[]{new Tag(0, "uniform/random"), new Tag(1, "total uniform"), new Tag(2, "gaussian")};
    public static final int CONTINUOUS = 0;
    public static final int INTEGER = 1;
    public static final Tag[] TAGS_CLUSTERSUBTYPE = new Tag[]{new Tag(0, "continuous"), new Tag(1, "integer")};

    public SubspaceCluster() {
        this.setNoiseRate(this.defaultNoiseRate());
    }

    public String globalInfo() {
        return "A data generator that produces data points in hyperrectangular subspace clusters.";
    }

    public Enumeration listOptions() {
        Vector vector = this.enumToVector(super.listOptions());
        vector.addElement(new Option("\tThe noise rate in percent (default " + this.defaultNoiseRate() + ").\n" + "\tCan be between 0% and 30%. (Remark: The original \n" + "\talgorithm only allows noise up to 10%.)", "P", 1, "-P <num>"));
        vector.addElement(new Option("\tA cluster definition of class '" + SubspaceClusterDefinition.class.getName().replaceAll(".*\\.", "") + "'\n" + "\t(definition needs to be quoted to be recognized as \n" + "\ta single argument).", "C", 1, "-C <cluster-definition>"));
        vector.addElement(new Option("", "", 0, "\nOptions specific to " + SubspaceClusterDefinition.class.getName() + ":"));
        vector.addAll(this.enumToVector(new SubspaceClusterDefinition(this).listOptions()));
        return vector.elements();
    }

    public void setOptions(String[] stringArray) throws Exception {
        super.setOptions(stringArray);
        this.m_numValues = new int[this.getNumAttributes()];
        for (int i = 0; i < this.getNumAttributes(); ++i) {
            this.m_numValues[i] = 1;
        }
        String string = Utils.getOption('P', stringArray);
        if (string.length() != 0) {
            this.setNoiseRate(Double.parseDouble(string));
        } else {
            this.setNoiseRate(this.defaultNoiseRate());
        }
        Vector<SubspaceClusterDefinition> vector = new Vector<SubspaceClusterDefinition>();
        int n = 0;
        do {
            if ((string = Utils.getOption('C', stringArray)).length() == 0) continue;
            ++n;
            SubspaceClusterDefinition subspaceClusterDefinition = new SubspaceClusterDefinition(this);
            subspaceClusterDefinition.setOptions(Utils.splitOptions(string));
            vector.add(subspaceClusterDefinition);
        } while (string.length() != 0);
        this.m_Clusters = vector.toArray(new ClusterDefinition[vector.size()]);
        this.getClusters();
    }

    public String[] getOptions() {
        int n;
        Vector<String> vector = new Vector<String>();
        String[] stringArray = super.getOptions();
        for (n = 0; n < stringArray.length; ++n) {
            vector.add(stringArray[n]);
        }
        vector.add("-P");
        vector.add("" + this.getNoiseRate());
        for (n = 0; n < this.getClusters().length; ++n) {
            vector.add("-C");
            vector.add(Utils.joinOptions(this.getClusters()[n].getOptions()));
        }
        return vector.toArray(new String[vector.size()]);
    }

    protected ClusterDefinition[] getClusters() {
        if (this.m_Clusters == null || this.m_Clusters.length == 0) {
            if (this.m_Clusters != null) {
                System.out.println("NOTE: at least 1 cluster definition is necessary, created default one.");
            }
            this.m_Clusters = new ClusterDefinition[]{new SubspaceClusterDefinition(this)};
        }
        return this.m_Clusters;
    }

    protected int defaultNumAttributes() {
        return 1;
    }

    public void setNumAttributes(int n) {
        super.setNumAttributes(n);
        this.m_numValues = new int[this.getNumAttributes()];
    }

    public String numAttributesTipText() {
        return "The number of attributes the generated data will contain (Note: they must be covered by the cluster definitions!)";
    }

    protected double defaultNoiseRate() {
        return 0.0;
    }

    public double getNoiseRate() {
        return this.m_NoiseRate;
    }

    public void setNoiseRate(double d) {
        this.m_NoiseRate = d;
    }

    public String noiseRateTipText() {
        return "The noise rate to use.";
    }

    public ClusterDefinition[] getClusterDefinitions() {
        return this.getClusters();
    }

    public void setClusterDefinitions(ClusterDefinition[] clusterDefinitionArray) throws Exception {
        String string = "";
        this.m_Clusters = clusterDefinitionArray;
        for (int i = 0; i < this.getClusters().length; ++i) {
            if (!(this.getClusters()[i] instanceof SubspaceClusterDefinition)) {
                if (string.length() != 0) {
                    string = string + ",";
                }
                string = string + "" + (i + 1);
            }
            this.getClusters()[i].setParent(this);
            this.getClusters()[i].setOptions(this.getClusters()[i].getOptions());
        }
        if (string.length() != 0) {
            throw new Exception("These cluster definitions are not '" + SubspaceClusterDefinition.class.getName() + "': " + string);
        }
    }

    public String clusterDefinitionsTipText() {
        return "The clusters to use.";
    }

    protected boolean checkCoverage() {
        int n;
        int[] nArray = new int[this.getNumAttributes()];
        for (n = 0; n < this.getNumAttributes(); ++n) {
            for (int i = 0; i < this.getClusters().length; ++i) {
                SubspaceClusterDefinition subspaceClusterDefinition = (SubspaceClusterDefinition)this.getClusters()[i];
                Range range = new Range(subspaceClusterDefinition.getAttrIndexRange());
                range.setUpper(this.getNumAttributes());
                if (!range.isInRange(n)) continue;
                int n2 = n;
                nArray[n2] = nArray[n2] + 1;
            }
        }
        String string = "";
        for (n = 0; n < nArray.length; ++n) {
            if (nArray[n] != 0) continue;
            if (string.length() != 0) {
                string = string + ",";
            }
            string = string + (n + 1);
        }
        if (string.length() != 0) {
            throw new IllegalArgumentException("The following attributes are not covered by a cluster definition: " + string + "\n");
        }
        return true;
    }

    public boolean getSingleModeFlag() {
        return false;
    }

    public Instances defineDataFormat() throws Exception {
        int n;
        Attribute attribute;
        int n2;
        this.setOptions(this.getOptions());
        this.checkCoverage();
        Random random = new Random(this.getSeed());
        this.setRandom(random);
        FastVector fastVector = new FastVector(3);
        boolean bl = this.getClassFlag();
        FastVector fastVector2 = null;
        if (bl) {
            fastVector2 = new FastVector(this.getClusters().length);
        }
        FastVector fastVector3 = new FastVector(2);
        fastVector3.addElement("false");
        fastVector3.addElement("true");
        FastVector fastVector4 = null;
        for (n2 = 0; n2 < this.getNumAttributes(); ++n2) {
            if (this.m_booleanCols.isInRange(n2)) {
                attribute = new Attribute("B" + n2, fastVector3);
            } else if (this.m_nominalCols.isInRange(n2)) {
                fastVector4 = new FastVector(this.m_numValues[n2]);
                for (n = 0; n < this.m_numValues[n2]; ++n) {
                    fastVector4.addElement("value-" + n);
                }
                attribute = new Attribute("N" + n2, fastVector4);
            } else {
                attribute = new Attribute("X" + n2);
            }
            fastVector.addElement(attribute);
        }
        if (bl) {
            for (n2 = 0; n2 < this.getClusters().length; ++n2) {
                fastVector2.addElement("c" + n2);
            }
            attribute = new Attribute("class", fastVector2);
            fastVector.addElement(attribute);
        }
        Instances instances = new Instances(this.getRelationNameToUse(), fastVector, 0);
        if (bl) {
            instances.setClassIndex(this.m_NumAttributes);
        }
        Instances instances2 = new Instances(instances, 0);
        this.setDatasetFormat(instances2);
        for (n = 0; n < this.getClusters().length; ++n) {
            SubspaceClusterDefinition subspaceClusterDefinition = (SubspaceClusterDefinition)this.getClusters()[n];
            subspaceClusterDefinition.setNumInstances(random);
            subspaceClusterDefinition.setParent(this);
        }
        return instances;
    }

    public boolean isBoolean(int n) {
        return this.m_booleanCols.isInRange(n);
    }

    public boolean isNominal(int n) {
        return this.m_nominalCols.isInRange(n);
    }

    public int[] getNumValues() {
        return this.m_numValues;
    }

    public Instance generateExample() throws Exception {
        throw new Exception("Examples cannot be generated one by one.");
    }

    public Instances generateExamples() throws Exception {
        Instances instances = this.getDatasetFormat();
        Instance instance = null;
        if (instances == null) {
            throw new Exception("Dataset format not defined.");
        }
        block5: for (int i = 0; i < this.getClusters().length; ++i) {
            SubspaceClusterDefinition subspaceClusterDefinition = (SubspaceClusterDefinition)this.getClusters()[i];
            int n = subspaceClusterDefinition.getNumInstances();
            String string = "c" + i;
            switch (subspaceClusterDefinition.getClusterType().getSelectedTag().getID()) {
                case 0: {
                    for (int j = 0; j < n; ++j) {
                        instance = this.generateExample(instances, this.getRandom(), subspaceClusterDefinition, string);
                        if (instance == null) continue;
                        instances.add(instance);
                    }
                    continue block5;
                }
                case 1: {
                    if (!subspaceClusterDefinition.isInteger()) {
                        this.generateUniformExamples(instances, n, subspaceClusterDefinition, string);
                        continue block5;
                    }
                    this.generateUniformIntegerExamples(instances, n, subspaceClusterDefinition, string);
                    continue block5;
                }
                case 2: {
                    this.generateGaussianExamples(instances, n, this.getRandom(), subspaceClusterDefinition, string);
                }
            }
        }
        return instances;
    }

    private Instance generateExample(Instances instances, Random random, SubspaceClusterDefinition subspaceClusterDefinition, String string) {
        boolean bl = subspaceClusterDefinition.isInteger();
        int n = -1;
        Instance instance = null;
        int n2 = this.m_NumAttributes;
        if (this.getClassFlag()) {
            ++n2;
        }
        instance = new Instance(n2);
        instance.setDataset(instances);
        boolean[] blArray = subspaceClusterDefinition.getAttributes();
        double[] dArray = subspaceClusterDefinition.getMinValue();
        double[] dArray2 = subspaceClusterDefinition.getMaxValue();
        int n3 = -1;
        for (int i = 0; i < this.m_NumAttributes; ++i) {
            if (blArray[i]) {
                double d;
                ++n3;
                ++n;
                if (this.isBoolean(i) || this.isNominal(i)) {
                    if (dArray[n3] == dArray2[n3]) {
                        d = dArray[n3];
                    } else {
                        int n4 = (int)(dArray2[n3] - dArray[n3] + 1.0);
                        d = random.nextInt(n4);
                        d += dArray[n3];
                    }
                } else {
                    d = random.nextDouble() * (dArray2[n] - dArray[n]) + dArray[n];
                    if (bl) {
                        d = Math.round(d);
                    }
                }
                instance.setValue(i, d);
                continue;
            }
            instance.setMissing(i);
        }
        if (this.getClassFlag()) {
            instance.setClassValue(string);
        }
        return instance;
    }

    private void generateUniformExamples(Instances instances, int n, SubspaceClusterDefinition subspaceClusterDefinition, String string) {
        int n2;
        Instance instance = null;
        int n3 = this.m_NumAttributes;
        if (this.getClassFlag()) {
            ++n3;
        }
        instance = new Instance(n3);
        instance.setDataset(instances);
        boolean[] blArray = subspaceClusterDefinition.getAttributes();
        double[] dArray = subspaceClusterDefinition.getMinValue();
        double[] dArray2 = subspaceClusterDefinition.getMaxValue();
        double[] dArray3 = new double[dArray.length];
        for (n2 = 0; n2 < dArray.length; ++n2) {
            dArray3[n2] = dArray2[n2] - dArray[n2];
        }
        for (n2 = 0; n2 < n; ++n2) {
            int n4 = -1;
            for (int i = 0; i < this.m_NumAttributes; ++i) {
                if (blArray[i]) {
                    double d = dArray[++n4] + dArray3[n4] * ((double)n2 / (double)(n - 1));
                    instance.setValue(i, d);
                    continue;
                }
                instance.setMissing(i);
            }
            if (this.getClassFlag()) {
                instance.setClassValue(string);
            }
            instances.add(instance);
        }
    }

    private void generateUniformIntegerExamples(Instances instances, int n, SubspaceClusterDefinition subspaceClusterDefinition, String string) {
        int n2;
        int n3;
        Instance instance = null;
        int n4 = this.m_NumAttributes;
        if (this.getClassFlag()) {
            ++n4;
        }
        instance = new Instance(n4);
        instance.setDataset(instances);
        boolean[] blArray = subspaceClusterDefinition.getAttributes();
        double[] dArray = subspaceClusterDefinition.getMinValue();
        double[] dArray2 = subspaceClusterDefinition.getMaxValue();
        int[] nArray = new int[dArray.length];
        int[] nArray2 = new int[dArray2.length];
        int[] nArray3 = new int[dArray2.length];
        int[] nArray4 = new int[dArray.length];
        int n5 = 1;
        for (n3 = 0; n3 < dArray.length; ++n3) {
            nArray[n3] = (int)Math.ceil(dArray[n3]);
            nArray2[n3] = (int)Math.floor(dArray2[n3]);
            nArray4[n3] = nArray2[n3] - nArray[n3] + 1;
            n5 *= nArray4[n3];
        }
        n3 = n / n5;
        int n6 = n - n3 * n5;
        for (n2 = 0; n2 < this.m_NumAttributes; ++n2) {
            if (blArray[n2]) {
                instance.setValue(n2, (double)nArray[n2]);
                nArray3[n2] = nArray[n2];
                continue;
            }
            instance.setMissing(n2);
        }
        if (this.getClassFlag()) {
            instance.setClassValue(string);
        }
        n2 = 0;
        int n7 = 0;
        do {
            int n8;
            for (n8 = 0; n8 < n3; ++n8) {
                instances.add(instance);
                instance = (Instance)instance.copy();
                ++n2;
            }
            if (n6 > 0) {
                instances.add(instance);
                instance = (Instance)instance.copy();
                ++n2;
                --n6;
            }
            if (n2 >= n) break;
            n8 = 0;
            do {
                if (blArray[n7] && nArray3[n7] + 1 <= nArray2[n7]) {
                    int n9 = n7;
                    nArray3[n9] = nArray3[n9] + 1;
                    n8 = 1;
                    continue;
                }
                ++n7;
            } while (n8 == 0);
            instance.setValue(n7, (double)nArray3[n7]);
        } while (n2 < n);
    }

    private void generateGaussianExamples(Instances instances, int n, Random random, SubspaceClusterDefinition subspaceClusterDefinition, String string) {
        boolean bl = subspaceClusterDefinition.isInteger();
        Instance instance = null;
        int n2 = this.m_NumAttributes;
        if (this.getClassFlag()) {
            ++n2;
        }
        instance = new Instance(n2);
        instance.setDataset(instances);
        boolean[] blArray = subspaceClusterDefinition.getAttributes();
        double[] dArray = subspaceClusterDefinition.getMeanValue();
        double[] dArray2 = subspaceClusterDefinition.getStddevValue();
        for (int i = 0; i < n; ++i) {
            int n3 = -1;
            for (int j = 0; j < this.m_NumAttributes; ++j) {
                if (blArray[j]) {
                    double d = dArray[++n3] + random.nextGaussian() * dArray2[n3];
                    if (bl) {
                        d = Math.round(d);
                    }
                    instance.setValue(j, d);
                    continue;
                }
                instance.setMissing(j);
            }
            if (this.getClassFlag()) {
                instance.setClassValue(string);
            }
            instances.add(instance);
        }
    }

    public String generateFinished() throws Exception {
        return "";
    }

    public String generateStart() {
        StringBuffer stringBuffer = new StringBuffer();
        int n = 0;
        for (int i = 0; i < this.getClusters().length; ++i) {
            SubspaceClusterDefinition subspaceClusterDefinition = (SubspaceClusterDefinition)this.getClusters()[i];
            stringBuffer.append("%\n");
            stringBuffer.append("% Cluster: c" + i + "   ");
            switch (subspaceClusterDefinition.getClusterType().getSelectedTag().getID()) {
                case 0: {
                    stringBuffer.append("Uniform Random");
                    break;
                }
                case 1: {
                    stringBuffer.append("Total Random");
                    break;
                }
                case 2: {
                    stringBuffer.append("Gaussian");
                }
            }
            if (subspaceClusterDefinition.isInteger()) {
                stringBuffer.append(" / INTEGER");
            }
            stringBuffer.append("\n% ----------------------------------------------\n");
            stringBuffer.append("%" + subspaceClusterDefinition.attributesToString());
            stringBuffer.append("\n% Number of Instances:            " + subspaceClusterDefinition.getInstNums() + "\n");
            stringBuffer.append("% Generated Number of Instances:  " + subspaceClusterDefinition.getNumInstances() + "\n");
            n += subspaceClusterDefinition.getNumInstances();
        }
        stringBuffer.append("%\n% ----------------------------------------------\n");
        stringBuffer.append("% Total Number of Instances: " + n + "\n");
        stringBuffer.append("%                            in " + this.getClusters().length + " Cluster(s)\n%");
        return stringBuffer.toString();
    }

    public String getRevision() {
        return RevisionUtils.extract("$Revision: 1.5 $");
    }

    public static void main(String[] stringArray) {
        SubspaceCluster.runDataGenerator(new SubspaceCluster(), stringArray);
    }
}

