/*
 * Decompiled with CFR 0.152.
 */
package weka.gui;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.beans.PropertyEditor;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JTabbedPane;
import weka.classifiers.EnsembleLibrary;
import weka.gui.CostMatrixEditor;
import weka.gui.GenericArrayEditor;
import weka.gui.GenericObjectEditor;
import weka.gui.PropertyPanel;
import weka.gui.PropertyText;
import weka.gui.PropertyValueSelector;
import weka.gui.ensembleLibraryEditor.AddModelsPanel;
import weka.gui.ensembleLibraryEditor.ListModelsPanel;

public class EnsembleLibraryEditor
implements PropertyEditor {
    protected EnsembleLibrary m_Library;
    protected transient PropertyChangeSupport m_PropSupport = new PropertyChangeSupport(this);
    protected transient CustomEditor m_CustomEditor = new CustomEditor();
    protected transient JTabbedPane m_ModelOptionsPane = new JTabbedPane();
    protected transient ListModelsPanel m_ListModelsPanel = new ListModelsPanel(this.m_Library);

    public EnsembleLibraryEditor() {
        this.m_PropSupport = new PropertyChangeSupport(this);
        this.m_CustomEditor = new CustomEditor();
    }

    public void setValue(Object value) {
        this.m_Library = (EnsembleLibrary)value;
        this.m_ListModelsPanel.setLibrary(this.m_Library);
    }

    public Object getValue() {
        return this.m_Library;
    }

    public boolean isPaintable() {
        return true;
    }

    public void paintValue(Graphics gfx, Rectangle box) {
        gfx.drawString(this.m_Library.size() + " models selected", box.x, box.y + box.height);
    }

    public String getJavaInitializationString() {
        return "new Library(" + this.m_Library.size() + ")";
    }

    public String getAsText() {
        return null;
    }

    public void setAsText(String text) {
        throw new IllegalArgumentException("LibraryEditor: Library properties cannot be expressed as text");
    }

    public String[] getTags() {
        return null;
    }

    public Component getCustomEditor() {
        return this.m_CustomEditor;
    }

    public boolean supportsCustomEditor() {
        return true;
    }

    public void addPropertyChangeListener(PropertyChangeListener listener) {
        this.m_Library.addPropertyChangeListener(listener);
    }

    public void removePropertyChangeListener(PropertyChangeListener listener) {
        this.m_PropSupport.removePropertyChangeListener(listener);
    }

    public static Object getEditorValue(Object source) {
        Object value = null;
        if (source instanceof GenericArrayEditor) {
            value = ((GenericArrayEditor)source).getValue();
        } else if (source instanceof CostMatrixEditor) {
            value = ((CostMatrixEditor)source).getValue();
        } else if (source instanceof PropertyText) {
            value = ((PropertyText)source).getText();
        } else if (source instanceof PropertyEditor) {
            value = ((PropertyEditor)source).getValue();
        }
        return value;
    }

    public static Component getDefaultRenderer(PropertyEditor nodeEditor) {
        JComponent genericRenderer = null;
        if (nodeEditor.isPaintable() && nodeEditor.supportsCustomEditor()) {
            genericRenderer = new PropertyPanel(nodeEditor);
        } else if (nodeEditor.getTags() != null) {
            genericRenderer = new PropertyValueSelector(nodeEditor);
        } else if (nodeEditor.getAsText() != null) {
            genericRenderer = new PropertyText(nodeEditor);
            ((PropertyText)genericRenderer).setColumns(20);
        } else {
            System.err.println("Warning: Property \"" + nodeEditor.getClass().toString() + "\" has non-displayabale editor.  Skipping.");
        }
        return genericRenderer;
    }

    public static Component createGenericObjectRenderer(GenericObjectEditor classifierEditor) {
        PropertyPanel propertyPanel = new PropertyPanel(classifierEditor);
        return propertyPanel;
    }

    public static void main(String[] args) {
        EnsembleLibrary value = new EnsembleLibrary();
        EnsembleLibraryEditor libraryEditor = new EnsembleLibraryEditor();
        libraryEditor.setValue(value);
        JPanel editor = (JPanel)libraryEditor.getCustomEditor();
        JFrame frame = new JFrame();
        frame.getContentPane().add(editor);
        frame.pack();
        frame.setVisible(true);
    }

    private class CustomEditor
    extends JPanel {
        private static final long serialVersionUID = -1553490570313707008L;

        public CustomEditor() {
            EnsembleLibraryEditor.this.m_ModelOptionsPane = new JTabbedPane();
            EnsembleLibraryEditor.this.m_ListModelsPanel = new ListModelsPanel(EnsembleLibraryEditor.this.m_Library);
            EnsembleLibraryEditor.this.m_ModelOptionsPane.addTab("Current Library", EnsembleLibraryEditor.this.m_ListModelsPanel);
            EnsembleLibraryEditor.this.m_ModelOptionsPane.addTab("Add Models", new AddModelsPanel(EnsembleLibraryEditor.this.m_ListModelsPanel));
            this.setLayout(new BorderLayout());
            this.add((Component)EnsembleLibraryEditor.this.m_ModelOptionsPane, "Center");
        }
    }
}

